<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
* Description of User
*
* @author Developer
*/
class Access extends MY_Model
{
    
    protected $_table;
    protected $_table_parent;
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->_table               = 'evi05partic';
        $this->_table_parent        = 'gen01agencias';
        $this->_table_parent_parent = 'par02empresa';
        $this->primary_key          = 'NUM_IDETER';
    }
    
    //------------------------------------------------------------------------------
    /**
    * Para logeo de Acceso.
    *
    * @param type $datos
    * @return boolean
    */
    public function login_participante($acceso, $password = null)
    {
        //$this->db->select("$this->_table.*");
        $this->db->select("$this->_table.*,$this->_table_parent.TEX_NOMAGE");
        $this->db->from('evi05partic');
        $this->db->join($this->_table_parent, "$this->_table_parent.COD_AGENCIA=$this->_table.COD_AGENCIA");
        $this->db->where("$this->_table.NUM_IDETER", ltrim($acceso, '0'));
        if ($password) {
            $this->db->where("$this->_table.TEX_CLAVE", $password);
        }
       // $this->db->where('BOL_INISES', 0);
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $query = $this->db->get();

       // echo $this->db->last_query($query);

        if ($query->num_rows() > 0) {
            return $query->row();
        }
        else {
            return false;
        }
    }
    
    
    public function get_ip_agencia_participante($cedula)
    {
        $this->db->select("$this->_table_parent.TEX_IPORIG");
        $this->db->from('evi05partic');
        $this->db->join($this->_table_parent, "$this->_table_parent.COD_AGENCIA=$this->_table.COD_AGENCIA");
        $this->db->where("$this->_table.NUM_IDETER", $cedula);
        return $this->db->get()->row();
    }
    
    //------------------------------------------------------------------------------
    
    /**
    * Para editar el campo de una tabla.
    *
    * @param type @table Tabla
    * @param type @table_id Id a editar
    * @param type @id Id primaria
    * @param array $data datos
    * @return boolean
    */
    public function edit($id, $data)
    {
        $this->db->where($this->primary_key, $id);
        if ($this->db->update($this->_table, $data)):
            return true;
        else:
            return false;
        endif;
    }
    
    public function borrar_log_acceso($identificacion)
    {
        $this->db->where('NUM_IDETER', $identificacion);
        $this->db->delete('evi06loinpa');
    }
    
    //------------------------------------------------------------------------------
    /**
    *  Guardar datos del PIN.
    *
    * @param type $data
    * @param type $pin
    * @return boolean
    */
   public function insert_log_ingreso($data, $pin = null)
{
    if (!$pin) { $pin = 0; }

    if (!isset($data['FEC_INISES'])) {
        $data['FEC_INISES'] = date("Y-m-d H:i:s");
    }
    if (!isset($data['TEX_IPORIG'])) {
        $data['TEX_IPORIG'] = $this->input->ip_address();
    }

    // Solo columnas válidas de la tabla
    $this->_table = 'evi06loinpa';
    $tableFields  = $this->db->list_fields($this->_table);       // ['FEC_INISES', 'TEX_IPORIG', ...]
    $data         = array_intersect_key($data, array_flip($tableFields));

    // Agrega campos calculados si existen en la tabla
    if (in_array('FEC_CREACION', $tableFields)) {
        $data['FEC_CREACION'] = date("Y-m-d H:i:s");
    }
    if (in_array('NUM_PINGEN', $tableFields)) {
        $data['NUM_PINGEN'] = (int)$pin;
    }

    // (Opcional) elimina explícitamente honeypots si llegaran
    unset($data['fakeuser'], $data['honeypot']);

    return is_int($this->insert($data));
}

    //------------------------------------------------------------------------------
    /**
    *  Validación de PIN
    * @param type $cedula
    * @param type $celular
    * @param type $pin
    * @return type
    */
    public function valida_pin_ingreso($cedula, $celular, $pin)
    {
        $this->db->select_max('FEC_CREACION');
        $this->db->where('NUM_IDETER', $cedula);
        $this->db->where('NUM_TELCEL', $celular);
        $this->db->where('NUM_PINGEN', $pin);
        $this->db->where('BOL_USADO', 0);
        $this->db->order_by('FEC_CREACION', 'ASC');
        return $this->db->get('evi06loinpa')->row();
    }
    
    //------------------------------------------------------------------------------
    
    /**
    * Valida que el celular no haya sido usado por otro participante.
    *
    * @param type $celular
    * @return type
    */
    public function valida_unico_celular($celular)
    {
        $this->db->where('NUM_TELCEL', $celular);
        $this->db->where('BOL_USADO', 1);
        return $this->db->get('evi06loinpa')->row();
    }
    
    /**
    * Valida que el celular no haya sido usado por otro participante.
    *
    * @param type $celular
    * @return type
    */
    public function valida_celular($celular)
    {
        $this->db->where('NUM_TELCEL', $celular);
        return $this->db->get('evi05partic')->row();
    }
    
    public function valida_existencia_participante($id_participante, $celular)
    {
        $this->db->where('NUM_IDETER', $id_participante);
        $this->db->where('NUM_TELCEL', $celular);
        $this->db->where('BOL_USADO', 0);
        return $this->db->get('evi06loinpa')->row();
    }
    
}
