<?php
defined('BASEPATH') OR exit('No direct script access allowed');



class Candidatos extends MX_Controller

{
	
	public $path_js;
	
	public $path_css;
	
	private $_configuracion;
	protected $_permisos;
	
	
	public function __construct()
	
	{
		
		parent::__construct();
		
		$this->load->model(['Candidato', 'configuracion/Config']);
		
		$this->path_js = 'candidatos/scripts_dev.js';
		
		$this->path_css = 'candidatos/styles_dev.css';
		
		$this->load->helper('html');
		
		//Config del sistema
		$this->_configuracion = $this->Config->get_row();
		
		//Si no esta definida la configuraci�n.
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuraci�n del sistema. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}
		
		$this->_permisos = $this->session->userdata('permisos'); 
		
	}
	
	
	
	public function index()
	
	{
		
		$data_view['titulo']  = 'Listado de Candidatos';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		
		$this->load->view('index', $data_view);
		
	}
	
	
	
	/**
	
	* Lista asociados desde Datatables. 
	
	*/
	
	public function get_all()
	
	{
		
		$list = $this->Candidato->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		foreach ($list as $candidato) {
			$no++;
			$row    = array();
			$delete= '';
			$editar = '';
			$status = '';
			
			
			if(isset($this->_permisos['candidatos']['candidatos_borrar'])) {
				
				$delete = "<a href='candidatos/delete/$candidato->ID_CANDID ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
			}
			
			if(isset($this->_permisos['candidatos']['candidatos_editar'])) {
				$editar = "<a href='candidatos/create/1/$candidato->ID_CANDID ' class='btn btn-success'>Editar</a>";
			}
			if(isset($this->_permisos['candidatos']['candidatos_activar'])) {
				$status = ($candidato->BOL_ACTIVO) ? "<a href='candidatos/status/$candidato->ID_CANDID/0 ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='candidatos/status/$candidato->ID_CANDID/1 ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
			}
			
			
			
			
			$row[]  = $candidato->ID_CANDID;
			
			$row[]  = $candidato->TEX_NOMCAN . ' ' . $candidato->TEX_APECAN;
			
			$row[]  = $candidato->TEX_NOMINS;
			
			$row[]  = $candidato->TEX_NOMCIU;
			
			$row[]  = $candidato->TEX_NOMAGE;
			
			$row[]  = ($candidato->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
			
			$row[]  = "$editar $status $delete";
			
			$data[] = $row;
			
		}
		
		$output = array(
			
			"draw"            => $this->input->post('draw'),
			
			"recordsTotal"    => $this->Candidato->count_all(),
			
			"recordsFiltered" => $this->Candidato->count_filtered(),
			
			"data"            => $data,
			
		);
		
		echo json_encode($output);
		
	}
	
	
	
	public function valida_orden_candidato_lista()
	{
		$id_lista = $this->input->post('id_lista');
		$orden = $this->input->post('orden');
		$consulta    = $this->Candidato->get_exits_orden_lista($id_lista,$orden);
		if ($consulta) {
			echo json_encode(['error' =>true]);   		
		}
		else {
			echo json_encode(['success' =>true]);
		}
	}
	
	
	
	/**
	* Crear candidato.
	*/
	public function create($edit = null, $id = null)
	
	{
		
		// if ($this->session->userdata('logged_in')):
			
			if ($this->input->post()):
				
				$edit = $this->input->post('edit');
				
				$id   = $this->input->post('ID_CANDID');
				
				if ($edit) {
					$this->form_validation->set_rules('TEX_NOMCAN', 'Nombre del Candidato', 'required');
				}
				
				else {
					
					$this->form_validation->set_rules('TEX_NOMCAN', 'Nombre del Candidato', 'required');
					$this->form_validation->set_rules('NUM_ORDEN', 'Orden del Candidato', 'required');
					
				}
				
				if (!$this->form_validation->run()):
					
					$this->session->set_flashdata('error', validation_errors());
					
					if ($edit) {
						
						redirect("candidatos/create/1/$id");
						
					}
					
					redirect("candidatos/create");
					
				else:
					
					unset($_POST['TEX_CIUDAD']);
					
					
					
					$data_post       = [
						
						'NUM_ORDEN'       => $this->input->post('NUM_ORDEN'),
						
						'TEX_NOMCAN'      => $this->input->post('TEX_NOMCAN'),
						
						'TEX_APECAN'      => $this->input->post('TEX_APECAN'),
						
						'ID_INSTAN'       => $this->input->post('ID_INSTAN'),
						
						'ID_LISTA'        => $this->input->post('ID_LISTA'),
						
						'COD_AGENCIA'     => $this->input->post('COD_AGENCIA'),
						
						'TEX_PERCAN'      => $this->input->post('TEX_PERCAN'),
						
						// 'TEX_FOTO'        => 'uploads/candidatos/default.jpg',
						
						'COD_CIUDAD'      => $this->input->post('COD_CIUDAD'),
						
						'TEX_OBSERVACION' => $this->input->post('TEX_OBSERVACION'),
						
					];
					
					$datos_candidato = array_merge($data_post, $this->get_campos_control_DB());
					
					
					
					if ($edit && $id) {
						
						unset($datos_candidato['edit']);
						
						if ($this->Candidato->edit($id, $datos_candidato)) {
							
							$this->session->set_flashdata('success', 'Se ha editado el registro');
							
							if ($_FILES['upload_foto']['size'] > 0) {
								
								if ($this->do_upload($id)) {
									
									$datos_candidato_foto = ['TEX_FOTO' => 'uploads/candidatos/' . $this->upload->data('file_name')];
									
									$this->Candidato->edit($id, $datos_candidato_foto);
								}
								
							}
							
							redirect('candidatos');
							
						}
						
						else {
							
							$this->session->set_flashdata('error', 'Error en la edici�n de los datos');
							
							redirect("candidatos/create/1/$id");
							
						}
						
					}
					
					$candidato_id = $this->Candidato->insert($datos_candidato);
					
					if (is_int($candidato_id)):
						
						if ($this->do_upload($candidato_id)) {
							
							$_POST['TEX_FOTO'] = 'uploads/candidatos/' . $this->upload->data('file_name');
							
							$update_arr        = ['TEX_FOTO' => $_POST['TEX_FOTO']];
							
							$this->Candidato->edit($candidato_id, $update_arr);
							
						}
						
						$this->session->set_flashdata('success', 'Se ha guardado el registro');
						
						redirect('candidatos');
						
					else:
						
						$this->session->set_flashdata('error', 'Error en la inserción de los datos');
						
						redirect('candidatos/create');
						
					endif;
					
				endif;
				
			else:
				
				$data_view['titulo'] = 'Crear Candidato';
				
				$data_view['numeros_orden'] = $this->Candidato->get_numeros_orden();
				$data_view['por_listas'] = null;
				if($this->_configuracion->BOL_VALLIS){
					$data_view['numeros_orden'] = $this->Candidato->get_numeros_orden_by_lista();
					$data_view['por_listas'] = $this->_configuracion->BOL_VALLIS;
				}
				
				$data_view['route']  = $this->get_module_name();
				
				if ($edit && $id) {
					
					$data_view['titulo']    = 'Editar Candidato';
					
					$this->db->join("gen04ciudad", "gen04ciudad.COD_CIUDAD = evi04candidat_mr.COD_CIUDAD");
					
					$data_view['candidato'] = $this->Candidato->get($id);
					
				}
				
				$data_view['ciudades']  = $this->Candidato->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
				
				$data_view['instancia'] = $this->Candidato->select_forms('evi02instan', 'ID_INSTAN', 'TEX_NOMINS');
				
				$data_view['listas']    = $this->Candidato->select_forms('evi03listas', 'ID_LISTA', 'TEX_NOMLIS');
				
				$data_view['agencias']  = $this->Candidato->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');
				
				$data_view['load_js']   = $this->path_js;
				
				$data_view['load_css']   = $this->path_css;
				
				$this->load->view('create', $data_view);
				
			endif;
			
			// endif;
			
		}
		
		
		
		public function do_upload($name_image)
		
		{
			
			$config['upload_path']   = './uploads/candidatos';
			
			$config['allowed_types'] = 'gif|jpg|png';
			
			$config['max_size']      = 5000;
			
			$config['max_width']     = 1920;
			
			$config['max_height']    = 1080;
			
			$config['file_name']     = $name_image;
			
			$config['overwrite']     = true;
			
			
			
			$this->load->library('upload', $config);
			
			if ($this->upload->do_upload('upload_foto')) {
				
				return $config['file_name'];
				
			}
			
			else {
				
				$this->session->set_flashdata('error', $this->upload->display_errors());
				
			}
			
		}
		
		
		
		/**
		
		* 
		
		* Cambiar status
		
		* 
		
		* @param type $id
		
		* @param type $status
		
		* 
		
		*/
		
		public function status($id, $status)
		
		{
			
			$data = ['BOL_ACTIVO' => 0];
			
			if((boolean)$status) {
				
				$data = ['BOL_ACTIVO' => 1];
				
			}
			
			
			
			if ($this->Candidato->edit($id, $data)):
				
				$this->session->set_flashdata('success', 'Status modificado');
				
				redirect('candidatos');
				
			else:
				
				$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
				
				redirect('candidatos');
				
			endif;
			
		}
		
		
		
		/**
		
		* Borrar Registro
		
		* @param type $id
		
		*/
		
		public function delete($id)
		
		{
			
			$data = ['IS_DELETE' => 1];
			
			if ($this->Candidato->edit($id, $data)):
				
				$this->session->set_flashdata('success', 'Registro Eliminado');
				
				redirect('candidatos');
				
			else:
				
				$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
				
				redirect('candidatos');
				
			endif;
			
		}
		
		
		
		function upload_csv(){
			if(isset($this->_permisos['candidatos']['candidatos_cargar'])) {
				if ($this->input->post()) {
					if (empty($this->input->post())) {
						$this->session->set_flashdata('error', 'Debes cargar el archivo');
						redirect("candidatos/upload", 'refresh');
					}
					
					$files_count = count($_FILES['imagenes']['name']);
					if ($files_count > 0) {
						for($i = 0; $i < $files_count; $i++){
							$_FILES['imagen']['name'] = $_FILES['imagenes']['name'][$i];
							$_FILES['imagen']['type'] = $_FILES['imagenes']['type'][$i];
							$_FILES['imagen']['tmp_name'] = $_FILES['imagenes']['tmp_name'][$i];
							$_FILES['imagen']['error'] = $_FILES['imagenes']['error'][$i];
							$_FILES['imagen']['size'] = $_FILES['imagenes']['size'][$i];
							$uploadPath = 'uploads/candidatos/';
							$config_img['upload_path'] = $uploadPath;
							$config_img['allowed_types'] = 'gif|jpg|jpge|png';                
							$this->load->library('upload', $config_img);
							$this->upload->initialize($config_img);
							if($this->upload->do_upload('imagen')){
								$fileData = $this->upload->data();
								$uploadData[$i]['imagen'] = $fileData['file_name'];
								$uploadData[$i]['created'] = date("Y-m-d H:i:s");
								$uploadData[$i]['modified'] = date("Y-m-d H:i:s");
							}
						} 
					}
					
					$config['upload_path']   = './uploads/csv';
					$config['allowed_types'] = 'csv';
					$config['max_size']      = 5000;
					$this->load->library('upload', $config);
					$this->upload->initialize($config);
					if (!$this->upload->do_upload('csv')) {
						echo $this->upload->display_errors();exit;
						$this->session->set_flashdata('error', $this->upload->display_errors());
						redirect("candidatos/upload_csv", 'refresh');
						
					}
					
					else {
						
						$data      = $this->upload->data();
						$file_path = $data['file_path'] . $data['file_name'];
						$rows      = $this->csv_to_array($file_path);
						//Se retira el encabezado.
						unset($rows[0]);
						if ($rows) {
							$contador  = 1;
							$no_upload = 0;
							for ($index = 1; $index < count($rows) + 1; $index++) {
								$contador++;
								$validacion = $this->valida_unica_cedula($rows[$index][0]);
								if (!$validacion) {
									$data         = [
										'NUM_ORDEN'       => $rows[$index][0],
										'TEX_NOMCAN'      => $rows[$index][1],
										'TEX_APECAN'      => $rows[$index][2],
										'ID_INSTAN'       => $rows[$index][3],
										'ID_LISTA'        => $rows[$index][4],
										'COD_CIUDAD'      => $rows[$index][5],
										'COD_AGENCIA'     => $rows[$index][6],
										'TEX_PERCAN'      => $rows[$index][7],
										'TEX_OBSERVACION' => $rows[$index][8],
										'TEXT_TIPLIST'    => 'LCC',
										'ID_LISTA'    => (isset($rows[$index][9]))?$rows[$index][9]:0,
										'TEX_FOTO' => (isset($rows[$index][10]))?'uploads/candidatos/'.$rows[$index][10].'.jpg'
										:'uploads/candidatos/'.$rows[$index][0].'.jpg'
									];
									$data_save    = array_merge($data, $this->get_campos_control_DB());
									$id_candidato = $this->Candidato->insert($data_save);
									$data_edit    = ['TEX_FOTO' => (isset($rows[$index][10]))?'uploads/candidatos/'.$rows[$index][10].'.jpg'
									:'uploads/candidatos/'.$rows[$index][0].'.jpg'];
									$this->Candidato->edit($id_candidato, $data_edit);
									$no_upload    += $contador;
									
								}
							}
							$this->session->set_flashdata('success', 'Se han cargado con exito');
							redirect("candidatos", 'refresh');
						}
					}
				}
				else {
					$data_view['titulo'] = 'Carga de Candidatos (Archivo separado por ;)';
					$this->load->view('upload', $data_view);
				}
				
			}
			
		}
		
		
		public function valida_unica_cedula($cedula)
		
		{
			
			return $this->Candidato->get_row($cedula);
			
		}
		
		public function get_archivo_csv()
		
		{
			$this->load->helper('download');
			
			force_download('./uploads/ayuda/candidatos.csv', NULL);
			
		}
		
		
		
	}
	
	