<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User
 *
 * @author Developer
 */
class Candidato extends MY_Model
{

	protected $_table;
	protected $_table_parent;
	protected $_table_parent2;
	protected $_table_parent3;
	private $_configuracion;
	private $_column;
	private $_order;

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
        //Modelo de la Configuración.
		$this->load->model(['configuracion/Config',
			'agencias/Agencia', 'ciudades/Ciudad']);
        //Datos de la configuración.
		$this->_configuracion = $this->Config->get_row();

		if (!$this->_configuracion) {
			exit('No se ha definido la configuración del sistema.');
		}
		$this->_table         = 'evi04candidat_mr';
		$this->_table_parent  = 'evi02instan';
		$this->_table_parent2 = 'gen04ciudad';
		$this->_table_parent3 = 'gen01agencias';
		$this->primary_key    = 'ID_CANDID';

		$this->_column = array(
			'ID_CANDID',
			'TEX_NOMCAN',
			"$this->_table_parent.TEX_NOMINS",
			"$this->_table_parent2.TEX_NOMCIU",
			"$this->_table_parent3.TEX_NOMAGE",
			"$this->_table_parent2.COD_CIUDAD",
			'TEX_APECAN');
		$this->_order = array('ID_CANDID' => 'desc', "$this->_table_parent2 . TEX_NOMCIU" => 'ASC');
	}

    /**
     * Para editar el campo de una tabla.
     *
     * @param type @table Tabla
     * @param type @table_id Id a editar
     * @param type @id Id primaria
     * @param type $data datos
     * @return boolean
     */
    public function edit($id, $data)
    {
    	$this->db->where($this->primary_key, $id);
    	if ($this->db->update($this->_table, $data)):
    		return true;
    	else:
    		return false;
    	endif;
    }

    private function _get_datatables_query()
    {
    	$this->db->select("$this->_table.*, $this->_table_parent.TEX_NOMINS,"
    		. " $this->_table_parent2.TEX_NOMCIU, $this->_table_parent3.TEX_NOMAGE");
    	$this->db->from($this->_table);
    	$this->db->join($this->_table_parent, "$this->_table_parent.ID_INSTAN=$this->_table.ID_INSTAN");
    	$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_CIUDAD=$this->_table.COD_CIUDAD");
    	$this->db->join($this->_table_parent3, "$this->_table_parent3.COD_AGENCIA=$this->_table.COD_AGENCIA");
    	$this->db->where("$this->_table.IS_DELETE", 0);
    	$i = 0;
    	foreach ($this->_column as $item) {
    		if ($_POST['search']['value']) {
    			($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
    		}

    		$column[$i] = $item;
    		$i++;
    	}
    	if (isset($_POST['order'])) {
    		$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
    	} else if (isset($this->_order)) {
    		$order = $this->_order;
    		$this->db->order_by(key($order), $order[key($order)]);
    	}
    }

    public function get_datatables()
    {
    	$this->_get_datatables_query();
    	if ($_POST['length'] != -1):
    		$this->db->limit($_POST['length'], $_POST['start']);
    	endif;
    	$query = $this->db->get();
    	return $query->result();
    }

    public function count_filtered()
    {
    	$this->_get_datatables_query();
    	$query = $this->db->get();
    	return $query->num_rows();
    }

    /**
     * Conteo de todos los registros.
     * @return type
     */
    public function count_all()
    {
    	$this->db->from($this->_table);
    	return $this->db->count_all_results();
    }

    /**
     * Select HTML.
     * @return array.
     */
    public function get_html_select()
    {
    	$this->db->from($this->_table);
    	$this->db->where("$this->_table.BOL_ACTIVO", 1);
    	$this->db->where("$this->_table.IS_DELETE", 0);
    	return $this->db->get($this->_table);
    }

    /**
     * Trae la lista de candidatos por instancia.
     *
     * @param type $instancia
     * @return type
     */
    public function get_candidatos_by_instancia($instancia)
    {
    	$this->db->where('ID_INSTAN', $instancia);
    	$this->db->where('BOL_BLANCO', 0);
    	$this->db->where('IS_DELETE', 0);
    	$this->db->where('BOL_ACTIVO', 1);
    	$this->db->where("$this->_table.BOL_ACTIVO", 1);
        //Tipo de segmentacion por Agencia.
    	if ($this->_configuracion->TEX_SEGMEN === 'A') {
    		$this->db->where('COD_AGENCIA', $this->session->userdata('COD_AGENCIA'));
    	}
        //Tipo de segmentacion po Ciudad.
    	if ($this->_configuracion->TEX_SEGMEN === 'C') {
    		$this->db->where('COD_CIUDAD', $this->session->userdata('COD_CIUDAD'));
    	}
        //   $this->db->where('TEXT_TIPLIST !=', 'LCL');

    	if (!$this->_configuracion->BOL_VALLIS) {
    		$this->db->where('TEXT_TIPLIST !=', 'LCL');
    		$this->db->where('TEXT_TIPLIST !=', 'LVP');
    	}

    	$this->db->order_by('cast(NUM_ORDEN as unsigned) ASC');

    	return $this->db->get($this->_table)->result();
    }

    /**
     * Trae la lista de candidatos por instancia.
     *
     * @param type $instancia
     * @return type
     */
    public function get_candidatos_tarjeton_preview($instancia, $agencia, $ciudad)
    {
    	$this->db->where('ID_INSTAN', $instancia);
    	$this->db->where("evi04candidat_mr.IS_DELETE", 0);
    	$this->db->where('evi04candidat_mr.BOL_ACTIVO', 1);

    	if (!$this->_configuracion->BOL_VALLIS) {
    		$this->db->where('TEXT_TIPLIST !=', 'LCL');
    		$this->db->where('TEXT_TIPLIST !=', 'LVP');
    	}
        //Tipo de segmentacion por Agencia.
    	if ($agencia) {
    		$this->db->where('COD_AGENCIA', $agencia);
    	}
        //Tipo de segmentacion po Ciudad.
    	if ($ciudad) {
    		$this->db->where('COD_CIUDAD', $ciudad);
    	}

    	$this->order_by("cast(evi04candidat_mr.NUM_ORDEN as unsigned)", 'ASC');
    	$this->order_by("evi04candidat_mr.BOL_BLANCO", 'ASC');
        //   $this->db->where('TEXT_TIPLIST !=', 'LCL');
    	return $this->db->get($this->_table)->result();
    }

    /**
     *  Inserta los datos del log cuando se realiza el proceso de votación. lo hace
     * por candidato.
     *
     * @param type $data
     */
    public function insert_log_voto($data, $candidato_id)
    {
		$this->db->trans_begin();
		$this->_table = 'evi07audpro';
    	$this->insert($data);
	//	echo $this->db->last_query($query);
    		$this->_table = 'evi04candidat_mr';
			$votos_candidato     = $this->_get_consulta_voto_desencriptado($candidato_id);
			$peso_participante = $this->session->userdata('PESO_VOTO');
		

	 	 /*    echo '<pre>';
			echo 'voto antes de:';
			var_dump($votos_candidato);
			echo '<br>';  

			echo '<pre>';
			echo 'peso parti:';
			var_dump($peso_participante);
			echo '<br>';    */
            
			if (!isset($votos_candidato)) {
    			$votos_candidato = 0;
			} 

			

			//Suma de votos.
			if(!is_int($votos_candidato) && !is_int($peso_participante)){
				$voto_sum = (float)str_replace(',', '.', $votos_candidato) + (float) str_replace(',', '.', $peso_participante);
			} else {
				$voto_sum = $votos_candidato + $peso_participante;
			}
/* 
		 echo '<pre>';
		 	 echo 'voto storage:';
			var_dump((int) $votos_candidato);
			echo '<br>';

			echo 'voto parti:';
			var_dump($peso_participante);

			echo 'voto suma:';
			var_dump($voto_sum); */

		
			
		//	$suma_voto_proceso = $this->suma_voto_encriptado($candidato_id, $voto_sum);
			//echo 'proceso suma:';
			//var_dump($suma_voto_proceso);
			//exit;  

			if ($this->db->trans_status() === FALSE)
			{
					$this->db->trans_rollback();
			}
			else
			{
					$this->db->trans_commit();
			}
    }

    /**
     * Suma de voto encriptado.
     *
     */
    public function suma_voto_encriptado($id, $data)
    {
     return	$this->db->query("UPDATE $this->_table
    		SET NUM_TOVOCA = AES_ENCRYPT( '$data', '$this->_key' ) "
    		. " WHERE $this->primary_key = $id");
    }

    /**
     *  Consulta voto encriptado.
     *
     */
    private function _get_consulta_voto_desencriptado($candidato_id)
    {
    	$this->db->where("$this->primary_key", $candidato_id);
    	$this->db->select("AES_DECRYPT(NUM_TOVOCA, '$this->_key') as NUM_TOVOCA", false);
    	return $this->db->get($this->_table)->row()->NUM_TOVOCA;
    }

    /**
     * Trae la información del voto en blanco.
     *
     * @return type
     */
    public function get_voto_blanco($instancia)
    {
    	if ($instancia) {
    		$this->db->where('ID_INSTAN', $instancia);
    	}

        if ($this->_configuracion->TEX_SEGMEN === 'A') {
            $this->db->where('COD_AGENCIA', $this->session->userdata('COD_AGENCIA'));
		}


        if ($this->_configuracion->TEX_SEGMEN === 'C') {
            $this->db->where('COD_CIUDAD', $this->session->userdata('COD_CIUDAD'));
		}
		

        $this->db->where('BOL_ACTIVO', 1);
        $this->db->where('BOL_BLANCO', 1);
        $this->db->where("IS_DELETE", 0);
        return $this->db->get($this->_table)->row();
    }

    /**
     * Candidato tipo LCL.
     *
     * @param type $id_lista
     * @param type $nombre_lista
     * @param type $id_instancia
     * @param type $cod_ciudad
     * @param type $id_agencia
     */
    public function create_candidato_lista($id_lista, $nombre_lista, $id_instancia, $cod_ciudad, $id_agencia)
    {
    	$candidato_lista = [
    		'NUM_ORDEN'       => 1,
    		'TEX_NOMCAN'      => 'REGISTRO VOTACION',
    		'TEX_APECAN'      => $nombre_lista,
    		'ID_LISTA'        => $id_lista,
    		'TEXT_TIPLIST'    => 'LCL',
    		'ID_INSTAN'       => $id_instancia,
    		'COD_AGENCIA'     => $id_agencia,
    		'TEX_PERCAN'      => $nombre_lista,
    		'TEX_FOTO'        => 'uploads/candidatos/lista.jpg',
    		'COD_CIUDAD'      => $cod_ciudad,
    		'TEX_OBSERVACION' => 'Registro votación: ' . $id_lista . ' - ' . $nombre_lista,
    	];
    	$candidato_lista = array_merge($candidato_lista, $this->get_campos_control_DB());
    	$this->insert($candidato_lista);
    }

    /**
     * Crea el candidato del voto en blanco basado en la instancia.
     *
     * @param type $id_instancia
     * @param type $nombre_instancia
     * @param type $cod_ciudad
     * @param type $id_agencia
     */
    public function create_candidato_voto_blanco($id_instancia, $nombre_instancia, $cod_ciudad = null, $cod_agencia = null)
    {
    	if ($this->_configuracion->TEX_SEGMEN === 'N') {
    		$candidato_voto_blanco = [
    			'NUM_ORDEN'       => 1,
    			'TEX_NOMCAN'      => 'VOTO',
    			'TEX_APECAN'      => "BLANCO $nombre_instancia",
    			'NUM_TOVOCA'       => 0,
    			'ID_INSTAN'       => $id_instancia,
    			'COD_AGENCIA'     => $cod_agencia,
    			'TEX_PERCAN'      => 'Candidato lista',
    			'TEX_FOTO'        => 'uploads/candidatos/blanco.jpg',
    			'COD_CIUDAD'      => $cod_ciudad,
    			'BOL_BLANCO'      => 1,
    			'TEX_OBSERVACION' => "Voto en blanco de la instancia: $nombre_instancia",
    		];
    		$arr = array_merge($candidato_voto_blanco, $this->get_campos_control_DB());
    		$this->insert($arr);
    	}
    	if ($this->_configuracion->TEX_SEGMEN === 'A') {
    		$this->db->where('BOL_ACTIVO', 1);
            $this->db->where('IS_DELETE', 0);
            $this->db->where('COD_AGENCIA !=', 0);
			$agencias = $this->Agencia->get_all();
            foreach ($agencias as $agen) {
             $candidato_voto_blanco = [
                'NUM_ORDEN'       => 1,
                'TEX_NOMCAN'      => 'VOTO',
				'TEX_APECAN'      => 'BLANCO '.$agen->TEX_NOMAGE,
				'NUM_TOVOCA'       => 0,
                'ID_INSTAN'       => $id_instancia,
                'COD_AGENCIA'     => $agen->COD_AGENCIA,
                'TEX_PERCAN'      => "Voto en blanco agencia ".$agen->TEX_NOMAGE,
                'TEX_FOTO'        => 'uploads/candidatos/blanco.jpg',
                'COD_CIUDAD'      => $agen->COD_CIUDAD,
                'BOL_BLANCO'      => 1,
                'TEX_OBSERVACION' => "Voto en blanco de la agencia: ".$agen->COD_AGENCIA.' - '.$agen->TEX_NOMAGE,
            ];
            $arr = array_merge($candidato_voto_blanco, $this->get_campos_control_DB());
            $this->insert($arr);
        }
    }
    if ($this->_configuracion->TEX_SEGMEN === 'C') {
      $this->db->where('BOL_ACTIVO', 1);
      $this->db->where('IS_DELETE', 0);
      $this->db->where('COD_CIUDAD !=', 0);
      $ciudades = $this->Ciudad->get_all();
      foreach ($ciudades as $ciu) {
         $candidato_voto_blanco = [
            'NUM_ORDEN'       => 1,
            'TEX_NOMCAN'      => 'VOTO',
			'TEX_APECAN'      => "BLANCO $nombre_instancia",
			'NUM_TOVOCA'       => 0,
            'ID_INSTAN'       => $id_instancia,
            'COD_AGENCIA'     => $cod_agencia,
            'TEX_PERCAN'      => 'Candidato lista',
            'TEX_FOTO'        => 'uploads/candidatos/blanco.jpg',
            'COD_CIUDAD'      => $ciu->COD_CIUDAD,
            'BOL_BLANCO'      => 1,
            'TEX_OBSERVACION' => "Voto en blanco de la instancia: $nombre_instancia",
        ];
        $arr = array_merge($candidato_voto_blanco, $this->get_campos_control_DB());
        $this->insert($arr);
    }
}
}

    /**
     * Trae el voto en blanco a partir de la instancia.
     *
     * @param type $instancia
     * @return type
     */
    public function get_candidato_by_instancia($instancia)
    {
    	$this->db->where('ID_INSTAN', $instancia);
    	$this->db->where('BOL_BLANCO', 1);
    	$this->db->where('BOL_ACTIVO', 1);
    	$this->db->where('IS_DELETE', 0);
    	return $this->db->get($this->_table)->row();
    }


    public function get_numeros_orden()
    {

    	$sql = "SELECT NUM_ORDEN from evi04candidat_mr WHERE NUM_ORDEN is not null
    	GROUP BY NUM_ORDEN ORDER BY cast(NUM_ORDEN as unsigned)";
    	$res = $this->db->query($sql);
    	return $res->result();


    }

    public function get_numeros_orden_by_lista()
    {

    	$sql_listas = "SELECT ID_LISTA,TEX_NOMLIS FROM evi03listas 
    	WHERE BOL_ACTIVO=1 AND IS_DELETE=0";
    	$res = $this->db->query($sql_listas);
    	$listas =  $res->result();
    	$arr=[];
    	foreach ($listas as $key => $lista) {
    		$arr[$key] = [ 
    			'nombre_lista'=>$lista->TEX_NOMLIS,
    			'numeros' => $this->_get_orden_by_lista($lista->ID_LISTA)
    		];
    	}
    	return $arr;
    }

    private function _get_orden_by_lista($id_lista)
    {
    	$sql = "SELECT NUM_ORDEN from evi04candidat_mr
    	WHERE  ID_LISTA = $id_lista       
    	AND NUM_ORDEN is not null
    	ORDER BY cast(NUM_ORDEN as unsigned)";
    	$res = $this->db->query($sql);
    	return $res->result();
    }

    public function get_exits_orden_lista($id_lista,$orden)
    {
    	$this->db->where('ID_LISTA', $id_lista);
    	$this->db->where('NUM_ORDEN', $orden);
    	return $this->db->get('evi04candidat_mr')->row();
    }

}
