<?php

defined('BASEPATH') or exit('No direct script access allowed');

// -----------------------------------------------------------------------------
 /**
  * Clase Ciudades.
  */
 class Ciudades extends MX_Controller
 {

 	public $path_js;
 	protected $_permisos;

 	public function __construct()
 	{
 		parent::__construct();

 		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
 			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
 			exit;
 		}
 		$this->load->model('Ciudad');
 		$this->path_js = 'ciudades/scripts_dev.js';
 		$this->_permisos = $this->session->userdata('permisos'); 
 	}

 	public function index()
 	{
 		$data_view['titulo']  = 'Listado de Ciudades';
 		$data_view['permisos']  = $this->_permisos;
 		$data_view['load_js'] = $this->path_js;
 		$this->load->view('index', $data_view);
 	}

     //-----------------------------------------------------------------------------

     /**
      * Lista asociados desde Datatables.
      */
     public function get_all()
     {

     	$list = $this->Ciudad->get_datatables();
     	$data = array();
     	$no   = $this->input->post
     	('start ');
     	foreach ($list as $ciudad) {
     		$no++;
     		$row    = array();

     		$delete= '';
     		$editar = '';
     		$status = '';

     		if(isset($this->_permisos['ciudades']['ciudades_borrar'])) {
     			$delete = "<a href='ciudades/delete/$ciudad->COD_CIUDAD ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";

     		}

     		if(isset($this->_permisos['ciudades']['ciudades_editar'])) {
     			$editar = "<a href='ciudades/create/1/$ciudad->COD_CIUDAD ' class='btn btn-success'>Editar</a>";
     		}
     		if(isset($this->_permisos['ciudades']['ciudades_activar'])) {
     			$status = ($ciudad->BOL_ACTIVO) ? "<a href='ciudades/status/$ciudad->COD_CIUDAD/$ciudad->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='ciudades/status/$ciudad->COD_CIUDAD/$ciudad->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		$row[]  = $ciudad->COD_CIUDAD;
     		$row[]  = $ciudad->TEX_NOMCIU;
     		$row[]  = $ciudad->TEX_NOMDEPTO;
     		$row[]  = ($ciudad->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Ciudad->count_all(),
     		"recordsFiltered" => $this->Ciudad->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

//-----------------------------------------------------------------------------
     /**
      * Crear ciudad.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_CIUDAD');
     		if ($edit) {
     			$this->form_validation->set_rules('COD_CIUDAD', 'Código de la Ciudad', 'trim|required|integer');
     			$this->form_validation->set_rules('TEX_NOMCIU', 'Nombre de la Ciudad', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('COD_CIUDAD', 'Código de la Ciudad', 'trim|required|integer|is_unique[gen04ciudad.COD_CIUDAD]');
     			$this->form_validation->set_rules('TEX_NOMCIU', 'Nombre de la Ciudad', 'required|is_unique[gen04ciudad.TEX_NOMCIU]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("ciudades/create/1/$id");
     			}
     			redirect("ciudades/create");
     		else:
     			$_post        = $this->security->xss_clean($_POST);
     			$datos_ciudad = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_ciudad['edit']);
     				if ($this->Ciudad->edit($id, $datos_ciudad)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('ciudades');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("ciudades/create/1/$id");
     				}
     			}
     			if (is_int($this->Ciudad->insert($datos_ciudad))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('ciudades');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('ciudades/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['ciudad'] = $this->Ciudad->get($id);
     		}
     		$data_view['departamentos'] = $this->Ciudad->select_forms('gen03depto', 'COD_DEPTO', 'TEX_NOMDEPTO');
     		$data_view['titulo']        = 'Crear Ciudad';
     		$data_view['load_js']       = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

//-----------------------------------------------------------------------------

     /**
      *
      * Cambiar status
      *
      * @param type $id
      * @param type $status
      *
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 1];
     	if ($status) {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Ciudad->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('ciudades');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('ciudades');
     	endif;
     }

//-----------------------------------------------------------------------------

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Ciudad->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('ciudades');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('ciudades');
     	endif;
     }

  }
