<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Configuracion extends MX_Controller
{

	public $path_js;
	private $_message;
	private $_permisos;

	public function __construct()
	{

		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Config', 'agencias/Agencia', 'ciudades/Ciudad', 'usuarios/Usuario']);
		$this->_configuracion = $this->Config->get_row();
		$this->path_js = 'configuracion/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos');
	}

	public function index()
	{
		$data_view['titulo']     = 'Configuracion';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js']    = $this->path_js;
		$data_view['parametros'] = $this->Config->get_row();
		$this->load->view('index', $data_view);
	}

	/**
	 * Crear configuracion.
	 */
	public function create($edit = null, $id = null)
	{

		if ($this->_permisos['configuracion']['configuracion_editar']) {
			$this->ini_desencriptado();
			if ($this->input->post()):
				$edit = $this->input->post('edit');
				$id   = $this->input->post('ID_GENERAL');

				$this->form_validation->set_rules('NUM_VALING', 'Tipo de ingreso', 'required');
				$this->form_validation->set_rules('TEX_SEGMEN', 'Por agencia o ciudad', 'required');
				$this->form_validation->set_rules('BOL_VALLIS', 'Votación por listas', 'required');
				$this->form_validation->set_rules('NUM_CANFIL', 'Número candidatos por fila', 'required|integer|less_than_equal_to[8]');
				$this->form_validation->set_rules('BOL_VALMAI', 'Envía Mail', 'required');

				if (!$this->form_validation->run()):
					$this->session->set_flashdata('error', validation_errors());
					if ($edit) {
						redirect("configuracion/create/1/$id");
					}
					redirect("configuracion/create");
				else:
					unset($_POST['RE_TEX_MAICLA']);
					if ($this->input->post('TEX_MAICLA')) {
						$_POST['TEX_MAICLA'] = $this->encriptar_texto($this->input->post('TEX_MAICLA'));
					} else {
						unset($_POST['TEX_MAICLA']);
					}

					if ($this->input->post('TEX_PASS_FIJA_DEF')) {
						$_POST['TEX_PASS_FIJA_DEF'] = $this->encriptar_texto($this->input->post('TEX_PASS_FIJA_DEF'));
					} else {
						unset($_POST['TEX_PASS_FIJA_DEF']);
					}

					$_post        = $this->security->xss_clean($_POST);
					$datos_config = array_merge($_post, $this->get_campos_control_DB('', 1));
					if ($edit && $id) {
						unset($datos_config['edit']);
						$this->session->unset_userdata('permisos');
						if ($this->Config->edit($id, $datos_config)) {

							//Actualiza nombre del segmanto
							if ($datos_config['TEX_NOMSEG']) {
								$segmento = ['NOMBRE_SEGMENTO' => $datos_config['TEX_NOMSEG']];
								$this->session->set_userdata($segmento);
							}
							//Actualiza Permisos
							$permisos = $this->_cargar_permisos_usuario($this->session->userdata('COD_PERFIL'), $this->input->post('BOL_ACTIINFORVOT'));
							$this->session->set_userdata(['permisos' => $permisos]);
							//echo "<pre>";	
							//var_dump($this->session->userdata());


							$configuracion = $this->Config->get_datos_load_session();
							$this->session->set_userdata('settings', $configuracion);
							$this->session->set_flashdata('success', 'Se ha editado el registro');
							redirect('configuracion');
						} else {
							$this->session->set_flashdata('error', 'Error en la edición de los datos');
							redirect("configuracion/create/1/$id");
						}
					}
					if (is_int($this->Config->insert($datos_config))):
						$configuracion = $this->Config->get_datos_load_session();
						$this->session->set_userdata('settings', $configuracion);
						$this->session->set_flashdata('success', 'Se ha guardado el registro');
						redirect('configuracion');
					else:
						$this->session->set_flashdata('error', 'Error en la inserción de los datos');
						redirect('configuracion/create');
					endif;
				endif;
			else:
				$data_view['titulo'] = 'Establecer Configuración';
				$data_view['route']  = $this->get_module_name();
				if ($edit && $id) {
					$data_view['configuracion'] = $this->Config->get($id);
					$data_view['titulo']        = 'Cambiar Configuración';


					$data_view['pass_fija_def_plain'] =
						!empty($data_view['configuracion']->TEX_PASS_FIJA_DEF)
						? $this->desencriptar_texto($data_view['configuracion']->TEX_PASS_FIJA_DEF)
						: '';
				}

				$data_view['load_js'] = $this->path_js;
				$this->load->view('configurar', $data_view);
			endif;
		} else {

			if ($this->session->userdata('COD_USUARIO')) {
				$this->session->set_flashdata('error', ERROR_PERMISOS);
				redirect('administrador');
			}
			$data_view['message'] = ERROR_PERMISOS;
			$this->load->view('errors/error_permisos', $data_view);
		} //Permisos
	}

	public function validacion_segmen()
	{
		$segmen = $this->input->post('segmen');
		if ($segmen === 'A') {
			$this->db->where('BOL_ACTIVO', 1);
			$this->db->where('IS_DELETE', 0);
			$agencias = $this->Agencia->get_all();
			$total    = count($agencias);
			if ($total < 2) {
				$this->_message = ['type' => 'error', 'message' => 'El número de agencias creadas y habilitadas debe ser mayor a 2'];
			}
		}
		if ($segmen === 'C') {
			$this->db->where('BOL_ACTIVO', 1);
			$this->db->where('IS_DELETE', 0);
			$this->db->where('COD_CIUDAD !=', 1);
			$ciudades = $this->Ciudad->get_all();
			$total    = count($ciudades);
			if ($total < 2) {
				$this->_message = ['type' => 'error', 'message' => 'El número de ciudades creadas y habilitadas debe ser mayor a 2'];
			}
		}

		echo json_encode($this->_message);
	}


	/**
	Carga de permisos asociados al usuario.
	 */
	protected function _cargar_permisos_usuario($cod_usuario, $activa_informe_votacion)
	{
		$arr = [];
		$datos_pemisos = $this->Usuario->get_perfil_permisos($cod_usuario);
		$config_cierre_votacion = $this->get_valida_cierre_instancia();
		foreach ($datos_pemisos as $key => $permiso) {
			$permiso_es_votacion = (bool)$permiso->BOL_VOTACION;
			if ($config_cierre_votacion && $permiso_es_votacion && $activa_informe_votacion) {
				$mostrar_en_front = false;
			} else {
				$mostrar_en_front = true;
			}

			$arr[$permiso->TEX_MODULO][$permiso->TEX_NOMPERMI] = [
				'TEX_NOMPERMI' => $permiso->TEX_NOMPERMI,
				'TEX_MODULO' => $permiso->TEX_MODULO,
				'TIPO_ACCION' => $permiso->TIPO_ACCION,
				'COD_TIPOPERFIL' => $permiso->COD_TIPOPERFIL,
				'MOSTRAR_FRONT' => $mostrar_en_front
			];
		}

		return $arr;
	}
}
