<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Escarapelas extends MX_Controller
{

	public $path_js;

//---------------------------------------------------------------------------------------------------

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Escarapela', 'participantes/Participante', 'configuracion/Config', 'ingresos_salidas/Ingresos_salida']);

    //Config del sistema
		$this->_configuracion = $this->Config->get_row();

     //Si no esta definida la configuración.
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}


		$this->path_js = 'escarapelas/scripts_dev.js';
	}

//------------------------------------------------------------------------------
	public function index()
	{
		$data_view['titulo']  = 'Generación de Escarapelas';
		$data_view['escarapelas_masivo']  = (boolean)$this->_configuracion->BOL_GENMASESP;
		$data_view['load_js'] = $this->path_js;

		if($this->input->post()){
			$this->load->library('mydompdf');
			$cedula = $this->input->post('cedula');
			$arr= [];
			for ($i=0; $i < count($cedula) ; $i++) { 
				$participante = $this->Participante->get_participante($cedula[$i]);
				if(!$participante){
					$this->session->set_flashdata('error', 'El número de cédula: '.$cedula[$i].' no existe');
					$data_view['cedulas'] = $cedula;					
					$this->load->view('index', $data_view);
					return false;
				}

				if($this->_configuracion->BOL_REGIST){

					if(!$participante->FEC_REGIST) {
						$data = ['FEC_REGIST' => $this->get_fecha_hora_hoy()];
						$this->db->trans_start();
						if ($this->Participante->edit(xss_clean($participante->NUM_IDETER), $data)) {
                         //Registro de ingreso.
							$data_registro = ['NUM_IDETER'   => xss_clean($participante->NUM_IDETER),
							'FEC_INGSAL'   => $this->get_fecha_hora_hoy(),
							'COD_CREAUSU'  => $this->session->userdata('COD_USUARIO'),
							'TEX_CREANOTA' => $this->input->ip_address()
						];
                         //Crea registro en la tabla de ingresos.
						$this->Ingresos_salida->insert($data_registro);
					}
					$this->db->trans_complete();
				}
			}


			$arr[] = $participante;
		}
		$data_view['participantes'] = $arr;
		foreach ($arr as $key => $participante) {
			$this->barcode($participante->NUM_IDETER);
		}

		$data_view['is_masivo'] = false;
		if(count($cedula) > 1){
			$data_view['is_masivo'] = true;
		}

		$html=	$this->load->view('generar_escaralepa', $data_view, true);
  
		$this->mydompdf->load_html($html);
	   define("DOMPDF_DPI", 62.230);
		$this->mydompdf->set_paper(array(3, 3, 290, 370), 'portrait');
		if(count($cedula) > 1){
			$this->mydompdf->set_paper(array(0,0,612.00,792.00), 'portrait');
		}			

		$this->mydompdf->output(['isRemoteEnabled' => true]);
		$this->mydompdf->render();
		$this->mydompdf->stream("Escarapelas.pdf", array(
			"Attachment" => false,
		));
		return false;
	}             

	$this->load->view('index', $data_view);

}

public function barcode($code)
{
	$this->load->library('zend');
	$this->zend->load('Zend/Barcode');
	$imageResource = Zend_Barcode::factory('code128', 'image', array('text'=>$code), array())->draw();
	imagepng($imageResource, "uploads/barcode/$code.png");
}

}
