<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Informes extends MX_Controller
{
	
	public $path_js;
	public $graficos_js;
	private $_configuracion;
	private $_poblacion_total;
	private $_permisos;
	
	public function __construct()
	{
		parent::__construct();
		
		if (!$this->session->userdata('COD_PERFIL')) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		
		$this->load->model(['Inf_personas_sin_registrarse', 'Inf_personas_registradas',
		'Inf_participantes', 'Inf_participantes_bloqueados', 'Inf_personas_en_auditorio', 'Inf_personas_fuera_auditorio',
		'Inf_registrados_sin_participar', 'Inf_asistentes_habiles', 'Inf_candidatos',
		'Inf_personas_sin_participar', 'Inf_por_cociente', 'Inf_cociente_agencia',
		'Inf_por_instancias',  'Inf_por_instancias_participantes', 'Inf_por_instancias_sin_participar',
		'Inf_por_instancias_registrados_sin_participar','Inf_resumen_por_agencia', 'Inf_por_agencia',
		'Inf_candidatos_por_agencia', 'inf_resumen_ip_por_agencia','Inf_resumen_votacion_usuario_registro',
		'agencias/Agencia', 'instancias/Instancia','participantes/Participante', 'configuracion/Config',
		'usuarios/Usuario', 'acceso/Log_recordar_password'
		]);
		$this->ini_desencriptado();
		$this->path_js          = 'informes/scripts_dev.js';
		$this->graficos_js      = 'informes/graficos.js';
		$this->_poblacion_total = $this->Participante->count_all();
		$this->_permisos = $this->session->userdata('permisos');
		
		$this->_configuracion = $this->Config->get_row();
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Personas sin registrarse
	*/
	public function personas_sin_registrarse()
	{
		if ($this->_configuracion->BOL_REGIST) {
			$data_view['titulo']  = 'Personas Sin registrarse';
			$data_view['load_js'] = $this->path_js;
			$this->load->view('personas_sin_registrarse', $data_view);
			return false;
		} else {
			$this->session->set_flashdata('error', 'No es posible ver el reporte, configuración del'
			. ' sistema sin registro previo.');
			redirect('administrador');
		}
	}
	
	/**
	* Personas sin registrarse load .
	*/
	public function get_all_personas_sin_registrarse()
	{
		$list = $this->Inf_personas_sin_registrarse->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $personas_sin_registrarse) {
			$no++;
			$row   = array();
			$row[] = $personas_sin_registrarse->NUM_IDETER;
			$row[] = $personas_sin_registrarse->TEX_NOMPAR . ' ' . $personas_sin_registrarse->TEX_APEPAR;
			$row[] = $personas_sin_registrarse->TEX_NOMCIU;
			$row[] = $personas_sin_registrarse->TEX_NOMAGE;
			
			$data[] = $row;
		}
		$output = array(
			"draw"                            => $this->input->post('draw'),
			"recordsTotal"                    => $this->Inf_personas_sin_registrarse->count_all(),
			"recordsFiltered"                 => $this->Inf_personas_sin_registrarse->count_filtered(),
			'no_registradas'                  => $this->Inf_personas_sin_registrarse->count_all(),
			'poblacion'                       => $this->_poblacion_total,
			'porcentaje_total_poblacion'      => '100%',
			'porcentaje_total_no_registradas' => (number_format(((int) $this->Inf_personas_sin_registrarse->count_all() / (int) $this->_poblacion_total) * 100, 2) . '%'),
			"data"                            => $data,
		);
		echo json_encode($output);
	}
	
	public function personas_registradas()
	{
		if ($this->_configuracion->BOL_REGIST) {
			$data_view['titulo']  = 'Personas Registradas';
			$data_view['load_js'] = $this->path_js;
			$this->load->view('personas_registradas', $data_view);
			return false;
		} else {
			$this->session->set_flashdata('error', 'No es posible ver el reporte, configuración del'
			. ' sistema sin registro previo.');
			redirect('administrador');
		}
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Personas sin registrarse.
	*/
	public function get_all_personas_registradas()
{
    $list = $this->Inf_personas_registradas->get_datatables();
    $data = array();
    $no   = $this->input->post('start');
    
    foreach ($list as $all_personas_registradas) {
        $no++;
        $row   = array();
        $row[] = $all_personas_registradas->NUM_IDETER;
        $row[] = $all_personas_registradas->TEX_NOMPAR . ' ' . $all_personas_registradas->TEX_APEPAR;
        $row[] = $all_personas_registradas->NUM_PESO;
        $row[] = $all_personas_registradas->TEX_NOMCIU;
        $row[] = $all_personas_registradas->TEX_NOMAGE;
        $row[] = $all_personas_registradas->FEC_REGIST;

        // NUEVA COLUMNA: usuario que realizó el registro (usa el alias que pusiste en el SELECT)
        $row[] = !empty($all_personas_registradas->TEX_USUARIO_REG)
                 ? $all_personas_registradas->TEX_USUARIO_REG
                 : (!empty($all_personas_registradas->NOM_USUARIO_REG) ? $all_personas_registradas->NOM_USUARIO_REG : '-');

        $data[] = $row;
    }

    $output = array(
        "draw"                         => $this->input->post('draw'),
        "recordsTotal"                 => $this->Inf_personas_registradas->count_all(),
        "recordsFiltered"              => $this->Inf_personas_registradas->count_filtered(),
        'registradas'                  => $this->Inf_personas_registradas->count_all(),
        'poblacion'                    => $this->_poblacion_total,
        'porcentaje_total_poblacion'   => '100%',
        'porcentaje_total_registradas' => (number_format(((int) $this->Inf_personas_registradas->count_all() / (int) $this->_poblacion_total) * 100, 2) . '%'),
        "data"                         => $data,
    );
    echo json_encode($output);
}

	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------


// 1) Cargar el informe NUEVO
public function solicitudes_contra_voto()
{
    // Solo disponible si el tipo de ingreso es CC+CONTRASEÑA
    if ($this->_configuracion->NUM_VALING !== 'W') {
        $this->session->set_flashdata('error', "Este informe solo está disponible cuando el tipo de ingreso es Identificación y Clave (CC + Contraseña).");
        redirect('administrador');
        return;
    }

    $data_view['titulo']  = 'Personas que solicitaron contraseña (con Voto Sí/No)';
    $data_view['load_js'] = $this->path_js;
    $this->load->view('solicitudes_contra_voto', $data_view);
}

// 2) DataTables server-side
public function get_solicitudes_contra_voto()
{
    // Doble validación por seguridad
    if ($this->_configuracion->NUM_VALING !== 'W') {
        show_error('No autorizado para este tipo de ingreso', 403);
        return;
    }

    $this->load->model('informes/Inf_solicitudes_contra_voto');
    $list = $this->Inf_solicitudes_contra_voto->get_datatables();

    $data = [];
    $no   = $this->input->post('start');

    foreach ($list as $row) {
        $no++;
        $data[] = [
            $row->NUM_IDETER,
            $row->TEX_NOMPAR . ' ' . $row->TEX_APEPAR,
            $row->TEX_NOMAGE,
            $row->FEC_ULT_SOL,
            (int)$row->VECES,
            $row->VOTO,
        ];
    }

    $output = [
        "draw"            => $this->input->post('draw'),
        "recordsTotal"    => $this->Inf_solicitudes_contra_voto->count_all(),
        "recordsFiltered" => $this->Inf_solicitudes_contra_voto->count_filtered(),
        "total"           => $this->Inf_solicitudes_contra_voto->count_all(),
        "data"            => $data,
    ];

    echo json_encode($output);
}



	
	/**
	* Participantes.
	*/
	public function participantes()
	{
		$data_view['titulo']  = 'Personas que han participado';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('participantes', $data_view);
	}
	
	/**
	* Participantes load.
	*/
	public function get_all_participantes()
	{
		$list = $this->Inf_participantes->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $partipantes) {
			$no++;
			$row    = array();
			$row[]  = $partipantes->NUM_IDETER;
			$row[]  = $partipantes->TEX_NOMPAR . ' ' . $partipantes->TEX_APEPAR;
			$row[]  = $partipantes->TEX_NOMCIU;
			$row[]  = $partipantes->TEX_NOMAGE;
			$row[]  = $partipantes->FEC_PROVOT;
			$row[]  = $partipantes->TEX_IPORIG;
			$data[] = $row;
		}
		$output = array(
			"draw"                           => $this->input->post('draw'),
			"recordsTotal"                   => $this->Inf_participantes->count_all(),
			"recordsFiltered"                => $this->Inf_participantes->count_filtered(),
			"data"                           => $data,
			'poblacion'                      => $this->_poblacion_total,
			'porcentaje_total_poblacion'     => '100%',
			'participacion'                  => $this->Inf_participantes->count_all(),
			'porcentaje_total_participacion' => (number_format(((int) $this->Inf_participantes->count_all() / (int) $this->_poblacion_total) * 100, 2) . '%'),
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	/**
	* Participantes.
	*/
	public function participantes_bloqueados()
	{
		if ($this->_configuracion->NUM_VALING != 'W') {
			$this->session->set_flashdata('error', 'No es posible ver el reporte, la configuración del'
			. ' sistema debe estar en tipo de acceso usuario y contraseña.');
			redirect('administrador');
		} else {
			$data_view['titulo']  = 'Personas bloqueadas sin votar';
			$data_view['load_js'] = $this->path_js;
			$this->load->view('participantes_bloqueados', $data_view);
		}
	}
	
	/**
	* Participantes load.
	*/
	public function get_all_participantes_bloqueados()
	{
		$list = $this->Inf_participantes_bloqueados->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $participantes) {
			$estado = ($participantes->bloqueado && (int)$participantes->intentos_login >= (int)$this->_configuracion->NUM_INLOGIN)?'Bloqueo Intentos':'';
			if(!$estado) {
				$estado =	($participantes->inicio_sesion)?'Bloqueo inicio sesión':'';
			}
			$no++;
			$row    = array();
			$row[]  = $participantes->NUM_IDETER;
			$row[]  = $participantes->TEX_NOMPAR . ' ' . $participantes->TEX_APEPAR;
			$row[]  = $participantes->TEX_NOMCIU;
			$row[]  = $participantes->TEX_NOMAGE;
			$row[]  = $estado;
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_participantes_bloqueados->count_all(),
			"recordsFiltered" => $this->Inf_participantes_bloqueados->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Personas en el auditorio.
	*/
	public function personas_en_auditorio()
	{
		$data_view['titulo']  = 'Personas en el Auditorio';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('personas_en_auditorio', $data_view);
	}
	
	/**
	* Personas en auditorio load.
	*/
	public function get_personas_en_auditorio()
	{
		$list = $this->Inf_personas_en_auditorio->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $personas_en_auditorio) {
			
			$no++;
			$row   = array();
			$row[] = $personas_en_auditorio->NUM_IDETER;
			$row[] = $personas_en_auditorio->ingresos;
			$row[] = $personas_en_auditorio->TEX_NOMPAR . ' ' . $personas_en_auditorio->TEX_APEPAR;
			$row[] = $this->get_fecha($personas_en_auditorio->FEC_INGSAL);
			$row[] = 'Ingreso: ' . $this->get_hora($personas_en_auditorio->FEC_INGSAL);
			$row[] = $data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_personas_en_auditorio->count_all(),
			"recordsFiltered" => $this->Inf_personas_en_auditorio->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Registrados sin participar.
	*/
	public function registrados_sin_participar()
	{
		if ($this->_configuracion->BOL_REGIST) {
			$data_view['titulo']  = 'Personas en el Auditorio Sin Participar';
			$data_view['load_js'] = $this->path_js;
			$this->load->view('registrados_sin_participar', $data_view);
			return false;
		} else {
			$this->session->set_flashdata('error', 'No es posible ver el reporte, configuración del'
			. ' sistema sin registro previo.');
			redirect('administrador');
		}
		
	}
	
	/**
	* Registrados sin participar load.
	*/
	public function get_registrados_sin_participar()
	{
		$list = $this->Inf_registrados_sin_participar->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $registrados_sin_participar) {
			$no++;
			$row   = array();
			$row[] = $registrados_sin_participar->NUM_IDETER;
			$row[] = $registrados_sin_participar->TEX_NOMPAR . ' ' . $registrados_sin_participar->TEX_APEPAR;
			$row[] = $registrados_sin_participar->TEX_NOMCIU;
			$row[] = $registrados_sin_participar->TEX_NOMAGE;
			
			$data[] = $row;
		}
		$output = array(
			"draw"                           => $this->input->post('draw'),
			"recordsTotal"                   => $this->Inf_registrados_sin_participar->count_all(),
			"recordsFiltered"                => $this->Inf_registrados_sin_participar->count_filtered(),
			"data"                           => $data,
			'poblacion'                      => $this->_poblacion_total,
			'porcentaje_total_poblacion'     => '100%',
			'sin_participar'                  => $this->Inf_registrados_sin_participar->count_all(),
			'porcentaje_sin_participar' => (number_format(((int) $this->Inf_registrados_sin_participar->count_all() / (int) $this->_poblacion_total) * 100, 2) . '%'),
		);
		
		echo json_encode($output);
	}
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------
	
	/**
	* Registrados sin participar.
	*/
	public function personas_fuera_auditorio()
	{
		$data_view['titulo']  = 'Personas en el Auditorio Sin Participar';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('personas_fuera_auditorio', $data_view);
	}
	
	/**
	* Personas sin participar load.
	*/
	public function get_personas_fuera_auditorio()
	{
		$list = $this->Inf_personas_fuera_auditorio->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $personas_fuera_auditorio) {
			
			$no++;
			$row   = array();
			$row[] = $personas_fuera_auditorio->NUM_IDETER;
			$row[] = $personas_fuera_auditorio->ingresos;
			$row[] = $personas_fuera_auditorio->TEX_NOMPAR . ' ' . $personas_fuera_auditorio->TEX_APEPAR;
			$row[] = $this->get_fecha($personas_fuera_auditorio->FEC_INGSAL);
			$row[] = 'Salida: ' . $this->get_hora($personas_fuera_auditorio->FEC_INGSAL);
			$row[] = $data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_personas_fuera_auditorio->count_all(),
			"recordsFiltered" => $this->Inf_personas_fuera_auditorio->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Asistentes hábiles
	*/
	public function asistentes_habiles()
	{
		$data_view['titulo']  = 'Asistentes Hábiles';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('asistentes_habiles', $data_view);
	}
	
	/**
	* Personas en auditorio load.
	*/
	public function get_asistentes_habiles()
	{
		$list = $this->Inf_asistentes_habiles->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $asistentes_habiles) {
			
			$no++;
			$row    = array();
			$row[]  = $asistentes_habiles->NUM_IDETER;
			$row[]  = $asistentes_habiles->TEX_NOMPAR . ' ' . $asistentes_habiles->TEX_APEPAR;
			$row[]  = $asistentes_habiles->NUM_PESO;
			$row[]  = $asistentes_habiles->TEX_NOMCIU;
			$row[]  = $asistentes_habiles->TEX_NOMAGE;
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_asistentes_habiles->count_all(),
			"recordsFiltered" => $this->Inf_asistentes_habiles->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* Listado de participantes que solicitaron la contraseña
	*/
	public function log_recordar_password()
	{
		$data_view['titulo']  = 'Log recordatorio de contraseña';
		$data_view['load_js'] = $this->path_js;
		$this->load->view('log_recordar_password', $data_view);
	}
	
	/**
	* Personas en auditorio load.
	*/
	public function get_log_recordar_password()
	{
		$list = $this->Log_recordar_password->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $log) {
			
			$no++;
			$row    = array();
			$row[]  = $log->NUM_IDETER;
			$row[]  = $log->TEX_NOMPAR . ' ' . $log->TEX_APEPAR;
			$row[]  = $log->TEX_TIPOENVIO;
			$row[]  = ($log->TEX_TIPOENVIO === 'Email')?$log->TEX_MAIL:$log->NUM_TELCEL;
			$row[]  = $log->TEX_NOMAGE;
			$row[]  = $log->TEX_IPORIG;
			$row[]  = $log->FEC_GENERACION;
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Log_recordar_password->count_all(),
			"recordsFiltered" => $this->Log_recordar_password->count_filtered(),
			'total' => $this->Log_recordar_password->count_all(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-----------------------------------------------------------------------------
	//-----------------------------------------------------------------------------
	
	/**
	* General Candidatos
	*/
	public function candidatos()
	{
		$data_view['titulo']          = 'General Candidatos';
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['load_js']         = $this->path_js;
		$data_view['graficos']        = $this->graficos_js;
		$this->load->view('general_candidatos', $data_view);
	}
	
	/**
	* General Candidatos load.
	*/
	public function get_general_candidatos()
	{
		$list = $this->Inf_candidatos->get_datatables();
		
		$data        = array();
		$no          = $this->input->post('start');
		$total_votos = 0;
		
		foreach ($list as $votos) {
			$voto_individual = ($votos->votos) ? $votos->votos : 0;
			$total_votos += $voto_individual;
		}
		foreach ($list as $candidatos) {
			$voto_individual = ($candidatos->votos) ? $candidatos->votos : 0;
			$no++;
			$row    = [];
			$row[]  = $candidatos->ID_CANDID;
			$row[]  = $candidatos->TEX_NOMCAN . ' ' . $candidatos->TEX_APECAN;
			$row[]  = $voto_individual;
			$row[]  = $candidatos->TEX_NOMINS;
			$row[]  = $candidatos->TEX_NOMCIU;
			$row[]  = $candidatos->TEX_NOMAGE;
			$row[]  = $this->_calculate_percent_votos($voto_individual, $total_votos);
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_candidatos->count_all(),
			"recordsFiltered" => $this->Inf_candidatos->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------    
	
	/**
	* Personas sin Participar
	*/
	
	public function personas_sin_participar()
	{
		$data_view['titulo']          = 'Personas sin Participar';
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['load_js']         = $this->path_js;
		$data_view['graficos']        = $this->graficos_js;
		$this->load->view('personas_sin_participar', $data_view);
	}
	
	
	public function get_all_personas_sin_participar()
	{
		$list = $this->Inf_personas_sin_participar->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $personas_sin_participar) {
			$no++;
			$row   = array();
			$row[] = $personas_sin_participar->NUM_IDETER;
			$row[] = $personas_sin_participar->TEX_NOMPAR . ' ' . $personas_sin_participar->TEX_APEPAR;
			$row[] = $personas_sin_participar->TEX_NOMCIU;
			$row[] = $personas_sin_participar->TEX_NOMAGE;
			$row[] = $personas_sin_participar->TEX_MAIL;
			$row[] = $personas_sin_participar->NUM_TELCEL;
			
			$data[] = $row;
		}
		$output = array(
			"draw"                            => $this->input->post('draw'),
			"recordsTotal"                    => $this->Inf_personas_sin_participar->count_all(),
			"recordsFiltered"                 => $this->Inf_personas_sin_participar->count_filtered(),
			'no_registradas'                  => $this->Inf_personas_sin_participar->count_all(),
			'poblacion'                       => $this->_poblacion_total,
			'porcentaje_total_poblacion'      => '100%',
			'porcentaje_total_no_registradas' => (number_format(((int) $this->Inf_personas_sin_participar->count_all() / (int) $this->_poblacion_total) * 100, 2) . '%'),
			"data"                            => $data,
		);
		echo json_encode($output);
	}
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------
	
	/**
	* Por instancias.
	*/


// =========================================================
// FUNCION AUXILIAR - genera los .xls con HTML
// =========================================================
private function generar_excel_simple($nombre_archivo, $data, $headers = [])
{
    $ruta = FCPATH . 'uploads/reportes/export/' . $nombre_archivo;
    $f = fopen($ruta, 'w');
    fwrite($f, "<table border='1' style='border-collapse:collapse;'>");

    if (!empty($data['data'])) {
        // Encabezados
        fwrite($f, "<tr style='background-color:#eaeaea;font-weight:bold;'>");
        $cols = !empty($headers) ? $headers : array_keys($data['data'][0]);
        foreach ($cols as $columna) fwrite($f, "<th>".htmlspecialchars($columna)."</th>");
        fwrite($f, "</tr>");

        // Filas
        foreach ($data['data'] as $fila) {
            fwrite($f, "<tr>");
            foreach ($fila as $valor) fwrite($f, "<td>".htmlspecialchars($valor)."</td>");
            fwrite($f, "</tr>");
        }
    } else {
        fwrite($f, "<tr><td>Sin datos</td></tr>");
    }

    fwrite($f, "</table>");
    fclose($f);
}


	public function por_instancias()
	{
		
		
		if (!$this->_permisos['informes']['informes_por_instancias']['MOSTRAR_FRONT']){
			$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
			redirect('administrador');
			
		}
		
		
		$data_view['titulo']          = 'Informe por Instancias';
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['load_js']         = $this->path_js;
		
		
		if (!$this->input->post()) {
			$data_view['titulo']     = 'Selecione la Instancia';
			$data_view['instancias'] = $this->Inf_por_instancias->select_forms('evi02instan', 'ID_INSTAN', 'TEX_NOMINS','BOL_ACTIVO',null, null,null,null, true );
			$data_view['load_js']         = false;
			$this->load->view('form_por_instancia', $data_view);
		} else {
			
			$data_view['graficos']         = $this->graficos_js;
			$data_view['nombre_instancia'] = $this->Instancia->get($this->input->post('ID_INSTAN'));
			
			
			//Todas la instancias.
		 $ruta_export = FCPATH . 'uploads/reportes/export/';
    if (!is_dir($ruta_export)) {
        mkdir($ruta_export, 0777, true);
    }

    // =========================================================
    // 🧩 CASO 1: TODAS LAS INSTANCIAS (ZIP de 4 reportes)
    // =========================================================
    if ($this->input->post('TIPO_ENTIDAD')  == 'ET') {
		$id_instancia = $this->input->post('ID_INSTAN');
        // Generar reportes
        $nombre_archivo_por_instancias_candidatos = 'por_instancias_candidatos.xls';  
        $nombre_archivo_por_instancias_participantes = 'por_instancias_participantes.xls';  
        $nombre_archivo_por_instancias_sin_participar = 'por_instancias_sin_participar.xls';  
        $nombre_archivo_por_instancias_en_auditorio_sin_participar = 'por_instancias_en_auditorio_sin_participar.xls';  

        $this->generar_excel_simple($nombre_archivo_por_instancias_candidatos, $this->get_por_instancias($id_instancia, true), [
            'ID Candidato', 'Nombre', 'Votos', 'Instancia', 'Agencia o Zona', '%'
        ]);
        $this->generar_excel_simple($nombre_archivo_por_instancias_participantes, $this->get_por_instancias_participantes($id_instancia, true), [
            'ID Participante', 'Nombre', 'Peso', 'Fecha Participa', 'Instancia', 'Agencia o Zona'
        ]);
        $this->generar_excel_simple($nombre_archivo_por_instancias_sin_participar, $this->get_por_instancias_sin_participar($id_instancia, true), [
            'Id Participante', 'Nombres', 'Peso', 'Ciudad', 'Agencia o Zona'
        ]);
        $this->generar_excel_simple($nombre_archivo_por_instancias_en_auditorio_sin_participar, $this->get_por_instancias_registrados_sin_participar($id_instancia, true), [
            'Id Participante', 'Nombres', 'Peso', 'Ciudad', 'Agencia o Zona'
        ]);

        // Crear ZIP con todos los reportes
        $zip_file = $ruta_export . 'reportes_por_instancia_todos.zip';
        $zip = new ZipArchive();
        $zip->open($zip_file, ZipArchive::CREATE | ZipArchive::OVERWRITE);
        foreach ([
            $nombre_archivo_por_instancias_candidatos,
            $nombre_archivo_por_instancias_participantes,
            $nombre_archivo_por_instancias_sin_participar,
            $nombre_archivo_por_instancias_en_auditorio_sin_participar
        ] as $archivo) {
            $zip->addFile($ruta_export . $archivo, $archivo);
        }
        $zip->close();

        // Descargar ZIP
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=' . basename($zip_file));
        header('Content-Length: ' . filesize($zip_file));
        readfile($zip_file);
        exit;
    }

			
			
			// Solo candidatos
			if($this->input->post('TIPO_ENTIDAD') == 'C'){ 
				
				if (!$this->_permisos['informes']['informes_por_instancias_candidatos']['MOSTRAR_FRONT']){
					$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
					redirect('administrador');
					
				}
				
				//Todas la instancias.
				if($this->input->post('ID_INSTAN') == 'T'){
					$data_view['titulo']  = 'Informe todas las Instancias';
					$data_view['instancias'] = $this->Inf_por_instancias->get_all_instancias();
					$this->load->view('por_instancias_todas', $data_view);
					return false;
				}
				
				$data_view['instancia']        = $this->input->post('ID_INSTAN');
				$this->load->view('por_instancias', $data_view);
				// Solo Participantes
			} else if($this->input->post('TIPO_ENTIDAD') == 'P') {
				
				if (!$this->_permisos['informes']['informes_por_instancias_participantes']['MOSTRAR_FRONT']){
					$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
					redirect('administrador');
					
				}
				
				//Todas la instancias.
				if($this->input->post('ID_INSTAN') == 'T'){
					$data_view['titulo']  = 'Informe todas las Instancias';
					$data_view['instancias'] = $this->Inf_por_instancias->get_all_instancias('P');
					$this->load->view('por_instancias_todas_participantes', $data_view);
					return false;
				}
				
				// Instancias por participantes
				$data_view['titulo']          = 'Informe por Instancias Participantes';
				$data_view['instancia']        = $this->input->post('ID_INSTAN');
				$this->load->view('por_instancia_participantes', $data_view);
				
			} 
			// Solo Personas sin participar
			else if($this->input->post('TIPO_ENTIDAD') =='PSP'){
				
				if (!$this->_permisos['informes']['informes_por_instancias_personas_sin_participar']['MOSTRAR_FRONT']){
					$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
					redirect('administrador');
					
				}
				
				//Todas la instancias.
				if($this->input->post('ID_INSTAN') == 'T'){
					$data_view['titulo']  = 'Informe todas las Instancias - Personas sin participar';
					$this->load->view('personas_sin_participar', $data_view);
					return false;
				}
				
				// Instancias personas sin participar.
				$data_view['titulo']          = 'Informe por Instancia - Personas sin participar';
				$data_view['instancia']        = $this->input->post('ID_INSTAN');
				$this->load->view('por_instancias_sin_participar', $data_view);
				
			} 
			// Solo Personas registradas sin participar
			else if ($this->input->post('TIPO_ENTIDAD') =='RSP') {
				
				if (!$this->_permisos['informes']['informes_por_instancias_registrados_sin_participar']['MOSTRAR_FRONT']){
					$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
					redirect('administrador');
					
				}
				
				//Todas la instancias.
				if($this->input->post('ID_INSTAN') == 'T'){
					$data_view['titulo']  = 'Informe todas las Instancias - Personas en el Auditorio Sin Participar';
					$this->load->view('por_instancia_todas_registrados_sin_participar', $data_view);
					return false;
				}
				
				// Por instancia.
				$data_view['titulo']          = 'Informe por Instancia - Personas sin participar';
				$data_view['instancia']        = $this->input->post('ID_INSTAN');
				$this->load->view('por_instancia_registrados_sin_participar', $data_view);
				
			}
			else {
				$this->session->set_flashdata('error', "Debe seleccionar una opcion");
				redirect('administrador');
			} // end tipo_entidad
			
		}
	}
	
	/*
	* Por instancias load.
	*/
	
	public function get_por_instancias($instancia, $return_data=false)
	{
		$list = $this->Inf_por_instancias->get_datatables($instancia);
		$data = array();
		$no   = $this->input->post('start');
		
		$total_votos = 0;
		
		foreach ($list as $votos) {
			$voto_individual = ($votos->NUM_TOVOCA) ? $votos->NUM_TOVOCA : 0;
			$total_votos += $voto_individual;
		}
		
		foreach ($list as $por_instancias) {
			
			$no++;
			$row    = [];
			$row[]  = $por_instancias->ID_CANDID;
			$row[]  = $por_instancias->TEX_NOMCAN . ' ' . $por_instancias->TEX_APECAN;
			$row[]  = ($por_instancias->NUM_TOVOCA) ? number_format(str_replace(',', '.',$por_instancias->NUM_TOVOCA), 2) : 0;
			$row[]  = $por_instancias->TEX_NOMINS;
			$row[]  = $por_instancias->TEX_NOMAGE;
			$row[]  = $this->_calculate_percent_votos($por_instancias->NUM_TOVOCA, $total_votos);
			
			$data[] = $row;
		}
		
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_por_instancias->count_all(),
			"recordsFiltered" => $this->Inf_por_instancias->count_filtered(),
			"data"            => $data,
		);
		if($return_data){
			return $output;
		}
		
		echo json_encode($output);
	}
	
	
	/**
	* Por instancias participantes
	*/
	
	public function get_por_instancias_participantes($instancia, $return_data=false)
	{
		$list = $this->Inf_por_instancias_participantes->get_datatables($instancia);
		$data = array();
		$no   = $this->input->post('start');
		foreach ($list as $por_instancias) {
			
			$no++;
			$row    = [];
			$row[]  = $por_instancias->NUM_IDETER;
			$row[]  = $por_instancias->TEX_NOMPAR . ' ' . $por_instancias->TEX_APEPAR;
			$row[]  = $por_instancias->NUM_PESO;
			$row[]  = $por_instancias->FEC_PROVOT;
			$row[]  = $por_instancias->TEX_NOMINS;
			$row[]  = $por_instancias->TEX_NOMAGE;
			$data[] = $row;
		}
		
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_por_instancias->count_all(),
			"recordsFiltered" => $this->Inf_por_instancias->count_filtered(),
			'poblacion'                       => $this->_poblacion_total,
			'porcentaje_total_poblacion'      => '100%',
			'participantes_por_instancia'      => count($list),
			'porcentaje_total_por_instancia' => (number_format(((int) count($list) / (int) $this->_poblacion_total) * 100, 2) . '%'),
			"data"                            => $data,
		);
		
		if($return_data){
			return $output;
		}
		
		echo json_encode($output);
	}
	
	/**
	* Por instancia sin participar.
	*
	* @param [type] $instancia
	* @return void
	*/
	public function get_por_instancias_sin_participar($instancia, $return_data=false)
	{
		$list = $this->Inf_por_instancias_sin_participar->get_datatables($instancia);
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $registrados_sin_participar) {
			$no++;
			$row   = array();
			$row[] = $registrados_sin_participar->NUM_IDETER;
			$row[] = $registrados_sin_participar->TEX_NOMPAR . ' ' . $registrados_sin_participar->TEX_APEPAR;
			$row[] = $registrados_sin_participar->NUM_PESO;
			$row[] = $registrados_sin_participar->TEX_NOMCIU;
			$row[] = $registrados_sin_participar->TEX_NOMAGE;
			
			$data[] = $row;
		}
		$output = array(
			"draw"                           => $this->input->post('draw'),
			"recordsTotal"                   => $this->Inf_por_instancias_sin_participar->count_all(),
			"recordsFiltered"                => $this->Inf_por_instancias_sin_participar->count_filtered(),
			"data"                           => $data,
			'poblacion'                      => $this->_poblacion_total,
			'porcentaje_total_poblacion'     => '100%',
			'sin_participar'                  => $this->Inf_por_instancias_sin_participar->count_all(),
			'porcentaje_sin_participar' => (number_format(((int) count($list) / (int) $this->_poblacion_total) * 100, 2) . '%'),
		);
		
		if($return_data){
			return $output;
		}
		
		echo json_encode($output);
	}
	
	
	/**
	* Get por instancias registrados sin participar - Todas. 
	*/
	/**
	* Por instancia sin participar.
	*
	* @param [type] $instancia
	* @return void
	*/
	public function get_por_instancias_registrados_sin_participar($instancia=null,$return_data=false)
	{
		$list = $this->Inf_por_instancias_registrados_sin_participar->get_datatables($instancia);
		$data = array();
		$no   = $this->input->post('start');
		
		foreach ($list as $registrados_sin_participar) {
			$no++;
			$row   = array();
			$row[] = $registrados_sin_participar->NUM_IDETER;
			$row[] = $registrados_sin_participar->TEX_NOMPAR . ' ' . $registrados_sin_participar->TEX_APEPAR;
			$row[] = $registrados_sin_participar->NUM_PESO;
			$row[] = $registrados_sin_participar->TEX_NOMCIU;
			$row[] = $registrados_sin_participar->TEX_NOMAGE;
			
			$data[] = $row;
		}
		$output = array(
			"draw"                           => $this->input->post('draw'),
			"recordsTotal"                   => $this->Inf_por_instancias_registrados_sin_participar->count_all(),
			"recordsFiltered"                => $this->Inf_por_instancias_registrados_sin_participar->count_filtered(),
			"data"                           => $data,
			'poblacion'                      => $this->_poblacion_total,
			'porcentaje_total_poblacion'     => '100%',
			'sin_participar'                  => $this->Inf_por_instancias_registrados_sin_participar->count_all(),
			'porcentaje_sin_participar' => (number_format(((int) count($list) / (int) $this->_poblacion_total) * 100, 2) . '%'),
		);
		
		if($return_data){
			return $output;
		}
		
		echo json_encode($output);
	}
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------
	
	/**
	* Resumen por agencias.
	*/
	public function resumen_por_agencia()
	{
		
		if (!$this->_permisos['informes']['informes_resumen_por_agencia']['MOSTRAR_FRONT']){
			$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
			redirect('administrador');
			
		}
		
		$data_view['titulo']          = 'Resumen por '.$this->session->userdata('NOMBRE_SEGMENTO');
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['load_js']         = $this->path_js;
		$data_view['graficos']        = $this->graficos_js;
		$this->load->view('resumen_por_agencia', $data_view);
	}
	
	/*
	* Resumen por agencias load.
	*/
	
	public function get_resumen_por_agencia()
	{
		$list        = $this->Inf_resumen_por_agencia->get_datatables();
		$data        = array();
		$no          = $this->input->post('start');
		$total_votos = 0;
		
		foreach ($list as $votos) {
			$voto_por_agencia = ($votos->votos) ? $votos->votos : 0;
			$total_votos += $voto_por_agencia;
		}
		foreach ($list as $resumen_por_agencia) {
			$votos_por_agencia = ($resumen_por_agencia->votos) ? $resumen_por_agencia->votos : 0;
			$sufragantes = $this->Inf_resumen_por_agencia->get_sufragantes($resumen_por_agencia->COD_AGENCIA);
			$participantes = $this->Inf_resumen_por_agencia->get_participantes_by_agencia($resumen_por_agencia->COD_AGENCIA);
			$no++;
			$row   = [];
			$row[] = $resumen_por_agencia->COD_AGENCIA;
			$row[] = $resumen_por_agencia->TEX_NOMAGE;
			$row[] = ($participantes->participantes)?$participantes->participantes:0;
			$row[] = (isset($sufragantes))?$sufragantes:0;
			$row[] = ($resumen_por_agencia->votos) ? $resumen_por_agencia->votos : 0;
			$row[] = $this->_calculate_participacion($participantes->participantes, $sufragantes);
			
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_resumen_por_agencia->count_all(),
			"recordsFiltered" => $this->Inf_resumen_por_agencia->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	/**
	*  Calcula el porcentaje de votos
	* @param type $num_votos
	* @param type $total_votos
	* @return type
	*/
	private function _calculate_participacion($total_participantes, $total_sufragantes)
	{
		if ($total_participantes > 0) {
			$res = ((int) $total_sufragantes / (int) $total_participantes) * 100;
			return number_format($res, 2) . '%';
		} else {
			return 0;
		}
	}
	
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------
	
	/**
	* Por agencias.
	*/
	public function por_agencia()
	{
		
		if (!$this->_permisos['informes']['informes_por_agencia']['MOSTRAR_FRONT']){
			$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
			redirect('administrador');
			
		}
		$data_view['titulo']          = 'Reporte por '.$this->session->userdata('NOMBRE_SEGMENTO');
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['graficos']        = $this->graficos_js;
		$data_view['load_js']         = $this->path_js;
		
		if (!$this->input->post()) {
			$data_view['titulo'] = 'Selecione '.$this->session->userdata('NOMBRE_SEGMENTO');
			//Agencia usuario.
			$data_view['agencias'] = $this->Inf_resumen_por_agencia->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE', null, null, null, null, true);
			$this->load->view('form_por_agencia', $data_view);
		} else {
			$data_view['agencia']        = $this->input->post('COD_AGENCIA');
			$data_view['nombre_agencia'] = $this->Agencia->get($this->input->post('COD_AGENCIA'));
			$this->load->view('por_agencia', $data_view);
		}
	}
	
	/*
	* Por agencia load.
	*/
	
	public function get_por_agencia($agencia)
	{
		$this->ini_desencriptado();
		$list        = $this->Inf_por_agencia->get_datatables($agencia);
		$data        = array();
		$no          = $this->input->post('start');
		$total_votos = 0;
		
		foreach ($list as $votos) {
			$voto_individual = ($votos->votos) ? $votos->votos : 0;
			$total_votos += $voto_individual;
		}
		
		foreach ($list as $por_agencia) {
			$voto_individual = ($por_agencia->votos) ? $por_agencia->votos : 0;
			$no++;
			$row    = [];
			$row[]  = $por_agencia->ID_CANDID;
			$row[]  = $por_agencia->TEX_NOMCAN . ' ' . $por_agencia->TEX_APECAN;
			$row[]  = $voto_individual;
			$row[]  = $this->_calculate_percent_votos($voto_individual, $total_votos);
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_por_agencia->count_all(),
			"recordsFiltered" => $this->Inf_por_agencia->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	/*
	* Por instancias load.
	*/
	
	public function get_candidatos_por_agencia()
	{
		$candidatos_con_votos = $this->Inf_candidatos_por_agencia->get_candidatos_con_votos();
		
		$arr = [];
		foreach ($candidatos_con_votos as $candidato) {
			$arr[] = [
				'nombre_candidato'  => $candidato->TEX_NOMCAN . ' ' . $candidato->TEX_APECAN,
				'votos_por_agencia' =>
				$this->Inf_candidatos_por_agencia->get_votos_candidato_por_agencia($candidato->ID_CANDID, $candidato->COD_AGENCIA),
			];
		}
		
		$data_view['candidatos_agencias'] = $arr;
		$data_view['votos_agencias']      = $this->Inf_candidatos_por_agencia->get_votos_agencia();
		$data_view['agencias_votacion']   = $this->Inf_candidatos_por_agencia->all_agencias();
		$data_view['load_js']             = $this->path_js;
		
		$this->load->view('candidatos_por_agencia', $data_view);
	}
	
	//-------------------------------------------------------------------------
	//-------------------------------------------------------------------------
	
	/**
	* Devuelve la hora a partir de un datetime.
	*
	* @param type $fecha
	* @return type
	*/
	public function get_hora($fecha)
	{
		$hora = new DateTime($fecha);
		return $hora->format('H:i:s');
	}
	
	/**
	* Devuelve fecha en formato (Y/m/d)
	*
	* @param type $fecha
	* @return type
	*/
	public function get_fecha($fecha)
	{
		$fecha_final = new DateTime($fecha);
		return $fecha_final->format('Y/m/d');
	}
	
	/**
	*  Calcula el porcentaje de votos
	* @param type $num_votos
	* @param type $total_votos
	* @return type
	*/
	private function _calculate_percent_votos($num_votos, $total_votos)
	{
		if ($total_votos > 0) {
			$res = ((int) $num_votos / (int) $total_votos) * 100;
			return number_format($res, 2) . '%';
		} else {
			return 0;
		}
	}
	
	public function get_por_cociente()
	{
		$listas          = $this->Inf_por_cociente->get_listas();
		$datos_instancia = $this->Inf_por_cociente->get_datos_instancia();
		
		$total_votos_global = $this->Inf_por_cociente->get_total_votos_listas();
		
		if ((int) $total_votos_global->votos < 30) {
			$this->session->set_flashdata('error', "El numero de votos total ($total_votos_global->votos) es muy bajo para realizar el cálculo.");
			redirect('administrador');
		} 
		
		$cociente = $this->_get_cociente_electoral($total_votos_global->votos, $datos_instancia->cargos_a_suplir);
		
		$arr           = [];
		$residuos      = [];
		$total_rxc     = 0;
		$total_rxr     = 0;
		$total_enteros = 0;
		foreach ($listas as $key => $lista) {
			$cociente_por_lista = $this->_get_cociente_electoral($lista->votos, $cociente);
			$rxc                = floor($cociente_por_lista);
			
			$n        = $cociente_por_lista;
			$whole    = floor($n); // 1
			$fraction = $n - $whole; // .25
			$rxr      = $fraction;
			
			$limit_candidato = $rxc + $rxr;
			
			$total_rxc += $rxc;
			
			$arr[] = [
				'id_lista'           => $lista->ID_LISTA,
				'nombre_lista'       => $lista->TEX_NOMLIS,
				'votos'              => ($lista->votos) ? $lista->votos : 0,
				// 'candidatos'   => $this->Inf_por_cociente->get_candidatos_por_lista($lista->ID_LISTA, $limit_candidato),
				'candidatos'         => [],
				'cociente_por_lista' => ($lista->TEX_NOMLIS === 'VOTO EN BLANCO') ? 0 : number_format($cociente_por_lista, $datos_instancia->decimales_size, ',', ' '),
				'rxc'                => ($lista->TEX_NOMLIS === 'VOTO EN BLANCO') ? 0 : (int) $whole,
				'rxr'                => ($lista->TEX_NOMLIS === 'VOTO EN BLANCO') ? 0 : $rxr,
				'total_r'            => ($lista->TEX_NOMLIS === 'VOTO EN BLANCO') ? 0 : 0,
			];
			
			$total_enteros += $whole;
		}
		
		$cargos_a_suplir      = $datos_instancia->cargos_a_suplir;
		$candidatos_restantes = (int) $cargos_a_suplir - $total_enteros;
		$residuos              = array_column($arr, 'rxr');
		$residuos_seleccionado = [];
		
		if ($cargos_a_suplir == 15) {
			$candidatos_restantes = 3;
		}
		if ($cargos_a_suplir > 15) {
			$candidatos_restantes = 5;
		}
		if ($cargos_a_suplir >= 25) {
			$candidatos_restantes = 4;
		}
		
		if ($cargos_a_suplir >= 30) {
			$candidatos_restantes = 5;
		}
		if ($cargos_a_suplir == 40) {
			$candidatos_restantes = 6;
		}
		
		if ($cargos_a_suplir == 50) {
			$candidatos_restantes = 6;
		}
		
		for ($index = 0; $index < (int) $candidatos_restantes; $index++) {
			$key                      = array_search(max($residuos), $residuos);
			$residuos_seleccionados[] = $key;
			unset($residuos[$key]);
		}
		
		foreach ($residuos_seleccionados as $value) {
			$arr[$value]['rxr'] = 1;
		}
		
		$limit_candidato = 0;
		foreach ($arr as $key => $lista_final) {
			if ($lista_final['rxr'] != 1) {
				$arr[$key]['rxr'] = 0;
			}
			$limit_candidato         = $arr[$key]['rxc'] + $arr[$key]['rxr'];
			$arr[$key]['candidatos'] = $this->Inf_por_cociente->get_candidatos_por_lista($lista_final['id_lista'], $limit_candidato);
		}
		
		$data_view['datos_instancia']    = $this->Inf_por_cociente->get_datos_instancia();
		$data_view['cociente_electoral'] = $this->_get_cociente_electoral($total_votos_global->votos, $datos_instancia->cargos_a_suplir);
		$data_view['listas_cociente']    = $arr;
		$data_view['total_votos_global'] = $total_votos_global->votos;
		
		$data_view['load_js'] = $this->path_js;
		$this->load->view('por_cociente', $data_view);
	}
	
	private function _get_cociente_electoral($votos, $cargos_a_suplir)
	{
		$cociente = $votos / $cargos_a_suplir;
		return $cociente;
	}
	
	/**
	* Conciente por agencias.
	*
	* @return void
	*/
	public function get_cociente_agencia()
	{
		
	}
	
	public function get_resumen_ip_por_agencia()
	{
		$data_view['titulo']          = 'Resumen ip por '.$this->session->userdata('NOMBRE_SEGMENTO');
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['graficos']        = $this->graficos_js;
		$data_view['load_js']         = $this->path_js;
		
		if (!$this->input->post()) {
			$data_view['titulo'] = 'Selecione la '.$this->session->userdata('NOMBRE_SEGMENTO');
			//Agencia usuario.
			$data_view['agencias'] = $this->Inf_resumen_por_agencia->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE', null, null, null, null, true);
			$this->load->view('form_ip_por_agencia', $data_view);
		} else {
			$data_view['agencia']        = $this->input->post('COD_AGENCIA');
			$data_view['nombre_agencia'] = $this->Agencia->get($this->input->post('COD_AGENCIA'));
			$this->load->view('resumen_ip_por_agencia', $data_view);
		}
		
	}
	
	public function get_ip_por_agencia($agencia, $render = null)
	{
		$this->ini_desencriptado();
		$list = $this->inf_resumen_ip_por_agencia->get_datatables($agencia);
		
		$data        = array();
		$no          = $this->input->post('start');
		$total_votos = 0;
		
		/*   foreach ($list as $votos) {
			$voto_individual = ($votos->NUM_TOVOCA) ? $votos->NUM_TOVOCA : 0;
			$total_votos     += $voto_individual;
		}*/
		
		foreach ($list as $por_agencia) {
			$no++;
			$row    = [];
			$row[]  = $por_agencia->TEX_NOMAGE;
			$row[]  = $por_agencia->votos_agencia;
			$row[]  = $this->get_ip_candids_votos($por_agencia->COD_AGENCIA, 1);
			$row[]  = $this->get_ip_candids_votos($por_agencia->COD_AGENCIA, null);
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->inf_resumen_ip_por_agencia->count_all(),
			"recordsFiltered" => $this->inf_resumen_ip_por_agencia->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	public function get_ip_candids_votos($cod_agencia, $candidato = null)
	{
		$result = $this->inf_resumen_ip_por_agencia->get_candidatos_por_agencia($cod_agencia);
		$cadena = '';
		if ($candidato) {
			foreach ($result as $res) {
				$cadena .= $res->candidato . '<br>';
			}
		} else {
			foreach ($result as $res) {
				$cadena .= $res->votos . '<br>';
			}
		}
		
		return $cadena;
	}
	
	public function ip_agencia_pdf($agencia)
	{
		
		$this->load->library('mydompdf');
		
		$list = $this->inf_resumen_ip_por_agencia->get_datatables($agencia);
		
		$data = array();
		
		$total_votos = 0;
		
		foreach ($list as $por_agencia) {
			$no++;
			$row    = [];
			$row[]  = $por_agencia->TEX_NOMAGE;
			$row[]  = $por_agencia->votos_agencia;
			$row[]  = $this->get_ip_candids_votos($por_agencia->COD_AGENCIA, 1);
			$row[]  = $this->get_ip_candids_votos($por_agencia->COD_AGENCIA, null);
			$data[] = $row;
		}
		
		$this->mydompdf->load_html($html);
		$this->mydompdf->render();
		$this->mydompdf->stream("welcome.pdf", array(
			"Attachment" => false,
		));
		
	}
	
	public function usuario_registro_pdf($agencia)
	{
		
		$this->load->library('mydompdf');
		
		$result = $this->Inf_resumen_votacion_usuario_registro->get_votacion_usuario_registro($agencia);
		$data   = [];
		foreach ($result as $key => $agen) {
			$data[] = [
				'agencia'          => $agen->TEX_NOMAGE,
				'votos'            => $agen->votos_agencia,
				'candidatos'       => $this->get_regis_candids_votos_arr($agen->COD_AGENCIA,
				$agencia, 1),
				'votos_candidatos' => $this->get_regis_candids_votos_arr($agen->COD_AGENCIA,
				$agencia, null),
			];
		}
		
		$data_view['titulo']  = 'Resumen Votación por Usuario Registro';
		$data_view['usuario'] = $this->Usuario->get($agencia);
		$data_view['datos']   = $data;
		$html                 = $this->load->view('pdf/resumen_votacion_usuario_registro_pdf', $data_view, true);
		
		$this->mydompdf->load_html($html);
		$this->mydompdf->render();
		$this->mydompdf->stream("resumen_votacion_usuario_registro_pdf.pdf", array(
			"Attachment" => true,
		));
		
	}
	
	public function resumen_votacion_usuario_registro()
	{
		
		
		if (!$this->_permisos['informes']['informes_resumen_votacion_usuario_registro']['MOSTRAR_FRONT']){
			$this->session->set_flashdata('error', "No tienes permiso para ver este reporte");
			redirect('administrador');
			
		}
		
		
		$data_view['titulo']          = 'Resumen Votación por Usuario Registro';
		$data_view['titulo_graficos'] = 'Gráficos';
		$data_view['graficos']        = $this->graficos_js;
		$data_view['load_js']         = $this->path_js;
		
		if (!$this->input->post()) {
			$data_view['titulo'] = 'Selecione el usuario';
			//Agencia usuario.
			$data_view['usuarios'] = $this->Inf_resumen_votacion_usuario_registro->select_forms_usuario('auth03usuarios', 'COD_USUARIO', 'TEX_NOMUSUA', 'TEX_USUARIO', null, null, null, true);
			
			$this->load->view('form_votacion_usuario_registro', $data_view);
		} else {
			$data_view['agencia']        = ($this->input->post('COD_AGENCIA')) ? $this->input->post('COD_AGENCIA') : '0';
			$data_view['nombre_agencia'] = $this->Usuario->get($this->input->post('COD_AGENCIA'));
			$this->load->view('resumen_votacion_usuario_registro', $data_view);
		}
	}
	
	public function get_resumen_votacion_usuario_registro($agencia)
	{
		$this->ini_desencriptado();
		
		$list = $this->Inf_resumen_votacion_usuario_registro->get_datatables($agencia);
		
		$data        = array();
		$no          = $this->input->post('start');
		$total_votos = 0;
		
		foreach ($list as $por_agencia) {
			$no++;
			$row   = [];
			$row[] = $por_agencia->TEX_NOMAGE;
			$row[] = $por_agencia->votos_agencia;
			$row[] = $this->get_regis_candids_votos($por_agencia->COD_AGENCIA,
			$agencia, 1);
			$row[] = $this->get_regis_candids_votos($por_agencia->COD_AGENCIA,
			$agencia, null);
			$data[] = $row;
		}
		$output = array(
			"draw"            => $this->input->post('draw'),
			"recordsTotal"    => $this->Inf_resumen_votacion_usuario_registro->count_all(),
			"recordsFiltered" => $this->Inf_resumen_votacion_usuario_registro->count_filtered(),
			"data"            => $data,
		);
		echo json_encode($output);
	}
	
	public function get_regis_candids_votos($cod_agencia, $usuario, $candidato = null)
	{
		$result = $this->Inf_resumen_votacion_usuario_registro->get_candidatos_por_agencia($cod_agencia, $usuario);
		$cadena = '';
		if ($candidato) {
			foreach ($result as $res) {
				$cadena .= '<td>' . $res->candidato . '</td><br>';
			}
		} else {
			foreach ($result as $res) {
				$cadena .= '<td>' . $res->votos . '</td><br>';
			}
		}
		
		return $cadena;
	}
	public function get_regis_candids_votos_arr($cod_agencia, $usuario, $candidato = null)
	{
		$result = $this->Inf_resumen_votacion_usuario_registro->get_candidatos_por_agencia($cod_agencia, $usuario);
		$arr    = [];
		if ($candidato) {
			foreach ($result as $res) {
				$arr[] = $res->candidato;
			}
		} else {
			foreach ($result as $res) {
				$arr[] = $res->votos;
			}
		}
		
		return $arr;
	}
	
	public function get_lista_registrados_sin_votar()
	{
		$registrados_sin_votar = $this->db->query("SELECT p.NUM_IDETER, 
		COUNT(i.NUM_IDETER) as ingresos,
		CONCAT(p.TEX_NOMPAR, ' ', p.TEX_APEPAR) as nombre_participante, a.TEX_NOMAGE
		FROM `evi09ingre` `i`
		JOIN `evi05partic` `p` ON p.NUM_IDETER=i.NUM_IDETER
		JOIN `gen01agencias` `a` ON a.COD_AGENCIA=p.COD_AGENCIA
		WHERE p.NUM_IDETER IN (
			SELECT NUM_IDETER
			FROM evi09ingre)
			AND i.NUM_IDETER NOT IN (
				SELECT NUM_IDETER
				FROM evi07audpro)
				GROUP BY i.NUM_IDETER
				HAVING ingresos %2=1
				ORDER BY p.TEX_NOMPAR ASC")
				->result();
				
				$data_view['registrados_sin_votar']  = $registrados_sin_votar;
				echo $this->load->view('html/lista_registrados_sin_votar', $data_view, true);
			}
		}
		