<?php

 class Inf_asistentes_habiles extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     protected $_table_parent2;
     protected $_table_child;
     protected $_agencia_usuario; 
     private $_column;
     private $_order;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();
         $this->_table         = 'evi05partic';
         $this->_table_parent  = 'gen04ciudad';
         $this->_table_parent2 = 'gen01agencias';
         $this->_table_child   = 'evi07audpro';
         $this->primary_key    = 'NUM_IDETER';
         $this->_agencia_usuario = $this->session->userdata('COD_AGENCIA');
         $this->_column        = array('evi05partic.NUM_IDETER', 'evi05partic.TEX_NOMPAR', 'gen04ciudad.TEX_NOMCIU', 'gen01agencias.TEX_NOMAGE');
         $this->_order         = array('NUM_IDETER' => 'desc');
     }

     private function _get_datatables_query()
     {
         $this->db->select("$this->_table.*, $this->_table_parent.TEX_NOMCIU, $this->_table_parent2.TEX_NOMAGE");
         $this->db->from($this->_table);
         $this->db->join($this->_table_parent, "$this->_table_parent.COD_CIUDAD=$this->_table.COD_CIUDAD");
         $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table.COD_AGENCIA");
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);

         $this->db->where("$this->_table_parent2.COD_AGENCIA !=", 0);
        if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
           } 

         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables()
     {
         $this->_get_datatables_query();
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query();
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->from($this->_table);
        $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table.COD_AGENCIA");
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
        if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
           }
         return $this->db->count_all_results();
     }

 }
 