<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of Inf_por_empresa
  *
  * @author Jaime Bravo.
  */
 class Inf_candidatos extends MY_Model
 {

 	protected $_table;
 	protected $_table_parent;
 	protected $_table_parent2;
 	protected $_table_parent3;
 	private $_column;
 	private $_order;

 	public function __construct()
 	{
 		parent::__construct();
 		$this->load->database();
 		$this->_table         = 'evi04candidat_mr';
 		$this->_table_parent  = 'evi02instan';
 		$this->_table_parent2 = 'gen04ciudad';
 		$this->_table_parent3 = 'gen01agencias';
 		$this->primary_key    = 'ID_CANDID';
 		$this->_column        = array('ID_CANDID', 'TEX_NOMCAN', 'TEX_APECAN', "NUM_TOVOCA",
 			"$this->_table_parent.TEX_NOMINS", "$this->_table_parent2.TEX_NOMCIU",
 			"$this->_table_parent3.TEX_NOMAGE");
 		$this->_order         = array('' => '');
 	}

 	private function _get_datatables_query()
 	{
 		$this->db->select("$this->_table.ID_CANDID, $this->_table.TEX_NOMCAN,"
 			. " $this->_table.TEX_APECAN, $this->_table.TEXT_TIPLIST,"
 			. " NUM_TOVOCA as votos,"
 			. " $this->_table_parent.TEX_NOMINS,"
 			. " $this->_table_parent2.TEX_NOMCIU, $this->_table_parent3.TEX_NOMAGE");
 		$this->db->from($this->_table);
 		$this->db->join($this->_table_parent, "$this->_table_parent.ID_INSTAN=$this->_table.ID_INSTAN", 'INNER');
 		$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_CIUDAD=$this->_table.COD_CIUDAD", 'INNER');
 		$this->db->join($this->_table_parent3, "$this->_table_parent3.COD_AGENCIA=$this->_table.COD_AGENCIA", 'INNER');


 		if(!$this->session->userdata('POR_LISTAS')) {
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", "LCC");
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", "LVP");
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", 'LCL');
 		}
 		$this->db->where("$this->_table.BOL_ACTIVO", 1);
 		$this->db->where("$this->_table.IS_DELETE", 0);


         //Agencia del usuario
 		if ($this->_agencia_usuario !== 0) {
 			$this->db->where("gen01agencias.COD_AGENCIA", $this->_agencia_usuario);
 		}
 		$this->db->order_by('cast(votos as unsigned) DESC');

 		$i = 0;
 		foreach ($this->_column as $item) {
 			if (isset($_POST['search']['value'])) {
 				($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
 			}

 			$column[$i] = $item;
 			$i++;
 		}
 		if (isset($_POST['order'])) {
 			$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
 		}
 		else if (isset($this->_order)) {
 			$order = $this->_order;
 			$this->db->order_by(key($order), $order[key($order)]);
 		}
 	}

 	public function get_datatables()
 	{
 		$this->_get_datatables_query();
 		if (isset($_POST['length']) != -1):
 			$this->db->limit(isset($_POST['length']), isset($_POST['start']));
 		endif;
 		return $this->db->get()->result();
 	}

 	public function count_filtered()
 	{
 		$this->_get_datatables_query();
 		$query = $this->db->get();
 		return $query->num_rows();
 	}

 	public function count_all()
 	{
 		$this->db->from($this->_table);
 		$this->db->join($this->_table_parent, "$this->_table_parent.ID_INSTAN=$this->_table.ID_INSTAN", 'INNER');
 		$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_CIUDAD=$this->_table.COD_CIUDAD", 'INNER');
 		$this->db->join($this->_table_parent3, "$this->_table_parent3.COD_AGENCIA=$this->_table.COD_AGENCIA", 'INNER');
 		$this->db->where("$this->_table.BOL_ACTIVO", 1);
 		$this->db->where("$this->_table.IS_DELETE", 0);


 		if(!$this->session->userdata('POR_LISTAS')) {
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", 'LCL');
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", "LCC");
 			$this->db->where("$this->_table.TEXT_TIPLIST !=", "LVP");
 		}
        //Agencia del usuario
 		if ($this->_agencia_usuario !== 0) {
 			$this->db->where("$this->_table_parent3.COD_AGENCIA", $this->_agencia_usuario);
 		}

 		return $this->db->count_all_results();
 	}

 	public function get_all_data()
 	{
 		$this->db->select("$this->_table.ID_CANDID, $this->_table.TEX_NOMCAN,"
 			. " $this->_table.TEX_APECAN, $this->_table.TEXT_TIPLIST,"
 			. "NUM_TOVOCA as votos,"
 			. " $this->_table_parent.TEX_NOMINS,"
 			. " $this->_table_parent2.TEX_NOMCIU, $this->_table_parent3.TEX_NOMAGE");
 		$this->db->from($this->_table);
 		$this->db->join($this->_table_parent, "$this->_table_parent.ID_INSTAN=$this->_table.ID_INSTAN", 'INNER');
 		$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_CIUDAD=$this->_table.COD_CIUDAD", 'INNER');
 		$this->db->join($this->_table_parent3, "$this->_table_parent3.COD_AGENCIA=$this->_table.COD_AGENCIA", 'INNER');

 		//if(!$this->session->userdata('POR_LISTAS')) {
 			//$this->db->where("$this->_table.TEXT_TIPLIST !=", "LCC");
 		//	$this->db->where("$this->_table.TEXT_TIPLIST !=", "LVP");
 			//$this->db->where("$this->_table.TEXT_TIPLIST !=", 'LCL');
 	//	}
 		$this->db->where("$this->_table.BOL_ACTIVO", 1);
 		$this->db->where("$this->_table.IS_DELETE", 0);

         //Agencia del usuario
 		if ($this->_agencia_usuario !== 0) {
 			$this->db->where("gen01agencias.COD_AGENCIA", $this->_agencia_usuario);
 		}
 		$this->db->order_by('cast(votos as unsigned) DESC'); 

 		return $this->db->get()->result();
 	}

 }
 