<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of Inf_por_agencia
  *
  * @author Jaime Bravo.
  */
 class Inf_por_agencia extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     private $_column;
     private $_order;
     private $_agencia;
     protected $_agencia_usuario;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();
         $this->_table        = 'evi04candidat_mr';
         $this->_table_parent = 'gen01agencias';
         $this->primary_key   = 'ID_CANDID';
         $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
         $this->_column       = array('ID_CANDID', 'TEX_NOMCAN', 'TEX_APECAN', 'NUM_TOVOCA');
         $this->_order        = array('COD_AGENCIA' => 'ASC');
     }

     private function _get_datatables_query($agencia)
     {

         $this->_agencia = $agencia;

         $this->db->select("$this->_table.ID_CANDID, $this->_table.TEX_NOMCAN,"
           . " $this->_table.TEX_APECAN,"
           . " NUM_TOVOCA as votos,");
         $this->db->from($this->_table);

         if($agencia !== '0') {

         $this->db->where("$this->_table.COD_AGENCIA", $agencia);
         } 


         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
          $this->db->order_by('cast(votos as unsigned) DESC');


         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables($agencia)
     {
         $this->_get_datatables_query($agencia);
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query($this->_agencia);
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->from($this->_table);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $this->db->where("$this->_table.COD_AGENCIA", $this->_agencia);
         return $this->db->count_all_results();
     }

     public function get_all_data($agencia_id=null)
     {
         $this->db->select("$this->_table.ID_CANDID, $this->_table.TEX_NOMCAN,"
           . " $this->_table.TEX_APECAN,"
           . " NUM_TOVOCA,");
         $this->db->from($this->_table);
         $this->db->where("$this->_table.COD_AGENCIA", $agencia_id);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
       if($this->_agencia !== '0') {
          $this->db->where("$this->_table.COD_AGENCIA", $agencia_id);
        } 
         $this->db->order_by("NUM_TOVOCA", 'DESC');
         return $this->db->get()->result();
     }

 }
 