<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
* Description 
*
* @author Jaime Bravo.
*/
class Inf_por_instancias extends MY_Model
{
    
    protected $_table;
    protected $_table_parent;
    protected $_table_parent2;
    protected $_table_parent3;
    protected $_agencia_usuario;
    private $_instancia;
    private $_column;
    private $_order;
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->_table         = 'evi04candidat_mr';
        $this->_table_parent = 'evi07audpro';
        $this->_table_parent2  = 'evi02instan';
        $this->_table_parent3 = 'gen04ciudad';
        $this->_table_parent4 = 'gen01agencias';
        $this->_table_participante = 'evi05partic';
        $this->primary_key    = 'ID_CANDID';
        $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
        $this->_column        = array('ID_CANDID', "$this->_table.TEX_NOMCAN",
        "$this->_table.TEX_APECAN", 'NUM_TOVOCA',
        "$this->_table_parent2.TEX_NOMINS", "$this->_table_parent3.TEX_NOMCIU",
        "$this->_table_parent4.TEX_NOMAGE");
        $this->_order         = array("$this->_table_parent2.TEX_NOMINS" => 'ASC');
    }
    
    private function _get_datatables_query($instancia)
    {
        $this->_instancia = $instancia;
        
        $this->db->select(""
        . "$this->_table.ID_CANDID, "
        . "$this->_table.TEX_NOMCAN,"
        . " $this->_table.TEX_APECAN,"
        . "CAST(NUM_TOVOCA AS CHAR) as NUM_TOVOCA,"
        . ", $this->_table_parent2.TEX_NOMINS,"
        . " $this->_table_parent3.TEX_NOMCIU, $this->_table_parent4.TEX_NOMAGE");
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent2, "$this->_table_parent2.ID_INSTAN=$this->_table.ID_INSTAN","RIGHT");
        $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table.COD_CIUDAD","RIGHT");
        $this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table.COD_AGENCIA","RIGHT");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("$this->_table.ID_INSTAN", $this->_instancia);
        
        $this->db->where("$this->_table_parent4.COD_AGENCIA !=", 0);
        if ($this->_agencia_usuario !== 0) {
            $this->db->where("$this->_table_parent4.COD_AGENCIA", $this->_agencia_usuario);
        }
        
        /*    if(!$this->session->userdata('POR_LISTAS')) {
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", "LCC");
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", "LVP");
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", 'LCL');
        } */
        
        $this->db->group_by("$this->_table.ID_CANDID");        
        
        $this->db->order_by("cast(NUM_TOVOCA as UNSIGNED)", 'DESC', false);
        
        $i = 0;
        foreach ($this->_column as $item) {
            if (!empty($_POST['search']['value'])) {
                ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
            }
            
            $column[$i] = $item;
            $i++;
        }
        if (!empty($_POST['order'])) {
            $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if (isset($this->_order)) {
            $order = $this->_order;
            $this->db->order_by(key($order), $order[key($order)]);
        } else {
            
        }
    }
    
    public function get_datatables($instancia)
    {
        $this->_get_datatables_query($instancia);
        if(isset($_POST['length'])){
            if ($_POST['length'] != -1):
                $this->db->limit($_POST['length'], $_POST['start']);
            endif;
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    public function count_filtered()
    {
        $this->_get_datatables_query($this->_instancia);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all()
    {
        $this->db->from($this->_table);
        //  $this->db->join($this->_table_parent, "$this->_table_parent.ID_CANDID=$this->_table.ID_CANDID");
        //$this->db->join($this->_table_parent2, "$this->_table_parent2.ID_INSTAN=$this->_table_parent.ID_INSTAN");
        //$this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table_parent.COD_CIUDAD");
        //$this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table_parent.COD_AGENCIA");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("$this->_table.ID_INSTAN", $this->_instancia);
        
        
        
        return $this->db->count_all_results();
    }
    
    public function get_all_data($instancia)
    {
        
        $this->db->select(""
        . " $this->_table.ID_CANDID, "
        . " $this->_table.TEX_NOMCAN,"
        . " $this->_table.TEX_APECAN,"
        . " NUM_TOVOCA,"
        . ", $this->_table_parent2.TEX_NOMINS,"
        . " $this->_table_parent3.TEX_NOMCIU, $this->_table_parent4.TEX_NOMAGE");
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent2, "$this->_table_parent2.ID_INSTAN=$this->_table.ID_INSTAN","RIGHT");
        $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table.COD_CIUDAD","RIGHT");
        $this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table.COD_AGENCIA","RIGHT");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("NUM_TOVOCA >", '0');
        $this->db->where("$this->_table_parent2.ID_INSTAN", $instancia);
        
        return $this->db->get()->result();
    }
    
    public function get_all_instancias($tipo='')
    {
        $all_instancias = $this->db->get('evi02instan')->result();
        $data = [];
        foreach ($all_instancias as $key => $instancia) {
            $instancia_id = $instancia->ID_INSTAN;
            
            if($tipo == 'P'){
                $datos =  $this->consulta_instancia_participante($instancia_id);
            } else if ($tipo == 'PSP'){
                $datos =  $this->consulta_instancia_personas_sin_participar($instancia_id);
            }
            else {
                $datos =  $this->consulta_instancia($instancia_id);
            }
            
            $arr[$key] =  [
                'nombre_instancia'=> $instancia->TEX_NOMINS, 
                'instancia_datos'=> $datos];
                
            }
            
            return $arr;
        }
        
        public function consulta_instancia($instancia_id)
        {
            $this->db->select(""
            . "$this->_table.TEX_NOMCAN,"
            . " $this->_table.TEX_APECAN,"
            . "CAST(NUM_TOVOCA AS UNSIGNED) as NUM_TOVOCA");
            //. "COUNT(NUM_TOVOCA) as total_votos");
            $this->db->from($this->_table);
            $this->db->where("$this->_table.BOL_ACTIVO", 1);
            $this->db->where("$this->_table.IS_DELETE", 0);
            // $this->db->where("NUM_TOVOCA >", '0');
            $this->db->where("$this->_table.ID_INSTAN", $instancia_id);
            $this->db->order_by("NUM_TOVOCA", 'DESC', false);
            $resultados = $this->db->get()->result();
            
            $total_votos = 0;
            foreach ($resultados as $key => $voto) {
                $total_votos += $voto->NUM_TOVOCA;
            }
            
            $arr = [];
            foreach ($resultados as $key => $resultado) {
                $votos = $resultado->NUM_TOVOCA;
                $arr[$key] = [
                    'candidato'=> $resultado->TEX_NOMCAN.' '.$resultado->TEX_APECAN,
                    'votos' => ($votos == 0 || $votos == '0.00')?0:$votos,
                    'porcentaje' => ($votos == 0 || $votos == '0.00')?0:number_format((($votos/$total_votos)*100),2),
                    'total_votos' => number_format($total_votos, 2)
                ]; 
            }
            
            return $arr;
        }
        
        
        public function consulta_instancia_participante($instancia_id)
        {
            $this->db->select(""
            . "$this->_table_participante.NUM_IDETER,"
            . "$this->_table_participante.TEX_NOMPAR,"
            . " $this->_table_participante.TEX_APEPAR");
            $this->db->from($this->_table_participante);
            $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table_participante.NUM_IDETER","INNER");
            $this->db->where("$this->_table_participante.BOL_ACTIVO", 1);
            $this->db->where("$this->_table_participante.IS_DELETE", 0);
            $this->db->where("$this->_table_parent.ID_INSTAN", $instancia_id);
            $this->db->group_by("$this->_table_participante.NUM_IDETER");
            $resultados = $this->db->get()->result();
            
            $this->db->select(""
            . "$this->_table_participante.NUM_IDETER");
            $this->db->from($this->_table_participante);
            $this->db->where("$this->_table_participante.BOL_ACTIVO", 1);
            $this->db->where("$this->_table_participante.IS_DELETE", 0);
            $this->db->where("$this->_table_participante.BOL_INISES", 1);
            $resultadosContador = $this->db->get()->result();
            
            
            $arr = [];
            foreach ($resultados as $key => $resultado) {
                $arr[$key] = [
                    'cedula'=> $resultado->NUM_IDETER,
                    'participante'=> $resultado->TEX_NOMPAR.' '.$resultado->TEX_APEPAR,
                    'porcentaje' => number_format(((count($resultados)/count($resultadosContador))*100),2),
                    'total_participantes' => count($resultadosContador)
                ]; 
            }
            
            return $arr;
        }
        
        
        public function consulta_instancia_personas_sin_participar($instancia_id)
        {
            $this->db->select("$this->_table_participante.*, $this->_table_parent3.TEX_NOMCIU, $this->_table_parent4.TEX_NOMAGE");
            $this->db->from($this->_table_participante);
            $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table_participante.COD_CIUDAD", 'INNER');
            $this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table_participante.COD_AGENCIA", 'INNER');
            $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table_parent.NUM_IDETER", 'LEFT');
            $this->db->where("$this->_table_participante.IS_DELETE", 0);
            $this->db->where("$this->_table_participante.BOL_ACTIVO", 1);
            $this->db->where("evi07audpro.ID_INSTAN", $instancia_id);
            $this->db->where('evi05partic.NUM_IDETER NOT IN (SELECT NUM_IDETER FROM evi07audpro)', NULL, FALSE);
            $this->db->where("$this->_table_participante.BOL_ACTIVO", 1);
            $this->db->where("$this->_table_parent4.COD_AGENCIA !=", 0);
            if ($this->_agencia_usuario !== 0) {
                $this->db->where("$this->_table_parent4.COD_AGENCIA", $this->_agencia_usuario);
            }
            
            $resultados = $this->db->get()->result();
            
            var_dump($resultados);exit;
        }
        
        
        /**
        * Consulta los datos de los participantes en todas la instancias.
        *
        * @return void
        */
        public function get_all_data_graficos_participantes()
        {
            $query = "SELECT instan.TEX_NOMINS AS instancia, COUNT(audit.NUM_IDETER) AS participantes
            FROM evi07audpro audit
            JOIN evi02instan instan ON instan.ID_INSTAN=audit.ID_INSTAN
            GROUP BY audit.ID_INSTAN";
            
            $resultados = $this->db->query($query);
            return $resultados->result();
            
        }
        /**
        * Consulta los datos de los candidatos en todas la instancias.
        *
        * @return void
        */
        public function get_all_data_graficos_candidatos()
        {
            $this->db->select(""
            . " $this->_table.TEX_NOMCA,"
            . " $this->_table.TEX_APECAN,"
            . " NUM_TOVOCA");
            //. "COUNT(NUM_TOVOCA) as total_votos");
            $this->db->from($this->_table);
            $this->db->where("$this->_table.BOL_ACTIVO", 1);
            $this->db->where("$this->_table.IS_DELETE", 0);
            $this->db->where("NUM_TOVOCA >", '0');
            $resultados = $this->db->get()->result();
            
            
            
        }
        
        
    }
    