<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
* Description 
*
* @author Jaime Bravo.
*/
class Inf_por_instancias_participantes extends MY_Model
{
    
    protected $_table;
    protected $_table_parent;
    protected $_table_parent2;
    protected $_table_parent3;
    protected $_agencia_usuario;
    private $_instancia;
    private $_column;
    private $_order;
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->_table         = 'evi05partic';
        $this->_table_parent = 'evi07audpro';
        $this->_table_parent2  = 'evi02instan';
        $this->_table_parent3 = 'gen04ciudad';
        $this->_table_parent4 = 'gen01agencias';
        $this->_table_participante = 'evi05partic';
        $this->primary_key    = 'ID_CANDID';
        $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
        $this->_column        = array(
        "$this->_table_parent2.TEX_NOMINS", "$this->_table_parent3.TEX_NOMCIU",
        "$this->_table_parent4.TEX_NOMAGE");
        $this->_order         = array("$this->_table_parent2.TEX_NOMINS" => 'ASC');
    }
    
    private function _get_datatables_query($instancia)
    {
        $this->_instancia = $instancia;
        
        $this->db->select(""
        . "$this->_table.NUM_IDETER, "
        . "$this->_table.TEX_NOMPAR,"
        . "$this->_table.TEX_APEPAR,"
        . "$this->_table.NUM_PESO,"
        . "$this->_table_parent.FEC_PROVOT,"
        . "$this->_table_parent2.TEX_NOMINS,"
        . " $this->_table_parent3.TEX_NOMCIU, $this->_table_parent4.TEX_NOMAGE");
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER");
        $this->db->join($this->_table_parent2, "$this->_table_parent2.ID_INSTAN=$this->_table_parent.ID_INSTAN","RIGHT");
        $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table.COD_CIUDAD","RIGHT");
        $this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table.COD_AGENCIA");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("$this->_table_parent.ID_INSTAN", $this->_instancia);
        
        $this->db->where("$this->_table.COD_AGENCIA !=", 0);
        if ($this->_agencia_usuario !== 0) {
            $this->db->where("$this->_table_parent4.COD_AGENCIA", $this->_agencia_usuario);
        }
        
        /*    if(!$this->session->userdata('POR_LISTAS')) {
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", "LCC");
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", "LVP");
            $this->db->where("$this->_table_parent.TEXT_TIPLIST !=", 'LCL');
        } */
        
        $this->db->group_by("$this->_table.NUM_IDETER");
        
        $this->db->order_by("$this->_table_parent2.ID_INSTAN", 'ASC');
        
        
        $i = 0;
        foreach ($this->_column as $item) {
            if (isset($_POST['search']['value'])) {
                ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
            }
            
            $column[$i] = $item;
            $i++;
        }
        if (isset($_POST['order'])) {
            $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if (isset($this->_order)) {
            $order = $this->_order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
    
    public function get_datatables($instancia)
    {
        $this->_get_datatables_query($instancia);
        if(isset($_POST['length'])){
            if ($_POST['length'] != -1):
                $this->db->limit((isset($_POST['length']))?$_POST['length']:1000000, (isset($_POST['start']))?$_POST['start']:0);
            endif;
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    public function count_filtered()
    {
        $this->_get_datatables_query($this->_instancia);
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all()
    {
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("$this->_table_parent.ID_INSTAN", $this->_instancia);
        
        
        
        return $this->db->count_all_results();
    }  
    
    public function get_all_data($instancia)
    {
        
        $this->db->select(""
        . "$this->_table.NUM_IDETER, "
        . "$this->_table.NUM_PESO, "
        . "$this->_table.TEX_NOMPAR,"
        . " $this->_table.TEX_APEPAR,"
        . ", $this->_table_parent2.TEX_NOMINS,"
        . " $this->_table_parent3.TEX_NOMCIU, $this->_table_parent4.TEX_NOMAGE");
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER");
        $this->db->join($this->_table_parent2, "$this->_table_parent2.ID_INSTAN=$this->_table_parent.ID_INSTAN","RIGHT");
        $this->db->join($this->_table_parent3, "$this->_table_parent3.COD_CIUDAD=$this->_table.COD_CIUDAD","RIGHT");
        $this->db->join($this->_table_parent4, "$this->_table_parent4.COD_AGENCIA=$this->_table.COD_AGENCIA","RIGHT");
        $this->db->where("$this->_table.BOL_ACTIVO", 1);
        $this->db->where("$this->_table.IS_DELETE", 0);
        $this->db->where("$this->_table_parent.ID_INSTAN", $instancia);
        
        $this->db->group_by("$this->_table.NUM_IDETER");
        
        return $this->db->get()->result();
    }
}
