<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of Inf_por_empresa
  *
  * @author Jaime Bravo.
  */
 class Inf_resumen_por_agencia extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     protected $_table_candidat;
     protected $_table_parent2;
     protected $_agencia_usuario;
     private $_column;
     private $_order;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();
         $this->_table        = 'evi07audpro';
         $this->_table_parent  = 'evi05partic';
         $this->_table_parent2 = 'gen01agencias';
         $this->_table_candidat = 'evi04candidat_mr';
         $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
         $this->primary_key   = 'COD_AGENCIA';
         $this->_column       = array("$this->_table_parent.COD_AGENCIA", "TEX_NOMAGE", 'participantes', 'sufragantes', 'votos');
         $this->_order        = array('COD_AGENCIA' => 'ASC');
     }

     private function _consulta_sql()
     {
         $this->db->distinct();
         $this->db->select("$this->_table_parent2.*,"
           . "COUNT(evi07audpro.NUM_IDETER) as sufragantes,"
           . "COUNT(evi05partic.NUM_IDETER) as participantes,"
           . "(select SUM(evi04candidat_mr.NUM_TOVOCA) from evi04candidat_mr WHERE gen01agencias.COD_AGENCIA=COD_AGENCIA) AS votos");
         $this->db->from($this->_table);
         $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER", 'RIGHT');
         $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table_parent.COD_AGENCIA");
         $this->db->join($this->_table_candidat, "$this->_table_candidat.COD_AGENCIA=$this->_table_parent2.COD_AGENCIA");
         $this->db->where("$this->_table_parent.BOL_ACTIVO", 1);
         $this->db->where("$this->_table_parent.IS_DELETE", 0);
         $this->db->where("$this->_table_parent2.COD_AGENCIA !=", 0);
         if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
         }

         $this->db->group_by("gen01agencias.COD_AGENCIA");

     }

     private function _get_datatables_query()
     {
         $this->_consulta_sql();
         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables()
     {
         $this->_get_datatables_query();
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query();
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
           $this->_consulta_sql();
         return $this->db->count_all_results();
     }

     public function get_all_data()
     {
         $this->_consulta_sql();
         return $this->db->get()->result();
     }


 public function get_sufragantes($cod_agencia)
 {
   $this->db->distinct();
         $this->db->select("$this->_table_parent.NUM_IDETER as sufragantes");
         $this->db->from($this->_table_parent);
         $this->db->join($this->_table, "$this->_table.NUM_IDETER=$this->_table_parent.NUM_IDETER");
        
         $this->db->where("$this->_table_parent.BOL_ACTIVO", 1);
         $this->db->where("$this->_table_parent.IS_DELETE", 0);
        // $this->db->where("$this->_table_parent2.COD_AGENCIA !=", 0);
   /*      if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent.COD_AGENCIA", $this->_agencia_usuario);
         }*/
       
         $this->db->where("$this->_table_parent.COD_AGENCIA", $cod_agencia);
          $query = $this->db->get();
         return $query->num_rows();

 } public function get_participantes_by_agencia($cod_agencia)
 {
         $this->db->select("COUNT($this->_table_parent.NUM_IDETER) as participantes");
         $this->db->from($this->_table_parent);      
         $this->db->where("$this->_table_parent.BOL_ACTIVO", 1);
         $this->db->where("$this->_table_parent.IS_DELETE", 0);
         $this->db->where("$this->_table_parent.COD_AGENCIA", $cod_agencia);
          $query = $this->db->get();
         return $query->row();

 }

 }
 