<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of Inf_por_agencia
  *
  * @author Jaime Bravo.
  */
 class Inf_resumen_votacion_usuario_registro extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     private $_column;
     private $_order;
     private $_agencia;
     protected $_agencia_usuario;
     private $_configuracion;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();

        $this->load->model('configuracion/Config');

         $this->_table        = 'gen01agencias';
         $this->_table_candid = 'evi04candidat_mr';
         $this->_table_audit = 'evi07audpro';
         $this->_table_parti = 'evi05partic';
         $this->_table_ingre = 'evi09ingre';
         $this->_table_usua = 'auth03usuarios';
         $this->primary_key   = 'COD_AGENCIA';
         $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
         $this->_column       = array('gen01agencias.COD_AGENCIA', 'gen01agencias.TEX_NOMAGE', 'gen01agencias.TEX_NOMAGE', 'gen01agencias.TEX_NOMAGE');
         $this->_order        = array('gen01agencias.COD_AGENCIA' => 'ASC');


          //Config del sistema
         $this->_configuracion = $this->Config->get_row();

         //Si no esta definida la configuración.
         if (!$this->_configuracion) {
             $data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';
             $this->load->view('errors/error_start_sistema', $data_view);
             return false;
         }
     }

     private function _get_datatables_query($agencia)
     {

         $this->_agencia = $agencia;


        //Datos de votación.
        $this->db->select("$this->_table.COD_AGENCIA,
            $this->_table.TEX_NOMAGE, 
            $this->_table_parti.NUM_IDETER,
            SUM(NUM_TOVOCA) as votos_agencia");
        $this->db->from($this->_table_audit);
        $this->db->join($this->_table_parti, "$this->_table_parti.NUM_IDETER=$this->_table_audit.NUM_IDETER");

         $this->db->join($this->_table_ingre, "$this->_table_ingre.NUM_IDETER=$this->_table_parti.NUM_IDETER");

         $this->db->join($this->_table_usua, "$this->_table_usua.COD_USUARIO=$this->_table_ingre.COD_CREAUSU");

         $this->db->join($this->_table, "$this->_table.COD_AGENCIA=$this->_table_parti.COD_AGENCIA");

         $this->db->join($this->_table_candid, "$this->_table_candid.COD_AGENCIA=$this->_table.COD_AGENCIA");

/*   if ($this->_agencia_usuario !== 0) {
       $this->db->where("$this->_table_usua.COD_AGENCIA", $this->session->userdata('COD_AGENCIA')); 
   }*/
       if($agencia !== '0') {
 $this->db->where("$this->_table_ingre.COD_CREAUSU", $agencia);    
}
      
/**
         if(!$this->_configuracion->BOL_VALLIS) {
                $this->db->where("$this->_table_candid.TEXT_TIPLIST !=", 'LCL');
                $this->db->where("$this->_table_candid.TEXT_TIPLIST !=", 'LVP');
            }*/
       
         
         $this->db->group_by("$this->_table_parti.COD_AGENCIA"); 


         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables($agencia)
     {
         $this->_get_datatables_query($agencia);
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query($this->_agencia);
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->from($this->_table);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $this->db->where("$this->_table.COD_AGENCIA", $this->_agencia);
         return $this->db->count_all_results();
     }

     public function get_all_data($agencia_id)
     {
         $this->db->select("$this->_table.*");
         $this->db->from($this->_table);
         $this->db->where("$this->_table.COD_AGENCIA", $agencia_id);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $this->db->order_by("NUM_TOVOCA", 'DESC');
         return $this->db->get()->result();
     }

     public function get_candidatos_por_agencia($cod_agencia, $usuario){
        $where = ''; 
       if(!$this->_configuracion->BOL_VALLIS) {
        $where = " AND candid.TEXT_TIPLIST != 'LCL' AND candid.TEXT_TIPLIST != 'LVP' ";
            }
      
 $where = ''; 
 $where_usua = '';

   if($usuario !== '0') {
   $where_usua = " AND ingre.COD_CREAUSU=$usuario ";
    }
        $sql = "SELECT candid.TEX_APECAN as candidato,
                COUNT(aut.ID_CANDID) AS votos
                FROM evi07audpro aut
                JOIN evi05partic parti ON parti.NUM_IDETER = aut.NUM_IDETER
                JOIN evi09ingre ingre ON ingre.NUM_IDETER = parti.NUM_IDETER
                JOIN auth03usuarios usua ON usua.COD_USUARIO = ingre.COD_CREAUSU
                JOIN evi04candidat_mr candid ON candid.ID_CANDID = aut.ID_CANDID
                WHERE parti.COD_AGENCIA = $cod_agencia 
                $where_usua 
                $where
                GROUP BY aut.ID_CANDID";
                 $res = $this->db->query($sql);
                 return $res->result();
             }


             public function get_votacion_usuario_registro($agencia)
             {
                  $this->_agencia = $agencia;


              //Datos de votación.
                $this->db->select("$this->_table.COD_AGENCIA,
                    $this->_table.TEX_NOMAGE, 
                    $this->_table_parti.NUM_IDETER,
                    COUNT($this->_table_audit.ID_CANDID) as votos_agencia");
                $this->db->from($this->_table_audit);
                $this->db->join($this->_table_parti, "$this->_table_parti.NUM_IDETER=$this->_table_audit.NUM_IDETER");
                 $this->db->join($this->_table_ingre, "$this->_table_ingre.NUM_IDETER=$this->_table_parti.NUM_IDETER");
                 $this->db->join($this->_table_usua, "$this->_table_usua.COD_USUARIO=$this->_table_ingre.COD_CREAUSU");
                 $this->db->join($this->_table, "$this->_table.COD_AGENCIA=$this->_table_parti.COD_AGENCIA");
                   if($agencia !== '0') {
                  $this->db->where("$this->_table_ingre.COD_CREAUSU", $agencia); 
                 }
                
                 $this->db->group_by("$this->_table_parti.COD_AGENCIA"); 
                 $query = $this->db->get();
                 return $query->result();

             }


  public function select_forms_usuario($table, $value, $label, $param1 = null, $column_where = null, $where = null, $order = null, $filtro_agencia=null)
     {
         $agencia_usuario = $this->session->userdata('COD_AGENCIA');
         $valores = array($value, $label, $param1);
         $this->db->select($valores);
         if ($where) {
             $this->db->where($column_where, $where);
         }
         $this->db->where('IS_DELETE', 0);
         $this->db->where('BOL_ACTIVO', 1);


        if($filtro_agencia) {   
         if($agencia_usuario != 0) {
         $this->db->where("$table.COD_AGENCIA",$agencia_usuario ); 
         }         
          } 

  if ($this->session->userdata('COD_PERFIL') === 3) {
        $this->db->where("$table.COD_USUARIO",$this->session->userdata('COD_USUARIO')); 
    }
          


         if ($order) {
             $this->db->order_by("$table.$order", 'ASC');
         }
         return $this->db->get($table)->result();
     }

 }
 