<?php $this->load->view('template/head_front.php'); ?>
<?php $permisos = $this->session->userdata('permisos'); ?>

<style>
.info-user,
.info-agencia {
    display: none;
}

.front-contenedor-logos {
    display: none;
}

#controles {
    position: absolute;
    right: 0;
    z-index: 1000;
}

ul {
    list-style: none;
}

ul li {
    display: inline-block;
    margin: 0 3px;
}

.dropdown-menu {
    width: 232px;
    padding: 5px 13px;
}

.dropdown-toggle {
    text-align: right;
    width: 200px;
}

.contenedor-cronometro {
    margin-top: -40px;
}



.btn-tempo {
    border: 0;
    border-radius: 0;
}

.btn:focus,
.btn:active {
    outline: none !important;
    box-shadow: none;
}

input[type=radio] {
    width: 12px;
}

.values {
    font-family: 'digital-clock-font';
    font-size: 100px;
    margin-left: 60px;
    color: #555555;
}


.contenedor-tabla-registrados {
    margin-top: 50px;
}

#contenedor-tabla-registrados-sin-participar {
  overflow-y: scroll;
  height: 580px;
}

.contenedor-torta {
  margin-top:90px;
}

.footer {
    display: none;
}
</style>
<script src="<?= base_url() ?>/assets/js/modules/informes/graficos.js"></script>

<body>
    <?php $this->load->view('template/header.php'); ?>
    <div class="container" style="margin-top: 54px;">
        <?php 
if (isset($permisos['registros']['registros_controles_contador_votos'])): ?>
        <!-- Controles -->
        <div id="controles" class="row">
            <div class="col-lg-7 col-md-7">

                <!-- Your navbar -->
                <nav class="navbar navbar-default" role="navigation">

                    <!-- A container for menu items -->
                    <div class="container-fluid">

                        <!-- A list of items that will float right -->
                        <ul class="nav navbar-nav navbar-right">

                            <!-- Your dropdown menu item -->
                            <li class="dropdown">

                                <!-- Define your dropdown menu item -->
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                    <strong>Controles</strong> <b class="caret"></b>
                                </a>

                                <!-- The list of dropdown menu items -->
                                <ul id="lista-controles" class="dropdown-menu">
                                    <li>
                                        <div class="form-group input-type ">
                                            <label for="reloj" class="control-label input-group">Reloj</label>
                                            <div id="grupo-reloj" class="btn-group" data-toggle="buttons">
                                                <label
                                                    class="switch btn btn-primary <?= ($bool_reloj_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('reloj', '1', ($bool_reloj_contador)?true:false) ?>Encender
                                                </label>
                                                <label
                                                    class="switch btn btn-primary  <?= (!$bool_reloj_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('reloj', '0', (!$bool_reloj_contador)?true:false) ?>Apagar
                                                </label>
                                            </div>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="form-group input-type ">
                                            <label for="grafico" class="control-label input-group">Gráfico</label>
                                            <div id="grupo-grafico" class="btn-group" data-toggle="buttons">
                                                <label
                                                    class="switch btn btn-primary <?= ($bool_grafico_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('grafico', '1', true) ?>Encender
                                                </label>
                                                <label
                                                    class="switch btn btn-primary <?= (!$bool_grafico_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('grafico', '0') ?>Apagar
                                                </label>
                                            </div>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-group input-type ">
                                            <label for="tabla-registrados" class="control-label input-group">Tabla
                                                registrados sin votar</label>
                                            <div id="grupo-tabla-registrados" class="btn-group" data-toggle="buttons">
                                                <label
                                                    class="switch btn btn-primary <?= ($bool_tabla_reg_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('tabla_registrados', '1', true) ?>Encender
                                                </label>
                                                <label
                                                    class="switch btn btn-primary <?= (!$bool_tabla_reg_contador)?'active':'' ?>"
                                                    data-toggle="button">
                                                    <?= form_radio('tabla_registrados', '0') ?>Apagar
                                                </label>
                                            </div>
                                        </div>
                                    </li>
                                </ul>

                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <?php  endif; ?>
        <!-- Cronometro -->
        <div class="row contenedor-cronometro">
            <div class="col-lg-6 col-md-6">
                <div id="cronometro" style="<?= (!$bool_reloj_contador)?'display:none;':'' ?>">
                    <div id="tiempo"></div>
                    <div class="values">00:00:00</div>
                    <div style="margin-top: -20px;">
                        <button class="btn btn-primary btn-lg btn-tempo" data-toggle="modal"
                            data-target="#modal-config">Configurar</button>
                        <button class="btn btn-success btn-lg btn-tempo startButton">Iniciar</button>
                        <button class="btn btn-warning btn-lg btn-tempo pauseButton">Pausar</button>
                        <button class="btn btn-danger btn-lg btn-tempo stopButton">Detener</button>
                        <button class="btn btn-danger btn-lg btn-tempo resetButton">Reset</button>
                    </div>
                </div>

                     <!-- Gráfico -->
            <div class="contenedor-torta" style=""
                <?= (!$bool_grafico_contador)?'display:none;':'' ?>>
                <div id="chartTortaContadorVotos" style="margin-top:-10px"></div>
            </div>
            </div>

            <!-- Tabla lista de registrados sin votar -->
                <div class="col-md-6 ">
                    <div id="contenedor-tabla-registrados"
                        style="margin-top:40px; <?= (!$bool_tabla_reg_contador)?'display:none;':'' ?>">
                        <button id="btn-refrescar-tabla" class="btn btn-danger">Refrescar tabla</button>
                        <div class="loading text-success" style="display:none; font-weight:bold;">Cargando...</div>
                        <div id="contenedor-tabla-registrados-sin-participar">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col">Nombre</th>
                                        <th scope="col"><?= $this->session->userdata('NOMBRE_SEGMENTO') ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($registrados_sin_votar as $key => $registrado): ?>
                                    <tr>
                                        <td><?= $registrado->nombre_participante ?></td>
                                        <td><?= $registrado->TEX_NOMAGE ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
        </div>

        <div id="modal-config" class="modal fade" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Configuración</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div><b>Tiempo en minutos:</b></div>
                                <div><input type="number" name="tiempo-config" id="tiempo-config" class="form-control"
                                        min="0"></div>
                            </div>
                        </div>
                        <br>
                        <div><b>Modo:</b></div>
                        <div class="row">
                            <div class="col-md-4">

                                <div class="radio">
                                    <label>
                                        <input type="radio" name="modo-config" id="modo-config-chrono" value="chrono"
                                            class="modo-config"> Cronometro
                                    </label>
                                </div>
                                <div class="radio">
                                    <label>
                                        <input type="radio" name="modo-config" id="modo-config-tempo" value="tempo"
                                            class="modo-config"> Temporizador
                                    </label>
                                </div>

                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                        <button type="button" id="guardar-config" class="btn btn-primary">Guardar</button>
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
        <?php
    $data_view['loajs'] =  '';
    $this->load->view('template/footer.php', $data_view);
    ?>
        <script>
        $(document).ready(function() {
            load = function() {
                $('#chartTortaContadorVotos').load('get_grafico_contador_votos', function() {
                    load()
                });
            }

            $('input[name="reloj"]').change(function() {
                selected_value = $("input[name='reloj']:checked").val();
                $.ajax({
                    type: "POST",
                    url: baseUrl + "informes/graficos/cambiar_estado_contador",
                    data: {
                        'tipo': 'reloj',
                        'estado': selected_value
                    },
                    dataType: "json",
                    success: function(response) {
                        Swal.fire({
                            'text': response.message,
                            timer: 3000
                        });
                    }
                });
            });

            $('input[name="grafico"]').change(function() {
                selected_value = $("input[name='grafico']:checked").val();
                $.ajax({
                    type: "POST",
                    url: baseUrl + "informes/graficos/cambiar_estado_contador",
                    data: {
                        'tipo': 'grafico',
                        'estado': selected_value
                    },
                    dataType: "json",
                    success: function(response) {
                        Swal.fire({
                            'text': response.message,
                            timer: 3000
                        });
                    }
                });
            });

            $('input[name="tabla_registrados"]').change(function() {
                selected_value = $("input[name='tabla_registrados']:checked").val();
                $.ajax({
                    type: "POST",
                    url: baseUrl + "informes/graficos/cambiar_estado_contador",
                    data: {
                        'tipo': 'tabla_registrados',
                        'estado': selected_value
                    },
                    dataType: "json",
                    success: function(response) {
                        Swal.fire({
                            'text': response.message,
                            timer: 3000
                        });
                    }
                });
            });


            //Refrescar la tabla
            $('#btn-refrescar-tabla').on('click', function() {
                $.ajax({
                    type: "POST",
                    url: baseUrl + 'informes/get_lista_registrados_sin_votar',
                    beforeSend: function(xhr) {
                        $('.loading').css("display", "inline-block");
                        $('.loading').show();
                    },
                    dataType: "html",
                    success: function(response) {
                        if (response) {
                            $('#contenedor-tabla-registrados-sin-participar').html('');
                            $('#contenedor-tabla-registrados-sin-participar').append(
                                response);
                            $('.loading').hide();
                        }
                    }
                });
            });


            $('#grupo-reloj').on('click', function() {
                var input1 = $(this).children().children();
                var check = input1[1].checked;
                if (check) {
                    $('#cronometro').show();
                } else {
                    $('#cronometro').hide();
                }
            });


            $('#grupo-grafico').on('click', function() {
                var input1 = $(this).children().children();
                var check = input1[1].checked;
                if (check) {
                    $('#chartTortaContadorVotos').show();
                    // $('.contenedor-tabla-registrados').css('margin-top', '430px');

                } else {
                    $('#chartTortaContadorVotos').hide();
                    // $('.contenedor-tabla-registrados').css('margin-top', '0');

                }
            });


            $('#grupo-tabla-registrados').on('click', function() {
                var input1 = $(this).children().children();
                var check = input1[1].checked;
                if (check) {
                    $('.contenedor-torta').css('margin-top', '-459px');
                    $('#contenedor-tabla-registrados').show();
                } else {
                    $('.contenedor-torta').css('margin-top', '20px');
                    $('#contenedor-tabla-registrados').hide();
                }
            });

        });

        $(function() {
            load();
        });
        </script>