<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
* Description of User
*
* @author Developer
*/
class Ingresos_salida extends MY_Model
{
    
    protected $_table;
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->_table      = 'evi09ingre';
        $this->primary_key = 'ID_INGRE';
    }
    
    /**
    * Para editar el campo de una tabla. 
    * 
    * @param type @table Tabla
    * @param type @table_id Id a editar
    * @param type @id Id primaria
    * @param type $data datos
    * @return boolean
    */
    public function edit($id, $data)
    {
        $this->db->where($this->primary_key, $id);
        if ($this->db->update($this->_table, $data)):
            return true;
        else:
            return false;
        endif;
    }
    
    public function valida_participante_fuera_auditorio($participante_id)
    {
        $validacion_fuera_auditorio = $this->db->select("COUNT(NUM_IDETER) as total_ingresos")
        ->from('evi09ingre')
        ->where("NUM_IDETER", $participante_id)
        ->having('total_ingresos %2=', 0, false)
        ->get()
        ->row();

        //Si tiene esta fuera del auditorio.
        if(isset($validacion_fuera_auditorio)){
            return true;
        }

        return false;
    }
    
}
