﻿<?php defined('BASEPATH') OR exit('No direct script access allowed');
//ini_set('display_errors', 1);
//error_reporting(E_ALL);

class Instancias extends MX_Controller
{
	
	public $path_js;
	private $_configuracion;
	protected $_permisos;
	
	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Instancia', 'configuracion/Config', 'candidatos/Candidato',
		'agencias/Agencia']);
		$this->path_js = 'instancias/scripts_dev.js';
		$this->template->title('Instancias');
		$this->template
		->set_layout('admin')
		->set('load_js', $this->path_js);
		
		$this->_configuracion = $this->Config->get_row();
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}
		$this->_permisos = $this->session->userdata('permisos'); 
		
	}
	
	public function index()
	{
		$this->template
		->build('index', ['titulo' => 'Listado de instancias']);
	}
	
	/**
	* Lista asociados desde Datatables. 
	*/
	public function get_all()
	{
		$list = $this->Instancia->get_datatables();
		$data = array();
		$no   = $this->input->post('start');
		foreach ($list as $instancia) {
			$no++;
			$row     = array();
			
			$delete= '';
			$editar = '';
			$status = '';
			$preview = '';
			$duplicar = '';
			
			if(isset($this->_permisos['instancias']['instancias_borrar'])) {
				
				$delete  = "<a href='instancias/delete/$instancia->ID_INSTAN ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";	
			}
			
			if(isset($this->_permisos['instancias']['instancias_editar'])) {
				$editar = "<a href='instancias/create/1/$instancia->ID_INSTAN ' class='btn btn-success'>Editar</a>";
			}
			
			
			//if(isset($this->_permisos['instancias']['instancias_editar'])) {
				$duplicar = "<a href='instancias/duplicar/$instancia->ID_INSTAN ' class='btn btn-warning'>Duplicar</a>";
				//	}
				
				if(isset($this->_permisos['instancias']['instancias_activar'])) {
					$status  = ($instancia->BOL_ACTIVO) ? "<a href='instancias/status/$instancia->ID_INSTAN/$instancia->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='instancias/status/$instancia->ID_INSTAN/$instancia->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
				}
				
				if(isset($this->_permisos['instancias']['instancias_previa_candidatos'])) {
					
					$preview = "<a href='instancias/preview_tarjeton/$instancia->ID_INSTAN' class='btn btn-success'>Previa Tarjetón</a>";
				}
				
				
				
				$row[]   = $instancia->ID_INSTAN;
				$row[]   = $instancia->TEX_NOMINS;
				$row[]   = $instancia->NUM_ORDEN;
				$row[]   = $instancia->NUM_MUSEIN;
				$row[]   = ($instancia->BOL_VOTBLA) ? 'SI' : 'NO';
				$row[]   = ($instancia->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
				$row[]   = "$editar $status $delete $preview $duplicar";
				$data[]  = $row;
			}
			$output = array(
				"draw"            => $this->input->post('draw'),
				"recordsTotal"    => $this->Instancia->count_all(),
				"recordsFiltered" => $this->Instancia->count_filtered(),
				"data"            => $data,
			);
			echo json_encode($output);
		}
		
		/**
		* Crear instancia.
		*/
		public function create($edit = null, $id = null)
		{
			if ($this->input->post()):
				unset($_POST['TEX_CIUDAD']);
				$edit = $this->input->post('edit');
				$id   = $this->input->post('ID_INSTAN');
				
				$this->form_validation->set_rules('NUM_MUSEIN', 'Multiselección de candidatos', 'required');
				$this->form_validation->set_rules('BOL_VOTBLA', 'Voto en Blanco', 'required');
				$this->form_validation->set_rules('FEC_INIUSO', 'Fecha ini uso', 'required');
				$this->form_validation->set_rules('FEC_FINUSO', 'Fecha fin uso', 'required');
				if ($edit) {
					$this->form_validation->set_rules('TEX_NOMINS', 'Nombre del Instancia', 'required');
				}
				else {
					$this->form_validation->set_rules('TEX_NOMINS', 'Nombre del Instancia', 'required|is_unique[evi02instan.TEX_NOMINS]');
					$this->form_validation->set_rules('NUM_ORDEN', 'Orden de la instancia', 'is_unique[evi02instan.NUM_ORDEN]');
				}
				if (!$this->form_validation->run()):
					$this->session->set_flashdata('error', validation_errors());
					if ($edit) {
						redirect("instancias/create/1/$id");
					}
					if (headers_sent()) {
						echo '<script type="text/javascript">';
						echo 'window.location.href="' . base_url('instancias/create') . '";';
						echo '</script>';
						exit;
					} else {
					redirect("instancias/create");
					}
				else:
					$_post              = $this->security->xss_clean($_POST);
					
					// echo '<pre>';
					// var_dump($_post);exit;
					
					$datos_tipo_agencia = array_merge($_post, $this->get_campos_control_DB(1));
					
					if ($edit && $id) {
						unset($datos_tipo_agencia['edit']);
						if ($this->Instancia->edit($id, $datos_tipo_agencia)) {
							//Crea candidato voto en blanco de la instancia.
							if ($this->input->post('BOL_VOTBLA')) {
								
								$this->Candidato->delete_by(['ID_INSTAN' => $id, 'BOL_BLANCO' => 1]);
								$exist_voto_blanco_insta = $this->Candidato->get_candidato_by_instancia($id);
								
								if (!$exist_voto_blanco_insta) {
									$this->Candidato->create_candidato_voto_blanco($id, $this->input->post('TEX_NOMINS'), 1, 1);
								}
							}
								if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias') . '";';
								echo '</script>';
								exit;
							} else {
								$this->session->set_flashdata('success', 'Se ha editado el registro');
							    redirect('instancias');
							}

							
						}
						else {
							$this->session->set_flashdata('error', 'Error en la edición de los datos');
							redirect("instancias/create/1/$id");
						}
					}
					// $this->db->trans_start();
					$id_instancia = $this->Instancia->insert($datos_tipo_agencia);
					if ($id_instancia) {
						if ($this->input->post('BOL_VOTBLA')) {
							$this->Candidato->create_candidato_voto_blanco($id_instancia, $this->input->post('TEX_NOMINS'), 1, 1);
						}
						if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias') . '";';
								echo '</script>';
								exit;
							} else {
						$this->session->set_flashdata('success', 'Se ha guardado la instancia.');
						redirect('instancias');
						}
					}
					else {
					if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias/create') . '";';
								echo '</script>';
								exit;
							} else {
						$this->session->set_flashdata('error', 'Error en la inserción de los datos');
						redirect('instancias/create');
						}
					}
					//   $this->db->trans_complete();
				endif;
			else:
				$temporizador = $this->_configuracion->NUM_TEMPO;
				$route        = $this->get_module_name();
				if ($edit && $id) {
					$instancia = $this->Instancia->get($id);
					$this->template
					->build('create', [
						'titulo'    => 'Editar Instancia',
						'tempo'     => $temporizador,
						'instancia' => $instancia,
						'route'     => $route,
						]);
					}
					$this->template
					->build('create', [
						'titulo' => 'Crear Instancia',
						'tempo'  => $temporizador,
						'route'  => $route,
						]);
					endif;
				}
				
				/**
				* 
				* Cambiar status
				* 
				* @param type $id
				* @param type $status
				* 
				*/
				public function status($id, $status)
				{
					if(isset($this->_permisos['instancias']['instancias_activar'])) {
						$data = ['BOL_ACTIVO' => 1];
						if ($status) {
							$data = ['BOL_ACTIVO' => 0];
						}
						if ($this->Instancia->edit($id, $data)):
						if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias') . '";';
								echo '</script>';
								exit;
							} else {
							$this->session->set_flashdata('success', 'Status cambiado');
							redirect('instancias');
							}
						else:
							$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
							redirect('instancias');
						endif;
					}
				}
				
				/**
				* Borrar Registro
				* @param type $id
				*/
				public function delete($id)
				{
					$data = ['IS_DELETE' => 1];
					if ($this->Instancia->edit($id, $data)):
					if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias') . '";';
								echo '</script>';
								exit;
							} else {
						$this->session->set_flashdata('success', 'Registro Eliminado');
						redirect('instancias');
						}
					else:
						$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
						redirect('instancias');
					endif;
				}
				
				public function preview_tarjeton($id_instancia = null)
				{
					if ($_POST) {
						$agencia                             = $this->input->post('COD_AGENCIA');
						$ciudad                              = $this->input->post('COD_CIUDAD');
						$id_instancia                        = $this->input->post('id_instancia');
						$data_view['candidatos']             = $this->Candidato->get_candidatos_tarjeton_preview($id_instancia, $agencia, $ciudad);
						$data_view['voto_blanco']            = $this->Candidato->get_voto_blanco($id_instancia);
						$data_view['instancia']              = $this->Instancia->get($id_instancia);
						$data_view['agencia_participante']   = $this->Agencia->get(1);
						$data_view['numero_candidatos_grid'] = (int) $this->_configuracion->NUM_CANFIL;
						$this->load->view('preview_candidatos', $data_view);
					}
					else {
						$num_candidatos = $this->Candidato->get_by(['ID_INSTAN' => $id_instancia]);
						if (empty($num_candidatos)) { 
							$this->session->set_flashdata('error', 'Esta instancia no tiene candidatos');
							redirect('pyr');
						}
						
						$data_view['id_instancia'] = $id_instancia;
						$data_view['ciudades']     = $this->Instancia->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
						$data_view['instancia']    = $this->Instancia->select_forms('evi02instan', 'ID_INSTAN', 'TEX_NOMINS');
						//  $data_view['listas']    = $this->Instancia->select_forms('evi03listas', 'ID_LISTA', 'TEX_NOMLIS');
						$data_view['agencias']     = $this->Instancia->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');
						$data_view['load_js']      = $this->path_js;
						$this->load->view('form_preview_candidatos', $data_view);
					}
				}
				
				
				public function duplicar($id_instancia=null)
				{
					
					if($this->input->post()){
						$id_instancia = $this->input->post('ID_INSTAN');
						$nombre_nueva_instancia = $this->input->post('TEX_NOMINS');
						if(!$id_instancia){
							$this->session->set_flashdata('error', 'Id de la instancia es requerido');
							redirect('instancias');
						}
						
						if(!$nombre_nueva_instancia){
							$this->session->set_flashdata('error', 'Nombre de la instancia es requerido');
							redirect('instancias');
						}
						
						$old_instancia = $this->Instancia->get($id_instancia);
						$num_order = $this->Instancia->get_max_num_order() + 1;
						
						$nueva_instancia = [
							'TEX_NOMINS' => $nombre_nueva_instancia,
							'NUM_ORDEN' => $num_order,
							'NUM_MUSEIN' => $old_instancia->NUM_MUSEIN,
							'BOL_OBLMUL' => $old_instancia->BOL_OBLMUL,
							'BOL_VOTBLA' => $old_instancia->BOL_VOTBLA,
							'FEC_INIUSO' => $old_instancia->FEC_INIUSO,
							'FEC_FINUSO' => $old_instancia->FEC_FINUSO,
							'NUM_TOTELE' => $old_instancia->NUM_TOTELE,
							'NUM_DECRES' => $old_instancia->NUM_DECRES,
							'TEX_OBSERVACION' => $old_instancia->TEX_OBSERVACION,
							'COD_CREAUSU' => $old_instancia->COD_CREAUSU,
							'FEC_CREACION' => date('Y-m-d H:i:s'),
							'TEX_CREANOTA' => $old_instancia->TEX_CREANOTA,
							'BOL_ACTIVO' => 0,
							'IS_DELETE' => 0,
						];
						//Inicia transacción.
						$this->db->trans_begin();
						$id_nueva_instancia = $this->Instancia->insert($nueva_instancia);
						
						$this->db->where('ID_INSTAN', $old_instancia->ID_INSTAN);
						$candidatos_instancia =  $this->db->get('evi04candidat_mr')->result();
						
						foreach ($candidatos_instancia as $key => $candidato_instancia) {
							
							$datos_candidato = [
								'NUM_ORDEN' => $candidato_instancia->NUM_ORDEN,
								'TEX_NOMCAN' => $candidato_instancia->TEX_NOMCAN,
								'TEX_APECAN' => $candidato_instancia->TEX_APECAN,
								'TEX_FOTO' => $candidato_instancia->TEX_FOTO,
								'NUM_TOVOCA' => $candidato_instancia->NUM_TOVOCA,
								'ID_INSTAN' => $id_nueva_instancia,
								'ID_LISTA' => $candidato_instancia->ID_LISTA,
								'TEXT_TIPLIST' => $candidato_instancia->TEXT_TIPLIST,
								'COD_CIUDAD' => $candidato_instancia->COD_CIUDAD,
								'COD_AGENCIA' => $candidato_instancia->COD_AGENCIA,
								'TEX_PERCAN' => $candidato_instancia->TEX_PERCAN,
								'TEX_OBSERVACION' => 'Duplicado desde instancia: '.$old_instancia->TEX_NOMINS,
								'BOL_BLANCO' => $candidato_instancia->BOL_BLANCO,
								'COD_CREAUSU'  => $this->session->userdata('COD_USUARIO'),
								'FEC_CREACION' => date("Y-m-d H:i:s"),
								'TEX_CREANOTA' => $this->input->ip_address(),
								'BOL_ACTIVO'   => '1',
								'IS_DELETE'    => '0',
							];
							
							$this->Candidato->insert($datos_candidato);
						}
						
						if ($this->db->trans_status() === FALSE)
						{
							$this->db->trans_rollback();
							$this->session->set_flashdata('error', 'Se ha presentado un error en la transacción.');
						      redirect('instancias');
						}
						else
						{
							$this->db->trans_commit();
							if (headers_sent()) {
								echo '<script type="text/javascript">';
								echo 'window.location.href="' . base_url('instancias') . '";';
								echo '</script>';
								exit;
							} else {
							$this->session->set_flashdata('success', 'Se ha duplicado la instancia y sus candidatos.');
					     	redirect('instancias');
							}
						}
							
						
					}
					
					if(!$id_instancia){
						$this->session->set_flashdata('error', 'Id de la instancia es requerido');
						redirect('instancias');
					}
					
					$data_view['id_instancia'] = $id_instancia;
					$this->load->view('duplicar', $data_view);
				}
				
			}
			
			