<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of User
 *
 * @author Developer
 */
class Log_ingreso extends MY_Model {

    protected $_table;
    protected $_table_parent;
    private $_column = array('ID_LOINPA', 'NUM_IDETER', 'NUM_PINGEN', 'FEC_INISES', 'FEC_FINSES', 'BOL_USADO');
    private $_order = array('COD_USUARIO' => 'desc');

    public function __construct() {
        parent::__construct();
        $this->load->database();
        $this->_table = 'evi06loinpa';
        $this->_table_parent = 'evi05partic';
        $this->primary_key = 'ID_LOINPA';
    }

    /**
     * Para editar el campo de una tabla. 
     * 
     * @param type @table Tabla
     * @param type @table_id Id a editar
     * @param type @id Id primaria
     * @param type $data datos
     * @return boolean
     */
    public function edit($id, $data) {
        $this->db->where('NUM_IDETER', $id);
        if ($this->db->update($this->_table, $data)):
            return true;
        else:
            return false;
        endif;
    }

    private function _get_datatables_query() {
        $this->db->select("$this->_table.*,$this->_table_parent.TEX_NOMPAR,$this->_table_parent.TEX_APEPAR");
        $this->db->from($this->_table);
        $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER");
        $i = 0;
        foreach ($this->_column as $item) {
            if ($_POST['search']['value'])
                ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
            $column[$i] = $item;
            $i++;
        }
        if (isset($_POST['order'])) {
            $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } else if (isset($this->_order)) {
            $order = $this->_order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }

    public function get_datatables() {
        $this->_get_datatables_query();
        if ($_POST['length'] != -1):
            $this->db->limit($_POST['length'], $_POST['start']);
        endif;
        $query = $this->db->get();
        return $query->result();
    }

    public function count_filtered() {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all() {
        $this->db->from($this->_table);
        return $this->db->count_all_results();
    }

}
