<?php







defined('BASEPATH') or exit('No direct script access allowed');







class Participantes extends MX_Controller



{







	/**



	 *



	 * @var type



	 */



	public $path_js;



	private $_configuracion;



	protected $_permisos;







	public function __construct()



	{



		parent::__construct();



		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {



			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";



			exit;
		}







		$this->load->model([
			'Participante',
			'Log_participante',
			'acceso/Access',
			'acceso/Log_recordar_password',
			'configuracion/Config',
			'agencias/Agencia',



			'empresas/Empresa',
			'instancias/Instancia'
		]);







		//Config del sistema



		$this->_configuracion = $this->Config->get_row();

         $this->ini_desencriptado();





		//Si no esta definida la configuración.



		if (!$this->_configuracion) {



			$data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';



			$this->load->view('errors/error_start_sistema', $data_view);



			return false;
		}







		$this->path_js = 'participantes/scripts_dev.js';



		$this->_permisos = $this->session->userdata('permisos');
	}








	public function index()



	{







		$data_view['titulo']  = 'Listado de Participantes';



		$data_view['permisos']  = $this->_permisos;



		$data_view['load_js'] = $this->path_js;



		$this->load->view('index', $data_view);
	}







	/**



	 * Lista asociados desde Datatables.



	 */



	public function get_all()



	{



		$list = $this->Participante->get_datatables();



		$data = array();



		$no   = $this->input->post('start');







		//Se busca la instancia activa



		$instancia_obj = $this->Instancia->get_instancia_by_id();



		$instancia_activa = '';



		if (isset($instancia_obj)) {



			$instancia_activa = $instancia_obj->ID_INSTAN;
		}







		foreach ($list as $participante) {



			$no++;



			$row    = array();







			$delete = '';



			$boton_editar = '';



			$status = '';



			$bloqueo = '';



			$status_bloq = '';



			$imprimir = '';



			$enviar_mensaje = '';







			//Validacion con la instancia activa.



			$validacion_voto_previo = $this->Participante->verifica_votacion($participante->NUM_IDETER, $instancia_activa);







			//$participacion = $this->Participante->verifica_votacion($participante->NUM_IDETER);



			$participacion = (isset($validacion_voto_previo)) ? true : false;



			$validar_dom = '';



			if ($participacion) {



				$validar_dom = 'onclick="return validarVoto(this.id);"';
			}







			if (isset($this->_permisos['participantes']['participantes_borrar'])) {



				$delete = "<a href='participantes/delete/$participante->NUM_IDETER' id='" . $participante->NUM_IDETER . "' class='btn btn-danger botones-table' $validar_dom>Eliminar</a>";
			}







			if (isset($this->_permisos['participantes']['participantes_editar'])) {



				$boton_editar = "<a href='participantes/create/1/$participante->NUM_IDETER' id='" . $participante->NUM_IDETER . "' class='btn btn-success botones-table' $validar_dom>Editar</a>";
			}



			if (isset($this->_permisos['participantes']['participantes_activar'])) {



				$status = ($participante->BOL_ACTIVO) ? "<a href='participantes/status/$participante->NUM_IDETER/$participante->BOL_ACTIVO' id='" . $participante->NUM_IDETER . "' class='btn btn-danger botones-table' style='margin-left:3px;' $validar_dom>Desactivar</a>" : "<a href='participantes/status/$participante->NUM_IDETER/$participante->BOL_ACTIVO ' id='" . $participante->NUM_IDETER . "' class='btn btn-success' style='margin-left:3px;' $validar_dom>Activar</a>";
			}











			if (isset($this->_permisos['participantes']['participantes_bloquear'])) {



				$status_bloq = ($participante->BOL_INISES) ? "<a href='participantes/bloqueo/$participante->NUM_IDETER/1 ' id='" . $participante->NUM_IDETER . "' class='btn btn-danger botones-table' style='margin-left:3px;'>Desbloquear</a>" :



					"<a href='participantes/bloqueo/$participante->NUM_IDETER/0' id='" . $participante->NUM_IDETER . "' class='btn btn-success' style='margin-left:3px;' $validar_dom>Bloquear</a>";
			}







			//if(isset($this->_permisos['participantes']['participantes_imprimir_voto'])) {



			if ($this->_configuracion->BOL_ACTIVAIMPREVOT && $this->_configuracion->BOL_ACTIVAIMPREVOT !== '0') {



				$imprimir = ($participacion) ? "<a href='participantes/imprimir_voto/$participante->NUM_IDETER/' id='" . $participante->NUM_IDETER . "' class='btn btn-warning botones-table' style='margin-left:3px;'>Imprimir voto</a>" : '';
			}



			//}











			if ($participante->BOL_ACTIVO) {



				$enviar_mensaje = "<a href='#' id='" . $participante->NUM_IDETER . "' class='btn btn-primary botones-table btn-enviar-mensaje' $validar_dom>Enviar contraseña</a>";
			}















			$bloqueo_login =  ($participante->BOL_BLOQUEADO) ? "<a href='participantes/desbloqueo_login/$participante->NUM_IDETER' id='" . $participante->NUM_IDETER . "' class='btn btn-success botones-table' style='margin-left:3px;' $validar_dom>Permitir Login</a>" : '';







			$boton_bloqueo_login = ($participante->BOL_BLOQUEADO) ? $bloqueo_login : '';







			$grupo_botones_accion = "$boton_editar $status $delete $status_bloq $boton_bloqueo_login $enviar_mensaje";



















			if ($participacion) {



				$grupo_botones_accion = "Ha realizado el proceso exitosamente. $imprimir";
			}







			$row[]  = $participante->NUM_IDETER;



			$row[]  = $participante->TEX_NOMPAR . ' ' . $participante->TEX_APEPAR;



			$row[]  = $participante->TEX_NOMAGE;



			$row[]  = $participante->NUM_PESO;



			$row[]  = ($participante->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';



			$row[]  = ($participante->FEC_INISES) ? $participante->FEC_INISES : '';



			$row[]  = ($participante->FEC_PROVOT) ? $participante->FEC_PROVOT : '';



			$row[]  = ($participante->FEC_INISES && $participante->FEC_PROVOT) ? $this->_diferenciaTiempoIngresoVoto($participante->FEC_INISES, $participante->FEC_PROVOT) : '';



			$row[]  = $grupo_botones_accion;



			$data[] = $row;
		}



		$output = array(



			"draw"            => $this->input->post('draw'),



			"recordsTotal"    => $this->Participante->count_all(),



			"recordsFiltered" => $this->Participante->count_filtered(),



			"data"            => $data,



		);



		echo json_encode($output);
	}







	private function _diferenciaTiempoIngresoVoto($fec_inises, $fec_voto)



	{



		$start_date = new DateTime($fec_inises);



		$since_start = $start_date->diff(new DateTime($fec_voto));



		$tiempo = '';



		if ($since_start->h > 0) {



			$tiempo .= $since_start->h . ' horas ';
		}







		if ($since_start->i > 0) {



			$tiempo .= $since_start->i . ' minutos ';
		}







		if ($since_start->s > 0) {



			$tiempo .= $since_start->s . ' segundos ';
		}



		return $tiempo;
	}







	public function imprimir_voto($num_ideter)



	{



		$consulta_votacion = $this->Participante->get_votacion_participante($num_ideter);



		$empresa = $this->Empresa->get_nom_empresa();



		$participante = $this->Participante->get($num_ideter);







		$nombre_empresa =  $this->Empresa->get_nom_empresa();



		$data_view['nombre_empresa'] = $empresa->COD_NIT . ' - ' . $empresa->TEX_NOMEMP;



		$data_view['instancia'] = $this->Instancia->get($consulta_votacion[0]->ID_INSTAN)->TEX_NOMINS;



		$data_view['agencia'] = $this->Agencia->get($participante->COD_AGENCIA)->TEX_NOMAGE;



		$data_view['participante'] = $this->Participante->get($num_ideter);



		$data_view['fecha_voto'] = $fecha_voto = $consulta_votacion[0]->FEC_PROVOT;



		$data_view['arr_votos'] = $consulta_votacion;



		$data_view['tipo_impresion'] = $this->_configuracion->TEX_TIPOIMPRE;;



		$this->load->view('imprimir_voto', $data_view);
	}







	/**



	 * Crear participante.



	 */



	public function create($edit = null, $id = null)
{
		if ($id) {
			$instancia_activa = $this->_get_instancia_activa();
			$participacion = $this->Participante->verifica_votacion($id, $instancia_activa);
			$this->mensaje_voto_previo($participacion);
		}

		if ($this->input->post()):
			$edit = $this->input->post('edit');
			$id   = $this->input->post('NUM_IDETER');

			if ($edit) {
				$this->form_validation->set_rules('NUM_IDETER', 'Código de la Participante', 'trim|required|integer');
			} else {
				$this->form_validation->set_rules('NUM_IDETER', 'Código de la Participante', 'trim|required|integer|is_unique[evi05partic.NUM_IDETER]');
			}

			$this->form_validation->set_rules('TEX_NOMPAR', 'Nombre de la Participante', 'required');

			if (!$this->form_validation->run()):
				$this->session->set_flashdata('error', validation_errors());
				if ($edit) {
					redirect("participantes/create/1/$id");
				}
				redirect("participantes/create", 'refresh');

			else:
				unset($_POST['RE_TEX_CLAVE']);
				unset($_POST['TEX_CIUDAD']);

				//$_POST['TEX_CLAVE'] = sha1($_POST['TEX_CLAVE']);
				// var_dump(sha1($_POST['TEX_CLAVE']));exit;

				$__plain_new_pw   = null; // contraseña en claro (propia o autogenerada) para TEX_CLAVE_FIJA
				$__plain_for_hash = null; // contraseña en claro a hashear

				if ($edit && $id) {
					// EDICIÓN
					$raw = isset($_POST['TEX_CLAVE']) ? trim((string)$_POST['TEX_CLAVE']) : '';
					if ($raw === '') {
						// Si está vacío en edición, NO tocar clave
						unset($_POST['TEX_CLAVE']);
					} else {
						// Cambiaron la clave en edición
						$__plain_new_pw   = $raw;
						$__plain_for_hash = $raw;
						// No hasheamos aún; se hará al preparar $datos_ciudad para ->edit()
					}
				} else {
					// CREACIÓN
					$raw = isset($_POST['TEX_CLAVE']) ? trim((string)$_POST['TEX_CLAVE']) : '';
					if ($raw === '') {
						// Autogenerar si no enviaron clave
						$num_digitos_pass = (int)$this->_configuracion->NUM_LONGPW;
						$tmp              = $this->_randomNumber($num_digitos_pass);
						$__plain_new_pw   = (string)$tmp;
						$__plain_for_hash = (string)$tmp;
						// Dejar en claro en $_POST; se hashea más abajo con tu línea existente
						$_POST['TEX_CLAVE'] = $tmp;
					} else {
						// Usuario escribió su clave al crear
						$__plain_new_pw   = $raw;
						$__plain_for_hash = $raw;
						// Dejar en claro en $_POST; se hashea más abajo
					}
				}

				$_post        = $this->security->xss_clean($_POST);
				$datos_ciudad = array_merge($_post, $this->get_campos_control_DB());

				// Manejo de TEX_CLAVE_FIJA / FEC_CLAVE_FIJA
				if ($__plain_new_pw !== null && $__plain_new_pw !== '') {
					$datos_ciudad['TEX_CLAVE_FIJA'] = $this->encriptar_texto($__plain_new_pw);
					$datos_ciudad['FEC_CLAVE_FIJA'] = date('Y-m-d H:i:s');
				} else {
					// en edición sin cambio de clave no tocamos los campos fijos
					unset($datos_ciudad['TEX_CLAVE_FIJA'], $datos_ciudad['FEC_CLAVE_FIJA']);
				}

				if ($edit && $id) {
					unset($datos_ciudad['edit']);

					// EDICIÓN: hashear sólo si hubo nueva clave, si no, no enviar TEX_CLAVE
					if ($__plain_for_hash !== null && $__plain_for_hash !== '') {
						$datos_ciudad['TEX_CLAVE'] = sha1($__plain_for_hash);
					} else {
						unset($datos_ciudad['TEX_CLAVE']);
					}

					if ($this->Participante->edit($id, $datos_ciudad)) {
						$this->Log_participante->registrar('EDITAR', $datos_ciudad);
						$this->session->set_flashdata('success', 'Se ha editado el registro');
						redirect('participantes');
					} else {
						$this->session->set_flashdata('error', 'Error en la edición de los datos');
						redirect("participantes/create/1/$id");
					}
				}

				// CREACIÓN: mantener tu línea original para hashear UNA SOLA VEZ
				$datos_ciudad['TEX_CLAVE'] = sha1($_POST['TEX_CLAVE']);

				$crear_participante = $this->Participante->insert($datos_ciudad);

				if (is_int($crear_participante)):
					$this->Log_participante->registrar('REGISTRAR', $datos_ciudad);
					$this->session->set_flashdata('success', 'Se ha guardado el registro');
					redirect('participantes');
				else:
					$this->session->set_flashdata('error', 'Error en la inserción de los datos');
					redirect('participantes/create');
				endif;

			endif;

		else:

			$data_view['route']  = $this->get_module_name();
			$data_view['titulo'] = 'Crear Participante';

			if ($edit && $id) {
				$this->db->join("gen04ciudad", "gen04ciudad.COD_CIUDAD = evi05partic.COD_CIUDAD");
				$data_view['participante'] = $this->Participante->get($id);
				$data_view['titulo']       = 'Editar Participante';
			}

			$data_view['ciudades']   = $this->Participante->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
			$data_view['agencias']   = $this->Participante->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');
			$data_view['instancias'] = $this->Participante->select_forms('evi02instan', 'ID_INSTAN', 'TEX_NOMINS');
			$data_view['load_js']    = $this->path_js;

			$this->load->view('create', $data_view);

		endif;
}







	private function _randomNumber($length)
	{



		$result = '';







		for ($i = 0; $i < $length; $i++) {



			$result .= mt_rand(0, 9);
		}







		return (int)$result;
	}







	/**



	 *



	 * Cambiar status



	 *



	 * @param type $id



	 * @param type $status



	 *



	 */



	public function status($id, $status)



	{







		if ($id) {



			$instancia_activa = $this->_get_instancia_activa();



			$participacion = $this->Participante->verifica_votacion($id, $instancia_activa);



			$this->mensaje_voto_previo($participacion);
		}







		$data = ['BOL_ACTIVO' => 1];



		if ($status) {



			$data = ['BOL_ACTIVO' => 0];
		}



		if ($this->Participante->edit($id, $data)):



			$this->Log_participante->registrar('CAMBIO_STATUS', array_merge($data, ['NUM_IDETER' => $id]));



			$this->session->set_flashdata('success', 'Se ha desactivado el participante');



			redirect('participantes');



		else:



			$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');



			redirect('participantes');



		endif;
	}







	public function mensaje_voto_previo($participacion)



	{



		if ($participacion) {



			setlocale(LC_ALL, "es_ES@euro", "es_ES", "esp");



			$fecha_voto_formato = iconv('ISO-8859-2', 'UTF-8', strftime("el %A %d de %B de %Y a las %H:%M:%S %p", strtotime($participacion->FEC_PROVOT)));



			$this->session->set_flashdata('error', 'Este participante ya ha realizado un proceso de votación ' . $fecha_voto_formato);



			redirect('participantes');
		}
	}















	/**



	 * Para bloquear el participante en el inicio de sesión.



	 * 



	 * @param type $id



	 * @param type $status



	 */



	public function bloqueo($id, $status)



	{







		if ($id) {



			$instancia_activa = $this->_get_instancia_activa();



			$participacion = $this->Participante->verifica_votacion($id, $instancia_activa);



			$this->mensaje_voto_previo($participacion);
		}







		$data = ['BOL_INISES' => 1];



		if ($status) {



			$data = ['BOL_INISES' => 0];
		}



		if ($this->Participante->edit($id, $data)):



			$this->Log_participante->registrar('BLOQUEO', array_merge($data, ['NUM_IDETER' => $id]));



			$this->session->set_flashdata('success', 'Status cambiado');



			redirect('participantes');



		else:



			$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');



			redirect('participantes');



		endif;
	}



	/**



	 * Para bloquear el participante en el inicio de sesión.



	 * 



	 * @param type $id



	 * @param type $status



	 */



	public function desbloqueo_login($id)

	{

		if ($id) {

			$instancia_activa = $this->_get_instancia_activa();

			$participacion = $this->Participante->verifica_votacion($id, $instancia_activa);

			$this->mensaje_voto_previo($participacion);
		}



		$data = ['BOL_BLOQUEADO' => '0', 'NUM_INTENLOGIN' => 0];



		// Guardar desbloqueo en evi05particlogeo

		$usuario_actual = $this->session->userdata('TEX_NOMUSUA'); // Suponiendo que el nombre del usuario actual está en la sesión

		$observacion = "Desbloqueo manual por $usuario_actual el " . date('Y-m-d H:i:s');

		$data_bloqueo = [

			'NUM_IDETER' => $id,

			'FEC_BLOQLOGIN' => date('Y-m-d H:i:s'),

			'TEX_OBSERVACION' => $observacion

		];



		// Insertar en evi05particlogeo

		$this->db->insert('evi05particlogeo', $data_bloqueo);



		// Actualizar datos en evi05partic

		if ($this->Participante->edit($id, $data)):

			// Registrar el log del desbloqueo

			$this->Log_participante->registrar('DESBLOQUEO_LOGIN', array_merge($data, ['NUM_IDETER' => $id]));



			// Mensaje de éxito

			$this->session->set_flashdata('success', 'Usuario desbloqueado para acceder.');

			redirect('participantes');

		else:

			// Mensaje de error

			$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status.');

			redirect('participantes');

		endif;
	}

















	/**



	 * Borrar Registro



	 * @param type $id



	 */



	public function delete($id)



	{







		if ($id) {



			$instancia_activa = $this->_get_instancia_activa();



			$participacion = $this->Participante->verifica_votacion($id, $instancia_activa);



			$this->mensaje_voto_previo($participacion);
		}







		$data = ['IS_DELETE' => 1];



		if ($this->Participante->edit($id, $data)):



			$this->Access->borrar_log_acceso($id);



			$this->Log_participante->registrar('BORRAR_PARTICIPANTE', array_merge($data, ['NUM_IDETER' => $id]));



			$this->session->set_flashdata('success', 'Registro Eliminado');



			redirect('participantes');



		else:



			$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');



			redirect('participantes');



		endif;
	}







	public function upload_csv()



	{



		if ($this->input->post()) {



			if (empty($this->input->post())) {



				$this->session->set_flashdata('error', 'Debes cargar el archivo');



				redirect("participantes/upload", 'refresh');
			}







			$config['upload_path']   = './uploads/csv';



			$config['allowed_types'] = 'csv';



			$config['max_size']      = 5000;



			$this->load->library('upload', $config);



			if (!$this->upload->do_upload('file')) {



				$this->session->set_flashdata('error', $this->upload->display_errors());



				redirect("participantes/upload_csv", 'refresh');
			} else {



				$data      = $this->upload->data();



				$file_path = $data['file_path'] . $data['file_name'];



				$rows      = $this->csv_to_array($file_path);



				unset($rows[0]);



				if ($rows) {



					$contador  = 1;



					$no_upload = 0;



					for ($index = 1; $index <= count($rows); $index++) {



						$contador++;



						$validacion = $this->valida_unica_cedula($rows[$index][0]);



						if (!$validacion):


                            $plainCsv = (string)$rows[$index][7]; 
							$data      = [



								'NUM_IDETER'  => $rows[$index][0],



								'TEX_NOMPAR'  => $rows[$index][1],



								'TEX_APEPAR'  => $rows[$index][2],



								'COD_CIUDAD'  => $rows[$index][3],



								'TEX_MAIL'    => $rows[$index][4],



								'NUM_TELCEL'  => $rows[$index][5],



								'COD_AGENCIA' => $rows[$index][6],



								'TEX_CLAVE'   => sha1($plainCsv),
								'TEX_CLAVE_FIJA' => $this->encriptar_texto($plainCsv),
								'FEC_CLAVE_FIJA' => date('Y-m-d H:i:s'),



								'NUM_PESO' => (isset($rows[$index][8])) ? $rows[$index][8] : 1



							];



							$data_save = array_merge($data, $this->get_campos_control_DB());



							$this->Participante->insert($data_save);



							$no_upload += $contador;



						else:



						endif;
					}



					$this->Log_participante->registrar('CARGA_MASIVA', $rows);



					$this->session->set_flashdata('success', 'Se han cargado con exito');



					redirect("participantes", 'refresh');
				}
			}
		} else {



			$data_view['titulo'] = 'Carga de Participantes (Archivo separado por ;)';



			$this->load->view('upload', $data_view);
		}
	}







	public function valida_unica_cedula($cedula)



	{



		return $this->Participante->get_row($cedula);
	}







	public function get_archivo_csv()



	{



		if ($this->session->userdata('COD_PERFIL') === 1) {



			$this->load->helper('download');



			force_download('./uploads/ayuda/participantes.csv', null);
		} else {



			redirect('/');
		}
	}







	public function generar_passwords()



	{



		if ($this->input->post()) {



			$arr_email = [];



			$size_pass = (int)$this->input->post('size_pass');



			$type_pass = (bool) $this->input->post('type_pass');



			$password = $this->_generateRandomStringMasivo($size_pass, $type_pass);







			$this->form_validation->set_rules('size_pass', 'Contraseña', 'trim|required|integer');



			if (!$this->form_validation->run()) {



				$this->session->set_flashdata('error', validation_errors());



				redirect('participantes/generar_passwords');



				return false;
			}







			$tipo = (int)$this->input->post('tipo');



			if ($tipo) {



				//Todos.



				$participantes = [];



				if ($tipo === 1) {



					$participantes = $this->Participante->get_participantes(null, null, 1);
				}







				if ($tipo === 2) {



					$participantes = $this->Participante->get_participantes('agen', $this->input->post('COD_AGENCIA'), 1);
				}



				if ($tipo === 3) {



					$participantes = $this->Participante->get_participantes('ciudad', $this->input->post('COD_CIUDAD'), 1);
				}







				if (count($participantes) > 0) {







					//Envío por correo electrónico.



					if ($this->input->post('send_email')) {







						foreach ($participantes as $key => $participante) {



							$password = $this->_generateRandomStringMasivo($size_pass, $type_pass);



							$update_pass =   $this->Participante->update_password($participante->NUM_IDETER, $password);



							$arr_email[] =



								[



									"To" => $participante->TEX_MAIL,



									"Parameters" => [



										['Name' => 'nombre_completo', 'Type' => 'text', 'Value' => $participante->TEX_NOMPAR],



										['Name' => 'contrasena', 'Type' => 'text', 'Value' => $password],



									]



								];
						}







						$this->api_envio_email($arr_email);
					} elseif ($this->input->post('send_sms')) {







						foreach ($participantes as $key => $participante) {



							$update_pass =   $this->Participante->update_password($participante->NUM_IDETER, $password);







							if ($update_pass) {



								//Envío por mesaje de texto.



								if ($participante->NUM_TELCEL) {



									$this->_enviar_sms_recordar_password($participante->NUM_IDETER, $participante->TEX_NOMPAR, $participante->NUM_TELCEL, $password);
								}
							} // update pass



						}
					} elseif (!$this->input->post('send_email') && !$this->input->post('send_sms')) {











						foreach ($participantes as $key => $participante) {



							$update_pass =   $this->Participante->update_password($participante->NUM_IDETER, $password);







							if ($update_pass) {



								//Envío por mesaje de texto.



								if ($participante->NUM_TELCEL) {



									$this->_enviar_sms_recordar_password($participante->NUM_IDETER, $participante->TEX_NOMPAR, $participante->NUM_TELCEL, $password);
								}
							}
						}
					} else {
					}







					$type_string = '';



					if ($this->input->post('send_email')) {



						$type_string = 'correos';
					} elseif ($this->input->post('send_sms')) {



						$type_string = 'mensajes de texto';
					} else {



						$type_string = 'correos';
					}







					if ($this->input->post('send_email') && $this->input->post('send_sms')) {



						$type_string = 'correos y mensajes de texto';
					}







					$this->session->set_flashdata('success', "Se han generado las contraseñas y enviado los $type_string.");



					redirect('participantes/generar_passwords');
				} else {



					$this->session->set_flashdata('error', 'No hay participantes.');



					redirect('participantes/generar_passwords');
				}
			}
		} else {



			$data_view['titulo'] = 'Generación de contraseñas';



			$data_view['agencias']   = $this->Participante->select_forms('gen01agencias', 'COD_AGENCIA', 'TEX_NOMAGE');



			$data_view['ciudades']   = $this->Participante->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');



			$data_view['correos_masivos_sin_enviar']   = $this->Participante->get_participantes_sin_envio_masivo();



			$this->load->view('generar_passwords', $data_view);
		}
	}







	private function _generateRandomString($length = 5, $type = null)



	{



		$characters = '0123456789';



		if ((bool)$this->_configuracion->BOL_TIPPW) {



			$characters       = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		}



		$charactersLength = strlen($characters);



		$randomString     = '';







		if ($this->_configuracion->NUM_LONGPW) {



			$length = $this->_configuracion->NUM_LONGPW;
		}



		for ($i = 0; $i < $length; $i++) {



			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}



		return $randomString;
	}







	private function _generateRandomStringMasivo($length = 5, $type = true)



	{



		$characters       = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';



		if ($type) {



			$characters = '0123456789';
		}







		$charactersLength = strlen($characters);



		$randomString     = '';







		for ($i = 0; $i < $length; $i++) {



			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}



		return $randomString;
	}











	public function api_envio_email($arr_recipients)



	{







		$body_html = $this->load->view('email_template_participante', [], true);







		$email_body_obj = new stdClass();











		$email_body_obj->Subject = "Nueva contraseña votación virtual";



		$email_body_obj->From = "info@eleccionvirtual.com";



		$email_body_obj->Template = ["Type" => "text/html", "Value" => $body_html];



		$email_body_obj->Recipients =  $arr_recipients;







		$email_body = json_encode((array)$email_body_obj, JSON_PRETTY_PRINT);











		$curl = curl_init();







		curl_setopt_array($curl, array(



			CURLOPT_URL => 'https://api.masiv.masivian.com/email/v1/delivery',



			CURLOPT_RETURNTRANSFER => true,



			CURLOPT_ENCODING => '',



			CURLOPT_MAXREDIRS => 10,



			CURLOPT_TIMEOUT => 0,



			CURLOPT_FOLLOWLOCATION => true,



			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,



			CURLOPT_CUSTOMREQUEST => 'POST',



			CURLOPT_POSTFIELDS => $email_body,



			CURLOPT_HTTPHEADER => array(



				'Authorization: Basic RW1haWxWNF9DWUJFUklBX1RFQ0hfNTk2Ni5BcGk6UWgpUDh1a0FlOQ==',



				'Content-Type: application/json'



			),



		));







		$response = curl_exec($curl);







		curl_close($curl);
	}







	private function _enviar_email_recordar_password($cedula, $nombre, $email, $password)

	{

		// 1) Actualiza la contraseña si viene definida

		if (!empty($password)) {

			$this->Participante->update_password($cedula, $password);
		}



		// 2) Datos de la empresa y textos

		$nombre_empresa = $this->Empresa->get_nom_empresa()->TEX_NOMEMP;

		$body  = $this->get_texto_sistema('TEX_MAILPWBOD')->TEX_LABEL;

		$body2 = $this->get_texto_sistema('TEX_MAILPWASUN')->TEX_LABEL;

		$asunto = $nombre_empresa . ' ' . $this->get_texto_sistema('TEX_MAILPWASU')->TEX_LABEL;



		// 3) Remitente (ajusta si tienes settings en BD o .env)

		$fromEmail = 'info@gestionvir.com';

		$fromName  = 'Evir - Votación Virtual';



		// 4) Destinatario

		$to = trim($email);



		// 5) Cabeceras HTML

		$headers = 'From: ' . $fromName . ' <' . $fromEmail . '>' . "\r\n" .

			'Reply-To: ' . $fromEmail . "\r\n" .

			'X-Mailer: PHP/' . phpversion() . "\r\n" .

			'MIME-Version: 1.0' . "\r\n" .

			'Content-type: text/html; charset=UTF-8';



		// 6) Sanitizar lo que se muestra en HTML

		$nombreSafe  = htmlspecialchars($nombre, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');

		$empresaSafe = htmlspecialchars($nombre_empresa, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');

		$bodySafe    = htmlspecialchars($body, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');

		$body2Safe   = htmlspecialchars($body2, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');

		// *Si la contraseña es temporal y no contiene HTML, se puede mostrar directa.

		$passwordSafe = htmlspecialchars($password, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');



		// 7) Cuerpo del mensaje

		$mensaje = "

    <html>

      <head>

        <title>Su contraseña se ha generado.</title>

      </head>

      <body>

        <h3>{$bodySafe}</h3>

        <p>Buen día Sr.(a) {$nombreSafe}</p>

        <p>{$body2Safe} {$empresaSafe} es: <strong>{$passwordSafe}</strong></p>

      </body>

    </html>";



		// 8) Envío y log

		$enviado = @mail($to, $asunto, $mensaje, $headers);



		// Registra en log (opcional, como tenías)

		if ($enviado && isset($this->Log_participante)) {

			$this->Log_participante->registrar('ENVIO_EMAIL_INDIVIDUAL', ['NUM_IDETER' => $cedula]);
		}



		return $enviado;
	}





	/**



						Para envío de SMS.



	 */



	private function _enviar_sms_recordar_password($cedula, $nombre, $celular, $password)



	{







		if ($password) {



			$this->Participante->update_password($cedula, $password);
		}







		$sms  = $this->get_texto_sistema('TEX_SMSPW')->TEX_LABEL;







		$nombre_empresa       = $this->Empresa->get_nom_empresa();



		$nombre_empresa = $nombre_empresa->TEX_NOMEMP;







		$nom = str_replace(array("#", "'", ";", "&"), '', $nombre);



		$message_sms = 'Buen día Sr.(a) , ' . $nom . ' ' . $nombre_empresa . ' ' . $this->get_texto_sistema('TEX_SMSPWSYS')->TEX_LABEL . ' ' . $password;



		//print_r($res);die;



	//	$this->envia_sms($celular, $message_sms, TRUE);
		if($this->_configuracion->BOL_SMS==1){
    $this->envia_sms_liwa($celular, $message_sms, TRUE);
   }else{
    $this->envia_sms_sigma($celular, $message_sms, TRUE);
   }




		/*//anterior codigo



							//Indicativo país.



							$celular     = '57' . $celular;



							



							$flash_sms = ($this->_configuracion->BOL_FLASHSMS)?'true':'false';



							



							$url_sms = 'https://api.masiv.co/SmsHandlers/sendhandler.ashx';



							$user_sms = 'Api_K4OGL';



							$pass_sms = 'h5yIvTxOR1Jh';



							



							$message_sms = $this->get_texto_sistema('TEX_SMSPWSYS')->TEX_LABEL. ' ' . $password;



							$message_sms =  str_replace(' ', '+', $message_sms);



							



							



							$url_send = "$url_sms?action=sendmessage&username=$user_sms&password=$pass_sms&recipient=$celular&messagedata=$message_sms&flash=$flash_sms&longMessage=true&premium=true";



							



							$ch = curl_init();



							curl_setopt($ch, CURLOPT_URL, $url_send);



							curl_setopt($ch, CURLOPT_VERBOSE, 0);



							curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);  



							



							curl_exec($ch);



							curl_close($ch);



							*/
	}



      function envia_sms_sigma($telefono, $mensaje, $idCategoria = 1, $nombreCampania = null)
{
    if ($nombreCampania === null) {
        $nombreCampania = 'EVIR_'.date('Ymd_His');
    }
    
    
    $indicativos = array("300","301","302","303","304","305","310","311","312","313","314","315","316","317","318","319","320","321","322","323","350","351");
    $indicativo_cliente = substr($telefono, 0, 3);

    if (strlen($telefono) != 10) {
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['ok'=>false,'error'=>'Teléfono inválido (se esperan 10 dígitos).','telefono'=>$telefono], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
        exit;
    }
    if (!in_array($indicativo_cliente, $indicativos)) {
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['ok'=>false,'error'=>'El indicativo del celular no está permitido.','telefono'=>$telefono], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
        exit;
    }

    // ---- Configuración SIGMA (SIN .env) ----
    $API_TOKEN = '21879|zxvWUa6n0YLhxcZXPyF3jGuQuTpSkGiqfyIJ9Jw2b08117bc'; // <-- tu token
    $API_BASE  = 'https://aio2.sigmamovil.com/api';
    $URL       = rtrim($API_BASE, '/').'/sms';

    // Algunos tenants usan x-api-key, otros Authorization: Bearer.
    // Déjalos ambos para la prueba; si ves 401/403, elimina el que no aplique.
    $headers = array(
        'x-api-key: '.$API_TOKEN,
        'Authorization: Bearer '.$API_TOKEN,
        'Content-Type: application/json',
        'Accept: application/json'
    );

    // Body tipo "lote" (con 1 receptor) como en tu screenshot
    $payload = array(
        'idSmsCategory' => (int)$idCategoria,     // debe existir en tu cuenta Sigma
        'name'          => (string)$nombreCampania,
        'receiver'      => array(
            array(
                'indicative' => 57,
                'phone'      => (int)$telefono,   // solo los 10 dígitos
                'message'    => (string)$mensaje
            )
        ),
        'dateNow'       => 1,                     // 1 = envío inmediato (si quieres programar: usa scheduleDate y pon 0)
        'type'          => 'lote',
        'track'         => 0,
        'flash'         => 0,
        'api'           => 1,
        'notification'  => 0,
        'rne'           => 0
    );

    $ch = curl_init($URL);
    curl_setopt_array($ch, array(
        CURLOPT_POST           => 1,
        CURLOPT_HTTPHEADER     => $headers,
        CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_TIMEOUT        => 25,
        CURLOPT_VERBOSE        => 0
    ));

    $raw    = curl_exec($ch);
    $errno  = curl_errno($ch);
    $errstr = curl_error($ch);
    $http   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $json = json_decode($raw, true);
    $ok   = ($http >= 200 && $http < 300);

    // Respuesta visible SIEMPRE
  /*  header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        'ok'      => $ok && !$errno,
        'http'    => $http,
        'url'     => $URL,
        'headers' => $headers,
        'payload' => $payload,
        'curlErr' => $errno ? ('cURL: '.$errstr) : null,
        'raw'     => $raw,
        'json'    => $json
    ], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE);
    //exit;*/
}


	function envia_sms_liwa($telefono, $mensaje, $debug)



	{



















		$indicativos = array("300", "301", "302", "303", "304", "305", "310", "311", "312", "313", "314", "315", "316", "317", "318", "319", "320", "321", "322", "323", "350", "351");



		$indicativo_cliente = substr($telefono, 0, 3);







		if (strlen($telefono) == 10) {



			if (in_array($indicativo_cliente, $indicativos)) {







				$account = '00486368700';



				$api_key = '976c108277654b6e83203d1ed6b4826f90ce8dc3';

				//  $api_key='dadce556b6a56f8be394a3600a24e977f6fbe970';



				$password = 'Cursor91';



				$api_numero_telefono = '57' . $telefono;



				$api_mensaje_texto = $mensaje;



				/***********************************************************************/







				$fullurl = "https://api.liwa.co/v2/auth/login";







				//https://api-dev.cellvoz.com/v2/auth/login _



				//https://api.cellvoz.com/v2/auth/login _







				$headers = array(



					"Content-Type: application/json",



				);







				$post_params = array(



					"api_key" => $api_key,



					"account" => $account,



					"password" => $password,



					"Content-type: application/json",



				);



				$post_params = json_encode($post_params);







				$curl = curl_init($fullurl);



				curl_setopt($curl, CURLOPT_POST, 1);



				curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);



				curl_setopt($curl, CURLOPT_POSTFIELDS, $post_params);



				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);



				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);



				curl_setopt($curl, CURLOPT_VERBOSE, 1);







				$response = curl_exec($curl);







				$respuesta_final_autentificacion = json_decode($response, true);











				$token_autentificacion = $respuesta_final_autentificacion['token'];

				//print_r($token_autentificacion);die;



				/********************************************************************/



				$fullurl = "https://api.liwa.co/v2/sms/single"; // "https://api.cellvoz.co/v2/sms/single";



				$headers = array(



					"api-key: " . $api_key,



					"Authorization: Bearer " . $token_autentificacion,



					"Content-Type: application/json",



				);







				$post_params = array(



					"number" => $api_numero_telefono,



					"message" => $api_mensaje_texto,



					"Content-type: application/json",



				);



				$post_params = json_encode($post_params);







				$curl = curl_init($fullurl);



				curl_setopt($curl, CURLOPT_POST, 1);



				curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);



				curl_setopt($curl, CURLOPT_POSTFIELDS, $post_params);



				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);



				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);



				curl_setopt($curl, CURLOPT_VERBOSE, 1);







				$response = curl_exec($curl);



				$respuesta_final_envio = json_decode($response, true);



				//	echo '<pre>';print_r($respuesta_final_envio);echo '</pre>';die;



				$mensaje_enviado = $respuesta_final_envio['success'];



				/********************************************************************/







				//if($mensaje_enviado == 1) { $er="Mensaje Enviado"; } else { $er="Mensaje No Enviado"; }







			} else {



				$er = "El indicativo del telefono celular no esta permitido";
			}
		} else {



			$er = "La longitud del telefono celular no concuerda con un numero valido";
		}







		/*if($debug == true)



							{ 



								echo '<pre>';print_r($respuesta_final_autentificacion);echo '</pre>';



								echo '<pre>';print_r($respuesta_final_envio);echo '</pre>';



								echo $er;



							}



						*/
	}



















	public function desbloqueo_masivo()



	{



		if (!isset($this->_permisos['participantes']['participantes_desbloqueo_masivo'])) {
		}



		$this->Participante->update_all(['BOL_INISES' => 0, 'BOL_BLOQUEADO' => 0, 'NUM_INTENLOGIN' => 0]);



		$this->Log_participante->registrar('DESBLOQUEO_MASIVO', ['BOL_INISES' => 0, 'BOL_BLOQUEADO' => 0, 'NUM_INTENLOGIN' => 0]);



		$this->session->set_flashdata('success', 'Se han desbloqueado los participantes');



		redirect('participantes');
	}











	public function validacion_voto()



	{



		if ($this->input->post('id')) {



			$participacion = $this->Participante->verifica_votacion($this->input->post('id'));



			if ($participacion) {



				echo json_encode(['type' => 'error', 'message' => 'Este participante ya ha realizado un proceso de votación']);



				return false;
			} else {



				echo json_encode(['type' => 'success', 'message' => '']);
			}
		}
	}











	private function _get_instancia_activa()



	{



		//Se busca la instancia activa



		$instancia_obj = $this->Instancia->get_instancia_by_id();



		$instancia_activa = '';



		if (isset($instancia_obj)) {



			$instancia_activa = $instancia_obj->ID_INSTAN;
		}







		return $instancia_activa;
	}











	public function enviar_mensaje($tipo, $identificacion)



	{







		$participante = $this->Participante->get($identificacion);



		$congelar = ((int)$this->_configuracion->BOL_CONGELA_CLAVE === 1);

		if ($congelar) {
			// Si congela la clave
			if (!empty($participante->TEX_CLAVE_FIJA)) {
				// Usa la clave fija del participante desencriptada
				$password = $this->desencriptar_texto($participante->TEX_CLAVE_FIJA);
			} else {
				// Si no hay clave fija, usa la clave fija por defecto de la configuración
				$password = $this->desencriptar_texto($this->_configuracion->TEX_PASS_FIJA_DEF);
			}
		} else {
			// Si no congela, generar aleatoria normal
			$password = $this->_generateRandomString(8, 0);
		}








		if ($participante) {



			$email = $participante->TEX_MAIL;



			$celular = $participante->NUM_TELCEL;







			//Email



			if ($tipo) {







				if (!$email) {



					echo json_encode(['type' => 'error', 'message' => 'El participante no tiene registrado un correo electrónico']);



					return false;
				}



                        $data_log = [



                            'NUM_IDETER' => $participante->NUM_IDETER,



                            'TEX_TIPOENVIO' => 'Email',



                            'TEX_IPORIG' => $this->input->ip_address(),



                            'FEC_GENERACION' => date("Y-m-d H:i:s")



                        ];



                        $this->Log_recordar_password->insert($data_log);




				$this->_enviar_email_recordar_password($participante->NUM_IDETER, $participante->TEX_NOMPAR, $participante->TEX_MAIL, $password);



				$this->Log_participante->registrar('ENVIO_EMAIL_INDIVIDUAL', ['NUM_IDETER' => $identificacion]);



				echo json_encode(['type' => 'success', 'message' => 'Mensaje de correo electrónico enviado']);



				return false;
			}











			if (!$celular) {



				echo json_encode(['type' => 'error', 'message' => 'El participante no tiene registrado un número de celular']);



				return false;
			}




                        $data_log = [



                            'NUM_IDETER' => $participante->NUM_IDETER,



                            'TEX_TIPOENVIO' => 'SMS',



                            'TEX_IPORIG' => $this->input->ip_address(),



                            'FEC_GENERACION' => date("Y-m-d H:i:s")



                        ];



                        $this->Log_recordar_password->insert($data_log);


			$this->_enviar_sms_recordar_password($participante->NUM_IDETER, $participante->TEX_NOMPAR, $participante->NUM_TELCEL, $password);



			$this->Log_participante->registrar('ENVIO_SMS_INDIVIDUAL', ['NUM_IDETER' => $identificacion]);



			echo json_encode(['type' => 'success', 'message' => 'Mensaje SMS enviado']);
		}
	}
}
