<?php

/*
* To change this license header, choose License Headers in Project Properties.
* To change this template file, choose Tools | Templates
* and open the template in the editor.
*/

/**
* Description of User
*
* @author Developer
*/
class Participante extends MY_Model
{
	
	protected $_table;
	protected $_table_parent;
	protected $_table_parent2;
	protected $_agencia_usuario;
	private $_configuracion;
	
	private $_column = array('evi05partic.NUM_IDETER', 'TEX_NOMPAR', 'TEX_APEPAR', 'gen01agencias.TEX_NOMAGE', 'evi05partic.BOL_ACTIVO');
	private $_order  = array('NUM_IDETER' => 'desc');
	
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->_table         = 'evi05partic';
		$this->_table_parent  = 'gen01agencias';
		$this->_table_parent2 = 'gen04ciudad';
		$this->_table_votacion = 'evi07audpro';
		$this->_table_registrados = 'evi09ingre';
		$this->primary_key    = 'NUM_IDETER';
		$this->_agencia_usuario = $this->session->userdata('COD_AGENCIA');
		
		$this->load->model('configuracion/Config');
		//Config del sistema
		$this->_configuracion = $this->Config->get_row();
		
		//Si no esta definida la configuración.
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}
	}
	
	public function get_participantes($where=null, $value=null, $masivo=0)
	{
		$this->db->where('BOL_ACTIVO', 1);
		
		if($where === 'agen') {
			$this->db->where('COD_AGENCIA', $value);
		}
		if($where === 'ciudad') {
			$this->db->where('COD_CIUDAD', $value);
		}
		if($masivo) {
		$this->db->where("$this->_table.BOL_EMAIL_MASIV", 0);
		}
		//$this->db->where('evi05partic.NUM_IDETER NOT IN (SELECT NUM_IDETER FROM evi07audpro)', NULL, FALSE);
		$this->db->select("NUM_IDETER,TEX_NOMPAR,TEX_MAIL,NUM_TELCEL");
		$this->db->from($this->_table);
		
		$query = $this->db->get();
		return $query->result();
	}
	
	public function get_participantes_sin_envio_masivo()
	{
		$this->db->where('BOL_ACTIVO', 1);
		$this->db->where('BOL_EMAIL_MASIV', 0);
		$this->db->select("NUM_IDETER,TEX_NOMPAR,TEX_MAIL,NUM_TELCEL");
		$this->db->from($this->_table);
		
		$query = $this->db->get();
		return count($query->result());
	}
	
	
	
	/**
	* Para editar el campo de una tabla. 
	* 
	* @param type @table Tabla
	* @param type @table_id Id a editar
	* @param type @id Id primaria
	* @param type $data datos
	* @return boolean
	*/
	public function edit($id, $data)
	{
		$this->db->where($this->primary_key, $id);
		if ($this->db->update($this->_table, $data)):
			return true;
		else:
			return false;
		endif;
	}
	
	/**
	* Para editar el campo de una tabla. 
	* 
	* @param type @table Tabla
	* @param type @table_id Id a editar
	* @param type @id Id primaria
	* @param type $data datos
	* @return boolean
	*/
	public function update_intentos_login($identificacion)
	{
		$participante = $this->get($identificacion);
		$intentos     = $participante->NUM_INTENLOGIN;
		if (!$intentos) {
			$intentos = 0;
		}
		$total_intentos = (int) $intentos + 1;
		
		
		$this->db->where($this->primary_key, $identificacion);
		if ($this->db->update($this->_table, ['NUM_INTENLOGIN' => $total_intentos])):
			return true;
		else:
			return false;
		endif;
	}
	
	public function update_participante_bloqueo($identificacion)
	{
		$this->db->where($this->primary_key, $identificacion);
		if ($this->db->update($this->_table, ['BOL_BLOQUEADO' => 1])):
			return true;
		else:
			return false;
		endif;
	}
	
	public function update_password($identificacion, $password, $masivo=1)
	{
		$this->db->where($this->primary_key, $identificacion);
		
		$arr = ['TEX_CLAVE' => sha1($password)];
		if(!$masivo){
			$arr =	['TEX_CLAVE' => sha1($password), 'BOL_EMAIL_MASIV' => 1];
		}
		
		if ($this->db->update($this->_table, $arr)):
			return true;
		else:
			return false;
		endif;
	}
	
	private function _get_datatables_query()
	{
		$this->db->distinct();
		$this->db->select("$this->_table.*,$this->_table_parent.TEX_NOMAGE, $this->_table_votacion.FEC_PROVOT");
		$this->db->from($this->_table);
		$this->db->join($this->_table_parent, "$this->_table_parent.COD_AGENCIA=$this->_table.COD_AGENCIA");
		$this->db->join($this->_table_votacion, "$this->_table_votacion.NUM_IDETER=$this->_table.NUM_IDETER", 'LEFT');
		$this->db->where("$this->_table.IS_DELETE", 0);
		$this->db->group_by("$this->_table.NUM_IDETER");
		
		
		//Segmentación por agencia.
		if($this->_configuracion->TEX_SEGMEN == 'A') {	
			if ($this->session->userdata('COD_TIPOPERFIL') !== 1){
				$this->db->where("$this->_table.COD_AGENCIA", $this->session->userdata('COD_AGENCIA'));
			}
		}
		
		
		if($_POST['search']['value'] == 'por_login') {
			$this->db->where("$this->_table.NUM_INTENLOGIN >=", (int) $this->_configuracion->NUM_INLOGIN);
			$this->db->where("$this->_table.BOL_BLOQUEADO", 1);
		}
		if($_POST['search']['value'] == 'por_ingreso') {
			$this->db->where('evi05partic.NUM_IDETER NOT IN (SELECT evi07audpro.NUM_IDETER FROM evi07audpro)', NULL, FALSE);
			$this->db->where("$this->_table.BOL_INISES ", 1);
		}  
		
		
		
		$i = 0;
		if ($_POST['search']['value'] !== 'por_ingreso' && $_POST['search']['value'] !== 'por_login') {
			foreach ($this->_column as $item) {
				if ($_POST['search']['value']) {
					$search = $_POST['search']['value']; 
					$paren = '';
					if($i==3) {
						$paren=')'; 				
					}
					($i === 0) ? 
					$this->db->where("($item LIKE '%$search%'"): $this->db->or_where("$item LIKE '%$search%'$paren");
				}
				$column[$i] = $item;
				$i++;
			}
			
			
			
			if (isset($_POST['order'])) {
				$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
			}
			else if (isset($this->_order)) {
				$order = $this->_order;
				$this->db->order_by(key($order), $order[key($order)]);
			}
		}
	}
	
	public function get_datatables()
	{
		$this->_get_datatables_query();
		if ($_POST['length'] != -1):
			$this->db->limit($_POST['length'], $_POST['start']);
		endif;
		$query = $this->db->get();
		return $query->result();
	}
	
	public function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}
	
	public function count_all()
	{
		$this->db->from($this->_table);
		$this->db->where("$this->_table.BOL_ACTIVO", 1);
		return $this->db->count_all_results();
	}
	
	/**
	* Select HTML.
	* @return array.
	*/
	public function get_html_select()
	{
		$this->db->from($this->_table);
		$this->db->where("$this->_table.BOL_ACTIVO", 1);
		$this->db->where("$this->_table.IS_DELETE", 0);
		return $this->db->get($this->_table);
	}
	
	/**
	*  Consulta los participantes - Sorteo
	* @return array.
	*/
	public function get_participantes_nombre()
	{
		$this->db->select("NUM_IDETER,  CONCAT(TEX_NOMPAR, ' ', TEX_APEPAR) as nombre_participante");
		$this->db->from($this->_table);
		$this->db->where("$this->_table.BOL_ACTIVO", 1);
		$this->db->where("$this->_table.IS_DELETE", 0);
		return $this->db->get()->result();
	}
	
	/**
	*  Consulta los registrados - Sorteo
	* @return array.
	*/
	public function get_registrados_nombre()
	{
		$this->db->select("$this->_table_registrados.NUM_IDETER, CONCAT($this->_table.TEX_NOMPAR, ' ', $this->_table.TEX_APEPAR) as nombre_participante");
		$this->db->from($this->_table_registrados);
		$this->db->join($this->_table, "$this->_table.NUM_IDETER=$this->_table_registrados.NUM_IDETER");
		$this->db->where("$this->_table_registrados.BOL_ACTIVO", 1);
		$this->db->order_by("$this->_table_registrados.NUM_IDETER", 'ASC');
		return $this->db->get()->result();
	}
	
	/**
	*  Consulta los participantes dentro del auditorio - Sorteo
	* @return array.
	*/
	public function get_participantes_auditorio_nombre()
	{
		$this->db->select("$this->_table_registrados.NUM_IDETER, COUNT($this->_table.NUM_IDETER) as ingresos, CONCAT($this->_table.TEX_NOMPAR, ' ', $this->_table.TEX_APEPAR) as nombre_participante");
		$this->db->from($this->_table_registrados);
		$this->db->join($this->_table, "$this->_table.NUM_IDETER=$this->_table_registrados.NUM_IDETER");
		$this->db->where("$this->_table_registrados.BOL_ACTIVO", 1);
		$this->db->having('ingresos %2=', 1, false);
		$this->db->group_by("$this->_table_registrados.NUM_IDETER");
		$this->db->order_by("$this->_table_registrados.NUM_IDETER", 'ASC');
		return $this->db->get()->result();
	}

	/**
	*  Consulta los participantes que han votado - Sorteo
	* @return array.
	*/
	public function get_participantes_votado_nombre()
	{
		$this->db->select("$this->_table_votacion.NUM_IDETER, CONCAT($this->_table.TEX_NOMPAR, ' ', $this->_table.TEX_APEPAR) as nombre_participante");
		$this->db->from($this->_table_votacion);
		$this->db->join($this->_table, "$this->_table.NUM_IDETER=$this->_table_votacion.NUM_IDETER");
		$this->db->where("$this->_table.IS_DELETE", 0);
		$this->db->group_by("$this->_table_votacion.NUM_IDETER");
		$this->db->order_by("$this->_table_votacion.NUM_IDETER", 'ASC');
		return $this->db->get()->result();
	}	
	
	
	public function get_participante($identificacion)
	{
		$this->db->select('*');
		$this->db->from($this->_table);
		$this->db->join($this->_table_parent, "$this->_table_parent.COD_AGENCIA=$this->_table.COD_AGENCIA");
		$this->db->where("$this->_table.NUM_IDETER", $identificacion);
		$this->db->where("$this->_table.BOL_ACTIVO", 1);
		$this->db->where("$this->_table.IS_DELETE", 0);
		
		if($this->_agencia_usuario !== 0) {
			
			if($this->session->userdata('COD_TIPOPERFIL') == 3) {
				$agen = [10, $this->_agencia_usuario];
				$this->db->where_in("$this->_table.COD_AGENCIA", $agen);
			} 
			else {
				$this->db->where("$this->_table.COD_AGENCIA", $this->_agencia_usuario); 
				
			}
			
		}
		
		
		return $this->db->get()->row();
	}
	
	public function get_participante_by_mail($email_celular)
	{
		$this->db->select('*');
		$this->db->from($this->_table);
		$this->db->where("$this->_table.TEX_MAIL", $email_celular);
		return $this->db->get()->row();
	}
	
	public function get_participante_by_sms($email_celular)
	{
		$this->db->select('*');
		$this->db->from($this->_table);
		$this->db->where("$this->_table.NUM_TELCEL", $email_celular);
		return $this->db->get()->row();
	}
	
	//------------------------------------------------------------------------------
	
	/**
	* Evalua si el participante ya ha votado previamente.
	* 
	* @param int $id_participante
	* @param string $candidato
	* @return obj
	*/
	public function get_exits_voto($instancia = null, $id_participante, $candidato = null)
	{
		if ($candidato) {
			$this->db->where('ID_CANDID', $candidato);
		}
		if ($instancia) {
			$this->db->where('ID_INSTAN', $instancia);
		}
		$this->db->where('NUM_IDETER', $id_participante);
		return $this->db->get('evi07audpro')->row();
	}
	
	public function verifica_votacion($id_participante, $instancia_activa=null)
	{
		$this->db->where('NUM_IDETER', $id_participante);
		
		if($instancia_activa) {
			$this->db->where('ID_INSTAN', $instancia_activa);
		}
		return $this->db->get('evi07audpro')->row();
	}

	public function consultafecha($id_participante)
	{
		$this->db->where('NUM_IDETER', $id_participante);
		return $this->db->get('evi05partic')->row();
		
	}
	
	/**
	* Verifica si el participante esta registrado.
	* 
	* @param type $id_participante
	* @return type
	*/
	public function verifica_registro($id_participante)
	{
		if($this->_agencia_usuario !== 0) {
			$this->db->where("$this->_table.COD_AGENCIA", $this->_agencia_usuario);  
		}
		
		$this->db->select('FEC_REGIST');
		return $this->get($id_participante);
	}
	
	public function get_votacion_participante($num_ideter)
	{
		$this->db->select('v.ID_INSTAN, v.ID_CANDID, v.FEC_PROVOT, c.TEX_NOMCAN, c.TEX_APECAN');  
		$this->db->from('evi05partic p');
		$this->db->join('evi07audpro v', "v.NUM_IDETER=p.NUM_IDETER", 'LEFT');
		$this->db->join('evi04candidat_mr c', "c.ID_CANDID=v.ID_CANDID");
		$this->db->where('p.NUM_IDETER', $num_ideter);
		return $this->db->get()->result();
	}
	
}
