<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Permisos extends MX_Controller
{

	public $path_js;
	private $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1) {
			echo "<h3>No tiene permisos para acceder a esta sección. Acceso solo para super administradores</h3>";
			exit;
		}

		$this->_permisos =  $this->session->userdata('permisos');

		$this->load->model(['Permiso', 'configuracion/Modulos_sistema']);
		$this->path_js = 'permisos/scripts_dev.js';
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado de Permisos';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

	function change_status($primary_key, $row)
	{
		return site_url('permisos/status') . '/' . $primary_key . '/' . $row->BOL_ACTIVO;
	}

	public function example_output($output = null, $titulo = null)
	{
		$this->load->view('render', $output);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Permiso->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $permiso) {
     		$no++;
     		$row    = array();
     		$delete= '';
     		$editar = '';
     		if(isset($this->_permisos['permisos']['permisos_borrar'])) {
     			$delete = "<a href='permisos/delete/$permiso->COD_PERMI ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}
     		if(!$permiso->IS_SISTEMA){
     			if(isset($this->_permisos['permisos']['permisos_editar'])) {
     				$editar = "<a href='permisos/create/1/$permiso->COD_PERMI ' class='btn btn-success'>Editar</a>";
     			}
     		}
     		$row[]  = $permiso->COD_PERMI;
     		$row[]  = $permiso->TEX_NOMPERMI;
     		$row[]  = $permiso->TEX_MODULO;
     		$row[]  = $permiso->TIPO_ACCION;
     		$row[]  = ($permiso->IS_SISTEMA)?'Si':'No';
     		$row[]  = ($permiso->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Permiso->count_all(),
     		"recordsFiltered" => $this->Permiso->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear permiso.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_PERMI');
     		if ($edit) {
     			$this->form_validation->set_rules('TEX_NOMPERMI', 'Nombre del permiso', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('TEX_NOMPERMI', 'Nombre del permiso', 'required|is_unique[auth04permi.TEX_NOMPERMI]');  
     			$this->form_validation->set_rules('COD_MODULO', 'Módulo', 'required');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("permisos/create/1/$id");
     			}
     			redirect("permisos/create");
     		else:
     			unset($_POST['COD_MODULO']);
     			$_post         = $this->security->xss_clean($_POST);
     			$datos_permiso = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_permiso['edit']);
     				if ($this->Permiso->edit($id, $datos_permiso)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('permisos');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("permisos/create/1/$id");
     				}
     			}
     			if (is_int($this->Permiso->insert($datos_permiso))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('permisos');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('permisos/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['permiso'] = $this->Permiso->get($id);
     		}
     		$data_view['titulo']  = 'Crear permiso';
     		if($edit) {
     			$data_view['titulo']  = 'Editar permiso';
     		}
     		$data_view['modulos']  = $this->Modulos_sistema->select_forms('evi10modulos', 'COD_MODULO', 'TEX_NOMMOD', null, null, null, 'TEX_NOMMOD');
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

/**
*Para ingresar permisos automáticamente al sistema.
*/
public function insert_label()
{
	$modulos =$this->Modulos_sistema->get_all();
	$acciones = ['listar', 'editar', 'ver', 'crear', 'borrar', 'activar'];

	foreach ($modulos as $key => $modulo) {
		$nom_modulo = $modulo->TEX_NOMMOD;

		for ($i=0; $i < count($acciones); $i++) { 
			$accion =  $acciones[$i];
			$nombre_permiso = $nom_modulo.'_'.$accion;
			$validador =   $this->Permiso->get_by_permiso($nombre_permiso);
			if(!$validador) {
				$data = [
					'TEX_NOMPERMI'=> $nom_modulo.'_'.$accion,
					'TEX_MODULO'=> $nom_modulo,
					'TIPO_ACCION'=> $accion,
					'TEX_LABEL'=> $nom_modulo.'_'.$accion,
					'COD_CREAUSU'=> 1,
					'FEC_CREACION'=> date('Y-m-d H:i:s'),
					'TEX_CREANOTA'=> 1,
				];
				$this->Permiso->insert($data);
			}

		}

	}
}

/**
* Para asignar permisos automáticamente.
*/
public function asignar_permisos_automatico()
{
	$cod_perfil=1;

	$permisos = $this->Permiso->get_all();

	foreach ($permisos as $key => $permiso) {

		if($permiso->COD_PERMI){
			$this->Permiso->crear_permisos_perfil($cod_perfil,$permiso->COD_PERMI);
		}
	}

}

/**
* Para asignar permisos automáticamente.
*/
public function editar_permisos_automatico()
{
	$cod_perfil=1;

	$permisos = $this->Permiso->get_all();

	foreach ($permisos as $key => $permiso) {

		$label = $permiso->TIPO_ACCION;
		$label = ucwords(strtolower($label));

		if($permiso->TEX_MODULO !== 'informes') {
			$arr = explode(" ", $label);

				$this->Permiso->edit($permiso->COD_PERMI,['TEX_LABEL'=> $label]);
			

		}
		
	}

}

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data           = ['IS_DELETE' => 1];
     	$valida_permiso = $this->Permiso->valida_permiso($id);
     	if (!$valida_permiso) {
     		if ($this->Permiso->edit($id, $data)):
     			$this->session->set_flashdata('success', 'Registro Eliminado');
     			redirect('permisos');
     		else:
     			$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     			redirect('permisos');
     		endif;
     	} else {
     		$this->session->set_flashdata('error', 'No puedes borrar este permiso, tiene perfiles asignados.');
     		redirect('permisos');
     	}
     }

  }
