<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Permiso extends MY_Model
 {

 	protected $_table     = 'auth04permi';
 	private $_primary_key = 'COD_PERMI';
 	private $_column      = ['COD_PERMI', 'TEX_NOMPERMI', 
 	'TEX_MODULO','TIPO_ACCION', 'IS_SISTEMA', 'BOL_ACTIVO'];
 	private $_order       = array('COD_PERMI' => 'desc');

 	public function __construct()
 	{
 		parent::__construct();
 		$this->load->database();
 		$this->_table      = 'auth04permi';
 		$this->primary_key = 'COD_PERMI';
 	}

     /**
      * Para editar el campo de una tabla. 
      * 
      * @param type @table Tabla
      * @param type @table_id Id a editar
      * @param type @id Id primaria
      * @param type $data datos
      * @return boolean
      */
     public function edit($id, $data)
     {
     	$this->db->where($this->_primary_key, $id);
     	if ($this->db->update($this->_table, $data)):
     		return true;
     	else:
     		return false;
     	endif;
     }

     private function _get_datatables_query()
     {
     	$this->db->select("$this->_table.*");
     	$this->db->from($this->_table);
     	$this->db->where('IS_DELETE', 0);
     	$i = 0;
     	foreach ($this->_column as $item) {
     		if ($_POST['search']['value']) ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
     			$column[$i] = $item;
     			$i++;
     		}
     		if (isset($_POST['order'])) {
     			$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
     		}
     		else if (isset($this->_order)) {
     			$order = $this->_order;
     			$this->db->order_by(key($order), $order[key($order)]);
     		}
     	}

     	public function get_datatables()
     	{
     		$this->_get_datatables_query();
     		if ($_POST['length'] != -1):
     			$this->db->limit($_POST['length'], $_POST['start']);
     		endif;
     		$query = $this->db->get();
     		return $query->result();
     	}

     	public function count_filtered()
     	{
     		$this->_get_datatables_query();
     		$query = $this->db->get();
     		return $query->num_rows();
     	}

     	public function count_all()
     	{
     		$this->db->from($this->_table);
     		$this->db->where("$this->_table.BOL_ACTIVO", 1);
     		return $this->db->count_all_results();
     	}

     	public function valida_permiso($COD_PERMI)
     	{
     		$this->db->where('COD_PERMI', $COD_PERMI);
     		return $this->db->get('auth06perfilhaspermi')->row();
     	}


     	public function get_all_permisos($cod_perfil)
     	{
     		$permisos_perfil = $this->_get_permisos_perfil_string($cod_perfil);
     		$id_permisos_asignados = implode(',', $permisos_perfil);
     		if($id_permisos_asignados) {
     			$this->db->where("auth04permi.COD_PERMI NOT IN ($id_permisos_asignados)", NULL, FALSE);
     		}
     		$this->db->where("BOL_ACTIVO", 1);
     		$this->db->where("IS_DELETE", 0);
     		$this->db->order_by('auth04permi.TIPO_ACCION', 'ASC');
     		$data_permisos =  $this->db->get('auth04permi')->result();

     		$arr =[];
     		foreach ($data_permisos as $key => $permiso) {
     			$arr[$permiso->TEX_MODULO][$key] = $permiso;
     		}

     		return $arr;
     	}


     	private function _get_permisos_perfil($cod_perfil)
     	{ 
     		$this->db->select('COD_PERMI');
     		$this->db->where('COD_PERFIL', $cod_perfil);
     		return $this->db->get('auth06perfilhaspermi')->result();
     	}   

     	public function get_by_permiso($nom_permiso)
     	{ 
     		$this->db->select('TEX_NOMPERMI');
     		$this->db->where('TEX_NOMPERMI', $nom_permiso);
     		return $this->db->get($this->_table)->row();
     	}


     	private function _get_permisos_perfil_string($cod_perfil)
     	{ 
     		$permisos_perfil = $this->_get_permisos_perfil($cod_perfil);
     		$arr = [];
     		foreach ($permisos_perfil as $key => $permi) {
     			$arr[$key] = $permi->COD_PERMI;
     		}
     		return $arr;
     	}


		/**
		Crea los permisos del perfil
		*/
		public function crear_permisos_perfil($cod_perfil, $cod_permi)
		{
			$datos = [
				'COD_PERFIL' => $cod_perfil,
				'COD_PERMI' => $cod_permi,
				'FEC_CREACION' => date("Y-m-d H:i:s"),
				'COD_CREAUSU'  => 1, 
				'TEX_CREANOTA' => $this->input->ip_address(),
			];
			$this->_table     = 'auth06perfilhaspermi';
			$this->insert($datos);
		}


    /**
      * Elimina todos los permisos asociados al perfil
      * 
      * @return boolean
      */
    public function borrar_permisos_perfil($cod_perfil)
    {
    	if ($this->db->delete('auth06perfilhaspermi', ['COD_PERFIL' => $cod_perfil])) {
    		return true;
    	}
    	else {
    		return false;
    	}
    }
 }
