<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Pyr extends MX_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->model('pyr/Pyr_instancia_model','pyrInstancia');
        $this->load->model('pyr/Pyr_candidato_model','Candidato');
        $this->load->model('candidatos/Candidato','CandidatoBase'); 
        $this->load->library('upload');
    }

    // listado
    public function index(){
    $instancias = $this->pyrInstancia->listar();

    foreach ($instancias as &$instancia) {
        $instancia->total_candidatos = $this->Candidato->contarPorInstancia($instancia->ID_INSTAN);
    }

    $data['instancias'] = $instancias;
   
    $this->load->view('pyr/listado',$data);
}

public function eliminar_candidato_ajax($idCandidato = null){
    header('Content-Type: application/json');

    if (!$idCandidato) {
        echo json_encode(['success' => false, 'message' => 'ID de candidato inválido.']);
        return;
    }

    $resultado = $this->Candidato->eliminarPorId($idCandidato);

    if ($resultado) {
        echo json_encode(['success' => true, 'message' => 'Candidato eliminado correctamente.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al eliminar el candidato.']);
    }
}


    

        public function cambiar_estado($idInstancia = null, $estado = null){
        if(!$idInstancia || $estado === null) {
            $this->session->set_flashdata('error', 'Parámetros inválidos.');
            redirect('pyr/index');
        }

        $resultado = $this->pyrInstancia->cambiarEstado($idInstancia, $estado);
        
        if($resultado) {
            $mensaje = $estado == 1 ? 'Pregunta activada correctamente.' : 'Pregunta desactivada correctamente.';
            $this->session->set_flashdata('success', $mensaje);
        } else {
            $this->session->set_flashdata('error', 'Error al cambiar el estado de la pregunta.');
        }

        redirect('pyr/index');
    }


     // ================= NUEVO MÉTODO PARA CAMBIAR ESTADO DE CANDIDATOS =================
    public function cambiar_estado_candidato($idCandidato = null, $estado = null){
        header('Content-Type: application/json');
       
        if(!$idCandidato || $estado === null) {
            echo json_encode(['success' => false, 'message' => 'Parámetros inválidos.']);
            return;
        }

        $resultado =  $this->Candidato->cambiarEstado($idCandidato, $estado);

        
        
        if($resultado) {
            $mensaje = $estado == 1 ? 'Candidato activado correctamente.' : 'Candidato desactivado correctamente.';
            echo json_encode(['success' => true, 'message' => $mensaje]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al cambiar el estado del candidato.']);
        }
    }


       // eliminar pregunta
    public function eliminar($idInstancia = null){
        if(!$idInstancia) {
            $this->session->set_flashdata('error', 'ID de pregunta inválido.');
            redirect('pyr/index');
        }

      
        $resultado = $this->pyrInstancia->eliminar($idInstancia);
        
        if($resultado) {
            $this->session->set_flashdata('success', 'Pregunta eliminada correctamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar la pregunta.');
        }

        redirect('pyr/index');
    }

    
    // formulario nuevo / editar
    public function form($idInstancia = null){
        $data['instancia']  = $idInstancia ? $this->pyrInstancia->obtener($idInstancia) : null;
        $data['candidatos'] = $idInstancia ? $this->Candidato->listarPorInstancia($idInstancia) : [];
        $data['maxOrden']   = $this->pyrInstancia->getMaxOrden(); 
        $data['candidatos_predef'] = $this->Candidato->listarCandidatosPredefinidos();

        $this->load->view('pyr/form_unificado',$data);
    }

    // guardar instancia + candidatos
     public function guardar(){
        $post = $this->input->post();

        $fechaHoy   = date('Y-m-d');
        $fechaFin   = date('Y-m-d', strtotime('+1 year'));
        $fechaActual = date('Y-m-d H:i:s');

      // ==============================
// 1. Guardar PREGUNTA
// ==============================
if (isset($post['guardar_pregunta'])) {
    $idInstancia = !empty($post['id_instancia']) ? $post['id_instancia'] : null;

    // reglas de validación
    $this->form_validation->set_rules('pregunta', 'Pregunta', 'required|trim');
    $this->form_validation->set_rules('orden', 'Orden de la instancia', [
        'required',
        'integer',
        function($orden) use ($idInstancia) {
            // Buscar si existe ya ese orden en otra instancia
            $this->db->where('NUM_ORDEN', $orden);
            if ($idInstancia) {
                // si es edición, excluir la misma instancia
                $this->db->where('ID_INSTAN !=', $idInstancia);
            }
            $existe = $this->db->get('evi02instan')->row();
            if ($existe) {
                $this->form_validation->set_message('orden', 'El número de orden ya está asignado a otra pregunta.');
                return false;
            }
            return true;
        }
    ]);

    if ($this->form_validation->run() === FALSE) {
        $this->session->set_flashdata('error', validation_errors());
        if ($idInstancia) {
            redirect('pyr/form/' . $idInstancia);
        } else {
            redirect('pyr/form');
        }
        return;
    }
    // ✅ si pasa validación, continuar esta
    $instanciaData = [
        'TEX_NOMINS'   => $post['pregunta'],
        'NUM_MUSEIN'   => $post['multiseleccion'],
        'NUM_ORDEN'    => $post['orden'],
        'NUM_TOTELE'   => $post['puestos'],
        'NUM_DECRES'   => $post['decimales'],
        'FEC_INIUSO'   => !empty($post['fec_ini']) ? $post['fec_ini'] : $fechaHoy,
        'FEC_FINUSO'   => !empty($post['fec_fin']) ? $post['fec_fin'] : $fechaFin,
        'BOL_ACTIVO'   => isset($post['activo']) ? $post['activo'] : 0,
        'BOL_VOTBLA'   => isset($post['voto_blanco']) ? $post['voto_blanco'] : 0,
        'BOL_OBLMUL'   => isset($post['obliga_multi']) ? $post['obliga_multi'] : 0
    ];

    if ($idInstancia) {
        $this->pyrInstancia->actualizar($idInstancia, $instanciaData);
    } else {
        $instanciaData['FEC_CREACION'] = $fechaActual;
        $idInstancia = $this->pyrInstancia->guardar($instanciaData);
    }

    redirect('pyr/form/' . $idInstancia);
    return;
}

     
// ==============================
// 2. Guardar CANDIDATOS
// ==============================
if (isset($post['guardar_candidatos']) && !empty($post['id_instancia'])) {
    
      
    $idInstancia = $post['id_instancia'];
 
    if (!empty($post['opciones'])) {
        foreach ($post['opciones'] as $i => $op) {
            if (trim($op['descripcion']) == '') continue;
 
            $idCandidato = !empty($op['id_candidato']) ? $op['id_candidato'] : null;
            $idOriginal = !empty($op['id_original']) ? $op['id_original'] : null;
            $fotoOriginal = !empty($op['foto_original']) ? $op['foto_original'] : null;
            $fotoPath    = null;
   
            // ✅ Si es candidato duplicado (sin id_candidato pero con id_original y foto_original)
            if (!$idCandidato && $idOriginal && $fotoOriginal) {
                $fotoPath = $fotoOriginal;
            }
            // ✅ Si es actualización de candidato existente, buscar foto actual en BD
            else if ($idCandidato) {
                $candExistente = $this->Candidato->obtenerPorId($idCandidato);
                if ($candExistente) {
                
                    $fotoPath = $candExistente->TEX_FOTO;
                }
            }

            // ✅ Si subió nueva foto → reemplazar
            if (!empty($_FILES['opciones']['name'][$i]['imagen'])) {
                $file_name = uniqid("cand_{$idInstancia}_{$i}_");
                $uploadPath = './uploads/candidatos/';
                
                $config['upload_path']   = $uploadPath;
                $config['allowed_types'] = 'gif|jpg|jpeg|png';
                $config['max_size']      = 5000;
                $config['file_name']     = $file_name;
                $config['overwrite']     = true;

                $this->upload->initialize($config);

                $_FILES['tempfile']['name']     = $_FILES['opciones']['name'][$i]['imagen'];
                $_FILES['tempfile']['type']     = $_FILES['opciones']['type'][$i]['imagen'];
                $_FILES['tempfile']['tmp_name'] = $_FILES['opciones']['tmp_name'][$i]['imagen'];
                $_FILES['tempfile']['error']    = $_FILES['opciones']['error'][$i]['imagen'];
                $_FILES['tempfile']['size']     = $_FILES['opciones']['size'][$i]['imagen'];

                if ($this->upload->do_upload('tempfile')) {
                    $uploadData = $this->upload->data();
                    $fotoPath   = 'uploads/candidatos/' . $uploadData['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                    redirect('pyr/form/' . $idInstancia);
                    return;
                }
            }

            // ⚠️ Validar que exista foto final (solo para candidatos nuevos que NO son duplicados)
            if ($fotoPath === null && !$idCandidato && !$idOriginal) {
                $this->session->set_flashdata('error', 'Debe cargar una foto para todos los candidatos.');
                redirect('pyr/form/' . $idInstancia);
                return;
            }
            // =============================
            // INSERTAR O ACTUALIZAR
            // =============================
            $candData = [
                'ID_INSTAN'  => $idInstancia,
                'TEX_NOMCAN' => $op['descripcion'],
                'TEX_APECAN' => $op['complemento'],
               'TEX_PERCAN' => $op['texto_perfil'],           
                'NUM_ORDEN'  => $op['orden'],
                'TEX_FOTO'   => $fotoPath,
                'COD_CIUDAD' => $op['ciudad'],
                'COD_AGENCIA'=> $op['segmento'],
                'BOL_ACTIVO' => 1,
                'IS_DELETE'  => 0
            ];

            if ($idCandidato) {
                // 🔄 UPDATE si ya existía
                $this->Candidato->actualizar($idCandidato, $candData);
            } else {
                // ➕ INSERT si es nuevo
                $this->Candidato->guardar($candData);
            }
        }
    }

    redirect('pyr/form/' . $idInstancia);
    return;
}



        redirect('pyr/index');
    }

    // ==============================
    // AJAX CIUDADES
    // ==============================
    public function ajax_ciudades() {
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode(
                $this->CandidatoBase->select_forms(
                    'gen04ciudad',
                    'COD_CIUDAD',
                    'TEX_NOMCIU',
                    null, null, null,
                    'TEX_NOMCIU'
                )
            ));
    }

    // ==============================
    // AJAX AGENCIAS
    // ==============================
    public function ajax_agencias() {
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode(
                $this->CandidatoBase->select_forms(
                    'gen01agencias',
                    'COD_AGENCIA',
                    'TEX_NOMAGE',
                    null, null, null,
                    'TEX_NOMAGE'
                )
            ));
    }

   
    // Duplicar pregunta con sus candidatos
    public function duplicar(){
        $post = $this->input->post();
        
        if(empty($post['id_pregunta_original']) || empty($post['nueva_pregunta'])) {
            $this->session->set_flashdata('error', 'Datos incompletos para duplicar la pregunta.');
            redirect('pyr/index');
        }
        
        $idOriginal = $post['id_pregunta_original'];
        $nuevaPregunta = trim($post['nueva_pregunta']);
        $activar = isset($post['duplicar_activa']) ? 1 : 0;
        
        // Obtener la pregunta original
        $preguntaOriginal = $this->pyrInstancia->obtener($idOriginal);
        if(!$preguntaOriginal) {
            $this->session->set_flashdata('error', 'La pregunta original no existe.');
            redirect('pyr/index');
        }
        
        // Obtener el siguiente orden disponible
        $maxOrden = $this->pyrInstancia->getMaxOrden();
        
        // Crear la nueva pregunta (duplicado)
        $fechaActual = date('Y-m-d H:i:s');
        $nuevaInstanciaData = [
            'TEX_NOMINS'   => $nuevaPregunta,
            'NUM_MUSEIN'   => $preguntaOriginal->NUM_MUSEIN,
            'NUM_ORDEN'    => $maxOrden + 1,
            'NUM_TOTELE'   => $preguntaOriginal->NUM_TOTELE,
            'NUM_DECRES'   => $preguntaOriginal->NUM_DECRES,
            'FEC_INIUSO'   => $preguntaOriginal->FEC_INIUSO,
            'FEC_FINUSO'   => $preguntaOriginal->FEC_FINUSO,
            'BOL_ACTIVO'   => $activar,
            'BOL_VOTBLA'   => $preguntaOriginal->BOL_VOTBLA,
            'BOL_OBLMUL'   => $preguntaOriginal->BOL_OBLMUL,
            'FEC_CREACION' => $fechaActual
        ];
        
        $nuevaInstanciaId = $this->pyrInstancia->guardar($nuevaInstanciaData);
        
        if($nuevaInstanciaId) {
            // Obtener los candidatos de la pregunta original
            $candidatosOriginales = $this->Candidato->listarPorInstancia($idOriginal);
            
            // Duplicar cada candidato
            foreach($candidatosOriginales as $candidato) {
                $nuevoCandidatoData = [
                    'ID_INSTAN'  => $nuevaInstanciaId,
                    'TEX_NOMCAN' => $candidato->TEX_NOMCAN,
                    'TEX_APECAN' => $candidato->TEX_APECAN,
                    'NUM_ORDEN'  => $candidato->NUM_ORDEN,
                    'TEX_FOTO'   => $candidato->TEX_FOTO, // Mantiene la misma foto
                    'COD_CIUDAD' => $candidato->COD_CIUDAD,
                    'COD_AGENCIA'=> $candidato->COD_AGENCIA,
                    'BOL_ACTIVO' => 1,
                    'IS_DELETE'  => 0
                ];
                $this->Candidato->guardar($nuevoCandidatoData);
            }
            
            $mensaje = "Pregunta duplicada exitosamente. Se creó '{$nuevaPregunta}' con " . count($candidatosOriginales) . " opciones de respuesta.";
            $this->session->set_flashdata('success', $mensaje);
            
            // Redirigir al formulario de la nueva pregunta para editarla si es necesario
            redirect('pyr/form/' . $nuevaInstanciaId);
        } else {
            $this->session->set_flashdata('error', 'Error al duplicar la pregunta.');
            redirect('pyr/index');
        }
    }

}
