<?php defined('BASEPATH') or exit('No direct script access allowed');

class Pyr_candidato_model extends CI_Model {
    protected $table = 'evi04candidat_mr'; 

   

  public function listarPorInstancia($idInstancia){
    return $this->db
        ->select('c.ID_CANDID, c.TEX_NOMCAN, c.TEX_APECAN, c.NUM_ORDEN, c.TEX_FOTO, c.ID_INSTAN,
                  c.COD_CIUDAD, ciu.TEX_NOMCIU, c.COD_AGENCIA, age.TEX_NOMAGE,c.BOL_ACTIVO,c.TEX_PERCAN')
        ->from('evi04candidat_mr c')
        ->join('gen04ciudad ciu','ciu.COD_CIUDAD = c.COD_CIUDAD','left')
        ->join('gen01agencias age','age.COD_AGENCIA = c.COD_AGENCIA','left')
        ->where('c.ID_INSTAN', $idInstancia)
        ->where('c.IS_DELETE', 0)
        ->order_by('c.NUM_ORDEN', 'ASC')
        ->get()
        ->result();

}

public function listarCandidatosPredefinidos() {
    return $this->db
        ->select('c.ID_CANDID, c.TEX_NOMCAN, c.TEX_APECAN, c.NUM_ORDEN, c.TEX_FOTO, 
                  c.COD_CIUDAD, ciu.TEX_NOMCIU, c.COD_AGENCIA, age.TEX_NOMAGE,c.TEX_PERCAN')
        ->from('evi04candidat_mr c')
        ->join('gen04ciudad ciu','ciu.COD_CIUDAD = c.COD_CIUDAD','left')
        ->join('gen01agencias age','age.COD_AGENCIA = c.COD_AGENCIA','left')
        ->where('c.ID_INSTAN', 0)
        ->where('c.IS_DELETE', 0)
        ->order_by('c.NUM_ORDEN', 'ASC')
        ->get()
        ->result();
}

public function contarPorInstancia($idInstancia) {
    return $this->db->where('ID_INSTAN', $idInstancia)
                    ->where('(IS_DELETE = 0 OR IS_DELETE IS NULL)', null, false)
                    ->count_all_results('evi04candidat_mr');
}


public function guardar($data){
    $this->db->insert('evi04candidat_mr',$data);
}

public function actualizar($idCandidato, $data) {
    if (!$idCandidato || empty($data)) {
        return false;
    }

    $this->db->where('ID_CANDID', $idCandidato);
    return $this->db->update('evi04candidat_mr', $data);
}


public function eliminarPorInstancia($idInstancia){
    $this->db->where('ID_INSTAN',$idInstancia)->delete('evi04candidat_mr');
}

public function eliminarPorId($idCandidato){
    
  
    return $this->db
        ->where('ID_CANDID', $idCandidato)
        ->update('evi04candidat_mr', ['IS_DELETE' => 1]);
}


    public function guardarBatch($idInstancia, $opciones){
        $orden = 1;
        foreach($opciones as $op){
            $this->db->insert($this->table,[
                'ID_INSTAN'    => $idInstancia,
                'NUM_ORDEN'    => $orden++,
                'TEX_NOMCAN'   => $op['nombre'],
                'TEX_APECAN'   => isset($op['apellido']) ? $op['apellido'] : '',
                'TEX_FOTO'     => 'uploads/candidatos/SinFoto.jpg',
                'TEX_PERCAN'   => isset($op['perfil']) ? $op['perfil'] : '',
                'BOL_BLANCO'   => 0,
                'COD_CREAUSU'  => $this->session->userdata('COD_USUARIO'),
                'FEC_CREACION' => date('Y-m-d H:i:s'),
                'TEX_CREANOTA' => $this->input->ip_address(),
                'BOL_ACTIVO'   => 1,
                'IS_DELETE'    => 0
            ]);
        }
    }

     // ================= MÉTODO PARA CAMBIAR ESTADO DE CANDIDATO =================
   
    public function cambiarEstado($idCandidato, $estado)
{
    return $this->db
        ->where('ID_CANDID', $idCandidato)
        ->update('evi04candidat_mr', ['BOL_ACTIVO' => (int)$estado]);
}

   public function obtenerPorId($idCandidato) {
    
        return $this->db
            ->where('ID_CANDID', $idCandidato)
            ->get($this->table)
            ->row();
    }
}
