<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $this->load->view('template/head.php'); ?>
<?php $this->load->view('template/header_admin.php'); ?>

<section class="row contenedor-titulo">
    <div class="col-xs-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <i class="fa fa-question-circle"></i> Gestión de Preguntas
                    <span class="badge pull-right" style="background-color: #337ab7;">
                        <?= !empty($instancias) ? count($instancias) : 0 ?> preguntas
                    </span>
                </h3>
            </div>
        </div>
    </div>
</section>

<section class="row contenedor" style="margin-top: 15px;">
    <div class="col-xs-12">
        <!-- Panel de acciones -->
        <div class="panel panel-primary">
            <div class="panel-heading">
                <h4 class="panel-title"><i class="fa fa-cogs"></i> Acciones</h4>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-6">
                        <a href="<?= base_url('pyr/form') ?>" class="btn btn-success btn-lg" style="width: 100%; margin-bottom: 10px;">
                            <i class="fa fa-plus"></i> Crear Nueva Pregunta
                        </a>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" id="buscar-pregunta" class="form-control" placeholder="Buscar pregunta..." style="border-radius: 6px 0 0 6px;">
                            <span class="input-group-btn">
                                <button type="button" id="limpiar-busqueda" class="btn btn-default" style="border-radius: 0 6px 6px 0;">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Panel de tabla -->
        <div class="panel panel-info">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <i class="fa fa-list"></i> Lista de Preguntas Existentes
                    <small class="pull-right">
                        <span id="contador-resultados">
                            <?= !empty($instancias) ? count($instancias) : 0 ?> resultados
                        </span>
                    </small>
                </h4>
            </div>
            <div class="panel-body" style="padding: 0;">
                <div class="table-responsive" style="max-height: 500px; overflow-y: auto; border: 1px solid #ddd;">
                    <table class="table table-bordered table-striped table-hover" style="margin-bottom: 0;">
                        <thead style="background-color: #f8f9fa; border-bottom: 2px solid #dee2e6;">
                            <tr>
                                <th style="padding: 12px; font-weight: 600; color: #495057; text-align: center; width: 80px;">
                                    <i class="fa fa-hashtag"></i> ID
                                </th>
                                <th style="padding: 12px; font-weight: 600; color: #495057;">
                                    <i class="fa fa-question-circle"></i> Pregunta
                                </th>
                                <th style="padding: 12px; font-weight: 600; color: #495057; text-align: center; width: 120px;">
                                    <i class="fa fa-users"></i> Candidatos
                                </th>
                                <th style="padding: 12px; font-weight: 600; color: #495057; text-align: center; width: 100px;">
                                    <i class="fa fa-sort-numeric-asc"></i> Orden
                                </th>
                                <th style="padding: 12px; font-weight: 600; color: #495057; text-align: center; width: 120px;">
                                    <i class="fa fa-toggle-on"></i> Estado
                                </th>
                                <th style="padding: 12px; font-weight: 600; color: #495057; text-align: center; width: 280px;">
                                    <i class="fa fa-cogs"></i> Acciones
                                </th>
                            </tr>
                        </thead>
                        <tbody id="tabla-preguntas">
                            <?php if (!empty($instancias)): ?>
                                <?php foreach ($instancias as $i): ?>
                                    <tr class="fila-pregunta" data-pregunta="<?= strtolower($i->TEX_NOMINS) ?>" style="vertical-align: middle;">
                                        <td style="padding: 12px; text-align: center; font-weight: bold; color: #6c757d;">
                                            <?= $i->ID_INSTAN ?>
                                        </td>
                                        <td style="padding: 12px;">
                                            <div style="font-weight: 500; color: #495057; margin-bottom: 4px;">
                                                <?= $i->TEX_NOMINS ?>
                                            </div>
                                            <small class="text-muted">
                                                <i class="fa fa-calendar"></i>
                                                Creada: <?= date('d/m/Y', strtotime($i->FEC_INIUSO ?? 'now')) ?>
                                            </small>
                                        </td>
                                        <td style="padding: 12px; text-align: center;">
                                            <span class="badge" style="background-color: #6f42c1; font-size: 14px; padding: 6px 10px;">
                                                <?= $i->total_candidatos ?>
                                            </span>
                                        </td>

                                        <td style="padding: 12px; text-align: center;">
                                            <span class="badge" style="background-color: #17a2b8; font-size: 14px; padding: 6px 10px;">
                                                <?= $i->NUM_ORDEN ?>
                                            </span>
                                        </td>
                                        <td style="padding: 12px; text-align: center;">
                                            <?php if ($i->BOL_ACTIVO == 1): ?>
                                                <span class="label label-success" style="font-size: 12px; padding: 6px 12px; border-radius: 12px;">
                                                    <i class="fa fa-check-circle"></i> Activo
                                                </span>
                                            <?php else: ?>
                                                <span class="label label-danger" style="font-size: 12px; padding: 6px 12px; border-radius: 12px;">
                                                    <i class="fa fa-times-circle"></i> Desactivado
                                                </span>
                                            <?php endif; ?>
                                        </td>

                                        <td style="padding: 8px; text-align: center;">
                                            <!-- Botones para móvil -->
                                            <div class="visible-xs">
                                                <div class="btn-group-vertical" style="width: 100%;">
                                                    <a href="<?= base_url('pyr/form/' . $i->ID_INSTAN) ?>" class="btn btn-info btn-xs" style="margin-bottom: 2px; border-radius: 4px; min-height: 28px;">
                                                        <i class="fa fa-edit"></i> Editar
                                                    </a>
                                                    <button type="button" class="btn btn-primary btn-xs btn-duplicar" data-id="<?= $i->ID_INSTAN ?>" data-nombre="<?= $i->TEX_NOMINS ?>" style="margin-bottom: 2px; border-radius: 4px; min-height: 28px;">
                                                        <i class="fa fa-copy"></i> Duplicar
                                                    </button>
                                                    <button type="button" class="btn btn-default btn-xs " data-id="<?= $i->ID_INSTAN ?>" data-nombre="<?= $i->TEX_NOMINS ?>" style="margin-bottom: 2px; border-radius: 4px; min-height: 28px;">
                                                        <i class="fa-file-o"></i> Previa Tarjetón
                                                    </button>
                                                    <?php if ($i->BOL_ACTIVO == 1): ?>
                                                        <a href="<?= base_url('pyr/cambiar_estado/' . $i->ID_INSTAN . '/0') ?>" class="btn btn-warning btn-xs" style="margin-bottom: 2px; border-radius: 4px; min-height: 28px;">
                                                            <i class="fa fa-pause"></i> Desactivar
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="<?= base_url('pyr/cambiar_estado/' . $i->ID_INSTAN . '/1') ?>" class="btn btn-success btn-xs" style="margin-bottom: 2px; border-radius: 4px; min-height: 28px;">
                                                            <i class="fa fa-play"></i> Activar
                                                        </a>
                                                    <?php endif; ?>
                                                    <button type="button" class="btn btn-danger btn-xs eliminar-pregunta" data-id="<?= $i->ID_INSTAN ?>" data-nombre="<?= $i->TEX_NOMINS ?>" style="border-radius: 4px; min-height: 28px;">
                                                        <i class="fa fa-trash"></i> Eliminar
                                                    </button>
                                                </div>
                                            </div>

                                           
                                            <!-- Botones para escritorio -->
                                            <div class="hidden-xs">
                                                <div class="btn-group btn-group-sm acciones" role="group">
                                                    <a href="<?= base_url('pyr/form/' . $i->ID_INSTAN) ?>"
                                                        class="btn btn-info" title="Editar">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                    <button type="button"
                                                        class="btn btn-primary btn-duplicar"
                                                        data-id="<?= $i->ID_INSTAN ?>"
                                                        data-nombre="<?= $i->TEX_NOMINS ?>"
                                                        title="Duplicar">
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <button type="button"
                                                        class="btn btn-default btn-privar-tarjeton"
                                                        data-id="<?= $i->ID_INSTAN ?>"
                                                        data-nombre="<?= $i->TEX_NOMINS ?>"
                                                        title="Previa Tarjetón">
                                                        <i class="fa-file-o"></i>
                                                    </button>
                                                    <?php if ($i->BOL_ACTIVO == 1): ?>
                                                        <a href="<?= base_url('pyr/cambiar_estado/' . $i->ID_INSTAN . '/0') ?>"
                                                            class="btn btn-warning" title="Desactivar">
                                                            <i class="fa fa-pause"></i>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="<?= base_url('pyr/cambiar_estado/' . $i->ID_INSTAN . '/1') ?>"
                                                            class="btn btn-success" title="Activar">
                                                            <i class="fa fa-play"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                    <button type="button"
                                                        class="btn btn-danger eliminar-pregunta"
                                                        data-id="<?= $i->ID_INSTAN ?>"
                                                        data-nombre="<?= $i->TEX_NOMINS ?>"
                                                        title="Eliminar">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr id="sin-resultados">
                                    <td colspan="5" class="text-center" style="padding: 40px; color: #6c757d;">
                                        <div style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;">
                                            <i class="fa fa-question-circle"></i>
                                        </div>
                                        <h4 style="margin-bottom: 10px;">No hay preguntas registradas</h4>
                                        <p style="margin-bottom: 20px;">Comienza creando tu primera pregunta</p>
                                        <a href="<?= base_url('pyr/form') ?>" class="btn btn-primary">
                                            <i class="fa fa-plus"></i> Crear Primera Pregunta
                                        </a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Panel de estadísticas -->
        <?php if (!empty($instancias)): ?>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="row text-center">
                        <div class="col-md-3 col-sm-6">
                            <div style="padding: 15px; border-right: 1px solid #eee;">
                                <h3 style="margin: 0; color: #28a745;">
                                    <?= count(array_filter($instancias, function ($i) {
                                        return $i->BOL_ACTIVO == 1;
                                    })) ?>
                                </h3>
                                <small class="text-muted">Preguntas Activas</small>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div style="padding: 15px; border-right: 1px solid #eee;">
                                <h3 style="margin: 0; color: #dc3545;">
                                    <?= count(array_filter($instancias, function ($i) {
                                        return $i->BOL_ACTIVO == 0;
                                    })) ?>
                                </h3>
                                <small class="text-muted">Preguntas Inactivas</small>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div style="padding: 15px; border-right: 1px solid #eee;">
                                <h3 style="margin: 0; color: #17a2b8;">
                                    <?= count($instancias) ?>
                                </h3>
                                <small class="text-muted">Total Preguntas</small>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div style="padding: 15px;">
                                <h3 style="margin: 0; color: #6c757d;">
                                    <?= !empty($instancias) ? max(array_column($instancias, 'NUM_ORDEN')) : 0 ?>
                                </h3>
                                <small class="text-muted">Último Orden</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- Modal para duplicar pregunta -->
<div class="modal fade" id="modalDuplicar" tabindex="-1" role="dialog" aria-labelledby="modalDuplicarLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #007bff; color: white;">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white; opacity: 0.8;">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="modalDuplicarLabel">
                    <i class="fa fa-copy"></i> Duplicar Pregunta
                </h4>
            </div>
            <form id="formDuplicar" method="post" action="<?= base_url('pyr/duplicar') ?>">
                <div class="modal-body">
                    <input type="hidden" id="id_pregunta_original" name="id_pregunta_original" value="">

                    <div class="alert alert-info" style="margin-bottom: 20px;">
                        <i class="fa fa-info-circle"></i>
                        <strong>Pregunta original:</strong> <span id="pregunta_original_texto"></span>
                    </div>

                    <div class="form-group">
                        <label for="nueva_pregunta" class="control-label">
                            <i class="fa fa-question-circle"></i> Nombre de la nueva pregunta:
                        </label>
                        <input type="text" class="form-control" id="nueva_pregunta" name="nueva_pregunta"
                            placeholder="Ingrese el nombre de la nueva pregunta..."
                            required minlength="5" maxlength="255"
                            style="border-radius: 6px; padding: 10px;">
                        <small class="help-block text-muted">Mínimo 5 caracteres, máximo 255</small>
                    </div>

                    <div class="alert alert-warning" style="margin-top: 15px;">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Nota:</strong> Se duplicarán todas las opciones de respuesta asociadas a esta pregunta.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal" style="border-radius: 6px;">
                        <i class="fa fa-times"></i> Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary" id="btnConfirmarDuplicar" style="border-radius: 6px;">
                        <i class="fa fa-copy"></i> <span class="btn-text">Duplicar Pregunta</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    /* Mejoras generales */
    .panel {
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        border: none;
        border-radius: 8px;
    }

    .panel-heading {
        border-radius: 8px 8px 0 0 !important;
    }

    .table-hover tbody tr:hover {
        background-color: #f8f9fa;
        transition: background-color 0.2s ease;
    }

    .btn {
        transition: all 0.2s ease;
    }

    .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }

    .badge {
        transition: all 0.2s ease;
    }

    .label {
        transition: all 0.2s ease;
    }

    /* Estilos para botones uniformes */
    .btn-group {
        display: flex !important;
        justify-content: center !important;
        align-items: center !important;
    }
    
    .btn-group .btn {
        margin: 0 !important;
        border-radius: 0 !important;
    }
    
    .btn-group .btn:first-child {
        border-radius: 4px 0 0 4px !important;
    }
    
    .btn-group .btn:last-child {
        border-radius: 0 4px 4px 0 !important;
    }
    
    .btn-group .btn:only-child {
        border-radius: 4px !important;
    }

    .btn-group-vertical .btn {
        text-align: left;
        display: flex;
        align-items: center;
        justify-content: flex-start;
    }

    .btn-group-vertical .btn i {
        margin-right: 6px;
        width: 14px;
        text-align: center;
    }

    /* Mejoras para responsive */
    @media (max-width: 767px) {

        .table th,
        .table td {
            padding: 8px 5px;
            font-size: 12px;
        }

        .btn-xs {
            font-size: 11px;
            padding: 4px 8px;
        }

        .label {
            font-size: 10px;
            padding: 4px 8px;
        }

        .badge {
            font-size: 11px;
            padding: 4px 8px;
        }

        .panel-title {
            font-size: 14px;
        }

        .btn-group-vertical .btn {
            font-size: 11px;
            padding: 4px 8px;
        }
    }

    @media (max-width: 480px) {

        .table th,
        .table td {
            padding: 6px 3px;
            font-size: 11px;
        }

        .contenedor {
            padding: 0 10px;
        }

        .panel-body {
            padding: 10px;
        }
    }

    /* Animaciones */
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .fila-pregunta {
        animation: fadeIn 0.3s ease;
    }

    /* Estilos para el buscador */
    #buscar-pregunta {
        border: 2px solid #e9ecef;
        transition: border-color 0.2s ease;
    }

    #buscar-pregunta:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
    }

    /* Mensaje sin resultados */
    .sin-resultados-busqueda {
        background-color: #fff3cd;
        border: 1px solid #ffeaa7;
        color: #856404;
    }

    /* Estilos para el modal */
    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }

    .modal-header {
        border-radius: 8px 8px 0 0;
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        border-radius: 0 0 8px 8px;
    }

    .form-control:focus {
        border-color: #007bff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
    }

    /* Animación de carga para el botón */
    .btn-loading {
        position: relative;
        color: transparent !important;
    }

    .btn-loading::after {
        content: "";
        position: absolute;
        width: 16px;
        height: 16px;
        top: 50%;
        left: 50%;
        margin-left: -8px;
        margin-top: -8px;
        border: 2px solid #ffffff;
        border-radius: 50%;
        border-top-color: transparent;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        to {
            transform: rotate(360deg);
        }
    }
</style>

<script>
    // Confirmación para eliminar pregunta
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('eliminar-pregunta') || e.target.closest('.eliminar-pregunta')) {
            e.preventDefault();

            var btn = e.target.classList.contains('eliminar-pregunta') ? e.target : e.target.closest('.eliminar-pregunta');
            var id = btn.getAttribute('data-id');
            var nombre = btn.getAttribute('data-nombre');

            if (confirm('¿Está seguro de que desea eliminar la pregunta "' + nombre + '"?\n\nEsta acción no se puede deshacer.')) {
                window.location.href = '<?= base_url('pyr/eliminar/') ?>' + id;
            }
        }
    });

    // Funcionalidad del botón Privar Tarjetón
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-privar-tarjeton') || e.target.closest('.btn-privar-tarjeton')) {
            e.preventDefault();

            var btn = e.target.classList.contains('btn-privar-tarjeton') ? e.target : e.target.closest('.btn-privar-tarjeton');
            var id = btn.getAttribute('data-id');
            var nombre = btn.getAttribute('data-nombre');

            
                // Aquí puedes agregar la URL a la que debe redirigir o la acción a realizar
                window.location.href = '<?= base_url('instancias/preview_tarjeton/') ?>' + id;
            
        }
    });

    // Funcionalidad de búsqueda
    document.getElementById('buscar-pregunta')?.addEventListener('input', function() {
        var busqueda = this.value.toLowerCase();
        var filas = document.querySelectorAll('.fila-pregunta');
        var contador = 0;

        filas.forEach(function(fila) {
            var textoPregunta = fila.dataset.pregunta;
            if (textoPregunta.includes(busqueda)) {
                fila.style.display = '';
                contador++;
            } else {
                fila.style.display = 'none';
            }
        });

        // Actualizar contador
        document.getElementById('contador-resultados').textContent = contador + ' resultados';

        // Mostrar mensaje si no hay resultados
        var sinResultados = document.getElementById('sin-resultados-busqueda');
        if (contador === 0 && busqueda !== '') {
            if (!sinResultados) {
                var tbody = document.getElementById('tabla-preguntas');
                var tr = document.createElement('tr');
                tr.id = 'sin-resultados-busqueda';
                tr.className = 'sin-resultados-busqueda';
                tr.innerHTML = `
                <td colspan="5" class="text-center" style="padding: 30px;">
                    <div style="font-size: 36px; margin-bottom: 10px; opacity: 0.5;">
                        <i class="fa fa-search"></i>
                    </div>
                    <h4>No se encontraron resultados</h4>
                    <p>No hay preguntas que coincidan con "${busqueda}"</p>
                </td>
            `;
                tbody.appendChild(tr);
            }
        } else if (sinResultados) {
            sinResultados.remove();
        }
    });

    // Limpiar búsqueda
    document.getElementById('limpiar-busqueda')?.addEventListener('click', function() {
        document.getElementById('buscar-pregunta').value = '';
        var filas = document.querySelectorAll('.fila-pregunta');
        filas.forEach(function(fila) {
            fila.style.display = '';
        });

        // Actualizar contador
        document.getElementById('contador-resultados').textContent = filas.length + ' resultados';

        // Remover mensaje de sin resultados si existe
        var sinResultados = document.getElementById('sin-resultados-busqueda');
        if (sinResultados) {
            sinResultados.remove();
        }
    });

    // Funcionalidad para duplicar pregunta
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('btn-duplicar') || e.target.closest('.btn-duplicar')) {
            e.preventDefault();

            var btn = e.target.classList.contains('btn-duplicar') ? e.target : e.target.closest('.btn-duplicar');
            var id = btn.getAttribute('data-id');
            var nombre = btn.getAttribute('data-nombre');

            // Llenar el modal con los datos
           // Llenar el modal con los datos (seguro)
var modal = document.getElementById('modalDuplicar');
if (!modal) return; // si no existe, no hacemos nada

var inId   = modal.querySelector('#id_pregunta_original');
if (inId) inId.value = id;

var span   = modal.querySelector('#pregunta_original_texto');
if (span) span.textContent = nombre || '';

var inNew  = modal.querySelector('#nueva_pregunta');
if (inNew) inNew.value = '';

            // Mostrar el modal
            // Mostrar el modal
if (typeof $ !== 'undefined') {
    // limpia posibles restos de una apertura anterior
    $('.modal-backdrop').remove();
    $('body').removeClass('modal-open');

    $('#modalDuplicar').modal('show');
} else {
    // Fallback sin jQuery
    var modal = document.getElementById('modalDuplicar');
    if (modal) {
        modal.style.display = 'block';
        modal.classList.add('in');
        document.body.classList.add('modal-open');
    }
}

            // Enfocar el campo de texto después de que se muestre el modal
            setTimeout(function() {
                var input = document.getElementById('nueva_pregunta');
                if (input) {
                    input.focus();
                }
            }, 500);
        }
    });

    // Validación del formulario de duplicar
    document.getElementById('formDuplicar')?.addEventListener('submit', function(e) {
        var nuevaPregunta = document.getElementById('nueva_pregunta').value.trim();

        if (nuevaPregunta.length < 5) {
            e.preventDefault();
            alert('El nombre de la nueva pregunta debe tener al menos 5 caracteres.');
            document.getElementById('nueva_pregunta').focus();
            return false;
        }

        if (nuevaPregunta.length > 255) {
            e.preventDefault();
            alert('El nombre de la nueva pregunta no puede exceder 255 caracteres.');
            document.getElementById('nueva_pregunta').focus();
            return false;
        }

        // Mostrar indicador de carga
        var btn = document.getElementById('btnConfirmarDuplicar');
        var btnText = btn.querySelector('.btn-text');

        btn.disabled = true;
        btn.classList.add('btn-loading');
        btnText.textContent = 'Duplicando...';

        // El formulario se enviará normalmente
        return true;
    });

    // Validación en tiempo real del campo de texto
    document.getElementById('nueva_pregunta')?.addEventListener('input', function() {
        var valor = this.value.trim();
        var btn = document.getElementById('btnConfirmarDuplicar');

        if (valor.length >= 5 && valor.length <= 255) {
            btn.disabled = false;
            this.style.borderColor = '#28a745';
        } else {
            btn.disabled = true;
            this.style.borderColor = '#dc3545';
        }
    });

    // Limpiar el modal cuando se cierre
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('close') || e.target.getAttribute('data-dismiss') === 'modal') {
            var modal = document.getElementById('modalDuplicar');
            if (modal) {
                modal.style.display = 'none';
                // Limpiar overlay si quedó alguno
var bd = document.querySelector('.modal-backdrop');
if (bd && bd.parentNode) bd.parentNode.removeChild(bd);
document.body.classList.remove('modal-open');

               
                
                // Limpiar el formulario
                document.getElementById('nueva_pregunta').style.borderColor = '';
                var btn = document.getElementById('btnConfirmarDuplicar');
                var btnText = btn.querySelector('.btn-text');

                btn.disabled = false;
                btn.classList.remove('btn-loading');
                btnText.textContent = 'Duplicar Pregunta';
            }
        }
    });

    // Función alternativa para cerrar modal (mantener la original por si jQuery está disponible)
    if (typeof $ !== 'undefined') {
        $('#modalDuplicar').on('hidden.bs.modal', function() {
        document.getElementById('nueva_pregunta').style.borderColor = '';
        var btn = document.getElementById('btnConfirmarDuplicar');
        var btnText = btn.querySelector('.btn-text');

        btn.disabled = false;
        btn.classList.remove('btn-loading');
        btnText.textContent = 'Duplicar Pregunta';
        });
    }

    // Efectos hover mejorados
    document.addEventListener('DOMContentLoaded', function() {
        // Agregar efectos de hover a los botones
        var botones = document.querySelectorAll('.btn');
        botones.forEach(function(btn) {
            btn.addEventListener('mouseenter', function() {
                if (!this.disabled) {
                    this.style.transform = 'translateY(-1px)';
                }
            });

            btn.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0)';
            });
        });
    });
</script>

<?php $this->load->view('template/footer.php'); ?>
