<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
* EVIR V 2.0
*
* An application development for PHP
*
* This content is released under the End User License Agreement (EULA)
*
* Copyright (c) 2008 - 2016, Cyberia Tech SAS.
*
* THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER, 
* AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, 
* DO NOT DOWNLOAD OR USE THIS SOFTWARE.
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* LICENSE
* The software is licensed for exclusive and non-transferable use. 
* A licensed copy of the software may be used for an unlimited amount 
* of time without any monthly fees. For each installed instance of the software,
* a separate license is required unless the multi-user licenses bundle
* deal has been purchased, thus the a simple copy of the software can be
* installed up to multiple different machines depending on the license type.
*
* @package	Evir 2.
* @author Jaime P. Bravo <http://www.jaimebravo.co> <http://www.githib.com/fire_flex>
* @copyright	Copyright (c) 2008 - 2016, Cyberia Tech SAS.(http://cyberiatech.com.co/)
* @license	http://opensource.org/licenses/MIT	EULA
* @link	http://cyberiatech.com.co/evir
* @since	Version 2.0.0
* @filesource
*/
class Registros extends MX_Controller
{
    
    public $path_js;
    public $message;
    
    public function __construct()
    {
        
        parent::__construct();
        if (!$this->session->userdata('COD_PERFIL')) {
            $this->redirect_no_login();
        }
        
        $this->load->model(['participantes/Participante','ingresos_salidas/Ingresos_salida',
        'registros/Registro', 'acceso/Access']);
        $this->load->helper('security');
        $this->path_js        = 'registros/scripts_dev.js';
        $this->graficos_js        = 'informes/graficos.js';
    }
    
    //--------------------------------------------------------------------------------------------------------------------------------
    /**
    *  Carga de los datos de votación. 
    * 
    * @param type $instancia_numero
    * @return boolean
    */
    public function index()
    {
        if (!$this->input->post()) {
            $data_view['titulo']  = 'Registro de Participantes';
            $data_view['load_js'] = $this->path_js;
            $this->load->view('index', $data_view);
        }
        else {
            $this->form_validation->set_rules('NUM_IDETER', 'Identificación', 'required|integer');
            if ($this->form_validation->run() == FALSE) {
                $this->message = ['type' => 'error', 'message' => validation_errors()];
            }
            else {
                
                $participante = $this->Participante->get_participante(ltrim($this->input->post('NUM_IDETER'), '0'));
                
                //Si no existe el participante.
                if (!$participante) {
                    $this->message = ['type' => 'error', 'message' => 'El participante no esta registrado en la base de datos o pertenece a otra agencia.'];
                    echo json_encode($this->message);
                    return false;
                    
                }
                //Si ya se ha registrado.
                if ($participante->FEC_REGIST) {
                    $this->message = ['type' => 'error', 'message' => '<div class="text-danger">El participante ya se ha registrado.<br> Fecha de registro: ' . $participante->FEC_REGIST . '</div>'];
                }
                else {
                    $data = ['FEC_REGIST' => $this->get_fecha_hora_hoy()];
                    $this->db->trans_start();
                    if ($this->Participante->edit(xss_clean($this->input->post('NUM_IDETER')), $data)) {
                        //Registro de ingreso.
                        $data_registro = ['NUM_IDETER'   => xss_clean(ltrim($this->input->post('NUM_IDETER'), '0')),
                        'FEC_INGSAL'   => $this->get_fecha_hora_hoy(),
                        'COD_CREAUSU'  => $this->session->userdata('COD_USUARIO'),
                        'TEX_CREANOTA' => $this->input->ip_address()
                    ];
                    //Crea registro en la tabla de ingresos.
                    $this->Ingresos_salida->insert($data_registro);
                    
                    $this->message = ['type'    => 'success',
                    'message' => $participante->TEX_NOMPAR . ' ' . $participante->TEX_APEPAR . '. Cédula: ' . ltrim($this->input->post('NUM_IDETER'), '0').'<br> AGENCIA: '. $participante->TEX_NOMAGE];
                }
                $this->db->trans_complete();
            }
        }
        echo json_encode($this->message);
    }
}


public function cuorum()
{
    //Participantes
    $total_participantes = $this->db->query("SELECT COUNT(NUM_IDETER) as participantes, SUM(p.NUM_PESO) AS peso_participantes
    FROM `evi05partic` `p`")
    ->row();

    $empresa =  $this->Access->get_nom_empresa();
    $data_view['titulo']  = 'CUORUM';
    $data_view['nombre_empresa'] = $empresa->TEX_NOMEMP.' - '. $empresa->COD_NIT;
    $data_view['total_participantes'] = $total_participantes;
    $data_view['load_js'] = $this->path_js;
    $data_view['graficos_js'] = $this->graficos_js;
    $this->load->view('cuorum', $data_view);
}


public function grafico()
{
    $data_view['datos'] = $this->get_graficos_cuorum();
    $this->load->view('grafico', $data_view);
}

public function get_graficos_cuorum()
{
    //Participantes
    $total_participantes = $this->db->query("SELECT COUNT(NUM_IDETER) as participantes, SUM(p.NUM_PESO) AS peso_participantes
    FROM `evi05partic` `p`
    WHERE NUM_IDETER NOT IN (select NUM_IDETER from evi09ingre)")
    ->row();
        
    
    //Registrados.
    $total_registrados = $this->db->query("SELECT COUNT(NUM_IDETER) as registrados, SUM(p.NUM_PESO) AS peso_registrados
    FROM `evi05partic` `p`
    WHERE NUM_IDETER IN (select NUM_IDETER from evi09ingre)")
    ->row();
    
    
    // Personas registradas fuera del auditorio
    $total_registrados_fuera_auditorio =  $this->db->select("COUNT(NUM_IDETER) as total_registrados_fuera_auditorio, NUM_IDETER")
    ->from('evi09ingre')
    ->group_by("NUM_IDETER")
    ->having('total_registrados_fuera_auditorio %2=', 0, false)
    ->get()
    ->result();
    
    
    $total_peso_registrados_fuera_auditorio = 0;
    foreach ($total_registrados_fuera_auditorio as $key => $registrados_fuera_auditorio) {
        $participante_id =  $registrados_fuera_auditorio->NUM_IDETER;
        $peso_obj = $this->get_peso_participantes($participante_id);
        if(isset($peso_obj)){
            $total_peso_registrados_fuera_auditorio += $peso_obj->NUM_PESO;
        }
    }    
    
    $total_registrados_fuera_auditorio = count($total_registrados_fuera_auditorio);
    
    $total_registrados_en_auditorio =  $this->db->select("COUNT(NUM_IDETER) as total_registrados_en_auditorio, NUM_IDETER")
    ->from('evi09ingre')
    ->group_by("NUM_IDETER")
    ->having('total_registrados_en_auditorio %2=', 1, false)
    ->get()
    ->result();
    
    
    $total_peso_registrados_en_auditorio = 0;
    foreach ($total_registrados_en_auditorio as $key => $registrados_en_auditorio) {
        $participante_id =  $registrados_en_auditorio->NUM_IDETER;
        $peso_obj_auditorio = $this->get_peso_participantes($participante_id);
        if(isset($peso_obj_auditorio)){
            $total_peso_registrados_en_auditorio += $peso_obj_auditorio->NUM_PESO;
        }
    }
    
    $total_registrados_en_auditorio = count($total_registrados_en_auditorio);
    
    
    $arr = [];
    $arr[0] = [
        'y'     => $total_participantes->peso_participantes,
        'label' => 'Sin registrar: '.$total_participantes->peso_participantes.'/'.$total_participantes->participantes
    ];
    
    $arr[1] = [
        'y'     => $total_registrados->peso_registrados,
        'label' => 'Registrados: '.$total_registrados->peso_registrados.'/'.$total_registrados->registrados
    ];
    
    $arr[2] = [
        'y'     => $total_registrados_fuera_auditorio,
        'label' => 'Personas fuera del auditorio: '.$total_peso_registrados_fuera_auditorio.'/'.$total_registrados_fuera_auditorio
    ];
    
    $arr[3] = [
        'y'     => $total_registrados_en_auditorio,
        'label' => 'Personas en auditorio: '.$total_peso_registrados_en_auditorio.'/'.$total_registrados_en_auditorio
    ];
    
    
    return json_encode($arr, JSON_NUMERIC_CHECK);
}


public function get_peso_participantes($participante_id)
{
    return $total_registrados_en_auditorio =  $this->db->select("NUM_PESO")
    ->from('evi05partic')
    ->where("NUM_IDETER", $participante_id)
    ->get()
    ->row();

}
}

