<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/**
* EVIR V 2.0
*
* An application development for PHP
*
* This content is released under the End User License Agreement (EULA)
*
* Copyright (c) 2008 - 2016, Cyberia Tech SAS.
*
* THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER, 
* AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, 
* DO NOT DOWNLOAD OR USE THIS SOFTWARE.
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* LICENSE
* The software is licensed for exclusive and non-transferable use. 
* A licensed copy of the software may be used for an unlimited amount 
* of time without any monthly fees. For each installed instance of the software,
* a separate license is required unless the multi-user licenses bundle
* deal has been purchased, thus the a simple copy of the software can be
* installed up to multiple different machines depending on the license type.
*
* @package	Evir 2.
* @author Jaime P. Bravo <http://www.jaimebravo.co> <http://www.githib.com/fire_flex>
* @copyright	Copyright (c) 2008 - 2020, Cyberia Tech SAS.(http://cyberiatech.com.co/)
* @license	http://opensource.org/licenses/MIT	EULA
* @link	http://cyberiatech.com.co/evir
* @since	Version 2.0.0
* @filesource
*/
class Sorteo extends MX_Controller
{
    
    public $path_js;
    public $message;
    private $_configuracion;
    protected $_permisos;
    
    public function __construct()
    {
        
        parent::__construct();
        $this->load->model(['sorteo/Sorteo_model','participantes/Participante']);
        $this->load->helper('security');
        $this->load->model('configuracion/Config');
        //Config del sistema
        $this->_configuracion = $this->Config->get_row();
        $this->path_js        = 'sorteo/scripts_dev.js';
        $this->_permisos = $this->session->userdata('permisos'); 
        
    }
    
    public function index()
    {
        
        if (!$this->_permisos['registros']['registros_sorteo']['MOSTRAR_FRONT']){
            $this->session->set_flashdata('error', "No tienes permisos para ver esta sección");
            redirect('administrador');
            
        }
        
        //Participantes
        if($this->_configuracion->TEX_MODSORTEO == 'P') {
            
            $data_view['titulo']  =  strtoupper('Sorteo participantes');
            $data_view['participantes']  = $this->Participante->get_participantes_nombre(); 
            //Participantes Registrados
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'R') {
            
            $data_view['titulo']  = strtoupper('Sorteo participantes registrados');
            $data_view['participantes']  = $this->Participante->get_registrados_nombre(); 
            if(count($data_view['participantes']) < 2){
                $this->session->set_flashdata('error', 'No hay suficientes participantes registrados');
                redirect("administrador", 'refresh');
            }
            //Participantes en el auditorio.
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'FA') {
            $data_view['titulo']  =  strtoupper('Sorteo participantes en auditiorio');
            $data_view['participantes']  = $this->Participante->get_participantes_auditorio_nombre(); 
            
            if(count($data_view['participantes']) < 2){
                $this->session->set_flashdata('error', 'No hay suficientes participantes en el auditorio');
                redirect("administrador", 'refresh');
            }
            //Participantes que han Votado
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'PV') {
            $data_view['titulo']  =  strtoupper('Sorteo participantes que han votado');
            $data_view['participantes']  = $this->Participante->get_participantes_votado_nombre(); 
            
            if(count($data_view['participantes']) < 2){
                $this->session->set_flashdata('error', 'No hay suficientes participantes que hayan votado');
                redirect("administrador", 'refresh');
            }            
        } else {
            $data_view['titulo']  =  strtoupper('Sorteo participantes');
            $data_view['participantes']  = $this->Participante->get_participantes_nombre(); 
            
        }
        
        $data_view['load_js'] = $this->path_js;
        $this->load->view('index', $data_view);
    }
    
    public function consulta_posicion()
    {
        
        if (!$this->_permisos['registros']['registros_sorteo']['MOSTRAR_FRONT']){
            $this->session->set_flashdata('error', "No tienes permisos para ver esta sección");
            redirect('administrador');
            
        }
        
        
        if($this->_configuracion->TEX_MODSORTEO == 'P') {
            $total = count($this->Participante->get_participantes_nombre()); 
            //Registrados
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'R') {
            $total  = count($this->Participante->get_registrados_nombre()); 
            //Personas en el auditorio.
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'FA') {
            $total  = count($this->Participante->get_participantes_auditorio_nombre()); 
            
        } elseif ($this->_configuracion->TEX_MODSORTEO == 'PV') {
            $total  = count($this->Participante->get_participantes_votado_nombre()); 
            
        } else {
            $total = count($this->Participante->get_participantes_nombre()); 
        }
        
        $total_ganadores = $this->Sorteo_model->count_all();
        
        if($total_ganadores === $total) {
            echo json_encode(['posicion' => '']);
            return false;
        }
        
        
        $posicion = rand(0, $total-1);
        
        $consulta_posicion = $this->Sorteo_model->get($posicion);
        
        if($consulta_posicion) {
            $posicion = rand(0, $total-1);
            
            $consulta_posicion2 = $this->Sorteo_model->get($posicion);
            if($consulta_posicion2) {
                $posicion = rand(0, $total-1);
                
                $consulta_posicion3 = $this->Sorteo_model->get($posicion);
                if($consulta_posicion3) {
                    $posicion = rand(0, $total-1);
                }
            }
            
        }
        
        $datos_posicion = ['NUM_POSICION' => $posicion];
        $crear_posicion = $this->Sorteo_model->insert($datos_posicion);
        
        if(is_int($crear_posicion)) {
            echo json_encode(['posicion' => $posicion]);
        } else {
            echo json_encode(['posicion' => '']);
        }
        
    }
    
    public function consulta_ganador()
    {
        
        if (!$this->_permisos['registros']['registros_sorteo']['MOSTRAR_FRONT']){
            $this->session->set_flashdata('error', "No tienes permisos para ver esta sección");
            redirect('administrador');
            
        }
        
        if( $this->input->post()){
            $cedula = $this->input->post('id');
            $posicion = $this->input->post('posicion');            
            $data_view['participante']  = $this->Participante->get_participante($cedula);
            //Se actualiza la cedula del participante.
            $datos_actualizar_ganador = ['NUM_IDETER' => $cedula];
            $actualizar_ganador = $this->Sorteo_model->edit($posicion, $datos_actualizar_ganador);
            echo $this->load->view('consulta_ganador', $data_view, true);
        }
    }
    
    
    
}