<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tipo_usuarios extends MX_Controller
{

	public $path_js;
	private $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->_permisos = $this->session->userdata('permisos'); 
		$this->load->model(['Tipo_usuario', 'Tipo_perfil', 'permisos/Permiso', 'usuarios/Usuario']);
		$this->path_js = 'tipo_usuarios/scripts_dev.js';
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado Perfiles';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Tipo_usuario->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $usuario) {
     		$asignar = '';
     		$editar = '';
     		$status = '';
     		$delete = '';
     		$no++;
     		$row    = array();


     		if(isset($this->_permisos['perfiles']['perfiles_asignar'])) {
     			$asignar = "<a href='tipo_usuarios/asignar_permisos/$usuario->COD_PERFIL' class='btn btn-primary'>Asignar Permisos</a>";
     		}

     		if(isset($this->_permisos['perfiles']['perfiles_editar'])) {
     			$editar = "<a href='tipo_usuarios/create/1/$usuario->COD_PERFIL ' class='btn btn-success'>Editar</a>";
     		}

     		if(isset($this->_permisos['perfiles']['perfiles_activar'])) {
     			$status = ($usuario->BOL_ACTIVO) ? "<a href='tipo_usuarios/status/$usuario->COD_PERFIL/$usuario->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='tipo_usuarios/status/$usuario->COD_PERFIL/$usuario->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		if(isset($this->_permisos['perfiles']['perfiles_borrar'])) {
     			$delete = "<a href='tipo_usuarios/delete/$usuario->COD_PERFIL ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}


     		$row[]  = $usuario->COD_PERFIL;
     		$row[]  = $usuario->TEX_NOMTIPO;
     		$row[]  = $usuario->TEXT_TIPOPERFIL;
     		$row[]  = $usuario->TEX_DESCTIPO;
     		$row[]  = ($usuario->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';

     		$row[]  = "$editar $asignar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Tipo_usuario->count_all(),
     		"recordsFiltered" => $this->Tipo_usuario->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear usuario.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_PERFIL');
     		if ($edit) {
     			$this->form_validation->set_rules('TEX_NOMTIPO', 'Nombre del Perfil', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('TEX_NOMTIPO', 'Nombre del Perfil', 'required|is_unique[auth02perfiles.TEX_NOMTIPO]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("tipo_usuarios/create/1/$id");
     			}
     			redirect("tipo_usuarios/create");
     		else:
     			$_post              = $this->security->xss_clean($_POST);
     			$datos_tipo_usuario = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_tipo_usuario['edit']);
     				if ($this->Tipo_usuario->edit($id, $datos_tipo_usuario)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('tipo_usuarios');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("tipo_usuarios/create/1/$id");
     				}
     			}
     			if (is_int($this->Tipo_usuario->insert($datos_tipo_usuario))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('tipo_usuarios');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('tipo_usuarios/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['usuario'] = $this->Tipo_usuario->get($id);
     		}
     		$data_view['titulo']  = 'Crear Perfil';
     		$data_view['tipos_perfiles'] = $this->Tipo_perfil->select_forms('auth01tiposperfiles', 'COD_TIPOPERFIL', 'TEXT_TIPOPERFIL');
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	$data = ['BOL_ACTIVO' => 1];
     	if ($status) {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Tipo_usuario->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('tipo_usuarios');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('tipo_usuarios');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Tipo_usuario->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('tipo_usuarios');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('tipo_usuarios');
     	endif;
     }

     public function asignar_permisos($cod_perfil=null)
     {


     	if ($this->input->post('COD_PERFIL')){
     		$permisos_a_asignar = $this->input->post('permisos');
     		if(!$permisos_a_asignar){
     			$this->session->set_flashdata('error', 'Debe seleccionar al menos un permiso');
     			redirect('tipo_usuarios/asignar_permisos/'.$this->input->post('COD_PERFIL'));
     			return false;
     		}
     		$this->db->trans_start();
        //Se borran todos los permisos del perfil
     		$this->Permiso->borrar_permisos_perfil($this->input->post('COD_PERFIL'));

     		foreach ($permisos_a_asignar as $key => $permiso) {
     			$this->Permiso->crear_permisos_perfil($this->input->post('COD_PERFIL'), $permiso);
     		}
     		$this->db->trans_complete();

     		if ($this->db->trans_status() === FALSE) {
     			$this->session->set_flashdata('error', 'Error en la transacción');
     			redirect('tipo_usuarios');
     		} else {
     			$this->session->set_flashdata('success', 'Se han asignados los permisos');
     			redirect('tipo_usuarios');
     		}

     	} else{
     		$data_perfil = $this->Tipo_usuario->get($cod_perfil);
     		$data_view['titulo']  = 'Asignar Permisos a '.$data_perfil->TEX_NOMTIPO;
     		$data_view['legend']  = $data_perfil->TEX_DESCTIPO;
     		$data_view['tipo_perfil']  = (int)$data_perfil->COD_TIPOPERFIL;
     		$data_view['data_perfil']  = $data_perfil;
     		$data_view['all_permisos'] =  $this->Permiso->get_all_permisos($cod_perfil);
     		$data_view['permisos_perfil'] =  $this->_perfil_permisos($cod_perfil);
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('asignar_permisos', $data_view);
     	}

     	
     }


/**
	Carga de permisos asociados al usuario.
	*/ 
	private function _perfil_permisos($cod_perfil)
	{
		$arr = [];
		$datos_pemisos = $this->Usuario->get_perfil_permisos($cod_perfil);

		foreach ($datos_pemisos as $key => $permiso) {
			$arr[$permiso->TEX_MODULO][$permiso->TEX_NOMPERMI] = $permiso;
		}
		return $arr;
	}

}
