<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Usuario extends MY_Model
 {

 	protected $_table;
 	protected $_table_parent;
 	protected $_table_tipo_perfil;
 	protected $_table_intermediate;
 	private $_column = array('auth03usuarios.COD_USUARIO', 'auth03usuarios.TEX_NOMUSUA', 'auth02perfiles.TEX_NOMTIPO', 'auth03usuarios.TEX_USUARIO',
 		'auth03usuarios.TEX_MAILUSUA', 'auth03usuarios.BOL_ACTIVO');
 	private $_order  = array('auth03usuarios.COD_USUARIO' => 'desc');

 	public function __construct()
 	{
 		parent::__construct();
 		$this->load->database();
 		$this->_table              = 'auth03usuarios';
 		$this->_table_parent       = 'auth02perfiles';
 		$this->_table_tipo_perfil       = 'auth01tiposperfiles';
 		$this->_table_intermediate = 'auth06perfilhaspermi';
 		$this->primary_key         = 'COD_USUARIO';
 	}

     /**
      * Para editar el campo de una tabla. 
      * 
      * @param type @table Tabla
      * @param type @table_id Id a editar
      * @param type @id Id primaria
      * @param type $data datos
      * @return boolean
      */
     public function edit($id, $data)
     {
     	$this->db->where($this->primary_key, $id);
     	if ($this->db->update($this->_table, $data)):
     		return true;
     	else:
     		return false;
     	endif;
     }

     private function _get_datatables_query()
     {
     	$this->db->select("$this->_table.*,$this->_table_parent.TEX_NOMTIPO");
     	$this->db->from($this->_table);
     	$this->db->join($this->_table_parent, "$this->_table_parent.COD_PERFIL=$this->_table.COD_PERFIL");
     	$this->db->where("$this->_table.IS_DELETE", 0);
     	$i = 0;
     	foreach ($this->_column as $item) {
     		if ($_POST['search']['value']) ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
     			$column[$i] = $item;
     			$i++;
     		}
     		if (isset($_POST['order'])) {
     			$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
     		}
     		else if (isset($this->_order)) {
     			$order = $this->_order;
     			$this->db->order_by(key($order), $order[key($order)]);
     		}
     	}

     	public function get_datatables()
     	{
     		$this->_get_datatables_query();
     		if ($_POST['length'] != -1):
     			$this->db->limit($_POST['length'], $_POST['start']);
     		endif;
     		$query = $this->db->get();
     		return $query->result();
     	}

     	public function count_filtered()
     	{
     		$this->_get_datatables_query();
     		$query = $this->db->get();
     		return $query->num_rows();
     	}

     	public function count_all()
     	{
     		$this->db->from($this->_table);
     		$this->db->where("$this->_table.BOL_ACTIVO", 1);
     		return $this->db->count_all_results();
     	}

     /**
      * Para logeo de Usuario.
      * 
      * @param type $datos
      * @return boolean
      */
     public function login_user($usuario, $password)
     {
     	$this->db->select("$this->_table.*, $this->_table_tipo_perfil.COD_TIPOPERFIL, $this->_table_parent.COD_PERFIL");
     	$this->db->from('auth03usuarios');
     	$this->db->join($this->_table_parent, "$this->_table_parent.COD_PERFIL=$this->_table.COD_PERFIL");
     	$this->db->join($this->_table_tipo_perfil, "$this->_table_tipo_perfil.COD_TIPOPERFIL=$this->_table_parent.COD_TIPOPERFIL");
     	$this->db->where('TEX_USUARIO', $usuario);
     	$this->db->where('TEX_CONTRASENA', $password);
     	$this->db->where("$this->_table.BOL_ACTIVO", 1);
     	$this->db->where("$this->_table.IS_DELETE", 0);
     	$query = $this->db->get();
     	if ($query->num_rows() > 0) {
     		return $query->row();
     	}
     	else {
     		return false;
     	}
     }

     /**
      * Permisos del usuario.
      * 
      * @param type $cod_perfil
      * @return type
      */
     public function get_perfil_permisos($cod_perfil)
     {
     	$this->db->select('*');
     	$this->db->join('auth02perfiles', "auth02perfiles.COD_PERFIL=$this->_table_intermediate.COD_PERFIL");
     	$this->db->join('auth04permi', "auth04permi.COD_PERMI=$this->_table_intermediate.COD_PERMI");
     	$this->db->where("$this->_table_intermediate.COD_PERFIL", $cod_perfil);
     	$this->db->where('auth04permi.BOL_ACTIVO', 1);
     	$this->db->where('auth04permi.IS_DELETE', 0);
     	$this->db->order_by('auth04permi.TIPO_ACCION', 'ASC');
     	return $this->db->get($this->_table_intermediate)->result();
     }

     /**
      * Para validar si el usuario ya existe.
      * 
      * @param type $user_id
      * @param type $password
      * @return type
      */
     public function exits($user_id, $password)
     {
     	$this->db->select("$this->_table.TEX_CONTRASENA");
     	$this->db->from($this->_table);
     	$this->db->where("$this->_table.COD_USUARIO", $user_id);
     	$this->db->where("TEX_CONTRASENA.TEX_CONTRASENA", $password);
     	return $this->db->get()->num_rows();
     }

     public function get_all_permisos()
     {
     	return $this->db->get('auth04permi')->result();
     }

     /**
      * Inserta los permisos de informes. 
      * 
      * @param type $arr_permisos
      * @param type $tipo_usuario
      * @param type $usuario
      */
     public function insertar_permisos($arr_permisos, $tipo_usuario, $usuario)
     {
     	$this->_table = 'auth06perfilhaspermi';
     	for ($index = 0; $index < count($arr_permisos); $index++) {
     		$_data_permisos = [
     			'COD_PERFIL' => $tipo_usuario,
     			'COD_USUARIO'  => $usuario,
     			'ID_PERMI'     => $arr_permisos[$index],
     			'FEC_CREACION' => date('Y-m-d H:i:s'),
     			'TEX_CREANOTA' => $this->input->ip_address()
     		];


     		$this->insert($_data_permisos);
     	}
     }

     public function remover_permisos($arr_remove_permisos, $tipo_usuario, $usuario)
     {
     	for ($index = 0; $index < count($arr_remove_permisos); $index++) {
     		$this->db->where('ID_PERMI', $arr_remove_permisos[$index]);
     		$this->db->where('COD_PERFIL', $tipo_usuario);
     		$this->db->where('COD_USUARIO', $usuario);
     		$this->db->delete('auth06perfilhaspermi');
     	}
     }

     /**
      * Permisos que tiene el usuario.
      * 
      * @param type $id_usuario
      * @return type
      
     public function get_permisos_usuario($id_usuario)
     {
         $this->_table = 'auth06perfilhaspermi';
         $this->db->where('COD_USUARIO', $id_usuario);
         $this->db->join('auth04permi', "auth04permi.ID_PERMI=$this->_table.ID_PERMI", 'LEFT');
         return $this->get_all();
     }
*/

     /**
      * Permisos que no tiene el usuario.
      * @param type $id_usuario
      * @return type
      
     public function get_lista_no_permisos_usuario($id_usuario)
     {
         $query = "SELECT *
	          FROM auth06perfilhaspermi p
	          WHERE p.ID_PERMI NOT IN (
	          SELECT ID_PERMI 
	          FROM auth06perfilhaspermi 
            WHERE auth06perfilhaspermi.COD_USUARIO = $id_usuario)";
         return $this->db->query($query)->result();
     } 
*/

  }
