<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
* EVIR V 2.0
*
* An application development for PHP
*
* This content is released under the End User License Agreement (EULA)
*
* Copyright (c) 2008 - 2016, Cyberia Tech SAS.
*
* THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER,
* AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT,
* DO NOT DOWNLOAD OR USE THIS SOFTWARE.
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* LICENSE
* The software is licensed for exclusive and non-transferable use.
* A licensed copy of the software may be used for an unlimited amount
* of time without any monthly fees. For each installed instance of the software,
* a separate license is required unless the multi-user licenses bundle
* deal has been purchased, thus the a simple copy of the software can be
* installed up to multiple different machines depending on the license type.
*
* @package    Evir 2.
* @author Jaime P. Bravo <http://www.jaimebravo.co> <http://www.githib.com/fire_flex>
* @copyright    Copyright (c) 2008 - 2016, Cyberia Tech SAS.(http://cyberiatech.com.co/)
* @license    http://opensource.org/licenses/MIT    EULA
* @link    http://cyberiatech.com.co/evir
* @since    Version 2.0.0
* @filesource
*/
class Votacion_listas extends MX_Controller
{
	
	public $path_js;
	private $_configuracion;
	
	public function __construct()
	{
		
		parent::__construct();
		if (!$this->session->userdata('logged_in')) {
			$this->redirect_no_login_sufragantes();
		}
		$this->load->model(['instancias/Instancia', 'candidatos/Candidato',
		'empresas/Empresa', 'participantes/Participante', 'log_ingresos/Log_ingreso', 'configuracion/Config', 'listas/Lista', 'agencias/Agencia',
		'puntos_votacion/Maquina']);
		
		$this->load->helper('security');
		$this->path_js        = 'votacion/scripts_dev.js';
		$this->_configuracion = $this->Config->get_row();
		if (!$this->_configuracion) {
			$data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';
			$this->load->view('errors/error_start_sistema', $data_view);
			return false;
		}
		if (!$this->_configuracion->BOL_VALLIS) {
			redirect('votacion');
		}
	}
	
	public function index($instancia_orden = null)
	{
		
		$participante_id=$this->session->userdata('NUM_IDETER');
		$sesion=$this->session->userdata('session_id');
		$validafecha = $this->Participante->consultafecha($participante_id);
		$sesion_bd= $validafecha->BOL_SESIONID;
		

	  if ($this->session->userdata('logged_in') &&$sesion_bd==$sesion ) {


		//Instancia Inicial.
		//$instancia = $this->Instancia->get_instancia();
		$instancias_activas =  $this->Instancia->all();
		$acumulador=array();
				foreach($instancias_activas as $intans) {
					
					$validacion_voto_previo = $this->Participante->get_exits_voto($intans->ID_INSTAN, $participante_id);
					if(!$validacion_voto_previo) {
		
						$valor=array($intans->ID_INSTAN);
						$acumulador=array_merge($acumulador,$valor);
					
					}
					
				  }
				  $instancia                           = $this->Instancia->get_instancia(current($acumulador));
		
		if ($instancia_orden) {
			$instancia = $this->Instancia->get_instancia($instancia_orden);
			$validacion_voto_previo = $this->Participante->get_exits_voto($instancia, $participante_id);
			//Orden de la instancia.
			if (!isset($instancia) || $validacion_voto_previo) {
				$this->logout();
				$data_view['mensaje'] = $this->get_texto_sistema('TEX_TERMIN')->TEX_LABEL;
				if ($this->_configuracion->BOL_VALMAI) {
					$this->_enviar_email_confirmacion();
				}
				//Si se cierra la ventana.
				$data_view['bol_cierra'] = (boolean)$this->_configuracion->BOL_CIERRA;

				if ($this->session->userdata('punto_votacion')) {
					$data_view['bol_redirect'] = (boolean)$this->session->userdata('punto_votacion');
					$data_view['url'] = base_url('puntoVotacion');
				}

				$this->load->view('avisos/voto_success', $data_view);
				return false;
			}
		}
		//Js
		$data_view['load_js'] = $this->path_js;
		//Datos de la Empresa.
		$nombre_empresa       = $this->Empresa->get_nom_empresa();
		$data_view['empresa'] = $nombre_empresa->TEX_NOMEMP . ' - ' . $nombre_empresa->COD_NIT;
		//Carga datos de la instancia.
		$data_view['instancia'] = $instancia;
		$data_view['listas']    = $this->Lista->get_all_listas($instancia->ID_INSTAN);
		$data_view['buscador']  = $this->_configuracion->BOL_BUSTAR;
		$data_view['previsualizar_votacion']  = (boolean) $this->_configuracion->BOL_VOTPREV;
		$this->load->view('votacion/por_listas/grid_listas', $data_view);
	}
	else {

		redirect('acceso/logout');

	}
}
	
	/**
	*  Candidatos por lista.
	*
	* @param type $id_lista
	* @param type $id_instancia
	*/
	public function get_candidatos_by_lista($id_lista, $id_instancia, $orden = null)
	{
		
		$participante_id=$this->session->userdata('NUM_IDETER');
		$sesion=$this->session->userdata('session_id');
		$validafecha = $this->Participante->consultafecha($participante_id);
		$sesion_bd= $validafecha->BOL_SESIONID;
		

	   if ($this->session->userdata('logged_in')  && $sesion_bd==$sesion ) {

		if ($id_lista && $id_instancia) {
			$datos_lista = $this->Lista->get($id_lista);
			if ($datos_lista) {
				
				//Instancia de la lista
				$data_view['instancia'] = $this->Instancia->get($id_instancia);
				
				//Datos agencia del participante.
				$data_view['agencia_participante'] = $this->Agencia->get($this->session->userdata('COD_AGENCIA'));
				
				$tipo_lista   = $datos_lista->TEX_TIPLIS;
				$nombre_lista = $datos_lista->TEX_NOMLIS;
				
				//Si existe la lista
				//ID lista
				$data_view['id_lista'] = $datos_lista->ID_LISTA;
				//Tipo de lista
				$data_view['tipo_lista'] = $tipo_lista;
				
				//Js
				$data_view['load_js'] = $this->path_js;
				//Datos de la Empresa.
				$nombre_empresa       = $this->Empresa->get_nom_empresa();
				$data_view['empresa'] = $nombre_empresa->TEX_NOMEMP . ' - ' . $nombre_empresa->COD_NIT;
				
				//Número de candidatos por fila.
				$data_view['numero_candidatos_grid'] = (int) $this->_configuracion->NUM_CANFIL;
				
				//Nombre de la lista.
				$data_view['nombre_lista'] = $nombre_lista;
				
				//Datos del voto en Blanco por instancia.
				$data_view['max_candidatos_lista'] = 0;
				$data_view['obliga_minima_multiple']  = false;
				if ($tipo_lista === 'LVP') {
					$data_view['voto_blanco'] = $this->Candidato->get_voto_blanco($id_instancia);
					$data_view['max_candidatos_lista'] = (int)($datos_lista->NUM_MUSEIN)?$datos_lista->NUM_MUSEIN:0;
					$data_view['obliga_minima_multiple'] = (int)($datos_lista->BOL_OBLMUL)?$datos_lista->BOL_OBLMUL:false;
				}
				
				//Candidatos de la lista.
				$this->db->where('ID_LISTA', $id_lista);
				$this->db->where('IS_DELETE', 0);
				$this->db->where('TEXT_TIPLIST !=', 'LCL');
				$this->db->order_by('cast(evi04candidat_mr.NUM_ORDEN as unsigned)');
				$data_view['candidatos'] = $this->Candidato->get_all();
				
				//Si es lista cerrada trae el candidato de la lista para voto.
				if ($tipo_lista === 'LCC') {
					$this->db->where('ID_LISTA', $id_lista);
					$this->db->where('IS_DELETE', 0);
					$this->db->where('TEXT_TIPLIST', 'LCL');
					$data_view['candidato_voto_lcc'] = $this->Candidato->get_row();
				}
				$data_view['previsualizar_votacion']  = (boolean) $this->_configuracion->BOL_VOTPREV;
				$this->load->view('votacion/por_listas/tarjeton_por_lista', $data_view);
			}
		}
	}
	else {

		redirect('acceso/logout');

	}
	}

	//------------------------------------------------------------------------------
	/**
	* Valida la vigencia de la instancia con referencia a la fecha de inicio y
	* la fecha final.
	*
	* @param type $instancia
	*/
	public function valida_fecha_vigencia_instancia($instancia)
	{
		setlocale(LC_ALL,"es_CO");
		$fecha_ini_instancia = $instancia->FEC_INIUSO;
		$fecha_ini_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime("%H:%M:%S %p del %A %d de %B de %Y", strtotime($instancia->FEC_INIUSO)));
		
		$fecha_fin_instancia_format = iconv('ISO-8859-2', 'UTF-8', strftime(" %H:%M:%S %p del %A %d de %B de %Y ", strtotime($instancia->FEC_FINUSO)));
		$fecha_fin_instancia = $instancia->FEC_FINUSO;
		$fecha_hoy           = date('Y-m-d H:i:s');
		
		//Valida la fecha de cierre de la instacia.
		if ($fecha_hoy < $fecha_ini_instancia) {
			return false;
		}
		if ($fecha_hoy > $fecha_fin_instancia) {
			return false;
		}
		return true;
	}
	
	
	/**
	*  Proceso de votación por listas.
	*
	* @return boolean
	*/
	public function proceso()
	{
		$participante_id=$this->session->userdata('NUM_IDETER');
		$sesion=$this->session->userdata('session_id');
		$validafecha = $this->Participante->consultafecha($participante_id);
		$sesion_bd= $validafecha->BOL_SESIONID;


	   if ($this->session->userdata('logged_in') && $sesion_bd==$sesion ) {
			if ($this->input->post()) {
				$orden              = $this->input->post('NUM_ORDEN');
				$instancia          = $this->input->post('ID_INSTAN');
				$id_lista           = $this->input->post('ID_LISTA');
				$candidato          = $this->input->post('ID_CANDID[]');
				$candidato_lista_cc = $this->input->post('ID_CANDID_LCL');
				$previsualizar_votacion    =  xss_clean($this->input->post('previsualizar_votacion'));
				$ip_address = $this->input->ip_address();
				
				$instancias_activas =  $this->Instancia->all();
				
				if(!$instancias_activas) {
					$this->_message = ['type' => 'error', 
					'message' =>  $this->get_texto_sistema('TEX_INSTA_INACTIVA')->TEX_LABEL,
					'redirect' => 'acceso/logout'
				]; 
				echo json_encode($this->_message);
				return false;
			}
			
			
			//Validacion de la vigencia de la  instancia. 
			$objInstancia = $this->Instancia->get_instancia_by_id($instancia);
			$valida_vigencia_instancia = $this->valida_fecha_vigencia_instancia($objInstancia);
			
			if(!$valida_vigencia_instancia) {
				
				if(count($instancias_activas) == 1) {
					$this->_message = ['type' => 'error', 
					'message' =>  $this->get_texto_sistema('TEX_INSTA_INACTIVA')->TEX_LABEL,
					'redirect' => 'acceso/logout'
				]; 
				echo json_encode($this->_message);
				return false;
			}
			
			$n_orden = $orden + 1;
			$url_retorno = 'votacion/index/' . $n_orden;
			
			$this->_message = ['type' => 'error', 
			'message' =>   $this->get_texto_sistema('TEX_VOTA_CERRADA')->TEX_LABEL, 
			'redirect' => $url_retorno
		]; 
		echo json_encode($this->_message);
		return false;
	}
	
	if($previsualizar_votacion) {
		//Candidato lista.
		$datos_candidato_lista = $this->Candidato->get($candidato_lista_cc);
		$datos_lista = $this->Lista->get($id_lista);
		$lista_candidato = '';
		$contador=0;
		for ($index = 0; $index < count($candidato); $index++) {
			$contador++;	
			$id_candidato = $candidato[$index];
			if($id_candidato !== ''){
				$datos_candidato = $this->Candidato->get($id_candidato);
				$lista_candidato .= $contador.'. '.$datos_candidato->TEX_NOMCAN.' '.$datos_candidato->TEX_APECAN.'<br>';
			}
		}
		if($candidato_lista_cc) {
			$this->_message = ['type' => 'success', 'message' => $lista_candidato, 'nombre_lista'=>$datos_candidato_lista->TEX_NOMCAN.' '.$datos_candidato_lista->TEX_APECAN, 
			'nombre_lista'=>$datos_lista->TEX_NOMLIS,'lista_cerrada'=>1]; 
		} 
		else {
			$this->_message = ['type' => 'success', 'message' => $lista_candidato,
			'nombre_lista'=>$datos_lista->TEX_NOMLIS,
			'lista_cerrada'=>0]; 
		}
		echo json_encode($this->_message);
		return false;
	} else { 
		if ($candidato_lista_cc) {
			$this->form_validation->set_rules("ID_CANDID_LCL", 'Candidato Lista', 'integer');
		} else {
			$this->form_validation->set_rules("ID_CANDID[]", 'Candidato', 'integer');
			$this->form_validation->set_rules('ID_BLANCO', 'Voto Blanco', 'integer');
		}
		
		if (!$this->form_validation->run()) {
			$url_retorno = base_url();
			$this->_message = ['type' => 'error', 'message' => validation_errors()]; 
			echo json_encode($this->_message);
		}
		
		//Voto para candidato lista.
		$this->db->trans_start();
		
		$punto_votacion = (boolean)$this->session->userdata('punto_votacion');
		
		if($punto_votacion){
			$mac_cliente = $_SERVER['REMOTE_ADDR'];
			$datos_maquina = $this->Maquina->get_row($mac_cliente);
			
			if($datos_maquina){
				if($datos_maquina->NOM_MAC)
				$ip_address = $datos_maquina->NOM_MAC;
			}
			
			
		}
		
		//Candidato de la lista cerrada.
		if ($candidato_lista_cc) {
			$valida_votacion = $this->valida_voto($instancia, $candidato_lista_cc);
			if (!$valida_votacion) {
				$url_retorno = base_url();
				$this->_message = ['type' => 'error', 'message' => 'Esta Sesión esta cerrada', 'url_retorno'=>$url_retorno]; 
				$this->session->sess_destroy();
				echo json_encode($this->_message);
				return false;
				
			}
			
			
			$arr_save = [
				'ID_INSTAN'  => $instancia,
				'ID_CANDID'  => $candidato_lista_cc,
				'NUM_IDETER' => $this->session->userdata('NUM_IDETER'),
				'FEC_PROVOT' => $this->get_fecha_hora_hoy(),
				'TEX_IPORIG' => $ip_address,
			];
			
			
			//Inserción de log y suma de voto al candidato lista.
			$this->Candidato->insert_log_voto($arr_save, $candidato_lista_cc);
			$orden_instancia = $orden + 1;
			$url_retorno = base_url('votacion/votacion_listas/index/' . $orden_instancia);
			$this->_message = ['type' => 'success', 'message' => '', 'url_retorno'=>$url_retorno]; 
			echo json_encode($this->_message);
			
		} else {
			$id_voto_blanco = $this->input->post('ID_BLANCO');
			$voto_blanco    = $this->input->post('BOL_VOTBLA');
			if (!$voto_blanco) {
				for ($index = 0; $index < count($candidato); $index++) {
					$id_candidato = $candidato[$index];
					
					//Si ya ha votado por el mismo candidato.
					$valida_votacion = $this->valida_voto($instancia, $id_candidato);
					if (!$valida_votacion) {
						//$url_retorno= base_url('votacion/votacion_listas/get_candidatos_by_lista/' . $id_lista . '/' . $instancia . '/' . $orden);
						$url_retorno= base_url('acceso/logout');
						$this->_message = ['type' => 'error', 'message' => 'Ya ha realizado una votación', 'url_retorno'=>$url_retorno]; 
						echo json_encode($this->_message);
					}
					
					$arr_save = [
						'ID_INSTAN'  => $instancia,
						'ID_CANDID'  => $id_candidato,
						'NUM_IDETER' => $this->session->userdata('NUM_IDETER'),
						'FEC_PROVOT' => $this->get_fecha_hora_hoy(),
						'TEX_IPORIG' => $ip_address,
					];
					//Inserción de log y suma de voto al candidato.
					$this->Candidato->insert_log_voto($arr_save, $id_candidato);
				}
			} else {
				
				$arr_save = [
					'ID_INSTAN'  => $instancia,
					'ID_CANDID'  => $id_voto_blanco,
					'NUM_IDETER' => $this->session->userdata('NUM_IDETER'),
					'FEC_PROVOT' => $this->get_fecha_hora_hoy(),
					'TEX_IPORIG' => $ip_address,
				];
				//Inserción de log y suma de voto al candidato.
				$this->Candidato->insert_log_voto($arr_save, $id_voto_blanco);
			}
			
			$orden_instancia = $orden + 1;
			$url_retorno =  base_url('votacion/votacion_listas/index/' . $orden_instancia); 
			$this->_message = ['type' => 'error', 'message' => '', 'url_retorno'=>$url_retorno]; 
			echo json_encode($this->_message);
		}
		
		$this->db->trans_complete();
		if ($this->db->trans_status() === FALSE)
		{
			$this->_message = ['type' => 'error', 'message' => 'Error en la transacción']; 
			echo json_encode($this->_message);
		}
	}
}
}
}

public function valida_voto($instancia, $candidato)
{
	$participante = $this->session->userdata('NUM_IDETER');
	$consulta     = $this->Participante->get_exits_voto($instancia, $participante, $candidato);
	if ($consulta) {
		$this->form_validation->set_message('valida_voto', 'Ya has realizado esta votación');
		return false;
	} else {
		return true;
	}
}

/**
* Para salir de la aplicación.
*/
public function logout()
{
	if ($this->session->userdata('logged_in')) {
		$this->load->helper('cookie');
		if ($this->session->userdata('is_pin')) {
			$this->Log_ingreso->edit($this->session->userdata('NUM_IDETER'), ['FEC_FINSES' => $this->get_fecha_hora_hoy(), 'BOL_USADO' => 1]);
			delete_cookie('tm');
			delete_cookie('mbienvenida');
		}
		$this->session->sess_destroy();
		//  redirect('/');
	}
}

private function _enviar_email_confirmacion()
{
	$email_participante = $this->session->userdata('TEX_MAIL');
	$nombre_empresa       = $this->Empresa->get_nom_empresa();
	$nombre_empresa = $nombre_empresa->TEX_NOMEMP;
	
	$asunto             = $nombre_empresa.' '.$this->get_texto_sistema('TEX_MAIASU')->TEX_LABEL;
	$mensaje_sistema    = $this->get_texto_sistema('TEX_MAIMEN')->TEX_LABEL;
	
	$nombre_participante = $this->session->userdata('TEX_NOMPAR') . ' ' . $this->session->userdata('TEX_APEPAR');
	$mensaje             = "
	<html>
	<head>
	<title>Confirmación de Voto en EVIR</title>
	</head>
	<body> <p>Buen día Sr.(a) : $nombre_participante</p> 
	<p>$mensaje_sistema</p> 
	<h3>¡Gracias por Votar!</h3> <p></p>
	</body>
	</html>
	";

	  $fromEmail = "info@gestionvir.com";

        $fromName  = "Evir - Votación Virtual";

        $to        = $email_participante;



        // Cabeceras del correo

        $headers = 'From: ' . $fromName . ' <' . $fromEmail . '>' . "\r\n" .

            'Reply-To: ' . $fromEmail . "\r\n" .

            'X-Mailer: PHP/' . phpversion() . "\r\n" .

            'MIME-Version: 1.0' . "\r\n" .

            'Content-type: text/html; charset=UTF-8';



		

		if (mail($to, $asunto, $mensaje, $headers)) {

            return true; // o manejar como necesites

        } else {

            return false;
        }



		}
		
		/**
		*  Para Enviar Email.
		*
		* @param type Asunto
		* @param type $mensaje Cuerpo del mensaje
		* @param type $destino Email del destino.
		* @return boolean Resultado del envío.
		*/
		private function _send_email($asunto, $mensaje, $destino)
		{
			require_once APPPATH . 'third_party/phpmailer/PHPMailerAutoload.php';
			$mail = new PHPMailer();
			$mail->IsSMTP();
			$mail->SMTPAuth   = true;
			$mail->CharSet    = "utf-8";
			$mail->Encoding   = "base64";
			$mail->SMTPSecure = "ssl";
			$mail->Host       = $this->_configuracion->TEX_SMTP;
			$mail->Port       = $this->_configuracion->TEX_PORT;
			$mail->Username   = $this->_configuracion->TEX_MAINOM;
			$mail->Password   = $this->_configuracion->TEX_MAICLA;
			$mail->SetFrom($this->_configuracion->TEX_MAINOM, 'Sistema Votación EVIR');
			$mail->isHTML(true);
			$mail->Subject = $asunto;
			$mail->Body    = $mensaje;
			$mail->AddAddress($destino, "Receiver");
			if (!$mail->Send()) {
				return false;
			} else {
				return true;
			}
		}
		
		public function timer_votacion()
		{
			$tiempo_restante = $this->_configuracion->NUM_TEMPO;
			if (!$tiempo_restante) {
				return false;
			}
			$tiempo_en_seg = $tiempo_restante * 60;
			echo json_encode($tiempo_en_seg);
		}
		
	}
	
	