<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<body>
  <?php
    // Variables de sesión comunes
    $permisos  = $this->session->userdata('permisos');
    $empresa   = $this->session->userdata('EMPRESA');
    $usuario   = $this->session->userdata('TEX_USUARIO');
    $nombre    = $this->session->userdata('TEX_NOMBRE');
    $logged    = (bool) $this->session->userdata('logged_in');
    $codPerfil = $this->session->userdata('COD_PERFIL');
    $tipoPerf  = $this->session->userdata('COD_TIPOPERFIL');
    $segmento  = $this->session->userdata('NOMBRE_SEGMENTO');

    // Evitar notices si settings no existe
    $settings  = $this->session->userdata('settings');
    $bolValLis = (!empty($settings) && isset($settings->BOL_VALLIS)) ? (bool)$settings->BOL_VALLIS : false;
  ?>

  <!-- Datos ocultos disponibles para JS -->
  <div id="nom_empresa" style="display:none"><?= html_escape($empresa) ?></div>
  <div id="nom_usuario" style="display:none"><?= html_escape($usuario) ?></div>

  <div class="header-admin">
    <div id="spin" style="display: none;"></div>
    <div id="top-bar"></div>
    <div class="contenedor-logos"></div>

    <nav class="navbar top-menu admin-menu">
      <div class="container">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
            <span class="sr-only">Toggle navigation</span>
            <i class="fa fa-bars fa-2x"></i>
          </button>
        </div>

        <div id="navbar" class="collapse navbar-collapse">
          <ul class="nav navbar-nav">
            <?php if ($codPerfil): ?>
              <li class="dropdown">
                <a href="<?= base_url('administrador') ?>"><i class="fa fa-home"></i> Inicio</a>
              </li>
            <?php endif; ?>

            <?php if ($tipoPerf === 1 && isset($permisos['sistema'])): ?>
              <li class="dropdown">
                <a href="#"><i class="fa fa-gears"></i> Sistema <b class="caret"></b></a>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['sistema']['sistema_generar'])): ?>
                    <li><a href="<?= base_url('sistema') ?>"><i class="fa fa-gears"></i> Generar Módulo</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if ($tipoPerf === 1 || $tipoPerf === 2): ?>
              <li class="dropdown">
                <?php if (isset($permisos['perfiles']) || isset($permisos['permisos']) || isset($permisos['usuarios']) || isset($permisos['generador_password']['participantes_generar_pass'])): ?>
                  <a href="#"><i class="fa fa-group"></i> Usuarios<b class="caret"></b></a>
                <?php endif; ?>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['tipo_perfiles']['tipo_perfiles_listar'])): ?>
                    <li><a href="<?= base_url('tipo_perfiles') ?>"><i class="fa fa-users"></i> Tipos de Perfiles</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['perfiles']['perfiles_listar'])): ?>
                    <li><a href="<?= base_url('tipo_usuarios') ?>"><i class="fa fa-user"></i> Perfiles</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['permisos']['permisos_listar'])): ?>
                    <li><a href="<?= base_url('permisos') ?>"><i class="fa fa-maxcdn"></i> Permisos</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['usuarios']['usuarios_listar'])): ?>
                    <li><a href="<?= base_url('usuarios') ?>"><i class="fa fa-users"></i> Usuarios</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['generador_password']['participantes_generar_pass'])): ?>
                    <li><a href="<?= base_url('participantes/generar_passwords') ?>"><i class="fa fa-users"></i> Generar Passwords Masivo</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['usuarios']['usuarios_listar_ingresos'])): ?>
                    <li><a href="<?= base_url('log_ingresos') ?>"><i class="fa fa-sign-in"></i> Log de Ingresos</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if ($tipoPerf === 1 || $tipoPerf === 2): ?>
              <li class="dropdown">
                <?php if (isset($permisos['paises']) || isset($permisos['departamentos']) || isset($permisos['ciudades']) || isset($permisos['agencias'])): ?>
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-map-marker"></i> Geo <b class="caret"></b></a>
                <?php endif; ?>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['paises']['paises_listar'])): ?>
                    <li><a href="<?= base_url('paises') ?>"><i class="fa fa-globe"></i> Países</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['departamentos']['departamentos_listar'])): ?>
                    <li><a href="<?= base_url('departamentos') ?>"><i class="fa fa-map-marker"></i> Departamentos</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['ciudades']['ciudades_listar'])): ?>
                    <li><a href="<?= base_url('ciudades') ?>"><i class="fa fa-map-marker"></i> Ciudades</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['agencias']['agencias_listar'])): ?>
                    <li><a href="<?= base_url('agencias') ?>"><i class="fa fa-building"></i> <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if ($tipoPerf === 1 || $tipoPerf === 2): ?>
              <li class="dropdown">
                <?php if (isset($permisos['configuracion']) || isset($permisos['textos']) || isset($permisos['empresas']) || isset($permisos['instancias']) || isset($permisos['listas']) || isset($permisos['candidatos']) || isset($permisos['participantes']) || isset($permisos['clear_data'])): ?>
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-gears"></i> Parametrización<b class="caret"></b></a>
                <?php endif; ?>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['configuracion']['configuracion_ver'])): ?>
                    <li><a href="<?= base_url('configuracion') ?>"><i class="fa fa-gear"></i> Configuración</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['textos']['textos_editar'])): ?>
                    <li><a href="<?= base_url('textos') ?>"><i class="fa fa-text-height"></i> Textos</a></li>
                  <?php endif; ?>
                  <?php if ($tipoPerf === 1): ?>
                    <?php if (isset($permisos['empresas']['empresas_editar'])): ?>
                      <li><a href="<?= base_url('empresas') ?>"><i class="fa fa-building"></i> Empresa</a></li>
                    <?php endif; ?>
                  <?php endif; ?>
                  <?php if (isset($permisos['instancias']['instancias_listar'])): ?>
                    <li><a href="<?= base_url('instancias') ?>"><i class="fa fa-book"></i> Instancias</a></li>
                  <?php endif; ?>
                  <?php if ($bolValLis): ?>
                    <?php if (isset($permisos['listas']['listas_listar'])): ?>
                      <li><a href="<?= base_url('listas') ?>"><i class="fa fa-users"></i> Listas</a></li>
                    <?php endif; ?>
                  <?php endif; ?>
                  <?php if (isset($permisos['candidatos']['candidatos_listar'])): ?>
                    <li><a href="<?= base_url('candidatos') ?>"><i class="fa fa-users"></i> Candidatos</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['participantes']['participantes_listar'])): ?>
                    <li><a href="<?= base_url('participantes') ?>"><i class="fa fa-users"></i> Participantes</a></li>
                  <?php endif; ?>

                  <!-- 🔥 Nuevo menú PYR -->
                  <?php if (isset($permisos['pyr']['pyr_listar']) || $tipoPerf === 1): ?>
                    <li><a href="<?= base_url('pyr') ?>"><i class="fa fa-question-circle"></i> Preguntas (PYR)</a></li>
                  <?php endif; ?>

                  <?php if (isset($permisos['clear_data']['clear_data_editar'])): ?>
                    <li><a href="<?= base_url('clear_data') ?>"><i class="fa fa-times-circle"></i> Limpiar Registro, Ingresos y Salidas</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if ($tipoPerf): ?>
              <li class="dropdown">
                <?php if (isset($permisos['escarapelas'])): ?>
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-users"></i> Escarapelas<b class="caret"></b></a>
                <?php endif; ?>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['escarapelas']['escarapelas_editar'])): ?>
                    <li><a href="<?= base_url('escarapelas') ?>"><i class="fa fa-credit-card"></i> Escarapelas</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if (isset($permisos['registros']) || isset($permisos['ingresos_salidas'])): ?>
              <li class="dropdown">
                <?php if (isset($permisos['registros']) || isset($permisos['ingresos_salidas'])): ?>
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-bars"></i> Procesos<b class="caret"></b></a>
                <?php endif; ?>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['registros']['registros_crear'])): ?>
                    <li><a href="<?= base_url('registros') ?>" target="_blank"><i class="fa fa-user-plus"></i> Registro</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['ingresos_salidas']['ingresos_salidas_crear'])): ?>
                    <li><a href="<?= base_url('ingresos_salidas') ?>" target="_blank"><i class="fa fa-sign-in"></i> Ingresos Salidas</a></li>
                    
                   <!-- <li><a href<?= base_url('ingresos_salidas') ?> target="_blank"><i class="fa fa-sign-in"></i> Ingresos Salidas o</a></li>-->
                  <?php endif; ?>
                  <?php if (isset($permisos['sincronizacion']['sincronizacion_ejecutar'])): ?>
                    <li><a href="<?= base_url('sincronizacion') ?>"><i class="fa fa-refresh"></i> Sincronización</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['registros']['registros_cuorum'])): ?>
                    <li><a href="<?= base_url('registros/cuorum') ?>" target="_blank"><i class="fa fa-pie-chart"></i> CUORUM</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['registros']['registros_contador_votos'])): ?>
                    <li><a href="<?= base_url('informes/graficos/contador_votos') ?>" target="_blank"><i class="fa fa-pie-chart"></i> Contador de votos</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['registros']['registros_sorteo'])): ?>
                    <li><a href="<?= base_url('sorteo') ?>"><i class="fa fa-user"></i> Sorteo</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>

            <?php if (isset($permisos['informes'])): ?>
              <li class="dropdown">
                <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-bar-chart"></i> Informes<b class="caret"></b></a>
                <ul class="dropdown-menu">
                  <?php if (isset($permisos['informes']['informes_por_agencia']) && $permisos['informes']['informes_por_agencia']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/por_agencia') ?>">Por <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_resumen_por_agencia']) && $permisos['informes']['informes_resumen_por_agencia']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/resumen_por_agencia') ?>">Resumen Por <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_resumen_ip_por_agencia']) && $permisos['informes']['informes_resumen_ip_por_agencia']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/get_resumen_ip_por_agencia') ?>">Resumen IP Por <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_resumen_votacion_usuario_registro']) && $permisos['informes']['informes_resumen_votacion_usuario_registro']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/resumen_votacion_usuario_registro') ?>">Resumen Votación por Usuario Registro</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_cociente_general']) && $permisos['informes']['informes_cociente_general']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/get_por_cociente') ?>">Cociente General</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_cociente_agencia']) && $permisos['informes']['informes_cociente_agencia']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/get_cociente_agencia') ?>">Cociente Por <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_candidatos_por_agencia']) && $permisos['informes']['informes_candidatos_por_agencia']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/get_candidatos_por_agencia') ?>">Candidatos Por <?= html_escape($segmento) ?></a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_por_instancias']) && $permisos['informes']['informes_por_instancias']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/por_instancias') ?>">Por Instancias</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_general_candidatos']) && $permisos['informes']['informes_general_candidatos']['MOSTRAR_FRONT']): ?>
                    <li><a href="<?= base_url('informes/candidatos') ?>">General Candidatos</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_sin_participar'])): ?>
                    <li><a href="<?= base_url('informes/personas_sin_participar') ?>">Personas sin Participar</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_participantes'])): ?>
                    <li><a href="<?= base_url('informes/participantes') ?>">Personas que han Participado</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_personas_registradas'])): ?>
                    <li><a href="<?= base_url('informes/personas_registradas') ?>">Personas Registradas</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_log_recordar_password'])): ?>
                   
                      <li><a href="<?= base_url('informes/solicitudes_contra_voto') ?>">Solicitudes de contraseña (Voto)</a></li>            
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_asistentes_habiles'])): ?>
                    <li><a href="<?= base_url('informes/asistentes_habiles') ?>">Total Asistentes o Hábiles</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_registrados_sin_participar'])): ?>
                    <li><a href="<?= base_url('informes/registrados_sin_participar') ?>">Personas en el Auditorio Sin Participar</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_personas_sin_registrarse'])): ?>
                    <li><a href="<?= base_url('informes/personas_sin_registrarse') ?>">Personas sin registrarse</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_personas_en_auditorio'])): ?>
                    <li><a href="<?= base_url('informes/personas_en_auditorio') ?>">Personas en el Auditorio</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_personas_fuera_auditorio'])): ?>
                    <li><a href="<?= base_url('informes/personas_fuera_auditorio') ?>">Personas fuera del Auditorio</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_participantes_bloqueados'])): ?>
                    <li><a href="<?= base_url('informes/participantes_bloqueados') ?>">Personas bloqueadas sin votar</a></li>
                  <?php endif; ?>
                  <?php if (isset($permisos['informes']['informes_log_recordar_password'])): ?>
                    <li><a href="<?= base_url('informes/log_recordar_password') ?>">Log recordar contraseña</a></li>
                  <?php endif; ?>
                  
                </ul>
              </li>
            <?php endif; ?>
          </ul>

          <?php if ($logged): ?>
            <div class="user-menu">
              <ul class="nav navbar-nav">
                <li class="dropdown">
                  <a href="#" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-user"></i> Mis Datos<b class="caret"></b></a>
                  <ul class="dropdown-menu">
                    <?php if ($codPerfil !== 3): ?>
                      <li><a href="<?= base_url('usuarios/change_password') ?>"><i class="fa fa-user"></i> Cambiar Contraseña</a></li>
                    <?php endif; ?>
                    <li><a href="<?= base_url('usuarios/logout') ?>"><i class="fa fa-sign-out"></i> Salir</a></li>
                  </ul>
                </li>
              </ul>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </nav>

    <?php if ($logged): ?>
      <div class="container info-user-admin">
        Panel de Administración / <b><?= html_escape($empresa) ?></b> / Bienvenido:
        <i class="fa fa-user"></i> <?= html_escape($nombre ? $nombre : $usuario) ?>
        <a style="float: right; font-size: 14px; color: #323232;" href="<?= base_url('usuarios/logout') ?>">
          <i class="fa fa-sign-out"></i>Salir
        </a>
      </div>
    <?php endif; ?>
  </div>

  <!-- 🔧 Mensajes Flash (lee una sola vez y barre) -->
  <div class="container" style="margin-top:10px;">
    <?php
      $flash = [
        'success' => $this->session->flashdata('success'),
        'error'   => $this->session->flashdata('error'),
        'warning' => $this->session->flashdata('warning'),
        'info'    => $this->session->flashdata('info'),
      ];
      $clase = ['success' => 'success', 'error' => 'danger', 'warning' => 'warning', 'info' => 'info'];

      foreach ($flash as $k => $msg):
        if (!$msg) continue;
    ?>
      <div class="alert alert-<?= $clase[$k] ?> alert-dismissible fade in" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
        <?= $msg ?>
      </div>
    <?php
        // Barrido defensivo (evita “pegados” aunque alguien reinyecte)
        $this->session->unmark_flash($k);
        $this->session->unset_userdata($k);
      endforeach;
    ?>
  </div>

  <!-- Auto-ocultar alerts después de 6s (opcional) -->
  <script>
    setTimeout(function () {
      var alerts = document.querySelectorAll('.alert');
      for (var i = 0; i < alerts.length; i++) {
        var a = alerts[i];
        if (a && a.parentNode) a.parentNode.removeChild(a);
      }
    }, 6000);
  </script>

  <!-- Contenedor general para vistas -->
  <div class="container">
