// ParsleyConfig definition if not already set
// Validation errors messages for Parsley
// Load this after Parsley

Parsley.addMessages('es', {
	defaultMessage: "Este valor parece ser inválido.",
	type: {
		email:        "Este valor debe ser un correo válido.",
		url:          "Este valor debe ser una URL válida.",
		number:       "Este valor debe ser un número válido.",
		integer:      "Este valor debe ser un número válido.",
		digits:       "Este valor debe ser un dígito válido.",
		alphanum:     "Este valor debe ser alfanumérico."
	},
	notblank:       "Este valor no debe estar en blanco.",
	required:       "Este valor es requerido.",
	pattern:        "Este valor es incorrecto.",
	min:            "Este valor no debe ser menor que %s.",
	max:            "Este valor no debe ser mayor que %s.",
	range:          "Este valor debe estar entre %s y %s.",
	minlength:      "Este valor es muy corto. La longitud mínima es de %s caracteres.",
	maxlength:      "Este valor es muy largo. La longitud máxima es de %s caracteres.",
	length:         "La longitud de este valor debe estar entre %s y %s caracteres.",
	mincheck:       "Debe seleccionar al menos %s opciones.",
	maxcheck:       "Debe seleccionar %s opciones o menos.",
	check:          "Debe seleccionar entre %s y %s opciones.",
	equalto:        "Este valor debe ser idéntico."
});

Parsley.setLocale('es');


function inputOnlyNumbers(id) {
	$('#' + id + '').keydown(function (e) {
		if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 190]) !== -1 ||
			(e.keyCode === 65 && (e.ctrlKey === true || e.metaKey === true)) ||
			(e.keyCode >= 35 && e.keyCode <= 40)) {
			return;
	}
	if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
		e.preventDefault();
	}
});
}
/**
 * Pasar a mayúsculas un string.
 * 
 * @param {type} id
 * @returns {undefined}
 */
 function uppercase(id) {
 	$('#' + id + '').blur(function () {
 		this.value = this.value.toUpperCase();
 	});
 }

 function lowercase(id) {
 	$('#' + id + '').blur(function () {
 		this.value = this.value.toLowerCase();
 	});
 }

 $(document).ready(function () {



//forms general
    /**
     * Envío de Ajax General.
     *
     * @param {String} Tipo de Envío POST o GET
     * @param {String} url Método del controlador PHP
     * @param {Obj} data Datos del form o del DOM en Objeto
     * @returns {jqXHR} Objeto que retorna.
     * @example  Modo de Captura:
     * var myVar = sendDataWithAjax('POST', url, data);
     myVar.success(function (response) {});
     */
     function sendDataWithAjax(type, url, data) {
     	return  $.ajax({
     		type: type,
     		url: url,
     		data: data,
     		dataType: 'json',
     		beforeSend: function () {
     		},
     		success: function (response) {

     		},
     		error: function (jqXHR, textStatus, errorThrown) {
     			console.log('Código:' + jqXHR.status);
     			console.log('Error AJAX: ' + textStatus);
     			console.log('Tipo Error: ' + errorThrown);
     		}
     	});
     }
// Form create
$('.create-form-view').submit(function (e) {
	e.preventDefault();

	var url = $(this).attr('action');
	var data = $(this).serialize();
	var torre = sendDataWithAjax('POST', url, data);
	$('#message-ajax').html('');
	torre.success(function (response) {
		if (response.type === 'error') {
			generateNoty('bottomLeft', response.message, 'error');
		} else {

			if (response.message) {
				$('#message-ajax').html('');
				$('#message-ajax').html('Bienvenido: ' + response.message);
				$('#NUM_IDETER').focus();
				resetForms('registro-form');
			}
			if (response.message_ing_salida) {
				$('#message-ajax').html('');
				$('#message-ajax').html(response.message_ing_salida);
				$('#NUM_IDETER').focus();
				resetForms('registro-form');
			}
			$('#NUM_IDETER').focus();
		}
	});
});

//Noty Master function
function generateNoty(layout, text, type) {
	var n = noty({
		text: text,
		type: type,
		dismissQueue: true,
		layout: layout,
		theme: 'relax',
		timeout: 4000
	});
}
/****************************************************************************/

$('.clean').on('click', function (e) {
	e.preventDefault();
	var boton = $(this);
	var url = $(this).attr('href');
	var data = {'clean': true};
	bootbox.confirm("Esta seguro que desea limpiar la tabla?", function (result) {
		if (result === true) {
			var deleteItem = sendDataWithAjax('post', url, data);
			deleteItem.success(function (response) {
				if (response.type === "error") {
					generateNoty('bottomLeft', response.message, 'error');
				} else {
					boton.hide();
					$('.lista-mandos').remove();
					generateNoty('bottomLeft', response.message, 'success');
				}
			});
		} else {

		}
	});
});

function borrarRegistro(id, message) {
	$('#' + id + '').on('click', function (e) {
		e.preventDefault();
		bootbox.confirm(message, function (result) {
			if (result) {
				return false;
			} else {
				return true;
			}
		});
	});
}

    //Autocompletado de ciudades
    var options = {
    	url: function (phrase) {
    		return baseUrl + "base/autocomplete_ciudades?query=" + phrase;
    	},
    	getValue: function (element) {
    		return '' + element.COD_CIUDAD + ' - ' + element.TEX_NOMCIU;
    	},
    	ajaxSettings: {
    		dataType: "json",
    		method: "POST",
    		data: {
    			dataType: "json"
    		}
    	},
    	adjustWidth: false,
    	list: {
    		maxNumberOfElements: 8,
    		showAnimation: {
    			type: "fade",
    			time: 200,
    			callback: function () {
    			}
    		},
    		hideAnimation: {
    			type: "slide",
    			time: 200,
    			callback: function () {
    			}
    		},
    		match: {
    			enabled: true
    		},
    		sort: {
    			enabled: true
    		},
    		onChooseEvent: function (e) {
    			var codCiudad = $("#TEX_CIUDAD").getSelectedItemData().COD_CIUDAD;
    			var textCiu = $("#TEX_CIUDAD").getSelectedItemData().TEX_NOMCIU;
    			$("#COD_CIUDAD").val(codCiudad);
    			$("#TEX_CIUDAD").val(textCiu);

    		}
    	},
    	preparePostData: function (data) {
    		data.phrase = $("#TEX_CIUDAD").val();
    		return data;
    	},
    	requestDelay: 400,
    	theme: "square"
    };
   

    $('.btn-leave-app').on('click', function () {
    	window.location = baseUrl;
    });
    function getFechaIniFromNow() {
    	var url = baseUrl+'acceso/get_fecha_inicio_votacion';
    	var fechaIniVotacionData = sendDataWithAjax('GET', url, {});
    	fechaIniVotacionData.success(function(response) {
    		var fechaIniVotacion = response.fecha_ini_instancia;
    		var $clock = $('#remain_votacion');
    		$clock.countdown(fechaIniVotacion, function(event) {
    			$(this).html(event.strftime('%D días %H horas %M minutos %S segundos'));
    		});
    	});

    }

    getFechaIniFromNow();


}); //End jQuery

//Helper functions
function resetForms(form_id) {
	$('#' + form_id + '').get(0).reset();
}
// Spin settings.
var opts = {
    lines: 15 // The number of lines to draw
    , length: 55 // The length of each line
    , width: 16 // The line thickness
    , radius: 71 // The radius of the inner circle
    , scale: 1 // Scales overall size of the spinner
    , corners: 1 // Corner roundness (0..1)
    , color: '#CC5403' // #rgb or #rrggbb or array of colors
    , opacity: 0.4 // Opacity of the lines
    , rotate: 6 // The rotation offset
    , direction: 1 // 1: clockwise, -1: counterclockwise
    , speed: 0.9 // Rounds per second
    , trail: 60 // Afterglow percentage
    , fps: 20 // Frames per second when using setTimeout() as a fallback for CSS
    , zIndex: 2e9 // The z-index (defaults to 2000000000)
    , className: 'spinner' // The CSS class to assign to the spinner
    , top: '30%' // Top position relative to parent
    , left: '50%' // Left position relative to parent
    , shadow: false // Whether to render a shadow
    , hwaccel: false // Whether to use hardware acceleration
    , position: 'absolute' // Element positioning
 };

var target = document.getElementById('spin');
var spinner = new Spinner(opts).spin(target);

 $('a.disable').tooltip();
 $(".disable").removeClass('delete-table-row');
 $(".disable").click(function () {
 	return false;
 });


 function checkSeccionPermisos(e, id) {
 	e.preventDefault();
 	var parent = $('#'+id+'').parent().parent().attr('id');
 	inputs =  $('#'+parent+' input')
 	inputs.each(function(i, p){
 		$(this).prop("checked", true);;
 	});
 }

 function unCheckSeccionPermisos(e,id) {
 	e.preventDefault();
 	var parent = $('#'+id+'').parent().parent().attr('id');
 	inputs =  $('#'+parent+' input');
 	console.log(inputs);
 	inputs.each(function(i, p){
 		$(this).prop("checked", false);;
 	});
 }
