$(document).ready(function () {
    $("#crear-form").validate({
        rules: {
            COD_CIUDAD: {
                required: true,
                number: true,
                maxlength: 11
            },
            TEX_NOMCIU: {
                required: true,
            },
            COD_DEPTO: {
                required: true,
            }
        },
        messages: {
            COD_CIUDAD: "El código de la Ciudad es requerido, debe contener solo números y max. 11 digitos",
            TEX_NOMCIU: "El nombre de la Ciudad es requerido",
            COD_DEPTO: "El código del Departamento es requerido",
        }
    });
//Listado de Países.
    $('#listing').DataTable({
        "bStateSave": true,
        dom: 'lBfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                title: ' - Lista Ciudades',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                },
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                title: ' - Lista Ciudades',
                header: true,
                footer: true,
                exportOptions: {
                    modifier: {
                        page: 'current'
                    }
                }
            },
            {
                extend: 'copy',
                text: 'Copiar',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                }
            }
        ],
        lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
        "scrollX": true,
        "bProcessing": true,
        "serverSide": true,
        "ajax": {
            url: baseUrl + "ciudades/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
                $("#processing").css("display", "none");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros  del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando registros  del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar Ciudad:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });
});