$(document).ready(function () {
	$("#crear-form").parsley();

//Listado de Candidatos.
$('#listing').DataTable({
	"bStateSave": true,
	dom: 'lBfrtip',
	"columns": [
	null,
	null,
	null,
	null,
	null,
	null,
	{ "width": "30%" }]
	,
	buttons: [
	{
		extend: 'excelHtml5',
		text: 'Exportar a Excel',
		title: 'Lista Candidatos',
		exportOptions: {
			modifier: {
				search: 'applied',
				order: 'applied'
			}
		},
	},
	{
		extend: 'pdf',
		text: 'Exportar a PDF',
		title: ' Lista Candidatos',
		header: true,
		footer: true,
		exportOptions: {
			modifier: {
				page: 'current'
			}
		}
	},
	{
		extend: 'copy',
		text: 'Copiar',
		exportOptions: {
			modifier: {
				search: 'applied',
				order: 'applied'
			}
		}
	}
	],
	lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
	"scrollX": true,
	"bProcessing": true,
	"serverSide": true,
	"ajax": {
            url: baseUrl + "candidatos/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
            	$("#processing").css("display", "none");
            }
         },
         "language": {
         	"sProcessing": "Procesando...",
         	"sLengthMenu": "Mostrar _MENU_ registros",
         	"sZeroRecords": "No se encontraron resultados",
         	"sEmptyTable": "Ningún dato disponible en esta tabla",
         	"sInfo": "Mostrando registros  del _START_ al _END_ de un total de _TOTAL_ registros",
         	"sInfoEmpty": "Mostrando registros  del 0 al 0 de un total de 0 registros",
         	"sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
         	"sInfoPostFix": "",
         	"sSearch": "Buscar Usuario:",
         	"sUrl": "",
         	"sInfoThousands": ",",
         	"sLoadingRecords": "Cargando...",
         	"oPaginate": {
         		"sFirst": "Primero",
         		"sLast": "Último",
         		"sNext": "Siguiente",
         		"sPrevious": "Anterior"
         	},
         	"oAria": {
         		"sSortAscending": ": Activar para ordenar la columna de manera ascendente",
         		"sSortDescending": ": Activar para ordenar la columna de manera descendente"
         	}
         }
      });
//Noty Master function
function generateNoty(layout, text, type) {
	var n = noty({
		text: text,
		type: type,
		dismissQueue: true,
		layout: layout,
		theme: 'relax',
		timeout: 4000
	});
}

$('#ID_LISTA').on('change', function(){
	var orden = $('#NUM_ORDEN').val();
	var idLista = $(this).val();
	if(orden == ''){
		alert('Debe seleccionar el orden de tarjetón');
		return false;
	}
	$.ajax({
		type: 'post',
		url: baseUrl+'candidatos/valida_orden_candidato_lista',
		data: {'id_lista':idLista, 'orden':orden},
		dataType: 'json',
		beforeSend: function () {
		},
		success: function (response) {
			if(response.error){
				generateNoty('bottomLeft', 'El número de orden del tarjetón ya ha sido asignado para esta lista', 'error');
				$('#NUM_ORDEN').focus();
			}
		},
		error: function (jqXHR, textStatus, errorThrown) {
			console.log('Código:' + jqXHR.status);
			console.log('Error AJAX: ' + textStatus);
			console.log('Tipo Error: ' + errorThrown);
		}
	})

});

});