$(document).ready(function () {
    $("#crear-form").validate({
        rules: {
            COD_DEPTO: {
                required: true,
                number: true,
                maxlength: 3
            },
            TEX_NOMDEPTO: {
                required: true,
            },
            COD_PAIS: {
                required: true,
            }
        },
        messages: {
            COD_DEPTO: "El código del Departamento es requerido, debe contener solo números y max. 3 digitos",
            TEX_NOMDEPTO: "El nombre del Departamento es requerido",
            COD_PAIS: "El código del país es requerido",
        }
    });
//Listado de Países.
    $('#listing').DataTable({
        "bStateSave": true,
        dom: 'lBfrtip',
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                title: ' - Lista Departamentos',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                },
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                title: ' - Lista Departamentos',
                header: true,
                footer: true,
                exportOptions: {
                    modifier: {
                        page: 'current'
                    }
                }
            },
            {
                extend: 'copy',
                text: 'Copiar',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    }
                }
            }
        ],
        lengthMenu: [[20, 50, 100, 100000], [20, 50, 100, "Todos"]],
        "scrollX": true,
        "bProcessing": true,
        "serverSide": true,
        "ajax": {
            url: baseUrl + "departamentos/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function () {
                $("#processing").css("display", "none");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando departamentos del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando departamentos del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar registro:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });
 

});