/**
* @author Jaime Bravo jbravo@cyberiatech.com.co
* @version 2.0
* 
*/

/**
* Envío de Ajax General.
*
* @param {String} Tipo de Envío POST o GET
* @param {String} url Método del controlador PHP
* @param {Obj} data Datos del form o del DOM en Objeto
* @returns {jqXHR} Objeto JSON que retorna.
* @example  Modo de Captura:
* var myVar = sendDataWithAjax('POST', url, data);
myVar.success(function (response) {});
*/
function sendAjax(type, url, data) {
    return  $.ajax({
        type: type,
        url: url,
        data: data,
        dataType: 'json',
        beforeSend: function () {
        },
        success: function (response) {
            
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.log('Código:' + jqXHR.status);
            console.log('Error AJAX: ' + textStatus);
            console.log('Tipo Error: ' + errorThrown);
        }
    });
}
/**
* Gráficos Barras. 
* 
* @argument data {json} Los datos.
* @argument target {string} el ID del elemento.
* @argument title {string} título del gráfico.
* @argument theme {string} Tema del gráfico. DEFAULT null.
* @type CanvasJS.Chart
*/
function gChartColumn(data, target, title, theme = null) {
    if (!theme) {
        theme = "theme2";
    }
    var gChart = new CanvasJS.Chart(target, {
        theme: theme,
        animationEnabled: true,
        title: {
            text: title
        },
        axisX:{
            labelFontSize: 10,
            labelFontColor: "#000",
            interval: 1,
            labelAngle: 90
        },
        data: [
            {
                indexLabelFontSize: 11,
                indexLabelFontColor: "red",
                type: 'column',
                toolTipContent: "{label}: <strong>{y}</strong> votos",
                dataPoints: data
            }
        ]
    });
    showDefaultText(gChart, "No hay datos disponibles");
    gChart.render();
}

function gChartBarra(data, target, title, theme = null) {
    if (!theme) {
        theme = "theme2";
    }
    var gChart = new CanvasJS.Chart(target, {
        theme: theme,
        animationEnabled: true,
        title: {
            text: title
        },
        axisX:{
            labelFontSize: 10,
            labelFontColor: "#000",
            interval: 1,
        },
        data: [
            {   indexLabelFontSize: 11,
                indexLabelFontColor: "red",
                type: 'bar',
                toolTipContent: "{label}: <strong>{y}</strong> votos",
                dataPoints: data
            }
        ]
    });
    showDefaultText(gChart, "No hay datos disponibles");
    gChart.render();
}


/**
* Gráficos Torta. 
* 
* @argument data {json} Los datos.
* @argument target {string} el ID del elemento.
* @argument title {string} título del gráfico.
* @argument theme {string} Tema del gráfico. DEFAULT null.
* @type CanvasJS.Chart
*/
function gChartTorta(data, target, title, theme = null) {
    if (!theme) {
        theme = "theme2";
    }
    var gChart = new CanvasJS.Chart(target, {
        theme: theme,
        animationEnabled: true,
        title: {
            text: title
        },
        axisX:{
            labelFontSize: 10,
            labelFontColor: "#000",
        },
        data: [
            {
                indexLabelFontSize: 11,
                indexLabelFontColor: "red",
                type: 'pie',
                toolTipContent: "{label}: {y} votos - <strong>#percent%</strong>",
                dataPoints: data
            }
        ]
    });
    showDefaultText(gChart, "No hay datos disponibles");
    gChart.render();
}

/**
* Reporte Candidatos.
* 
* @returns {undefined}
*/
function getDatosGraficosCandidatos() {
    var datosgraficosCandidatos = sendAjax('POST', 'graficos/get_graficos_general_candidatos', '');
    datosgraficosCandidatos.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}
/**
* Reporte por Agencia.#
* 
* @param {type} dataPorAgencia
* @returns {undefined}
*/
function getdatosGraficosPorAgencia(dataPorAgencia = null) {
    var dataPorAgencia = {'agencia_id': $('#agencia_id').val()};
    var datosGraficosPorAgencia = sendAjax('POST', 'graficos/get_graficos_por_agencia', dataPorAgencia);
    datosGraficosPorAgencia.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}
/**
* Reporte por agencia.
* 
* @type jqXHR
*/
function datosGraficosResumenAgencia()
{
    var datosGraficosResumenAgencia = sendAjax('POST', 'graficos/get_graficos_resumen_por_agencia');
    datosGraficosResumenAgencia.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}
/**
* Reporte por instancia.
* 
* @type jqXHR
*/
function datosGraficosPorInstancia($dataPorInstancia = null) {
    var dataPorInstancia = {'instancia_id': $('#instancia_id').val()};
    var datosGraficosPorInstancia = sendAjax('POST', 'graficos/get_graficos_por_instancia', dataPorInstancia);
    datosGraficosPorInstancia.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}

/**
* Reporte por instancia participantes.
* 
* @type jqXHR
*/
function datosGraficosPorInstanciaParticipantes($dataPorInstancia = null) {
    var dataPorInstancia = {'instancia_id': $('#instancia_id').val()};
    var datosGraficosPorInstancia = sendAjax('POST', 'graficos/get_graficos_por_instancia_participantes', dataPorInstancia);
    datosGraficosPorInstancia.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}

/**
* Reporte por instancia.
* 
* @type jqXHR
*/
function datosGraficosTodasInstanciasParticipantes() {
    var datosGraficosPorInstancia = sendAjax('POST', 'graficos/get_graficos_todas_instancias_participantes');
    datosGraficosPorInstancia.success(function (response) {
        if (response) {
            gChartColumn(response, 'chartColumn', ' Gráfico Columnas');
            gChartBarra(response, 'chartBarra', ' Gráfico Barras');
            gChartTorta(response, 'chartTorta', ' Gráfico Torta');
        }
    });
}

function showDefaultText(chart, text) {
    var isEmpty = !(chart.options.data[0].dataPoints && chart.options.data[0].dataPoints.length > 0);
    if (!chart.options.subtitles)
    (chart.options.subtitles = []);
    
    if (isEmpty)
    chart.options.subtitles.push({
        text: text,
        verticalAlign: 'center',
    });
    else
    (chart.options.subtitles = []);
}
