function sendDataWithAjax(type, url, data) {
    return $.ajax({
        type: type,
        url: url,
        data: data,
        dataType: 'json',
        beforeSend: function() {},
        success: function(response) {

        },
        error: function(jqXHR, textStatus, errorThrown) {
            console.log('Código:' + jqXHR.status);
            console.log('Error AJAX: ' + textStatus);
            console.log('Tipo Error: ' + errorThrown);
        }
    });
}

function validarVoto(id) {
    var url = baseUrl + 'participantes/validacion_voto'
    var validacion = sendDataWithAjax('post', url, { 'id': id });
    validacion.success(function(response) {
        if (response.type === 'error') {
            swal({
                title: "Error",
                text: response.message,
                icon: "error",
                button: {
                    text: "Cerrar",
                    value: true,
                    visible: false,
                },
                timer: 2000
            });
        }

        return true;

    });
    return false;

}

$(document).ready(function() {

    $("#crear-form").validate({
        rules: {
            NUM_IDETER: {
                required: true,
                number: true,

            },
            TEX_NOMPAR: {
                required: true,
            }
        },
        messages: {
            NUM_IDETER: "El número del identificación es requerido",
            TEX_NOMPAR: "El Nombre es requerido",
        }
    });

    function callBootbox(message) {
        bootbox.confirm({
            message: message,
            buttons: {
                confirm: {
                    label: 'Si',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'No',
                    className: 'btn-danger'
                }
            },
            callback: function(result) {
                if (result) {
                    window.location = baseUrl + 'participantes/desbloqueo_masivo';
                }
            }
        });
    }

    $('#desbloqueo-masivo').on('click', function(event) {
        event.preventDefault();
        callBootbox('¿Esta seguro que desea desbloquear todos lo participantes?')
    });


    $('#filtro_bloqueados').on('change', function() {
        $('#listing').DataTable().search($(this).val()).draw();
    });

    $('#listing').on('click', '.btn-enviar-mensaje', function() {
        var idUsuario = $(this).attr('id');
        $('.enlace-enviar-mensaje').attr('id', idUsuario);
        $('#modal-enviar-mensaje').modal({ keyboard: false, backdrop: 'static' })
    });


    $('.enlace-enviar-mensaje').on('click', function(e) {
        e.preventDefault();
        $('#modal-cargando-pagina').modal({ keyboard: false, backdrop: 'static' })
        var idUsuario = $(this).attr('id');
        var url = $(this).attr('href') + '/' + idUsuario;

        var validacion = sendDataWithAjax('post', url);

        validacion.success(function(response) {
            $('#modal-cargando-pagina').modal('hide');
            if (response.type === 'error') {
                swal({
                    title: "Error",
                    text: response.message,
                    icon: "error",
                    button: {
                        text: "Cerrar",
                        value: true,
                        visible: false,
                    },
                    timer: 3000
                });
            } else {
                swal({
                    title: "",
                    text: response.message,
                    icon: "success",
                    button: {
                        text: "Cerrar",
                        value: true,
                        visible: false,
                    },
                    timer: 3000
                });


            }
            return true;

        });
    });



    //Listado de Participantes.
    $('#listing').DataTable({
        "bStateSave": true,
        dom: 'lBfrtip',
        "columns": [
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            null,
            { "width": "40%" },
        ],
        buttons: [{
                extend: 'excelHtml5',
                text: 'Exportar a Excel',
                title: 'Lista Participantes',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3, 4]
                },
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                title: ' Lista Participantes',
                header: true,
                footer: true,
                exportOptions: {
                    modifier: {
                        page: 'current'
                    },
                    columns: [0, 1, 2, 3]
                }
            },
            {
                extend: 'copy',
                text: 'Copiar',
                exportOptions: {
                    modifier: {
                        search: 'applied',
                        order: 'applied'
                    },
                    columns: [0, 1, 2, 3]
                }
            }
        ],
        lengthMenu: [
            [20, 50, 100, 100000],
            [20, 50, 100, "Todos"]
        ],
        "scrollX": true,
        "bProcessing": true,
        "serverSide": true,
        "ajax": {
            url: baseUrl + "participantes/get_all", // json datasource
            type: "post", // type of method  ,GET/POST/DELETE
            error: function() {
                $("#processing").css("display", "none");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando participantes del _START_ al _END_ de un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando participantes del 0 al 0 de un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sInfoPostFix": "",
            "sSearch": "Buscar Usuario:",
            "sUrl": "",
            "sInfoThousands": ",",
            "sLoadingRecords": "Cargando...",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    });
});