SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: auth01tiposperfiles
#

DROP TABLE IF EXISTS `auth01tiposperfiles`;

CREATE TABLE `auth01tiposperfiles` (
  `COD_TIPOPERFIL` int(11) NOT NULL AUTO_INCREMENT,
  `TEXT_TIPOPERFIL` varchar(255) NOT NULL,
  `COD_CREAUSU` int(11) NOT NULL,
  `FEC_CREACION` datetime NOT NULL,
  `TEX_CREANOTA` varchar(255) NOT NULL,
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`COD_TIPOPERFIL`),
  UNIQUE KEY `TEXT_TIPOPERFIL` (`TEXT_TIPOPERFIL`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Tipos de perfiles del sistema';

INSERT INTO `auth01tiposperfiles` (`COD_TIPOPERFIL`, `TEXT_TIPOPERFIL`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 'SUPER ADMINISTRADOR', 1, '2020-04-28 17:02:26', '190.60.254.239', 1, 0);
INSERT INTO `auth01tiposperfiles` (`COD_TIPOPERFIL`, `TEXT_TIPOPERFIL`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 'ADMINISTRADORES', 0, '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `auth01tiposperfiles` (`COD_TIPOPERFIL`, `TEXT_TIPOPERFIL`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 'INFORMES', 0, '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `auth01tiposperfiles` (`COD_TIPOPERFIL`, `TEXT_TIPOPERFIL`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 'REGISTRO', 0, '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `auth01tiposperfiles` (`COD_TIPOPERFIL`, `TEXT_TIPOPERFIL`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, 'REGISTRO E INFORMES', 1, '2019-08-02 17:44:11', '190.25.101.36', 1, 1);


#
# TABLE STRUCTURE FOR: auth02perfiles
#

DROP TABLE IF EXISTS `auth02perfiles`;

CREATE TABLE `auth02perfiles` (
  `COD_PERFIL` int(11) NOT NULL AUTO_INCREMENT,
  `COD_TIPOPERFIL` int(11) NOT NULL,
  `TEX_NOMTIPO` varchar(50) NOT NULL,
  `TEX_DESCTIPO` text NOT NULL COMMENT 'Observaciones',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_PERFIL`),
  UNIQUE KEY `TEX_NOMTIPO` (`TEX_NOMTIPO`),
  KEY `COD_TIPOPERFIL` (`COD_TIPOPERFIL`),
  CONSTRAINT `FK_auth02perfiles_auth01tiposperfiles` FOREIGN KEY (`COD_TIPOPERFIL`) REFERENCES `auth01tiposperfiles` (`COD_TIPOPERFIL`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='Tipo Usuarios del sistema';

INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 1, 'SUPER ADMINISTRADOR', 'Acceso a todo el sistema\r\n', '1', '2016-10-15 02:33:14', '::1', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 2, 'ADMINISTRADOR', 'Perfil Administrador', '1', '2020-04-28 15:33:31', '181.54.0.138', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 2, 'INFORMES', 'Perfil para visualizar los informes del sistema', '1', '2020-02-06 15:56:57', '186.102.18.172', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 2, 'REGISTRO', 'Registro de participantes', '1', '2021-02-01 17:30:45', '181.62.52.107', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, 3, 'INFORMES Y REGISTRO', 'Para agente de elecciones', '1', '2019-08-02 17:56:37', '190.25.101.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, 4, 'SOLO REGISTRO DE PARTICIPANTES', 'REGISTRO DE PARTICIPANTES', '1', '2017-12-15 08:15:02', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, 3, 'REPORTE AGENCIAS', 'Solo para ver reportes de las agencias', '1', '2017-12-15 08:15:53', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8, 2, 'PARAMETROS DE VOTACION', ' listas, instancias, participantes, etc', '1', '2017-12-15 08:34:15', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (9, 1, 'ADMINISTRACION DE USUARIOS', 'Toda la administración de usuarios', '1', '2017-12-15 08:23:15', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (10, 3, 'INFORMES EN SITIO', 'inf participantes, fuera auditorio, bloqueados, etc', '1', '2017-12-15 08:33:57', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11, 2, 'REGISTRO POR ESCARAPELA', 'REGISTRO POR ESCARAPELA', '1', '2017-12-15 08:25:49', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (12, 4, 'REGISTRO SOLO INGRESOS SALIDAS', 'REGISTRO SOLO INGRESOS SALIDAS', '1', '2017-12-15 08:26:18', '177.252.245.36', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, 2, 'ADMINISTRADOR ASAMBLEA', 'ADMINISTRADOR ASAMBLEA', '1', '2021-02-09 12:44:34', '181.143.229.155', 1, 0);
INSERT INTO `auth02perfiles` (`COD_PERFIL`, `COD_TIPOPERFIL`, `TEX_NOMTIPO`, `TEX_DESCTIPO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (14, 5, 'REGISTRO E INFORMES', 'PERFIL PARA AGENTE DE ELECCIONES', '1', '2019-08-02 17:45:31', '190.25.101.36', 1, 1);


#
# TABLE STRUCTURE FOR: auth03usuarios
#

DROP TABLE IF EXISTS `auth03usuarios`;

CREATE TABLE `auth03usuarios` (
  `COD_USUARIO` int(11) NOT NULL AUTO_INCREMENT,
  `COD_PERFIL` int(11) NOT NULL,
  `TEX_NOMUSUA` varchar(255) DEFAULT NULL,
  `TEX_USUARIO` varchar(255) NOT NULL,
  `TEX_CONTRASENA` varchar(255) NOT NULL,
  `COD_AGENCIA` int(3) NOT NULL DEFAULT '0',
  `TEX_MAILUSUA` varchar(128) NOT NULL,
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_USUARIO`),
  KEY `FK_gen06usuarios_gen01agencias` (`COD_AGENCIA`),
  KEY `FK_auth03usuarios` (`COD_PERFIL`),
  CONSTRAINT `FK_auth02usuarios_gen01agencias` FOREIGN KEY (`COD_AGENCIA`) REFERENCES `gen01agencias` (`COD_AGENCIA`),
  CONSTRAINT `FK_auth03usuarios` FOREIGN KEY (`COD_PERFIL`) REFERENCES `auth02perfiles` (`COD_PERFIL`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COMMENT='Usuarios del sistema';

INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 1, 'CYBERIA TECH SAS', 'admin', '7170cb047f6a8619257ff008b3b8c60f30a5a249', 0, 'hsuarez@cyberiatech.com', '1', '2020-02-10 14:55:18', '181.143.84.226', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (37, 1, 'JAIME PIAMBA', 'jpiamba', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'jpiamba@gmail.com', '1', '2020-02-10 15:09:02', '181.143.84.226', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (39, 9, 'ADMINISTRACION USUARIOS', 'administracion_usuarios', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'administracion_usuarios@gmail.com', '1', '2020-02-10 14:38:00', '181.143.84.226', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (40, 5, 'INFORMES AGENCIA', 'informes_agencia', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'informes_agencia@gmail.com', '1', '2017-12-15 09:15:22', '177.252.245.36', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41, 13, 'ADMINISTRADOR ASAMBLEA', 'asamblea', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'asamblea1234@pgmail.com', '1', '2021-02-09 12:34:10', '181.129.169.35', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (42, 10, 'INFORMES EN SITIO', 'informes_sitio', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'informes_sitio@gmail.com', '1', '2017-12-15 09:19:38', '177.252.245.36', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (43, 8, 'PARAMETROS VOTACION', 'parametros_votacion', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'parametros_votacion@gmail.com', '1', '2017-12-15 09:21:11', '177.252.245.36', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44, 11, 'REGISTRO ESCARAPELA', 'registro_escarapela', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'registro_escarapela@gmail.com', '1', '2017-12-15 09:23:52', '177.252.245.36', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (45, 12, 'REGISTRO INGRESOS SALIDAS', 'registro_ingresos', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'registro_ingresos@gmail.com', '1', '2017-12-15 09:27:08', '177.252.245.36', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (46, 4, 'SOLO REGISTRO PARTICIPANTES', 'registro1', '4aded7e6d9432a960e22a4b672ea7e7959e82711', 0, 'registro_participantes@gmail.com', '1', '2021-02-01 17:32:19', '181.62.52.107', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47, 1, 'LINA MARIA ROMERO', 'lromero', '0125bf2ec3d7bc22835ae3b3ef686429ee6ab853', 0, 'danihernandez0827@gmail.com', '1', '2020-06-03 14:52:55', '181.54.0.138', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (48, 3, 'INFORMES', 'informes', '0125bf2ec3d7bc22835ae3b3ef686429ee6ab853', 0, 'aura@prueba.com', '1', '2020-06-19 19:31:34', '181.54.0.138', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (49, 2, 'PRUEBAS ADM', 'pruebas1', 'bfe54caa6d483cc3887dce9d1b8eb91408f1ea7a', 0, 'pruenbas1@pruebas.com', '1', '2020-04-28 15:34:47', '181.54.0.138', 1, 0);
INSERT INTO `auth03usuarios` (`COD_USUARIO`, `COD_PERFIL`, `TEX_NOMUSUA`, `TEX_USUARIO`, `TEX_CONTRASENA`, `COD_AGENCIA`, `TEX_MAILUSUA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50, 2, 'PRUEBAS', 'pruebas', '7c222fb2927d828af22f592134e8932480637c0d', 0, 'pruebas2019@cyberiatech.com.co', '1', '2019-02-07 15:50:30', '181.143.84.226', 1, 0);


#
# TABLE STRUCTURE FOR: auth04permi
#

DROP TABLE IF EXISTS `auth04permi`;

CREATE TABLE `auth04permi` (
  `COD_PERMI` int(11) NOT NULL AUTO_INCREMENT,
  `TEX_NOMPERMI` varchar(255) NOT NULL,
  `TEX_MODULO` varchar(255) NOT NULL,
  `TIPO_ACCION` varchar(255) NOT NULL,
  `TEX_LABEL` varchar(255) DEFAULT NULL,
  `IS_SISTEMA` tinyint(1) NOT NULL DEFAULT '0',
  `BOL_VOTACION` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Si pertenece al proceso de votación',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(255) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_PERMI`),
  UNIQUE KEY `TEX_NOMPERMI` (`TEX_NOMPERMI`)
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8;

INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19, 'configuracion_ver', 'configuracion', 'ver', 'Ver', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20, 'configuracion_editar', 'configuracion', 'editar', 'Editar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (22, 'paises_listar', 'paises', 'listar', 'Listar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23, 'paises_crear', 'paises', 'crear', 'Crear', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (24, 'ciudades_editar', 'ciudades', 'editar', 'Editar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25, 'perfiles_listar', 'perfiles', 'listar', 'Listar', 1, 0, '1', '2017-12-04 15:00:16', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (26, 'perfiles_crear', 'perfiles', 'crear', 'Crear', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27, 'usuarios_listar', 'usuarios', 'Listar', 'Listar', 1, 0, '1', '2017-11-23 09:31:37', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (28, 'participantes_generar_pass', 'generador_password', 'generar', 'Generar Password Masivo', 1, 0, '1', '2017-11-23 09:31:37', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (29, 'permisos_listar', 'permisos', 'listar', 'Listar', 1, 0, '1', '2017-11-23 09:33:01', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (31, 'perfiles_editar', 'perfiles', 'editar', 'Editar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (32, 'perfiles_asignar', 'perfiles', 'asignar', 'Asignar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (33, 'perfiles_activar', 'perfiles', 'activar', 'Activar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (34, 'perfiles_borrar', 'perfiles', 'borrar', 'Borrar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (35, 'participantes_crear', 'participantes', 'crear', 'Crear', 1, 0, '1', '2017-11-23 09:31:37', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (36, 'registros_crear', 'registros', 'Registrar participantes', 'Registrar Participantes', 1, 0, '1', '2017-11-23 09:33:01', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (38, 'informes_por_agencia', 'informes', 'Informe por agencia', 'Informe Por Agencia', 0, 1, '1', '2017-11-23 09:33:01', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (39, 'departamentos_listar', 'departamentos', 'listar', 'Listar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (40, 'ciudades_listar', 'ciudades', 'listar', 'Listar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (42, 'informes_resumen_votacion_usuario_registro', 'informes', 'Res votación usuario registro', 'Res Votación Usuario Registro', 0, 1, '1', '2017-11-27 14:37:37', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (43, 'agencias_listar', 'agencias', 'listar', 'Listar', 1, 0, '1', '2017-11-27 14:46:19', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44, 'textos_editar', 'textos', 'editar', 'Editar', 1, 0, '1', '2017-11-27 14:59:48', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (45, 'empresas_editar', 'empresas', 'editar', 'Editar', 1, 0, '1', '2017-11-27 15:00:15', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (46, 'instancias_listar', 'instancias', 'listar', 'Listar', 1, 0, '1', '2017-11-27 15:00:27', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47, 'listas_listar', 'listas', 'listar', 'Listar', 1, 0, '1', '2017-11-27 15:00:44', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (48, 'candidatos_listar', 'candidatos', 'listar', 'Listar', 1, 0, '1', '2017-11-27 15:00:58', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (49, 'participantes_listar', 'participantes', 'listar', 'Listar', 1, 0, '1', '2017-11-27 15:01:19', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50, 'clear_data_editar', 'clear_data', 'editar', 'Limpiar Registros', 1, 0, '1', '2017-11-27 15:01:30', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (51, 'escarapelas_editar', 'escarapelas', 'editar', 'Editar', 1, 0, '1', '2017-11-27 15:01:58', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52, 'informes_resumen_ip_por_agencia', 'informes', 'Resumen ip por agencia', 'Resumen Ip Por Agencia', 0, 1, '1', '2017-11-27 15:02:32', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (53, 'informes_informes_por_cociente', 'informes', 'Informes por cociente', 'Informes Por Cociente', 0, 1, '1', '2017-11-27 15:03:32', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54, 'informes_cociente_agencia', 'informes', 'Cociente agencia', 'Cociente Agencia', 0, 1, '1', '2017-11-27 15:03:52', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (55, 'informes_candidatos_por_agencia', 'informes', 'Candidatos por agencia', 'Candidatos Por Agencia', 0, 1, '1', '2017-11-27 15:04:11', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (56, 'informes_por_instancias', 'informes', 'Informe por instancia', 'Informe Por Instancia', 0, 1, '1', '2017-11-27 15:04:23', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (57, 'informes_general_candidatos', 'informes', 'General candidatos', 'General Candidatos', 0, 1, '1', '2017-11-27 15:04:37', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (58, 'informes_sin_participar', 'informes', 'Personas sin participar', 'Personas Sin Participar', 0, 0, '1', '2017-11-27 15:05:05', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (59, 'informes_participantes', 'informes', 'participantes', 'Participantes', 0, 0, '1', '2017-11-27 15:05:23', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (60, 'informes_personas_registradas', 'informes', 'Personas registradas', 'Personas Registradas', 0, 0, '1', '2017-11-27 15:05:36', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (61, 'informes_asistentes_habiles', 'informes', 'Asistentes hábiles', 'Asistentes Hábiles', 0, 0, '1', '2017-11-27 15:05:52', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (62, 'informes_registrados_sin_participar', 'informes', 'Registrados sin participar', 'Registrados Sin Participar', 0, 0, '1', '2017-11-27 15:06:06', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63, 'informes_personas_sin_registrarse', 'informes', 'Personas sin registrarse', 'Personas Sin Registrarse', 0, 0, '1', '2017-11-27 15:06:29', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (64, 'informes_personas_en_auditorio', 'informes', 'Personas en auditorio', 'Personas En Auditorio', 0, 0, '1', '2017-11-27 15:06:47', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (65, 'informes_personas_fuera_auditorio', 'informes', 'Personas fuera de auditorio', 'Personas Fuera De Auditorio', 0, 0, '1', '2017-11-27 15:07:02', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66, 'informes_participantes_bloqueados', 'informes', 'Participantes Bloqueados', 'Participantes Bloqueados', 0, 0, '1', '2017-11-27 15:07:17', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (67, 'participantes_editar', 'participantes', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (69, 'participantes_borrar', 'participantes', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70, 'participantes_activar', 'participantes', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73, 'ciudades_crear', 'ciudades', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (74, 'ciudades_borrar', 'ciudades', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (75, 'ciudades_activar', 'ciudades', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76, 'paises_editar', 'paises', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (78, 'paises_borrar', 'paises', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (79, 'paises_activar', 'paises', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (80, 'usuarios_editar', 'usuarios', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (82, 'usuarios_crear', 'usuarios', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (83, 'usuarios_borrar', 'usuarios', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (84, 'usuarios_activar', 'usuarios', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97, 'agencias_editar', 'agencias', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (99, 'agencias_crear', 'agencias', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (100, 'agencias_borrar', 'agencias', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (101, 'agencias_activar', 'agencias', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (102, 'candidatos_editar', 'candidatos', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (104, 'candidatos_crear', 'candidatos', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (105, 'candidatos_borrar', 'candidatos', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (106, 'candidatos_activar', 'candidatos', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (116, 'departamentos_editar', 'departamentos', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (118, 'departamentos_crear', 'departamentos', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (119, 'departamentos_borrar', 'departamentos', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (120, 'departamentos_activar', 'departamentos', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (121, 'empresas_listar', 'empresas', 'listar', 'Listar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (123, 'empresas_crear', 'empresas', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (124, 'empresas_borrar', 'empresas', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (125, 'empresas_activar', 'empresas', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (126, 'escarapelas_listar', 'escarapelas', 'listar', 'Listar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (128, 'escarapelas_crear', 'escarapelas', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (129, 'escarapelas_borrar', 'escarapelas', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (130, 'escarapelas_activar', 'escarapelas', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (140, 'ingresos_salidas_crear', 'ingresos_salidas', 'crear', 'Registrar Ingresos Salidas', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (143, 'instancias_editar', 'instancias', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (145, 'instancias_crear', 'instancias', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (146, 'instancias_borrar', 'instancias', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (147, 'instancias_activar', 'instancias', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (148, 'listas_editar', 'listas', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (150, 'listas_crear', 'listas', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (151, 'listas_borrar', 'listas', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (152, 'listas_activar', 'listas', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (153, 'log_ingresos_listar', 'log_ingresos', 'listar', 'Listar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (159, 'permisos_editar', 'permisos', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (161, 'permisos_crear', 'permisos', 'crear', 'Crear', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (162, 'permisos_borrar', 'permisos', 'borrar', 'Borrar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (163, 'permisos_activar', 'permisos', 'activar', 'Activar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (174, 'votacion_listar', 'votacion', 'listar', 'Listar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (175, 'votacion_editar', 'votacion', 'editar', 'Editar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (185, 'adicionales_accion', 'adicionales', 'accion', 'Acción', 0, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (186, 'candidatos_cargar', 'candidatos', 'cargar', 'Cargar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (188, 'informes_resumen_por_agencia', 'informes', 'Informe resumen por agencia', 'Informe Resumen Por Agencia', 0, 1, '1', '2017-11-27 15:06:06', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (190, 'tipo_perfiles_listar', 'tipo_perfiles', 'listar', 'Listar', 1, 0, '1', '2017-11-22 16:47:16', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (191, 'sistema_generar', 'sistema', 'generar', 'Generar Módulo', 1, 0, '1', '2017-12-04 15:00:16', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (202, 'permisos_asignar', 'permisos', 'asignar', 'Asignar', 1, 0, '1', '2017-11-27 20:25:58', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (203, 'instancias_previa_candidatos', 'instancias', 'previa', 'Previa Candidatos', 1, 0, '1', '2017-11-27 15:00:27', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (205, 'participantes_bloquear', 'participantes', 'boquear', 'Bloquear', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (206, 'participantes_cargar', 'participantes', 'cargar', 'Cargar', 1, 0, '1', '2017-11-27 20:25:57', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (207, 'usuarios_listar_ingresos', 'usuarios', 'Listar', 'Listar Log de Ingresos', 1, 0, '1', '2017-11-23 09:31:37', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (208, 'textos_crear', 'textos', 'crear', 'Crear', 0, 0, '1', '2018-02-14 22:51:23', '177.252.246.254', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (209, 'textos_activar', 'textos', 'activar', 'Activar', 0, 0, '1', '2018-02-14 22:51:45', '177.252.246.254', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (210, 'textos_borrar', 'textos', 'borrar', 'Borrar', 0, 0, '1', '2018-02-14 22:51:59', '177.252.246.254', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (211, 'informes_log_recordar_password', 'informes', 'log_recordar_password', 'Log Recordar Password', 0, 1, '1', '2018-02-18 16:45:15', '177.252.242.5', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (212, 'participantes_desbloqueo_masivo', 'participantes', 'desbloqueo_masivo', 'Desbloqueo masivo', 0, 1, '1', '2018-02-18 17:37:09', '177.252.242.5', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (219, 'sincronizacion_ejecutar', 'sincronizacion', 'ejecutar', 'Ejecutar', 0, 1, '1', '2018-10-30 16:06:42', '191.102.61.2', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (220, 'informes_cociente_general', 'informes', 'cociente_general', 'Informes cociente general', 0, 0, '1', '2020-02-10 15:05:07', '181.143.84.226', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (221, 'prueba_listar', 'prueba', 'listar', 'Listar', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (222, 'prueba_editar', 'prueba', 'editar', 'Editar', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (223, 'prueba_ver', 'prueba', 'ver', 'Ver', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (224, 'prueba_crear', 'prueba', 'crear', 'Crear', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (225, 'prueba_borrar', 'prueba', 'borrar', 'Borrar', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (226, 'prueba_activar', 'prueba', 'activar', 'Activar', 1, 0, '1', '2020-04-28 15:29:54', '1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (227, 'registros_cuorum', 'registros', 'cuorum', 'Cuorum', 0, 0, '1', '2020-05-31 23:16:19', '190.145.40.180', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (228, 'informes_por_instancias_candidatos', 'informes', 'por_instancias_candidatos', 'Por instancias candidatos', 0, 0, '1', '2020-06-12 17:19:45', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (229, 'informes_por_instancias_participantes', 'informes', 'por_instancias_participantes', 'Por instancias participantes', 0, 0, '1', '2020-06-12 17:22:18', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (230, 'informes_por_instancias_personas_sin_participar', 'informes', 'por_instancias_personas_sin_participar', 'Por instancias  sin participar', 0, 0, '1', '2020-06-12 17:22:13', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (231, 'informes_por_instancias_registrados_sin_participar', 'informes', 'por_instancias_registrados_sin_participar', 'Por instancias regis sin parti', 0, 0, '1', '2020-06-12 17:23:01', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (232, 'registros_contador_votos', 'registros', 'contador_votos', 'Contador votos', 0, 0, '1', '2020-06-17 22:10:49', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (233, 'registros_controles_contador_votos', 'registros', 'controles_contador_votos', 'Controles contador votos', 0, 0, '1', '2020-06-17 22:10:49', '::1', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (234, 'registros_sorteo', 'registros', 'sorteo', 'Sorteo', 0, 0, '1', '2020-06-23 00:04:05', '200.6.187.220', 1, 0);
INSERT INTO `auth04permi` (`COD_PERMI`, `TEX_NOMPERMI`, `TEX_MODULO`, `TIPO_ACCION`, `TEX_LABEL`, `IS_SISTEMA`, `BOL_VOTACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (241, 'clear_data_backup', 'clear_data', 'backup', 'Backup base de datos', 0, 0, '1', '2020-06-24 16:48:20', '::1', 1, 0);


#
# TABLE STRUCTURE FOR: auth06perfilhaspermi
#

DROP TABLE IF EXISTS `auth06perfilhaspermi`;

CREATE TABLE `auth06perfilhaspermi` (
  `COD_PERFIL` int(11) NOT NULL COMMENT 'Tipo de usuario',
  `COD_PERMI` int(11) NOT NULL,
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  KEY `FK_gen07permiusuarios_gen05tipousuarios` (`COD_PERFIL`),
  KEY `FK_gen08usuarioshaspermi_gen07permiusuarios` (`COD_PERMI`),
  CONSTRAINT `FK_auth06perfilhaspermi_auth02perfiles` FOREIGN KEY (`COD_PERFIL`) REFERENCES `auth02perfiles` (`COD_PERFIL`),
  CONSTRAINT `FK_auth06perfilhaspermi_auth04permi` FOREIGN KEY (`COD_PERMI`) REFERENCES `auth04permi` (`COD_PERMI`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Permisos de usuarios';

INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (6, 36, '2017-12-15 08:15:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 61, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 59, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 66, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 64, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 65, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 60, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 58, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 63, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (10, 62, '2017-12-15 08:30:19', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (11, 130, '2017-12-15 08:31:58', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (11, 129, '2017-12-15 08:31:58', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (11, 128, '2017-12-15 08:31:58', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (11, 51, '2017-12-15 08:31:58', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (11, 126, '2017-12-15 08:31:58', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (12, 140, '2017-12-15 08:32:09', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 101, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 100, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 99, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 97, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 43, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 147, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 146, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 145, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 143, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 46, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 203, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 152, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 151, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 150, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 148, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 47, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 106, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 105, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 186, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 104, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 102, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 48, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 70, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 205, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 69, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 206, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 35, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 67, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (8, 49, '2017-12-15 09:22:18', '1', '177.252.245.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (14, 36, '2019-08-02 17:49:01', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (14, 185, '2019-08-02 17:49:01', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (5, 36, '2019-08-02 17:56:02', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (5, 61, '2019-08-02 17:56:02', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (5, 57, '2019-08-02 17:56:02', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (5, 59, '2019-08-02 17:56:02', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (5, 60, '2019-08-02 17:56:02', '1', '190.25.101.36');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (7, 55, '2020-02-06 15:54:13', '1', '186.102.18.172');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (7, 54, '2020-02-06 15:54:13', '1', '186.102.18.172');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (7, 38, '2020-02-06 15:54:13', '1', '186.102.18.172');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (7, 52, '2020-02-06 15:54:13', '1', '186.102.18.172');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (7, 185, '2020-02-06 15:54:13', '1', '186.102.18.172');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 106, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 105, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 186, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 104, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 102, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 48, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 70, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 205, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 69, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 206, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 35, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 67, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 49, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 50, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 36, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 61, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 57, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 59, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 60, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 58, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 62, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 55, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 54, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 220, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 38, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 56, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 188, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 53, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 211, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 66, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 64, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 65, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 63, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 42, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (9, 52, '2020-02-10 15:07:05', '1', '181.143.84.226');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 101, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 100, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 99, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 97, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 43, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 147, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 146, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 145, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 143, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 46, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 203, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 106, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 105, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 186, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 104, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 102, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 48, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 70, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 205, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 69, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 206, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 35, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 67, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 49, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 50, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 36, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 140, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 219, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 61, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 55, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 54, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 220, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 57, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 38, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 56, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 188, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 53, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 211, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 59, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 66, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 64, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 65, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 60, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 58, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 63, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 62, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 42, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (2, 52, '2020-06-05 05:23:48', '1', '::1');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 36, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 227, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 140, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 61, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 59, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 60, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (3, 63, '2020-06-19 19:32:22', '1', '181.54.0.138');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 191, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 20, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 19, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 190, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 33, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 32, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 34, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 26, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 31, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 25, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 163, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 202, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 162, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 161, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 159, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 29, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 84, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 83, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 82, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 80, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 27, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 207, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 153, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 79, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 78, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 23, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 76, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 22, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 120, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 119, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 118, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 116, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 39, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 75, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 74, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 73, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 24, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 40, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 101, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 100, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 99, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 97, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 43, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 209, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 210, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 208, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 44, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 125, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 124, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 123, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 45, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 121, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 147, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 146, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 145, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 143, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 46, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 203, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 152, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 151, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 150, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 148, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 47, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 106, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 105, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 186, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 104, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 102, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 48, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 70, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 205, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 69, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 206, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 35, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 212, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 67, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 49, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 28, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 50, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 241, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 130, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 129, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 128, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 51, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 126, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 232, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 233, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 227, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 36, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 234, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 140, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 219, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 61, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 55, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 54, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 220, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 57, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 38, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 56, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 188, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 53, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 211, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 59, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 66, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 64, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 65, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 60, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 58, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 63, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 228, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 229, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 230, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 231, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 62, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 42, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 52, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (1, 185, '2020-06-24 16:57:38', '1', '200.6.187.220');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 36, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 140, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 59, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 64, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 65, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 60, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (4, 63, '2021-02-01 17:31:43', '1', '181.62.52.107');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 20, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 19, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 101, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 100, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 99, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 97, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 43, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 147, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 146, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 145, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 143, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 46, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 203, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 152, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 151, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 150, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 148, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 47, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 106, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 105, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 186, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 104, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 102, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 48, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 70, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 205, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 69, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 206, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 35, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 212, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 67, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 49, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 241, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 50, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 232, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 233, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 227, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 36, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 234, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 140, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 219, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 61, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 56, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 59, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 64, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 65, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 60, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 63, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 229, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 230, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 231, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 228, '2021-02-06 21:28:48', '1', '186.102.29.234');
INSERT INTO `auth06perfilhaspermi` (`COD_PERFIL`, `COD_PERMI`, `FEC_CREACION`, `COD_CREAUSU`, `TEX_CREANOTA`) VALUES (13, 185, '2021-02-06 21:28:48', '1', '186.102.29.234');


#
# TABLE STRUCTURE FOR: evi01general
#

DROP TABLE IF EXISTS `evi01general`;

CREATE TABLE `evi01general` (
  `ID_GENERAL` int(3) NOT NULL AUTO_INCREMENT COMMENT 'ID de la tabla',
  `NUM_VALING` varchar(1) NOT NULL DEFAULT 'W' COMMENT 'Define validacion para ingreso usuario sufragante I=Solo Identificacion, C=Solo Clave, W=Identificacion y Clave',
  `TEX_SEGMEN` varchar(3) NOT NULL DEFAULT '0' COMMENT 'Define si la segmentación es por A=Agencia, C=Ciudad y N=Ninguna.',
  `TEX_NOMSEG` varchar(40) NOT NULL DEFAULT 'AGENCIA' COMMENT 'Nombre de segmentación flexible y de acuerdo con cada cliente, por lo que de este campo se tomará el nombre para los informes y títulos alusivos al segmento por AGENCIA, ZONA, REGION, DISTRITO, Etc como sea que se deba llamar. ',
  `BOL_REGIST` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si la votación es con registro previo o no 1=Es con registro, 0= Sin registro. DEFAULT =0',
  `BOL_VALLIS` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si la votación es por listas. 1=Si es con Listas, 0= no es con Listas',
  `NUM_LISFIL` int(4) NOT NULL DEFAULT '4' COMMENT 'Define el numero de listas por fila en el tarjetón, se activa solo si BOL_VALLIS=1',
  `NUM_INLOGIN` int(4) NOT NULL DEFAULT '4' COMMENT 'Define el numero de intentos de login por parte del participantes',
  `NUM_CANFIL` int(4) NOT NULL DEFAULT '4' COMMENT 'Define el numero de candidatos por fila en el tarjetón, se activa solo si BOL_VALLIS=0',
  `BOL_BUSTAR` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si esta activo el buscadsor de candidatos en el tarjeton',
  `BOL_ACTRECCON` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si activa la opción recordar contraseña',
  `BOL_VALPIN` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si se genera PIN. 1=Se genera PIN, 0= no se genera PIN',
  `NUM_LONPIN` int(2) NOT NULL DEFAULT '4' COMMENT 'Define los intentos  máximos de login por parte del participante',
  `BOL_VALSMS` tinyint(1) DEFAULT '3' COMMENT 'Define si se envia PIN por SMS, si no se envia se debe mostrar PIN en un PopUp para pruebas, si BOL_VALPIN=0 esta opcion no se muestra. 1=Se envia, 0= no se envia ',
  `BOL_FLASHSMS` tinyint(1) NOT NULL DEFAULT '0',
  `TEX_URL_SMSAPI` varchar(250) NOT NULL DEFAULT '0',
  `TEX_USSMS` varchar(250) NOT NULL DEFAULT '0',
  `TEX_PWSMS` varchar(250) NOT NULL DEFAULT '0',
  `BOL_VALMAI` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si se envia MAIL de confirmación del voto. 1=Se envia, 0= no se envia',
  `TEX_SMTP` varchar(240) DEFAULT NULL COMMENT 'Nombre o IP SMTP, si BOL_VALMAI=0 esta opcion no se muestra',
  `TEX_PORT` int(30) DEFAULT NULL COMMENT 'Numero puesto, si BOL_VALMAI=0 esta opcion no se muestra',
  `TEX_MAINOM` varchar(240) DEFAULT NULL COMMENT 'Nombre correo utilizado como remitente, si BOL_VALMAI=0 esta opcion no se muestra',
  `TEX_MAICLA` text COMMENT 'Clave MAIL, si BOL_VALMAI=0 esta opcion no se muestra',
  `BOL_VOTBLA` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si en la instancia se activa el boton de voto en blanco. 1=Se activa, 0= no se activa',
  `BOL_GENMASESP` tinyint(1) NOT NULL DEFAULT '0',
  `BOL_ACTIINFORVOT` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Cuando se requere ocultar los informes de tipo escrutiño antes del proceso de votacion',
  `NUM_TEMPO` int(4) NOT NULL DEFAULT '0' COMMENT 'Define temporizador para el procesos, si es = 0 sera infinito',
  `BOL_TIPPW` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Tipo de password a generar 1=Alfaumérico 0=Numérico',
  `NUM_LONGPW` int(2) NOT NULL DEFAULT '5' COMMENT 'Tamaño del password',
  `TEX_OBSERVACION` varchar(240) DEFAULT NULL COMMENT 'Observaciones al registro de empresa',
  `TEX_TIPOIMPRE` enum('T','L') NOT NULL DEFAULT 'T',
  `TEX_MODSORTEO` varchar(3) NOT NULL DEFAULT 'P',
  `COD_CREAUSU` varchar(9) DEFAULT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` date NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo',
  `BOL_ACTIVAIMPREVOT` varchar(100) NOT NULL,
  `BOL_VOTPREV` varchar(100) NOT NULL DEFAULT '0',
  `BOL_CIERRA` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'BOL_CIERRA que al estar = 1 en la pantalla que se muestra al terminar el proceso de votación exitoso',
  PRIMARY KEY (`ID_GENERAL`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Parametros generales de configuracion de EVIR';

INSERT INTO `evi01general` (`ID_GENERAL`, `NUM_VALING`, `TEX_SEGMEN`, `TEX_NOMSEG`, `BOL_REGIST`, `BOL_VALLIS`, `NUM_LISFIL`, `NUM_INLOGIN`, `NUM_CANFIL`, `BOL_BUSTAR`, `BOL_ACTRECCON`, `BOL_VALPIN`, `NUM_LONPIN`, `BOL_VALSMS`, `BOL_FLASHSMS`, `TEX_URL_SMSAPI`, `TEX_USSMS`, `TEX_PWSMS`, `BOL_VALMAI`, `TEX_SMTP`, `TEX_PORT`, `TEX_MAINOM`, `TEX_MAICLA`, `BOL_VOTBLA`, `BOL_GENMASESP`, `BOL_ACTIINFORVOT`, `NUM_TEMPO`, `BOL_TIPPW`, `NUM_LONGPW`, `TEX_OBSERVACION`, `TEX_TIPOIMPRE`, `TEX_MODSORTEO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_ACTIVAIMPREVOT`, `BOL_VOTPREV`, `BOL_CIERRA`) VALUES (1, 'I', 'N', 'Asamblea', 1, 0, 8, 3, 4, 0, 0, 1, 4, 1, 0, 'https://api.masiv.co/SmsHandlers/sendhandler.ashx', 'Api_K4OGL', '2M30285ZB5', 0, 'mail.votoelectronico.co', 465, 'cyberia@votoelectronico.co', 'fbf5956ff9ba0e61b0066e6ca63d20b1dab1e85349d84c52acf34f44d9a84f613c3ba0e681d2c870c92fd459d570dfae153dc560013c9b04becfdb6e43099261B/MKU1QCs8ickqwRwzfh82giu7joVlmUeT0OD2Jv66o=', 0, 0, 0, 0, 0, 4, '', 'L', 'R', '1', '2021-03-01', '181.62.52.107', 1, '0', '1', 1);


#
# TABLE STRUCTURE FOR: evi02instan
#

DROP TABLE IF EXISTS `evi02instan`;

CREATE TABLE `evi02instan` (
  `ID_INSTAN` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo único de la instacia.',
  `TEX_NOMINS` varchar(240) DEFAULT NULL COMMENT 'Nombre instancia',
  `NUM_ORDEN` varchar(3) DEFAULT NULL COMMENT 'Orden de la instancia como será mostrada en serie',
  `NUM_MUSEIN` int(3) NOT NULL DEFAULT '1' COMMENT 'Multi selección de candidatos por instancia',
  `BOL_OBLMUL` tinyint(1) NOT NULL DEFAULT '1',
  `BOL_VOTBLA` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define si en la instancia se activa el boton de voto en blanco. 1=Se activa, 0= no se activa',
  `FEC_INIUSO` datetime NOT NULL COMMENT 'Fecha de inicio de uso de EVIR para el sufragante',
  `FEC_FINUSO` datetime NOT NULL COMMENT 'Fecha de expiración uso de EVIR para el sufragante',
  `NUM_TOTELE` int(4) DEFAULT '0' COMMENT 'número de puestos o personas a suplir, Se muestra y pide si EVI01.BOL_VALLIS = 1, se usara para el calculo del COCIENTE',
  `NUM_DECRES` int(4) NOT NULL DEFAULT '4' COMMENT 'número der  decimales a mostrar en el cociente, Se muestra y pide si EVI01.BOL_VALLIS = 1, se usara para principalmente para mostra el residuo del calculo del COCIENTE en cada LISTA',
  `TEX_OBSERVACION` text COMMENT 'Observaciones al registro de empresa',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`ID_INSTAN`),
  UNIQUE KEY `NUM_ORDEN_UNICO` (`NUM_ORDEN`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='Instancias o procesos de selección';

INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 'CONSEJO DE ADMINISTRACION', '1', 1, 0, 0, '2020-02-24 00:31:00', '2021-07-31 11:31:00', 2, 2, '', '1', '2021-02-05 21:23:58', '186.102.47.234', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 'ELECCION DELEGADOS', '2', 1, 0, 0, '2020-02-24 00:31:00', '2021-06-30 11:31:00', 5, 2, '', '1', '2021-02-08 18:09:39', '181.62.52.107', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 'APRUEBA LOS ESTADOS FINANCIEROS?', '3', 1, 0, 0, '2020-01-01 22:06:00', '2021-07-31 09:31:00', 6, 6, '', '1', '2021-02-19 09:39:12', '190.25.106.56', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 'CUAL OPCION DECIDE?', '4', 1, 0, 0, '2020-05-02 08:19:00', '2021-07-31 08:19:00', 0, 0, '', '1', '2021-02-16 11:12:55', '181.62.52.107', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, 'CUAL OPCION PARA ORDEN DEL DIA PREFIERE?', '5', 1, 0, 0, '2020-03-01 08:19:00', '2021-07-31 08:19:00', 0, 0, '', '1', '2021-02-05 21:29:28', '186.102.47.234', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, 'QUE DESEA DE ALMUERZO?', '6', 3, 0, 0, '2021-02-04 21:32:00', '2021-10-31 21:32:00', 1, 1, '', '1', '2021-03-02 21:10:55', '181.62.52.107', 0, 0);
INSERT INTO `evi02instan` (`ID_INSTAN`, `TEX_NOMINS`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `BOL_VOTBLA`, `FEC_INIUSO`, `FEC_FINUSO`, `NUM_TOTELE`, `NUM_DECRES`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, 'FUERON CLARAS LAS EXPLICACIONES DADAS?', '7', 1, 0, 0, '2021-03-01 21:11:00', '2021-08-12 21:11:00', 0, 0, '', '1', '2021-03-02 21:12:08', '181.62.52.107', 0, 0);


#
# TABLE STRUCTURE FOR: evi03listas
#

DROP TABLE IF EXISTS `evi03listas`;

CREATE TABLE `evi03listas` (
  `ID_LISTA` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo único de la lista',
  `TEX_NOMLIS` varchar(240) NOT NULL COMMENT 'Nombre Lista',
  `TEX_TIPLIS` varchar(3) NOT NULL COMMENT 'Tipo de lista',
  `TEX_FOTO` varchar(255) NOT NULL DEFAULT 'default.jpg' COMMENT 'Imagen',
  `TEX_PERLIS` varchar(255) DEFAULT 'Lista Perfil' COMMENT 'Perfil de la lista.',
  `ID_INSTAN` int(3) NOT NULL COMMENT 'Consecutivo unico de la instancia ala que pertenece la lista, se evalua solo si EVI01.BOL_VALLIS=1. EVI02INSTAN',
  `NUM_ORDEN` varchar(3) NOT NULL COMMENT 'Orden de la lista como será mostrada en el tarjeton',
  `NUM_MUSEIN` varchar(3) NOT NULL DEFAULT '1' COMMENT 'Multi selección de candidatos por instancia',
  `BOL_OBLMUL` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Selección máxima',
  `COD_CIUDAD` int(5) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad de la lista, para la segmentación valida EVI01.BOL_SEGAGE=0. GEN04CIUDAD',
  `COD_AGENCIA` int(3) NOT NULL DEFAULT '999' COMMENT 'Consecutivo o código de Agencia de la lista, para la segmentación valida EVI01.BOL_SEGAGE=1. GEN01AGENCIAS',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`ID_LISTA`),
  KEY `FK1_EVI02INSTAN` (`ID_INSTAN`),
  KEY `FK2_GEN01AGENCIAS` (`COD_AGENCIA`),
  KEY `COD_CIUDAD` (`COD_CIUDAD`),
  CONSTRAINT `FK1_EVI02INSTAN` FOREIGN KEY (`ID_INSTAN`) REFERENCES `evi02instan` (`ID_INSTAN`),
  CONSTRAINT `FK2_GEN01AGENCIAS` FOREIGN KEY (`COD_AGENCIA`) REFERENCES `gen01agencias` (`COD_AGENCIA`),
  CONSTRAINT `FK3_GEN04CIUDAD` FOREIGN KEY (`COD_CIUDAD`) REFERENCES `gen04ciudad` (`COD_CIUDAD`)
) ENGINE=InnoDB AUTO_INCREMENT=901 DEFAULT CHARSET=utf8 COMMENT='Listas q ue agrupan candidatos. ';

INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (101, 'PLANCHA 1 NORTE', 'LCC', 'uploads/listas/1.jpg', 'PLANCHA 1', 2, '1', '1', 0, 11001, 1, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (201, 'PLANCHA 2', 'LCC', 'uploads/listas/2.jpg', 'PLANCHA 2', 2, '2', '1', 0, 11001, 1, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (301, 'PLANCHA 3', 'LCC', 'uploads/listas/3.jpg', 'PLANCHA 3', 2, '3', '1', 0, 11001, 2, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (401, 'PLANCHA 4', 'LCC', 'uploads/listas/4.jpg', 'PLANCHA 4', 2, '4', '1', 0, 11001, 2, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (501, 'PLANCHA 5', 'LCC', 'uploads/listas/5.jpg', 'PLANCHA 5', 2, '5', '1', 0, 11001, 3, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (601, 'PLANCHA 6', 'LCC', 'uploads/listas/6.jpg', 'PLANCHA 6', 2, '6', '1', 0, 11001, 3, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (701, 'PLANCHA 7', 'LCC', 'uploads/listas/7.jpg', 'PLANCHA 7', 2, '7', '1', 0, 11001, 4, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi03listas` (`ID_LISTA`, `TEX_NOMLIS`, `TEX_TIPLIS`, `TEX_FOTO`, `TEX_PERLIS`, `ID_INSTAN`, `NUM_ORDEN`, `NUM_MUSEIN`, `BOL_OBLMUL`, `COD_CIUDAD`, `COD_AGENCIA`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (900, 'VOTO EN BLANCO', 'LCC', 'uploads/listas/blanco.jpg', 'VOTO EN BLANCO', 2, '8', '1', 0, 11001, 4, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);


#
# TABLE STRUCTURE FOR: evi04candidat
#

DROP TABLE IF EXISTS `evi04candidat`;

CREATE TABLE `evi04candidat` (
  `ID_CANDID` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo unico del Candidato',
  `NUM_ORDEN` varchar(3) NOT NULL COMMENT 'Orden del candidato como será mostrado en el tarjeton',
  `TEX_NOMCAN` varchar(240) NOT NULL COMMENT 'Nombre Candidato',
  `TEX_APECAN` varchar(240) DEFAULT NULL COMMENT 'Apellido Candidato',
  `TEX_FOTO` varchar(240) NOT NULL COMMENT 'ubicación y nombre fotografia (implementar filtro de la misma en el cargue para ajustar tamaño)',
  `NUM_TOVOCA` varbinary(200) NOT NULL DEFAULT '0' COMMENT 'Suma de votos obtenidos por el candidato. ENCRIPTADO',
  `ID_INSTAN` int(3) NOT NULL COMMENT 'Consecutivo unico de la instancia a la que esta vinculado el candidato, se evalua solo si EVI01.BOL_VALLIS=0. EVI02INSTAN',
  `ID_LISTA` int(3) DEFAULT NULL COMMENT 'Consecutivo unico de la Lista a la que esta vinculado el candidato,  se evalua solo si EVI01.BOL_VALLIS=1. EVI03LISTAS',
  `TEXT_TIPLIST` varchar(3) DEFAULT 'LCC' COMMENT 'Tipo de lista',
  `COD_CIUDAD` int(5) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad del candidato, para la segmentación valida EVI01.BOL_SEGAGE=0. GEN04CIUDAD',
  `COD_AGENCIA` int(3) NOT NULL DEFAULT '0' COMMENT 'Consecutivo o código de Agencia del candidato, para la segmentación valida EVI01.BOL_SEGAGE=1. GEN01AGENCIAS',
  `TEX_PERCAN` varchar(240) DEFAULT NULL COMMENT 'Perfil del candidato, este se mostrara en popup al pasar mause sobre candidato, soli se muestra si EVI01.BOL_PERCAN=1',
  `TEX_OBSERVACION` text COMMENT 'Observaciones al registro del candidato',
  `BOL_BLANCO` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si es voto en blanco',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`ID_CANDID`),
  KEY `ID_INSTAN` (`ID_INSTAN`),
  KEY `COD_AGENCIA` (`COD_AGENCIA`),
  CONSTRAINT `FK_evi04candidat_evi02instan` FOREIGN KEY (`ID_INSTAN`) REFERENCES `evi02instan` (`ID_INSTAN`),
  CONSTRAINT `FK_evi04candidat_gen01agencias` FOREIGN KEY (`COD_AGENCIA`) REFERENCES `gen01agencias` (`COD_AGENCIA`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Candidatos a elegir en el proceso';

#
# TABLE STRUCTURE FOR: evi04candidat_mr
#

DROP TABLE IF EXISTS `evi04candidat_mr`;

CREATE TABLE `evi04candidat_mr` (
  `ID_CANDID` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo unico del Candidato',
  `NUM_ORDEN` varchar(3) NOT NULL COMMENT 'Orden del candidato como será mostrado en el tarjeton',
  `TEX_NOMCAN` varchar(240) NOT NULL COMMENT 'Nombre Candidato',
  `TEX_APECAN` varchar(240) DEFAULT NULL COMMENT 'Apellido Candidato',
  `TEX_FOTO` varchar(240) NOT NULL COMMENT 'ubicación y nombre fotografia (implementar filtro de la misma en el cargue para ajustar tamaño)',
  `NUM_TOVOCA` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Suma de votos obtenidos por el candidato. ENCRIPTADO',
  `ID_INSTAN` int(3) NOT NULL COMMENT 'Consecutivo unico de la instancia a la que esta vinculado el candidato, se evalua solo si EVI01.BOL_VALLIS=0. EVI02INSTAN',
  `ID_LISTA` int(3) DEFAULT NULL COMMENT 'Consecutivo unico de la Lista a la que esta vinculado el candidato,  se evalua solo si EVI01.BOL_VALLIS=1. EVI03LISTAS',
  `TEXT_TIPLIST` varchar(3) DEFAULT 'LCC' COMMENT 'Tipo de lista',
  `COD_CIUDAD` int(5) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad del candidato, para la segmentación valida EVI01.BOL_SEGAGE=0. GEN04CIUDAD',
  `COD_AGENCIA` int(3) NOT NULL DEFAULT '0' COMMENT 'Consecutivo o código de Agencia del candidato, para la segmentación valida EVI01.BOL_SEGAGE=1. GEN01AGENCIAS',
  `TEX_PERCAN` varchar(240) DEFAULT NULL COMMENT 'Perfil del candidato, este se mostrara en popup al pasar mause sobre candidato, soli se muestra si EVI01.BOL_PERCAN=1',
  `TEX_OBSERVACION` text COMMENT 'Observaciones al registro del candidato',
  `BOL_BLANCO` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si es voto en blanco',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`ID_CANDID`),
  KEY `ID_INSTAN` (`ID_INSTAN`),
  KEY `COD_AGENCIA` (`COD_AGENCIA`)
) ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=utf8 COMMENT='Candidatos a elegir en el proceso';

INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, '1', 'REGISTRO VOTACION', 'PLANCHA 1 NORTE', 'uploads/candidatos/1.jpg', '0.00', 2, 101, 'LCL', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, '2', 'REGISTRO VOTACION', 'PLANCHA 2 SUR', 'uploads/candidatos/2.jpg', '0.00', 2, 201, 'LCL', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, '3', 'REGISTRO VOTACION', 'PLANCHA 3 ORIENTE', 'uploads/candidatos/3.jpg', '0.00', 2, 301, 'LCL', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, '4', 'REGISTRO VOTACION', 'PLANCHA 4 OCCIDNETE', 'uploads/candidatos/4.jpg', '0.00', 2, 401, 'LCL', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, '5', 'REGISTRO VOTACION', 'PLANCHA 5 CENTRO', 'uploads/candidatos/5.jpg', '0.00', 2, 501, 'LCL', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, '6', 'REGISTRO VOTACION', 'PLANCHA 6 GENERAL', 'uploads/candidatos/6.jpg', '0.00', 2, 601, 'LCL', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, '7', 'REGISTRO VOTACION', 'PLANCHA 7 ESPECIAL', 'uploads/candidatos/7.jpg', '0.00', 2, 701, 'LCL', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8, '8', 'REGISTRO VOTACION', 'VOTO EN BLANCO', 'uploads/candidatos/blanco.jpg', '0.00', 2, 900, 'LCL', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (9, '9', 'ARMANDO', 'PRUEBAS', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 2, NULL, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '2021-02-01 17:24:36', '181.62.52.107', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (10, '10', 'SANTIAGO', 'VARGAS', 'uploads/candidatos/SinFotoH.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11, '11', 'MATEO FELIPE', 'SERRATO', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (12, '12', 'NUBIA', 'VARGAS', 'uploads/candidatos/SinFotoM.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, '13', 'MATILDE', 'VURALIA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (14, '14', 'MAGDA', 'MOLINA', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15, '15', 'DANIELA', 'HERNANDEZ', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (16, '16', 'EZEQUIEL', 'VARGAS', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 2, 101, 'LCC', 11001, 1, 'Descripcion', '', 0, '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17, '17', 'MATILDE', 'SERRATO', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18, '18', 'ALBERTO', 'GRAJALES', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19, '19', 'AURA', 'CORREA', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20, '20', 'NOHORA ISABEL', 'NUNEZ LEAL', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (21, '21', 'JEFFERSON', 'RAIGOZA', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (22, '22', 'JOAN', 'CORREA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23, '23', 'ARGEMIRO', 'RAIGOZA', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (24, '24', 'CARMEN', 'CORREA', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 2, 201, 'LCC', 11001, 1, 'Descripcion', '', 0, '2', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25, '25', 'YERAL', 'MORENO', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (26, '26', 'CARLOS', 'ALQUICHIRE', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27, '27', 'MARIO', 'BOHORQUEZ DE RIOFRIO', 'uploads/candidatos/SinFotoH.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (28, '28', 'MARCOS', 'CHIPAGRA RINCON', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (29, '29', 'YULIET JOHANNA', 'HERNANDEZ DE MUNOZ', 'uploads/candidatos/SinFotoM.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (30, '30', 'DIVA FARLEY', 'PINZON HERRERA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (31, '31', 'OTILIA ', 'VALLEJO ROMERO', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (32, '32', 'MARINA ', 'SOLANO CASTILLO', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 2, 301, 'LCC', 11001, 1, 'Descripcion', '', 0, '3', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (33, '33', 'LORENZO', 'MORA MILLAN', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (34, '34', 'HERMINDA ', 'COLEY MORALES', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (35, '35', 'WILSON', 'PINEDA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (36, '36', 'MARIA DEL ROSARIO', 'RUEDA BALAGUERA', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (37, '37', 'CARMEN ANITA', 'CAMACHO DE GALINDO', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (38, '38', 'BERNARDO', 'MEJIA ARDILA', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (39, '39', 'GIOVANNY', 'GOMEZ VDA DE BENJUMEA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (40, '40', 'GUILLERMO', 'MANTILLA CAMACHO', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 2, 401, 'LCC', 11001, 1, 'Descripcion', '', 0, '4', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41, '41', 'MYRIAM ZORAIDA', 'MANTILLA CAMACHO', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (42, '42', 'OFELIO', 'MARTINEZ DE PUCHE', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (43, '43', 'WILLIAM', 'TARAZONA RUEDA', 'uploads/candidatos/SinFotoH_2.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44, '44', 'MAGOLO', 'SAENZ GONZALEZ', 'uploads/candidatos/SinFotoH.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (45, '45', 'GINO', 'SALAZAR ROMERO', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (46, '46', 'FABIOLA ', 'RUEDA DE RUEDA', 'uploads/candidatos/SinFotoM.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47, '47', 'LUZ AMPARO', 'PRADA DE RUEDA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (48, '48', 'MARIA TERESA', 'RUEDA ROJAS', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 2, 501, 'LCC', 11001, 1, 'Descripcion', '', 0, '5', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (49, '49', 'ADOLFA ', 'RUEDA ROJAS', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50, '50', 'JOSEFINO', 'WALTERO DE CORTES', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (51, '51', 'LOURDES ', 'RODRIGUEZ DE HERNANDEZ', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52, '52', 'JUAN DAVID', 'BUENO SALAZAR', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (53, '53', 'NUBIA MARIA', 'PEREZ BELTRAN', 'uploads/candidatos/SinFotoM_6.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54, '54', 'MIREYA ', 'DIAZ PEDRAZA', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (55, '55', 'ALBERTO', 'CRUZ DE TAMAYO', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (56, '56', 'NELSON ', 'HERAZO ', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 2, 601, 'LCC', 11001, 1, 'Descripcion', '', 0, '6', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (57, '57', 'CESAR TULIO', 'QUIROGA ', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (58, '58', 'GABRIELA', 'HERAZO HERNANDEZ', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (59, '59', 'OTTO', 'PENA HERNANDEZ', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (60, '60', 'YOHJANA ', 'AGUILAR ARCILA', 'uploads/candidatos/SinFotoM.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (61, '61', 'OSVALDO ', 'GALEANO URRUTIA', 'uploads/candidatos/SinFotoH_2.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (62, '62', 'PABLO ANTONIO', 'CASAS PENA', 'uploads/candidatos/SinFotoH.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63, '63', 'YANETH ', 'ARENAS ', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (64, '64', 'CLAUDIA PATRICIA', 'RUEDA PATERNINA', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (65, '65', 'JUDY YANETH', 'CHAVES CRUZ', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 2, 701, 'LCC', 11001, 1, 'Descripcion', '', 0, '7', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (100, '100', 'HENRY', 'SUAREZ', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (101, '101', 'SANTIAGO', 'VARGAS', 'uploads/candidatos/SinFotoH.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (102, '102', 'MATEO FELIPE', 'SERRATO', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (103, '103', 'NUBIA', 'VARGAS', 'uploads/candidatos/SinFotoM.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (104, '104', 'MATILDE', 'VURALIA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (105, '105', 'MAGDA', 'MOLINA', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (106, '106', 'DANIELA', 'HERNANDEZ', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (107, '107', 'EZEQUIEL', 'VARGAS', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (108, '108', 'MATILDE', 'SERRATO', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 1, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (109, '109', 'ALBERTO', 'GRAJALES', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (110, '110', 'AURA', 'CORREA', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (111, '111', 'NOHORA ISABEL', 'NUNEZ LEAL', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (112, '112', 'JEFFERSON', 'RAIGOZA', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (113, '113', 'JOAN', 'CORREA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (114, '114', 'ARGEMIRO', 'RAIGOZA', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (115, '115', 'CARMEN', 'CORREA', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (116, '116', 'YERAL', 'MORENO', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (117, '117', 'CARLOS', 'ALQUICHIRE', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 2, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (118, '118', 'MARIO', 'BOHORQUEZ DE RIOFRIO', 'uploads/candidatos/SinFotoH.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (119, '119', 'MARCOS', 'CHIPAGRA RINCON', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (120, '120', 'YULIET JOHANNA', 'HERNANDEZ DE MUNOZ', 'uploads/candidatos/SinFotoM.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (121, '121', 'DIVA FARLEY', 'PINZON HERRERA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (122, '122', 'OTILIA ', 'VALLEJO ROMERO', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (123, '123', 'MARINA ', 'SOLANO CASTILLO', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (124, '124', 'LORENZO', 'MORA MILLAN', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (125, '125', 'HERMINDA ', 'COLEY MORALES', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (126, '126', 'WILSON', 'PINEDA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 3, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (127, '127', 'MARIA DEL ROSARIO', 'RUEDA BALAGUERA', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (128, '128', 'CARMEN ANITA', 'CAMACHO DE GALINDO', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (129, '129', 'BERNARDO', 'MEJIA ARDILA', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (130, '130', 'GIOVANNY', 'GOMEZ VDA DE BENJUMEA', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (131, '131', 'GUILLERMO', 'MANTILLA CAMACHO', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (132, '132', 'MYRIAM ZORAIDA', 'MANTILLA CAMACHO', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (133, '133', 'OFELIO', 'MARTINEZ DE PUCHE', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (134, '134', 'WILLIAM', 'TARAZONA RUEDA', 'uploads/candidatos/SinFotoH_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (135, '135', 'MAGOLO', 'SAENZ GONZALEZ', 'uploads/candidatos/SinFotoH.jpg', '0.00', 1, NULL, 'LCC', 11001, 4, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (136, '136', 'GINO', 'SALAZAR ROMERO', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (137, '137', 'FABIOLA ', 'RUEDA DE RUEDA', 'uploads/candidatos/SinFotoM.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (138, '138', 'LUZ AMPARO', 'PRADA DE RUEDA', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (139, '139', 'MARIA TERESA', 'RUEDA ROJAS', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (140, '140', 'ADOLFA ', 'RUEDA ROJAS', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (141, '141', 'JOSEFINO', 'WALTERO DE CORTES', 'uploads/candidatos/SinFotoH_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (142, '142', 'LOURDES ', 'RODRIGUEZ DE HERNANDEZ', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (143, '143', 'JUAN DAVID', 'BUENO SALAZAR', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (144, '144', 'NUBIA MARIA', 'PEREZ BELTRAN', 'uploads/candidatos/SinFotoM_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 5, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (145, '145', 'MIREYA ', 'DIAZ PEDRAZA', 'uploads/candidatos/SinFotoM_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (146, '146', 'ALBERTO', 'CRUZ DE TAMAYO', 'uploads/candidatos/SinFotoH_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (147, '147', 'NELSON ', 'HERAZO ', 'uploads/candidatos/SinFotoH_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (148, '148', 'CESAR TULIO', 'QUIROGA ', 'uploads/candidatos/SinFotoH_7.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (149, '149', 'GABRIELA', 'HERAZO HERNANDEZ', 'uploads/candidatos/SinFotoM_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (150, '150', 'OTTO', 'PENA HERNANDEZ', 'uploads/candidatos/SinFotoH_8.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (151, '151', 'YOHJANA ', 'AGUILAR ARCILA', 'uploads/candidatos/SinFotoM.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (152, '152', 'OSVALDO ', 'GALEANO URRUTIA', 'uploads/candidatos/SinFotoH_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (153, '153', 'PABLO ANTONIO', 'CASAS PENA', 'uploads/candidatos/SinFotoH.jpg', '0.00', 1, NULL, 'LCC', 11001, 6, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (154, '154', 'YANETH ', 'ARENAS ', 'uploads/candidatos/SinFotoM_2.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (155, '155', 'CLAUDIA PATRICIA', 'RUEDA PATERNINA', 'uploads/candidatos/SinFotoM_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (156, '156', 'JUDY YANETH', 'CHAVES CRUZ', 'uploads/candidatos/SinFotoM_4.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (157, '157', 'JINNETH ', 'QUIROZ DE RIBON', 'uploads/candidatos/SinFotoM_5.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (158, '158', 'EUGENIO FABIAN', 'BELTRAN DE ORTEGA', 'uploads/candidatos/SinFotoH_3.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (159, '159', 'SANDRA MILENA', 'VERGARA SERNA', 'uploads/candidatos/SinFotoM_6.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (160, '160', 'VOTO', 'BLANCO CONSEJO DE ADMINISTRACION', 'uploads/candidatos/blanco.jpg', '0.00', 1, NULL, 'LCC', 11001, 7, 'descripci?n Candidato', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (200, '200', 'SI', '', 'uploads/candidatos/SI.jpg', '0.00', 3, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (201, '201', 'NO', '', 'uploads/candidatos/NO.jpg', '0.00', 3, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (202, '202', 'VOTO EN', 'BLANCO', 'uploads/candidatos/blanco.jpg', '0.00', 3, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (203, '203', 'SI', '', 'uploads/candidatos/SI.jpg', '0.00', 4, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (204, '204', 'NO', '', 'uploads/candidatos/NO.jpg', '0.00', 4, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (205, '205', 'VOTO EN', 'BLANCO', 'uploads/candidatos/blanco.jpg', '0.00', 4, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (206, '206', 'AUDITORES LDTA', '', 'uploads/candidatos/1.jpg', '0.00', 5, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (207, '207', 'AUDITORES SAS', '', 'uploads/candidatos/2.jpg', '0.00', 5, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (208, '208', 'AUDITORES SA', '', 'uploads/candidatos/3.jpg', '0.00', 5, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (209, '209', 'VOTO EN', 'BLANCO', 'uploads/candidatos/blanco.jpg', '0.00', 5, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2020-05-13 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (210, '66', 'PEDRO', 'PRUEBA', 'uploads/candidatos/210.jpg', '0.00', 2, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-01-30 17:59:49', '181.62.52.107', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (211, '1', 'BANDEJA PAISA', '', 'uploads/candidatos/211.jpg', '0.00', 6, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-02-05 21:33:58', '186.102.47.234', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (212, '2', 'CHULETA', '', 'uploads/candidatos/212.jpg', '0.00', 6, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-02-05 21:34:27', '186.102.47.234', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (213, '3', 'SANCOCHO', '', 'uploads/candidatos/213.jpg', '0.00', 6, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-02-05 21:35:05', '186.102.47.234', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (214, '4', 'ARROZ CON PPOLLO', '', 'uploads/candidatos/214.jpg', '0.00', 6, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-02-05 21:35:49', '186.102.47.234', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (215, '1', 'SI', '', 'uploads/candidatos/215.jpg', '2.00', 7, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-03-02 21:14:19', '181.62.52.107', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (216, '2', 'NO', '', 'uploads/candidatos/216.jpg', '1.00', 7, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-03-02 21:15:30', '181.62.52.107', 1, 0);
INSERT INTO `evi04candidat_mr` (`ID_CANDID`, `NUM_ORDEN`, `TEX_NOMCAN`, `TEX_APECAN`, `TEX_FOTO`, `NUM_TOVOCA`, `ID_INSTAN`, `ID_LISTA`, `TEXT_TIPLIST`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_PERCAN`, `TEX_OBSERVACION`, `BOL_BLANCO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (217, '3', 'VOTO EN BLANCO', '', 'uploads/candidatos/217.jpg', '0.00', 7, NULL, 'LCC', 11001, 1, '', '', 0, '1', '2021-03-02 21:17:13', '181.62.52.107', 1, 0);


#
# TABLE STRUCTURE FOR: evi05partic
#

DROP TABLE IF EXISTS `evi05partic`;

CREATE TABLE `evi05partic` (
  `NUM_IDETER` varchar(12) NOT NULL COMMENT 'Numero de identificacion del participante',
  `TEX_NOMPAR` varchar(240) NOT NULL COMMENT 'Nombre  tercero',
  `TEX_APEPAR` varchar(240) NOT NULL COMMENT 'Apellido tercero',
  `COD_CIUDAD` int(5) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad del candidato, para la segmentación valida EVI01.BOL_SEGAGE=0. GEN04CIUDAD',
  `COD_AGENCIA` int(3) NOT NULL DEFAULT '999' COMMENT 'Consecutivo o código de Agencia del candidato, para la segmentación valida EVI01.BOL_SEGAGE=1. GEN01AGENCIAS',
  `TEX_MAIL` varchar(128) DEFAULT NULL,
  `NUM_TELCEL` varchar(12) DEFAULT NULL COMMENT 'Número teléfono celular ',
  `NUM_INTENLOGIN` int(4) DEFAULT NULL COMMENT 'Intentos de login',
  `FEC_REGIST` datetime DEFAULT NULL COMMENT 'Fecha y hora de inicio sesion',
  `TEX_CLAVE` varchar(255) NOT NULL,
  `NUM_PESO` decimal(10,2) NOT NULL DEFAULT '1.00',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `FEC_INISES` datetime DEFAULT NULL,
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `BOL_BLOQUEADO` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si el participante ha sido bloqueado. Por defecto=0',
  `BOL_INISES` tinyint(1) NOT NULL DEFAULT '0',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`NUM_IDETER`),
  KEY `FK_evi05partic_gen04ciudad` (`COD_CIUDAD`),
  KEY `FK4_GEN01AGENCIAS` (`COD_AGENCIA`),
  CONSTRAINT `FK4_GEN01AGENCIAS` FOREIGN KEY (`COD_AGENCIA`) REFERENCES `gen01agencias` (`COD_AGENCIA`),
  CONSTRAINT `FK_evi05partic_gen04ciudad` FOREIGN KEY (`COD_CIUDAD`) REFERENCES `gen04ciudad` (`COD_CIUDAD`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sufragantes participantes en el proceso';

INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10001', 'PEDRO', 'PEREZ', 11001, 1, '', '', 0, '2021-02-16 11:12:15', '82915e4377961685decc9c25797c3eff222ea570', '1.00', '1', '2021-02-08 18:08:32', '2021-03-02 21:23:37', '181.62.52.107', 1, 0, 1, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10002', 'ANDREA SIERRA', '', 11001, 1, '', '', 0, '2021-02-16 11:12:16', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '2021-03-02 21:25:19', '181.54.0.138', 1, 0, 1, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10003', 'XIOMARA VARGAS', '', 11001, 1, '', '', 0, '2021-02-16 11:12:17', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '2021-03-02 21:25:33', '181.54.0.138', 1, 0, 1, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10004', 'SANDRA SANABRIA', '', 11001, 1, '', '', 0, '2021-02-16 11:12:19', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10005', 'VIVIANA GALEANO', '', 11001, 1, '', '', 0, '2021-02-16 11:12:20', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10006', 'ANGIE OCHOA', 'VARGAS', 11001, 1, 'henry.suarezv@gmail.com', '3163513800', 0, '2021-02-16 11:12:21', 'bc786e95a0e11c478615ec1c93df71f3fe6da439', '1.00', '1', '2021-01-25 11:05:37', '0000-00-00 00:00:00', '181.62.52.107', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10007', 'HERNAN OCHOA', '', 11001, 1, '', '', 0, '2021-02-16 11:12:22', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10008', 'VIVIANA CORTES', '', 11001, 1, '', '', 0, '2021-02-16 11:12:23', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10009', 'ANDRES HUERTAS', '', 11001, 1, '', '', 0, '2021-02-16 11:12:24', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10010', 'LUIS FERNANDO NI&&O', 'VARCHAS', 11001, 1, '', '3163513800', 0, '2021-02-16 11:12:25', '6b4142e2e97b851a319b0fcab23709b40e3fc19f', '1.00', '1', '2021-01-25 11:43:03', '0000-00-00 00:00:00', '181.62.52.107', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10011', 'FABIO CARDENAS', '', 11001, 1, '', '3014865930', 0, '2021-02-19 18:00:17', '506e6c96c4d81e254c61d69e91e0d378110f9df2', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10012', 'CLAUDIA MARIN', '', 11001, 1, '', '', 0, '2021-03-01 14:48:44', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10013', 'ALEJANDRA MONROY', '', 11001, 1, '', '', 0, '2021-03-01 14:48:47', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10014', 'AUGUSTO CORREDOR', '', 11001, 1, '', '', 0, '2021-03-01 14:48:48', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10015', 'DIEGO PINEDA', '', 11001, 1, '', '', 0, '2021-03-01 14:48:50', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10016', 'JAVIER MAURICIO ACOSTA', '', 11001, 1, '', '', 0, '2021-03-01 14:48:51', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10017', 'DIEGO ROMERO', '', 11001, 1, '', '', 0, '2021-03-01 14:48:53', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10018', 'ANDREA ROJAS', '', 11001, 1, '', '', 0, '2021-03-01 14:48:55', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10019', 'SIGUIRI BEJARANO', '', 11001, 1, '', '', 0, '2021-03-01 14:48:58', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10020', 'STEISY ORDO&&EZ', '', 11001, 1, '', '', 0, '2021-03-01 14:49:00', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10021', 'CINTHIA ORDO&&EZ', '', 11001, 1, '', '', 0, '2021-03-01 14:49:02', '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10022', 'Jhonatan Stivel Garcia Cala', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10023', 'Edwin Camilo Baquero', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10024', 'Melvin Castro S?nchez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10025', 'Johan Stevens Parada', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10026', 'Daniela Mejia Yate', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10027', 'Alexander Ruiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10028', 'KAROL YATE', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10029', 'Andrea Mejia', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10030', 'Monica Salazar', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10031', 'Maria Fernanda Salamanca', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10032', 'Alejandro L?pez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10033', 'Sindy Mancipe', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10034', 'Wemdy Meza', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:40', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10035', 'catalinacastiblancob@gmail.com', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10036', 'Andres Tenjo', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10037', 'Daniela Mejia Yate', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10038', 'Yeferson Quevedo', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10039', 'catalinacastiblancob@gmail.com', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10040', 'Judith Baron', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10041', 'Stefy Guzm?n', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10042', 'FRANCIA ELENA ALFEREZ', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10043', 'DANIELA HERN?NDEZ ARIAS', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10044', 'FRANCIA ELENA ALFEREZ', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10045', 'FRANCIA ELENA ALFEREZ', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10046', 'GARCKARO', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10047', 'Edwin Camilo Baquero Pabon', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10048', 'CLAUDIA GALEANO', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10049', 'Lina Romero', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10050', 'Omar Ahumada', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10051', 'Ginna Galeano', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10052', 'Johanna Matiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10053', 'Luis Galeano', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10054', 'Elkin Vera', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10055', 'Johanna Matiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10056', 'Luis Galeano', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10057', 'Jessica Bejarano', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10058', 'Santiago Suarez Alferez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10059', 'Ricardo Torres', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10060', 'Luis Galeano', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10061', 'X220', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10062', 'Nohra Fajardo', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10063', 'Santiago Suarez Alferez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10064', 'INGRID LOZANO', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10065', 'Rosa Castro', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10066', 'Johanna Matiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10067', 'Han Reyes', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10068', 'Alejandra Olarte', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10069', 'Karent Borda', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10070', 'Jose Sabogal', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10071', 'jeisson hernandez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10072', 'yuliana pinzon', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10073', 'jeisson hernandez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10074', 'Luz Adriana Valenzuela', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10075', 'GLORIA CRISTINA CASTRILLON AGUDELO', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10076', 'Alba Vera', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10077', 'Oscar Zu?iga', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10078', 'Oscar Vides', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10079', 'Alexander Ruiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10080', 'Camilo Castro', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10081', 'Lina Hern?ndez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10082', 'Maria Pe?a', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10083', 'Magda Molina', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10084', 'Gloria Avila', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10085', 'Anamar?a Barrag?n Contreras', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10086', 'Oscar Galeano Fajardo', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10087', 'Bibiana G?mez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10088', 'Natalia Villabon', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10089', 'Andrea Mejia', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10090', 'Julieth Pinilla Molina', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10091', 'Johanna Matiz', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10092', 'X220', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10093', 'Magda Molina', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10094', 'Oscar Galeano Fajardo', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10095', 'Lina Hern?ndez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10096', 'KAROL YATE', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10097', 'Stefy Guzm?n', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10098', 'FRANCIA ELENA ALFEREZ', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10099', 'Laura Castro', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('10100', 'Santiago Suarez Alferez', '', 11001, 1, '', '', 0, NULL, '7110eda4d09e062aa5e4a390b0a572ac0d2c0220', '1.00', '1', '2020-06-07 22:24:41', '0000-00-00 00:00:00', '181.54.0.138', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('11223344', 'PEDRO', 'PRUEBAS', 11001, 1, '', '3112334455', 0, NULL, '9c1c01dc3ac1445a500251fc34a15d3e75a849df', '1.00', '1', '2021-01-30 18:16:36', '0000-00-00 00:00:00', '181.62.52.107', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('22334455', 'PABLO', 'PRUEBA', 11001, 1, '', '3223445566', 0, NULL, '1b04f217730b9e677ec7021775bb6c2c8f8ca543', '1.00', '1', '2021-01-30 18:19:43', '0000-00-00 00:00:00', '181.62.52.107', 1, 0, 0, 0);
INSERT INTO `evi05partic` (`NUM_IDETER`, `TEX_NOMPAR`, `TEX_APEPAR`, `COD_CIUDAD`, `COD_AGENCIA`, `TEX_MAIL`, `NUM_TELCEL`, `NUM_INTENLOGIN`, `FEC_REGIST`, `TEX_CLAVE`, `NUM_PESO`, `COD_CREAUSU`, `FEC_CREACION`, `FEC_INISES`, `TEX_CREANOTA`, `BOL_ACTIVO`, `BOL_BLOQUEADO`, `BOL_INISES`, `IS_DELETE`) VALUES ('44556677', 'MAGDA', 'MOLINA', 11001, 1, 'hasunem@gmail.com', '3163513800', 0, NULL, 'c9d92497a1e93750f915bf11aefc5b2b058ae205', '1.00', '1', '2021-02-06 20:20:00', '0000-00-00 00:00:00', '190.25.106.56', 1, 0, 0, 0);


#
# TABLE STRUCTURE FOR: evi06loinpa
#

DROP TABLE IF EXISTS `evi06loinpa`;

CREATE TABLE `evi06loinpa` (
  `ID_LOINPA` int(12) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo unico del \r\n  ',
  `NUM_IDETER` varchar(20) NOT NULL COMMENT 'Numero de identificacion del participante. EVI05PARTIC',
  `NUM_TELCEL` varchar(12) NOT NULL COMMENT 'Numero de celular donde se envio PIN, , valida EVI01.BOL_VALSMS=1',
  `NUM_PINGEN` varchar(12) NOT NULL COMMENT 'PIN generado, para generar validar EVI01.BOL_VALPIN=1 y EVI01.BOL_ALFPIN CON LA LONGITUD DEFINIDA EN evi01.BOL_LONPIN',
  `FEC_INISES` datetime DEFAULT NULL COMMENT 'Fecha y hora de inicio sesion',
  `FEC_FINSES` datetime DEFAULT NULL COMMENT 'Fecha y hora de finalización sesion',
  `BOL_USADO` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Define con este registro de ingreso se hizo o no votacion. 1=Se hizo votacion, 0= No se hizo votacion',
  `TEX_IPORIG` varchar(20) DEFAULT NULL COMMENT 'IP que origina el proceso',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  PRIMARY KEY (`ID_LOINPA`),
  KEY `FK1_EVI05PARTIC` (`NUM_IDETER`),
  CONSTRAINT `FK_evi06loinpa_evi05partic` FOREIGN KEY (`NUM_IDETER`) REFERENCES `evi05partic` (`NUM_IDETER`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Log ingreso sufragantes participantes';

#
# TABLE STRUCTURE FOR: evi07audpro
#

DROP TABLE IF EXISTS `evi07audpro`;

CREATE TABLE `evi07audpro` (
  `ID_AUDPRO` int(12) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo unico de Auditoria',
  `ID_INSTAN` int(3) NOT NULL,
  `ID_CANDID` int(3) NOT NULL COMMENT 'Consecutivo unico del Candidato. EVI04CANDIDAT',
  `NUM_IDETER` varchar(12) NOT NULL COMMENT 'Numero de identificacion del participante. EVI05PARTIC',
  `FEC_PROVOT` datetime NOT NULL COMMENT 'Fecha y hora del registro',
  `TEX_IPORIG` varchar(20) NOT NULL COMMENT 'IP que origina el proceso',
  PRIMARY KEY (`ID_AUDPRO`),
  KEY `FK1_EVI04CANDIDAT` (`ID_CANDID`),
  KEY `FK2_EVI05PARTIC` (`NUM_IDETER`),
  KEY `ID_INSTAN` (`ID_INSTAN`),
  CONSTRAINT `FK_evi07audpro_evi02instan` FOREIGN KEY (`ID_INSTAN`) REFERENCES `evi02instan` (`ID_INSTAN`),
  CONSTRAINT `FK_evi07audpro_evi04candidat_mr` FOREIGN KEY (`ID_CANDID`) REFERENCES `evi04candidat_mr` (`ID_CANDID`),
  CONSTRAINT `FK_evi07audpro_evi05partic` FOREIGN KEY (`NUM_IDETER`) REFERENCES `evi05partic` (`NUM_IDETER`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COMMENT='Auditoria del proceso de votación la sumatoria de registros por candidato debe ser igual al respectivo EVI04.NUM_TOVOCA';

INSERT INTO `evi07audpro` (`ID_AUDPRO`, `ID_INSTAN`, `ID_CANDID`, `NUM_IDETER`, `FEC_PROVOT`, `TEX_IPORIG`) VALUES (29, 7, 215, '10001', '2021-03-02 21:24:39', '190.70.160.185');
INSERT INTO `evi07audpro` (`ID_AUDPRO`, `ID_INSTAN`, `ID_CANDID`, `NUM_IDETER`, `FEC_PROVOT`, `TEX_IPORIG`) VALUES (30, 7, 215, '10002', '2021-03-02 21:25:25', '190.70.160.185');
INSERT INTO `evi07audpro` (`ID_AUDPRO`, `ID_INSTAN`, `ID_CANDID`, `NUM_IDETER`, `FEC_PROVOT`, `TEX_IPORIG`) VALUES (31, 7, 216, '10003', '2021-03-02 21:25:41', '190.70.160.185');


#
# TABLE STRUCTURE FOR: evi08textos
#

DROP TABLE IF EXISTS `evi08textos`;

CREATE TABLE `evi08textos` (
  `ID_TEXTOS` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID de la tabla',
  `ID_EMPRESA` int(11) NOT NULL COMMENT 'ID de la empresa. PAR02EMPRESA',
  `TEX_VALOR` varchar(255) NOT NULL COMMENT 'Nombre del valor',
  `TEX_LABEL` varchar(255) NOT NULL COMMENT 'Texto a mostrar',
  `COD_MODULO` int(11) NOT NULL COMMENT 'Nombre del módulo al que pertenece',
  `TEX_OBSERVACION` varchar(240) DEFAULT NULL COMMENT 'Observaciones al registro',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID_TEXTOS`),
  UNIQUE KEY `TEX_TEXTO` (`TEX_VALOR`),
  KEY `FK1_textos_empresa` (`ID_EMPRESA`),
  KEY `FK_evitextos_evi10modulos` (`COD_MODULO`),
  CONSTRAINT `FK1_textos_empresa` FOREIGN KEY (`ID_EMPRESA`) REFERENCES `par02empresa` (`ID_EMPRESA`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_evitextos_evi10modulos` FOREIGN KEY (`COD_MODULO`) REFERENCES `evi10modulos` (`COD_MODULO`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='Tabla de textos del sistema';

INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 13, 'TEX_MAIASU', 'Has realizado el proceso de votación con éxito.', 23, 'Mensaje cuando el usuario ya ha realizado un proceso de votación.', '1', '2020-04-28 16:01:35', '181.54.0.138', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, 13, 'TEX_MAIMEN', 'Este es un correo de confirmación del sistema de votaciones', 23, 'Mensaje del correo que se remitirá, si PAR01GENERAL.BOL_VALMAI=0 esta opcion no se muestra', '1', '2018-02-14 21:08:01', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, 13, 'TEX_NOVIGE', 'En estos momentos están cerradas las votaciones', 23, 'Mensaje de proceso no vigente debe mostrar EVI02.FEC_INIUSO y EVI02.FEC_FINUSO', '1', '2018-02-14 21:10:15', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8, 13, 'TEX_BIENVE', 'Hola, Bienvenido al sistema de votación.', 23, 'Mensaje de bienvenida a EVIR', '1', '2018-02-14 21:11:03', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (9, 13, 'TEX_LOGIN', 'Inicio de Sesión', 6, 'Mensaje de login  EVIR', '1', '2018-02-14 21:12:00', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (10, 13, 'TEX_INLOGIN', 'Intentos de login restantes:', 6, 'Mensaje Intentos de login.', '1', '2018-02-14 21:12:55', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11, 13, 'TEX_LOGBLOQ', 'Usuario bloquedado. Ha alcanzado el múmero máximo de intentos. Contacte al administrador.', 6, 'Mensaje bloqueo usuario', '1', '2018-02-14 21:14:34', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (12, 13, 'TEX_TERMIN', 'Voto Registrado, Gracias por su participación.', 23, 'Mensaje de finalización del proceso EVIR', '1', '2021-01-28 20:33:25', '181.62.52.107', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, 13, 'TEX_ERCLNO', 'La contraseña es incorrecta', 6, 'Mensaje por error de clave incorrecto', '1', '2018-02-14 21:16:15', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (14, 13, 'TEX_ERUSNO', 'El usuario no existe en el sistema', 6, 'Mensaje por error por usuario inexistente', '1', '2018-02-14 21:17:16', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15, 13, 'TEX_ERSMS', 'No se puedo enviar el SMS', 6, 'Mensaje por error envio SMS', '1', '2018-02-14 21:18:02', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (16, 13, 'TEX_ISVOTO', 'Ya has realizado una votación previamente. Para más información contacta al administrador', 23, 'Mensaje si el usuario ya ha votado', '1', '2018-02-14 21:18:47', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17, 13, 'TEX_ERCELU', 'El celular digitado no está registrado', 6, 'Mensaje por error en celular digitado', '1', '2018-02-14 21:19:19', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18, 13, 'TEX_SMSMAILERR', 'El email o el número de celular digitado no existe en la base de datos', 6, '', '1', '2018-02-14 22:03:27', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19, 13, 'TEX_SMSPWSYS', 'La clave generada para acceso al sistema de votacion es:', 6, '', '1', '2021-01-25 11:45:20', '181.62.52.107', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20, 13, 'TEX_MAILPWASU', 'Recuperación de contraseña.', 6, '', '1', '2018-02-14 22:07:32', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (21, 13, 'TEX_MAILPWBOD', 'Una nueva contraseña para acceso al sistema Evir se ha generado.', 6, '', '1', '2018-02-14 22:08:00', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (22, 13, 'TEX_VALIPORIG', 'El sufragante no corresponde a este punto de votación, Por favor validar.', 23, 'Texto para los procesos donde se valida que el sufragante solo puede votar en el punto de votación definido para su respectiva agencia', '2', '2018-02-15 07:25:32', '177.252.245.40', 1, 1);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23, 13, 'no_inicio_proceso_votacion', 'Aun no ha iniciado el proceso de votación', 23, 'Mensaje cuando no ha iniciado el proceso de votacion', '1', '2018-02-15 12:55:27', '177.252.243.184', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (24, 13, 'TEX_MAILPWASUN', 'CLAVE DE ACCESO A PROCESO DE ELECCION', 6, 'Asunto para el envio de EMAIL en la recuperación de clave', '1', '2019-01-22 07:30:00', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25, 13, 'TEX_SMSPW', 'El pin para acceso al sistema EVIR es', 6, 'Mensaje SMS enviado al usuario con el pin de acceso', '1', '2019-10-23 22:03:27', '::1', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (26, 13, 'TEX_PARINACT', 'El participante se encuentra inactivo. Por favor comunicarse con el administrador.', 6, 'Texto que se muestra cuando el usuario esta desactivado', '1', '2020-11-17 15:06:39', '191.106.200.82', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27, 13, 'TEX_INSTA_INACTIVA', 'EL PROCESO DE VOTACION ESTA INACTIVO.', 6, ' Mensaje cuando las instancia se desactivan y el participante alcanzo a ingresar al tarjetón.', '1', '2020-06-17 10:46:10', '181.54.0.138', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (28, 13, 'TEX_VOTA_CERRADA', 'EL PROCESO DE VOTACION ESTA CERRADO', 23, 'EL PROCESO DE VOTACION ESTA CERRADO', '1', '2020-05-05 21:47:19', '190.60.254.232', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (29, 13, 'TEX_PART_FUERA_AUDI', 'No es posible acceder. Participante fuera del auditorio. Contacte al administrador.', 6, 'Texto acceso a participante fuera del auditorio.', '1', '2020-05-13 11:44:34', '190.60.254.239', 1, 0);
INSERT INTO `evi08textos` (`ID_TEXTOS`, `ID_EMPRESA`, `TEX_VALOR`, `TEX_LABEL`, `COD_MODULO`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (30, 13, 'PARTI_NO_REGIS', 'El participante no está registrado. ', 6, ' Mensaje cuando el participantes no esta registrado.', '1', '2020-05-14 16:23:47', '181.62.248.66', 1, 0);


#
# TABLE STRUCTURE FOR: evi09ingre
#

DROP TABLE IF EXISTS `evi09ingre`;

CREATE TABLE `evi09ingre` (
  `ID_INGRE` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo autoincremental',
  `NUM_IDETER` varchar(12) NOT NULL COMMENT 'Numero de identificacion del participante. EVI05PARTIC',
  `FEC_INGSAL` datetime NOT NULL COMMENT 'fecha y hora del registro de entrada o salida del participante',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo',
  PRIMARY KEY (`ID_INGRE`),
  KEY `FK_evi09ingre_evi05partic` (`NUM_IDETER`),
  CONSTRAINT `FK_evi09ingre_evi05partic` FOREIGN KEY (`NUM_IDETER`) REFERENCES `evi05partic` (`NUM_IDETER`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COMMENT='Log de ingresos y salidas del participante';

INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (1, '10001', '2021-02-16 11:12:15', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (2, '10002', '2021-02-16 11:12:16', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (3, '10003', '2021-02-16 11:12:17', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (4, '10004', '2021-02-16 11:12:19', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (5, '10005', '2021-02-16 11:12:20', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (6, '10006', '2021-02-16 11:12:21', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (7, '10007', '2021-02-16 11:12:22', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (8, '10008', '2021-02-16 11:12:23', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (9, '10009', '2021-02-16 11:12:24', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (10, '10010', '2021-02-16 11:12:25', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (11, '10010', '2021-02-19 17:35:30', '1', '190.25.106.56', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (12, '10010', '2021-02-19 17:47:24', '1', '190.25.106.56', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (13, '10011', '2021-02-19 18:00:17', '1', '190.25.106.56', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (14, '10012', '2021-03-01 14:48:44', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (15, '10013', '2021-03-01 14:48:47', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (16, '10014', '2021-03-01 14:48:48', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (17, '10015', '2021-03-01 14:48:50', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (18, '10016', '2021-03-01 14:48:51', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (19, '10017', '2021-03-01 14:48:53', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (20, '10018', '2021-03-01 14:48:55', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (21, '10019', '2021-03-01 14:48:58', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (22, '10020', '2021-03-01 14:49:00', '1', '181.62.52.107', 1);
INSERT INTO `evi09ingre` (`ID_INGRE`, `NUM_IDETER`, `FEC_INGSAL`, `COD_CREAUSU`, `TEX_CREANOTA`, `BOL_ACTIVO`) VALUES (23, '10021', '2021-03-01 14:49:02', '1', '181.62.52.107', 1);


#
# TABLE STRUCTURE FOR: evi10modulos
#

DROP TABLE IF EXISTS `evi10modulos`;

CREATE TABLE `evi10modulos` (
  `COD_MODULO` int(11) NOT NULL AUTO_INCREMENT,
  `TEX_NOMMOD` varchar(255) NOT NULL,
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`COD_MODULO`),
  UNIQUE KEY `TEX_NOMMOD` (`TEX_NOMMOD`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COMMENT='lista de modulos de la aplicacion';

INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 'participantes', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 'perfiles', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 'ciudades', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 'paises', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, 'usuarios', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, 'acceso', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, 'administrador', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8, 'agencias', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (9, 'candidatos', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (10, 'clear_data', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11, 'configuracion', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (12, 'departamentos', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, 'empresas', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (14, 'escarapelas', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15, 'informes', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (16, 'ingresos_salidas', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17, 'instancias', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18, 'listas', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19, 'log_ingresos', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20, 'permisos', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (21, 'registros', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (22, 'textos', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23, 'votacion', '1', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (24, 'adicionales', '1', '0000-00-00 00:00:00', '1', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25, 'sistema', '1', '0000-00-00 00:00:00', '1', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27, 'tipo_perfiles', '1', '0000-00-00 00:00:00', '1', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (28, 'sincronizacion', '1', '0000-00-00 00:00:00', '1', 1, 0);
INSERT INTO `evi10modulos` (`COD_MODULO`, `TEX_NOMMOD`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (29, 'prueba', '', '0000-00-00 00:00:00', '', 1, 1);


#
# TABLE STRUCTURE FOR: evi11logrecon
#

DROP TABLE IF EXISTS `evi11logrecon`;

CREATE TABLE `evi11logrecon` (
  `ID_LOGRECON` int(11) NOT NULL AUTO_INCREMENT,
  `NUM_IDETER` varchar(50) NOT NULL,
  `TEX_TIPOENVIO` varchar(50) NOT NULL,
  `TEX_IPORIG` varchar(20) NOT NULL COMMENT 'IP que origina el proceso',
  `FEC_GENERACION` datetime NOT NULL COMMENT 'Fecha de creación',
  PRIMARY KEY (`ID_LOGRECON`),
  KEY `FK_evi11logrecon_evi05partic` (`NUM_IDETER`),
  CONSTRAINT `FK_evi11logrecon_evi05partic` FOREIGN KEY (`NUM_IDETER`) REFERENCES `evi05partic` (`NUM_IDETER`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (1, '10006', 'SMS', '181.62.52.107', '2021-01-25 11:03:42');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (2, '10006', 'Email', '181.62.52.107', '2021-01-25 11:05:54');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (3, '10006', 'SMS', '181.62.52.107', '2021-01-25 11:21:43');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (4, '10011', 'SMS', '181.78.17.27', '2021-01-25 11:24:38');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (5, '10011', 'SMS', '181.129.166.178', '2021-01-25 11:29:52');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (6, '10011', 'SMS', '181.129.169.35', '2021-01-25 11:30:17');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (7, '10011', 'SMS', '181.78.17.27', '2021-01-25 11:36:43');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (8, '10011', 'SMS', '181.129.169.35', '2021-01-25 11:38:00');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (9, '10006', 'SMS', '181.62.52.107', '2021-01-25 11:42:02');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (10, '10006', 'SMS', '181.62.52.107', '2021-01-25 11:46:36');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (11, '10006', 'SMS', '181.62.52.107', '2021-01-25 11:49:01');
INSERT INTO `evi11logrecon` (`ID_LOGRECON`, `NUM_IDETER`, `TEX_TIPOENVIO`, `TEX_IPORIG`, `FEC_GENERACION`) VALUES (12, '10011', 'SMS', '181.78.17.27', '2021-01-25 11:52:31');


#
# TABLE STRUCTURE FOR: evi12gansorteo
#

DROP TABLE IF EXISTS `evi12gansorteo`;

CREATE TABLE `evi12gansorteo` (
  `NUM_POSICION` int(11) NOT NULL,
  `NUM_IDETER` varchar(12) DEFAULT NULL,
  `FEC_CREACION` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`NUM_POSICION`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `evi12gansorteo` (`NUM_POSICION`, `NUM_IDETER`, `FEC_CREACION`) VALUES (10, '10010', '2021-03-01 14:51:11');
INSERT INTO `evi12gansorteo` (`NUM_POSICION`, `NUM_IDETER`, `FEC_CREACION`) VALUES (15, NULL, '2021-03-01 14:51:09');


#
# TABLE STRUCTURE FOR: gen01agencias
#

DROP TABLE IF EXISTS `gen01agencias`;

CREATE TABLE `gen01agencias` (
  `COD_AGENCIA` int(3) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo o código de Agencia',
  `ID_EMPRESA` int(11) NOT NULL COMMENT 'consecutivo de las empresas. PAR02EMPRESA',
  `TEX_NOMAGE` varchar(60) NOT NULL COMMENT 'nombre de la Agencia',
  `NUM_TOTELE` varchar(30) NOT NULL DEFAULT '0',
  `COD_TERENC` int(9) DEFAULT '1' COMMENT 'Codigo consecutivo interno del tercero encargado de la agencia',
  `TEX_DIRAGE` varchar(60) NOT NULL COMMENT 'Direccion de la agencia',
  `TEX_TELAGE` varchar(30) DEFAULT NULL COMMENT 'Telefono de la agencia',
  `NUM_MUSEAG` int(3) NOT NULL DEFAULT '0' COMMENT 'Multi selección de candidatos definido desde la agencia, si es > 0 se toma este sino se toma el de la tabla control que sera general',
  `COD_CIUDAD` int(5) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad de la agencia',
  `TEX_IPORIG` varchar(20) NOT NULL DEFAULT '0',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_AGENCIA`),
  KEY `ID_EMPRESA` (`ID_EMPRESA`),
  KEY `FK_gen01agencias_gen04ciudad` (`COD_CIUDAD`),
  CONSTRAINT `FK1_PAR02EMPRESA_AGENCIA` FOREIGN KEY (`ID_EMPRESA`) REFERENCES `par02empresa` (`ID_EMPRESA`),
  CONSTRAINT `FK_gen01agencias_gen04ciudad` FOREIGN KEY (`COD_CIUDAD`) REFERENCES `gen04ciudad` (`COD_CIUDAD`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 COMMENT='Información de las agencias, oficinas o sucursales de la empresa';

INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (0, 13, 'TODAS', '0', 1, 'CALLE 1 NO 1 - 1', '2222222', 0, 11001, '0', '1', '2017-06-12 09:03:53', '190.156.194.151', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 13, 'AGENCIA BOGOTA', '0', 1, 'AGENCIA BOGOTA', '2222222', 0, 11001, '0', '1', '2020-02-07 16:30:22', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 13, 'AGENCIA 2 MEDELLIN', '0', 1, 'AGENCIA 2 MEDELLIN', '2222222', 2, 5001, '0', '1', '2019-02-20 16:02:38', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 13, 'AGENCIA 3 CALI', '0', 1, 'AGENCIA 3 CALI', '2222222', 0, 76001, '0', '1', '2019-02-22 09:50:14', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 13, 'AGENCIA 4 BQUILLA', '0', 1, 'AGENCIA 4 BQUILLA', '2222222', 0, 8001, '0', '1', '2017-10-12 11:46:05', '186.31.1.21', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5, 13, 'AGENCIA 5 BMANGA', '0', 1, 'AGENCIA 5 BMANGA', '2222222', 0, 68001, '0', '1', '2017-10-12 11:47:23', '186.31.1.21', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (6, 13, 'AGENCIA 6 IBAGUE', '0', 1, 'AGENCIA 6 IBAGUE', '2222222', 0, 73001, '0', '1', '2019-02-21 15:14:44', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (7, 13, 'AGENCIA 7 CUCUTA', '0', 1, 'AGENCIA 7 CUCUTA', '2222222', 0, 54001, '0', '1', '2017-10-12 11:49:26', '186.31.1.21', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8, 13, 'AGENCIA 8 NEIVA', '0', 1, 'AGENCIA 8 NEIVA', '2222222', 0, 41001, '0', '1', '2017-10-12 11:51:20', '186.31.1.21', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (9, 13, 'AGENCIA 9 MANIZALEZ', '0', 1, 'AGENCIA 9 MANIZALEZ', '2222222', 0, 17001, '0', '1', '2017-10-12 12:02:14', '186.31.1.21', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (10, 13, 'AGENCIA 10 POPAYAN', '0', 1, '1 TRABAJADORES ', '2222222', 0, 11001, '0', '1', '2019-02-21 15:18:53', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11, 13, 'AGENCIA 11 CHOCO', '0', 1, '2 BOGOTÁ (AGENCIA BOGOTÁ)', '2222222', 0, 11001, '0', '1', '2017-09-07 10:06:43', '181.62.230.127', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (12, 13, 'FACATATIVIA', '0', 1, 'CRA 3 2-48', '5939966', 19, 3, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, 13, 'COTA', '0', 1, 'CRA 3 2-48', '5939966', 20, 1, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (14, 13, 'QUIRIGUA', '0', 1, 'CRA 3 2-48', '5939966', 19, 3, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15, 13, 'CHOCONTA', '0', 1, 'CRA 3 2-48', '5939966', 20, 1, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (16, 13, 'UBATE', '0', 1, 'CRA 3 2-48', '5939966', 20, 1, '0', '1', '2019-02-21 15:15:51', '181.143.84.226', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17, 13, 'FUNZA', '0', 1, 'CRA 3 2-48', '5939966', 20, 2, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18, 13, 'FUNCIONARIOS', '0', 1, 'CRA 3 2-48', '5939966', 1, 4, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19, 13, 'ZIPAQUIRA', '0', 1, 'CRA 3 2-48', '5939966', 19, 3, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20, 13, 'CAJICA', '0', 1, 'CRA 3 2-48', '5939966', 20, 1, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (21, 13, 'SOPO', '0', 1, 'CRA 3 2-48', '5939966', 20, 1, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (22, 13, 'VILLETA', '0', 1, 'CRA 3 2-48', '5939966', 19, 3, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23, 13, 'MADRID', '0', 1, 'CRA 3 2-48', '5939966', 20, 2, '0', '1', '0000-00-00 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (160, 13, '16 PUNTO DE ATENCIÓN BARRANQUILLA', '0', 1, '16 PUNTO DE ATENCIÓN BARRANQUILLA', '2222222', 0, 8001, '0', '1', '2017-09-07 18:30:01', '181.62.230.127', 1, 0);
INSERT INTO `gen01agencias` (`COD_AGENCIA`, `ID_EMPRESA`, `TEX_NOMAGE`, `NUM_TOTELE`, `COD_TERENC`, `TEX_DIRAGE`, `TEX_TELAGE`, `NUM_MUSEAG`, `COD_CIUDAD`, `TEX_IPORIG`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (170, 13, '17 PUNTO DE ATENCIÓN TUMACO', '0', 1, '17 PUNTO DE ATENCIÓN TUMACO', '2222222', 0, 52835, '0', '1', '2017-09-07 18:30:20', '181.62.230.127', 1, 0);


#
# TABLE STRUCTURE FOR: gen02pais
#

DROP TABLE IF EXISTS `gen02pais`;

CREATE TABLE `gen02pais` (
  `COD_PAIS` varchar(3) NOT NULL COMMENT 'Codigo Pais',
  `TEX_NOMPAIS` varchar(60) NOT NULL COMMENT 'Nombre del país',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_PAIS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Información de los paises donde acciona la empresa';

INSERT INTO `gen02pais` (`COD_PAIS`, `TEX_NOMPAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('57', 'COLOMBIA', '1', '2020-04-28 15:36:36', '181.54.0.138', 1, 0);


#
# TABLE STRUCTURE FOR: gen03depto
#

DROP TABLE IF EXISTS `gen03depto`;

CREATE TABLE `gen03depto` (
  `COD_DEPTO` varchar(3) NOT NULL COMMENT 'Codigo Departamento o provincia de la agencia',
  `TEX_NOMDEPTO` varchar(60) NOT NULL COMMENT 'nombre del Departamento',
  `COD_PAIS` varchar(3) NOT NULL COMMENT 'Codigo Pais del Departamento',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_DEPTO`),
  KEY `FK_gen03depto_gen02pais` (`COD_PAIS`),
  CONSTRAINT `FK_gen03depto_gen02pais` FOREIGN KEY (`COD_PAIS`) REFERENCES `gen02pais` (`COD_PAIS`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Información de los departamentos, distritos o estado';

INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('05', 'ANTIOQUIA', '57', '1', '2020-04-28 15:37:13', '181.54.0.138', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('08', 'ATLANTICO', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('11', 'BOGOTA D.C', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('13', 'BOLIVAR', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('15', 'BOYACA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('17', 'CALDAS', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('18', 'CAQUETA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('19', 'CAUCA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('20', 'CESAR', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('212', 'QEWQEQWE', '57', '1', '2016-11-10 12:03:48', '::1', 1, 1);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('23', 'CORDOBA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('25', 'CUNDINAMARCA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('27', 'CHOCO', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('41', 'HUILA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('44', 'LA GUAJIRA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('47', 'MAGDALENA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('50', 'META', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('52', 'NARIÃ‘O', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('54', 'NTE DE SANTANDER', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('63', 'QUINDIO', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('66', 'RISARALDA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('68', 'SANTANDER', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('70', 'SUCRE', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('73', 'TOLIMA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('76', 'VALLE DEL CAUCA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('81', 'ARAUCA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('85', 'CASANARE', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('86', 'PUTUMAYO', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('88', 'ARCHIPIELAGO DE SAN ANDRES, PROVIDENCIA Y SANTA CATALINA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('91', 'AMAZONAS', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('94', 'GUAINIA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('95', 'GUAVIARE', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('97', 'VAUPES', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('99', 'VICHADA', '57', '2', '0000-00-00 00:00:00', '', 1, 0);
INSERT INTO `gen03depto` (`COD_DEPTO`, `TEX_NOMDEPTO`, `COD_PAIS`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES ('999', 'SIN DEFINIR', '57', '1', '0000-00-00 00:00:00', 'N/A', 1, 0);


#
# TABLE STRUCTURE FOR: gen04ciudad
#

DROP TABLE IF EXISTS `gen04ciudad`;

CREATE TABLE `gen04ciudad` (
  `COD_CIUDAD` int(11) NOT NULL COMMENT 'Codigo Ciudad',
  `TEX_NOMCIU` varchar(60) NOT NULL COMMENT 'nombre de la Ciudad',
  `COD_DEPTO` varchar(3) NOT NULL COMMENT 'Codigo Departamento o provincia de la ciudad',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`COD_CIUDAD`),
  KEY `COD_DEPTO` (`COD_DEPTO`),
  CONSTRAINT `FK1_DEPARTAMENTO` FOREIGN KEY (`COD_DEPTO`) REFERENCES `gen03depto` (`COD_DEPTO`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Información de las Ciudades y municipios';

INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (1, 'ZONA UNO', '25', '1', '2020-04-28 15:37:36', '181.54.0.138', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (2, 'ZONA DOS', '25', '1', '2019-02-04 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (3, 'ZONA TRES', '25', '1', '2019-02-04 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (4, 'ZONA CUATRO', '25', '1', '2019-02-04 00:00:00', '127.0.0.1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5001, 'MEDELLIN', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5002, 'ABEJORRAL', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5004, 'ABRIAQUI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5021, 'ALEJANDRIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5030, 'AMAGA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5031, 'AMALFI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5036, 'ANGELOPOLIS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5038, 'ANGOSTURA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5040, 'ANORI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5042, 'SANTAFE DE ANTIOQUIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5044, 'ANZA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5045, 'APARTADO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5051, 'ARBOLETES', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5055, 'ARGELIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5059, 'ARMENIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5079, 'BARBOSA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5086, 'BELMIRA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5088, 'BELLO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5091, 'BETANIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5093, 'BETULIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5101, 'CIUDAD BOLIVAR', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5107, 'BRICEÑO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5113, 'BURITICA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5120, 'CACERES', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5125, 'CAICEDO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5129, 'CALDAS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5134, 'CAMPAMENTO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5138, 'CAÑASGORDAS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5142, 'CARACOLI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5145, 'CARAMANTA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5147, 'CAREPA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5148, 'EL CARMEN DE VIBORAL', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5150, 'CAROLINA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5154, 'CAUCASIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5172, 'CHIGORODO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5190, 'CISNEROS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5197, 'COCORNA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5206, 'CONCEPCION', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5209, 'CONCORDIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5212, 'COPACABANA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5234, 'DABEIBA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5237, 'DON MATIAS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5240, 'EBEJICO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5250, 'EL BAGRE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5264, 'ENTRERRIOS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5266, 'ENVIGADO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5282, 'FREDONIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5284, 'FRONTINO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5306, 'GIRALDO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5308, 'GIRARDOTA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5310, 'GOMEZ PLATA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5313, 'GRANADA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5315, 'GUADALUPE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5318, 'GUARNE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5321, 'GUATAPE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5347, 'HELICONIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5353, 'HISPANIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5360, 'ITAGUI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5361, 'ITUANGO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5364, 'JARDIN', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5368, 'JERICO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5376, 'LA CEJA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5380, 'LA ESTRELLA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5390, 'LA PINTADA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5400, 'LA UNION', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5411, 'LIBORINA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5425, 'MACEO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5440, 'MARINILLA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5467, 'MONTEBELLO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5475, 'MURINDO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5480, 'MUTATA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5483, 'NARIÑO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5490, 'NECOCLI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5495, 'NECHI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5501, 'OLAYA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5541, 'PEÑOL', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5543, 'PEQUE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5576, 'PUEBLORRICO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5579, 'PUERTO BERRIO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5585, 'PUERTO NARE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5591, 'PUERTO TRIUNFO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5604, 'REMEDIOS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5607, 'RETIRO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5615, 'RIONEGRO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5628, 'SABANALARGA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5631, 'SABANETA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5642, 'SALGAR', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5647, 'SAN ANDRES', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5649, 'SAN CARLOS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5652, 'SAN FRANCISCO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5656, 'SAN JERONIMO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5658, 'SAN JOSE DE LA MONTAÑA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5659, 'SAN JUAN DE URABA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5660, 'SAN LUIS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5664, 'SAN PEDRO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5665, 'SAN PEDRO DE URABA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5667, 'SAN RAFAEL', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5670, 'SAN ROQUE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5674, 'SAN VICENTE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5679, 'SANTA BARBARA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5686, 'SANTA ROSA DE OSOS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5690, 'SANTO DOMINGO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5697, 'EL SANTUARIO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5736, 'SEGOVIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5756, 'SONSON', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5761, 'SOPETRAN', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5789, 'TAMESIS', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5790, 'TARAZA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5792, 'TARSO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5809, 'TITIRIBI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5819, 'TOLEDO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5837, 'TURBO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5842, 'URAMITA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5847, 'URRAO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5854, 'VALDIVIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5856, 'VALPARAISO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5858, 'VEGACHI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5861, 'VENECIA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5873, 'VIGIA DEL FUERTE', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5885, 'YALI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5887, 'YARUMAL', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5890, 'YOLOMBO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5893, 'YONDO', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (5895, 'ZARAGOZA', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8001, 'BARRANQUILLA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8078, 'BARANOA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8137, 'CAMPO DE LA CRUZ', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8141, 'CANDELARIA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8296, 'GALAPA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8372, 'JUAN DE ACOSTA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8421, 'LURUACO', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8433, 'MALAMBO', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8436, 'MANATI', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8520, 'PALMAR DE VARELA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8549, 'PIOJO', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8558, 'POLONUEVO', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8560, 'PONEDERA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8573, 'PUERTO COLOMBIA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8606, 'REPELON', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8634, 'SABANAGRANDE', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8638, 'SABANALARGA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8675, 'SANTA LUCIA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8685, 'SANTO TOMAS', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8758, 'SOLEDAD', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8770, 'SUAN', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8832, 'TUBARA', '08', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (8849, 'USIACURI', '05', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (11001, 'BOGOTA', '11', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13001, 'CARTAGENA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13006, 'ACHI', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13030, 'ALTOS DEL ROSARIO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13042, 'ARENAL', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13052, 'ARJONA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13062, 'ARROYOHONDO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13074, 'BARRANCO DE LOBA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13140, 'CALAMAR', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13160, 'CANTAGALLO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13188, 'CICUCO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13212, 'CORDOBA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13222, 'CLEMENCIA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13244, 'EL CARMEN DE BOLIVAR', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13248, 'EL GUAMO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13268, 'EL PEÑON', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13300, 'HATILLO DE LOBA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13430, 'MAGANGUE', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13433, 'MAHATES', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13440, 'MARGARITA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13442, 'MARIA LA BAJA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13458, 'MONTECRISTO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13468, 'MOMPOS', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13473, 'MORALES', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13549, 'PINILLOS', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13580, 'REGIDOR', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13600, 'RIO VIEJO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13620, 'SAN CRISTOBAL', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13647, 'SAN ESTANISLAO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13650, 'SAN FERNANDO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13654, 'SAN JACINTO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13655, 'SAN JACINTO DEL CAUCA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13657, 'SAN JUAN NEPOMUCENO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13667, 'SAN MARTIN DE LOBA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13670, 'SAN PABLO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13673, 'SANTA CATALINA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13683, 'SANTA ROSA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13688, 'SANTA ROSA DEL SUR', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13744, 'SIMITI', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13760, 'SOPLAVIENTO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13780, 'TALAIGUA NUEVO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13810, 'TIQUISIO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13836, 'TURBACO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13838, 'TURBANA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13873, 'VILLANUEVA', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13894, 'ZAMBRANO', '13', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15001, 'TUNJA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15022, 'ALMEIDA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15047, 'AQUITANIA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15051, 'ARCABUCO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15087, 'BELEN', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15090, 'BERBEO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15092, 'BETEITIVA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15097, 'BOAVITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15104, 'BOYACA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15106, 'BRICEÑO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15109, 'BUENAVISTA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15114, 'BUSBANZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15131, 'CALDAS', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15135, 'CAMPOHERMOSO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15162, 'CERINZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15172, 'CHINAVITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15176, 'CHIQUINQUIRA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15180, 'CHISCAS', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15183, 'CHITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15185, 'CHITARAQUE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15187, 'CHIVATA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15189, 'CIENEGA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15204, 'COMBITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15212, 'COPER', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15215, 'CORRALES', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15218, 'COVARACHIA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15223, 'CUBARA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15224, 'CUCAITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15226, 'CUITIVA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15232, 'CHIQUIZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15236, 'CHIVOR', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15238, 'DUITAMA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15244, 'EL COCUY', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15248, 'EL ESPINO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15272, 'FIRAVITOBA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15276, 'FLORESTA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15293, 'GACHANTIVA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15296, 'GAMEZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15299, 'GARAGOA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15317, 'GUACAMAYAS', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15322, 'GUATEQUE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15325, 'GUAYATA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15332, 'GÜICAN', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15362, 'IZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15367, 'JENESANO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15368, 'JERICO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15377, 'LABRANZAGRANDE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15380, 'LA CAPILLA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15401, 'LA VICTORIA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15403, 'LA UVITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15407, 'VILLA DE LEYVA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15425, 'MACANAL', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15442, 'MARIPI', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15455, 'MIRAFLORES', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15464, 'MONGUA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15466, 'MONGUI', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15469, 'MONIQUIRA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15476, 'MOTAVITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15480, 'MUZO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15491, 'NOBSA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15494, 'NUEVO COLON', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15500, 'OICATA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15507, 'OTANCHE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15511, 'PACHAVITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15514, 'PAEZ', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15516, 'PAIPA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15518, 'PAJARITO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15522, 'PANQUEBA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15531, 'PAUNA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15533, 'PAYA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15537, 'PAZ DE RIO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15542, 'PESCA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15550, 'PISBA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15572, 'PUERTO BOYACA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15580, 'QUIPAMA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15599, 'RAMIRIQUI', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15600, 'RAQUIRA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15621, 'RONDON', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15632, 'SABOYA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15638, 'SACHICA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15646, 'SAMACA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15660, 'SAN EDUARDO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15664, 'SAN JOSE DE PARE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15667, 'SAN LUIS DE GACENO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15673, 'SAN MATEO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15676, 'SAN MIGUEL DE SEMA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15681, 'SAN PABLO DE BORBUR', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15686, 'SANTANA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15690, 'SANTA MARIA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15693, 'SANTA ROSA DE VITERBO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15696, 'SANTA SOFIA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15720, 'SATIVANORTE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15723, 'SATIVASUR', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15740, 'SIACHOQUE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15753, 'SOATA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15755, 'SOCOTA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15757, 'SOCHA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15759, 'SOGAMOSO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15761, 'SOMONDOCO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15762, 'SORA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15763, 'SOTAQUIRA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15764, 'SORACA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15774, 'SUSACON', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15776, 'SUTAMARCHAN', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15778, 'SUTATENZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15790, 'TASCO', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15798, 'TENZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15804, 'TIBANA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15806, 'TIBASOSA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15808, 'TINJACA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15810, 'TIPACOQUE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15814, 'TOCA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15816, 'TOGÜI', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15820, 'TOPAGA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15822, 'TOTA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15832, 'TUNUNGUA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15835, 'TURMEQUE', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15837, 'TUTA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15839, 'TUTAZA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15842, 'UMBITA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15861, 'VENTAQUEMADA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15879, 'VIRACACHA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (15897, 'ZETAQUIRA', '15', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17001, 'MANIZALES', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17013, 'AGUADAS', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17042, 'ANSERMA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17050, 'ARANZAZU', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17088, 'BELALCAZAR', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17174, 'CHINCHINA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17272, 'FILADELFIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17380, 'LA DORADA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17388, 'LA MERCED', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17433, 'MANZANARES', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17442, 'MARMATO', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17444, 'MARQUETALIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17446, 'MARULANDA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17486, 'NEIRA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17495, 'NORCASIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17513, 'PACORA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17524, 'PALESTINA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17541, 'PENSILVANIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17614, 'RIOSUCIO', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17616, 'RISARALDA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17653, 'SALAMINA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17662, 'SAMANA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17665, 'SAN JOSE', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17777, 'SUPIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17867, 'VICTORIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17873, 'VILLAMARIA', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (17877, 'VITERBO', '17', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18001, 'FLORENCIA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18029, 'ALBANIA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18094, 'BELEN DE LOS ANDAQUIES', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18150, 'CARTAGENA DEL CHAIRA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18205, 'CURILLO', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18247, 'EL DONCELLO', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18256, 'EL PAUJIL', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18410, 'LA MONTAÑITA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18460, 'MILAN', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18479, 'MORELIA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18592, 'PUERTO RICO', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18610, 'SAN JOSE DEL FRAGUA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18753, 'SAN VICENTE DEL CAGUAN', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18756, 'SOLANO', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18785, 'SOLITA', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (18860, 'VALPARAISO', '18', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19001, 'POPAYAN', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19022, 'ALMAGUER', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19050, 'ARGELIA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19075, 'BALBOA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19100, 'BOLIVAR', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19110, 'BUENOS AIRES', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19130, 'CAJIBIO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19137, 'CALDONO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19142, 'CALOTO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19212, 'CORINTO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19256, 'EL TAMBO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19290, 'FLORENCIA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19318, 'GUAPI', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19355, 'INZA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19364, 'JAMBALO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19392, 'LA SIERRA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19397, 'LA VEGA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19418, 'LOPEZ', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19450, 'MERCADERES', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19455, 'MIRANDA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19473, 'MORALES', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19513, 'PADILLA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19517, 'PAEZ', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19532, 'PATIA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19533, 'PIAMONTE', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19548, 'PIENDAMO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19573, 'PUERTO TEJADA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19585, 'PURACE', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19622, 'ROSAS', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19693, 'SAN SEBASTIAN', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19698, 'SANTANDER DE QUILICHAO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19701, 'SANTA ROSA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19743, 'SILVIA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19760, 'SOTARA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19780, 'SUAREZ', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19785, 'SUCRE', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19807, 'TIMBIO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19809, 'TIMBIQUI', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19821, 'TORIBIO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19824, 'TOTORO', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (19845, 'VILLA RICA', '19', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20001, 'VALLEDUPAR', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20011, 'AGUACHICA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20013, 'AGUSTIN CODAZZI', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20032, 'ASTREA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20045, 'BECERRIL', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20060, 'BOSCONIA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20175, 'CHIMICHAGUA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20178, 'CHIRIGUANA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20228, 'CURUMANI', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20238, 'EL COPEY', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20250, 'EL PASO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20295, 'GAMARRA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20310, 'GONZALEZ', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20383, 'LA GLORIA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20400, 'LA JAGUA DE IBIRICO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20443, 'MANAURE', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20517, 'PAILITAS', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20550, 'PELAYA', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20570, 'PUEBLO BELLO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20614, 'RIO DE ORO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20621, 'LA PAZ', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20710, 'SAN ALBERTO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20750, 'SAN DIEGO', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20770, 'SAN MARTIN', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (20787, 'TAMALAMEQUE', '20', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23001, 'MONTERIA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23068, 'AYAPEL', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23079, 'BUENAVISTA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23090, 'CANALETE', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23162, 'CERETE', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23168, 'CHIMA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23182, 'CHINU', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23189, 'CIENAGA DE ORO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23300, 'COTORRA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23350, 'LA APARTADA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23417, 'LORICA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23419, 'LOS CORDOBAS', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23464, 'MOMIL', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23466, 'MONTELIBANO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23500, 'MOÑITOS', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23555, 'PLANETA RICA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23570, 'PUEBLO NUEVO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23574, 'PUERTO ESCONDIDO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23580, 'PUERTO LIBERTADOR', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23586, 'PURISIMA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23660, 'SAHAG/N', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23670, 'SAN ANDRES SOTAVENTO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23672, 'SAN ANTERO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23675, 'SAN BERNARDO DEL VIENTO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23678, 'SAN CARLOS', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23686, 'SAN PELAYO', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23807, 'TIERRALTA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (23855, 'VALENCIA', '23', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25001, 'AGUA DE DIOS', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25019, 'ALBAN', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25035, 'ANAPOIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25040, 'ANOLAIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25053, 'ARBELAEZ', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25086, 'BELTRAN', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25095, 'BITUIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25099, 'BOJACA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25120, 'CABRERA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25123, 'CACHIPAY', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25126, 'CAJICA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25148, 'CAPARRAPI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25151, 'CAQUEZA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25154, 'CARMEN DE CARUPA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25168, 'CHAGUANI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25175, 'CHIA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25178, 'CHIPAQUE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25181, 'CHOACHI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25183, 'CHOCONTA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25200, 'COGUA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25214, 'COTA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25224, 'CUCUNUBA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25245, 'EL COLEGIO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25258, 'EL PEÑON', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25260, 'EL ROSAL', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25269, 'FACATATIVA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25279, 'FOMEQUE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25281, 'FOSCA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25286, 'FUNZA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25288, 'F/QUENE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25290, 'FUSAGASUGA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25293, 'GACHALA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25295, 'GACHANCIPA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25297, 'GACHETA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25299, 'GAMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25307, 'GIRARDOT', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25312, 'GRANADA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25317, 'GUACHETA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25320, 'GUADUAS', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25322, 'GUASCA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25324, 'GUATAQUI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25326, 'GUATAVITA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25328, 'GUAYABAL DE SIQUIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25335, 'GUAYABETAL', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25339, 'GUTIERREZ', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25368, 'JERUSALEN', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25372, 'JUNIN', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25377, 'LA CALERA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25386, 'LA MESA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25394, 'LA PALMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25398, 'LA PEÑA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25402, 'LA VEGA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25407, 'LENGUAZAQUE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25426, 'MACHETA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25430, 'MADRID', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25436, 'MANTA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25438, 'MEDINA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25473, 'MOSQUERA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25483, 'NARIÑO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25486, 'NEMOCON', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25488, 'NILO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25489, 'NIMAIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25491, 'NOCAIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25506, 'VENECIA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25513, 'PACHO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25518, 'PAIME', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25524, 'PANDI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25530, 'PARATEBUENO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25535, 'PASCA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25572, 'PUERTO SALGAR', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25580, 'PULI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25592, 'QUEBRADANEGRA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25594, 'QUETAME', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25596, 'QUIPILE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25599, 'APULO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25612, 'RICAURTE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25645, 'SAN ANTONIO DEL TEQUENDAMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25649, 'SAN BERNARDO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25653, 'SAN CAYETANO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25658, 'SAN FRANCISCO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25662, 'SAN JUAN DE RIO SECO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25718, 'SASAIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25736, 'SESQUILE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25740, 'SIBATE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25743, 'SILVANIA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25745, 'SIMIJACA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25754, 'SOACHA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25758, 'SOPO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25769, 'SUBACHOQUE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25772, 'SUESCA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25777, 'SUPATA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25779, 'SUSA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25781, 'SUTATAUSA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25785, 'TABIO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25793, 'TAUSA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25797, 'TENA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25799, 'TENJO', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25805, 'TIBACUY', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25807, 'TIBIRITA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25815, 'TOCAIMA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25817, 'TOCANCIPA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25823, 'TOPAIPI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25839, 'UBALA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25841, 'UBAQUE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25843, 'VILLA DE SAN DIEGO DE UBATE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25845, 'UNE', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25851, 'UTICA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25862, 'VERGARA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25867, 'VIANI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25871, 'VILLAGOMEZ', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25873, 'VILLAPINZON', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25875, 'VILLETA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25878, 'VIOTA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25885, 'YACOPI', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25898, 'ZIPACON', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (25899, 'ZIPAQUIRA', '25', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27001, 'QUIBDO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27006, 'ACANDI', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27025, 'ALTO BAUDO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27050, 'ATRATO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27073, 'BAGADO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27075, 'BAHIA SOLANO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27077, 'BAJO BAUDO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27086, 'BELEN DE BAJIRA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27099, 'BOJAYA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27135, 'EL CANTON DEL SAN PABLO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27150, 'CARMEN DEL DARIEN', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27160, 'CERTEGUI', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27205, 'CONDOTO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27245, 'EL CARMEN DE ATRATO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27250, 'EL LITORAL DEL SAN JUAN', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27361, 'ISTMINA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27372, 'JURADO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27413, 'LLORO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27425, 'MEDIO ATRATO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27430, 'MEDIO BAUDO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27450, 'MEDIO SAN JUAN', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27491, 'NOVITA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27495, 'NUQUI', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27580, 'RIO IRO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27600, 'RIO QUITO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27615, 'RIOSUCIO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27660, 'SAN JOSE DEL PALMAR', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27745, 'SIPI', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27787, 'TADO', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27800, 'UNGUIA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (27810, 'UNION PANAMERICANA', '27', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41001, 'NEIVA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41006, 'ACEVEDO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41013, 'AGRADO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41016, 'AIPE', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41020, 'ALGECIRAS', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41026, 'ALTAMIRA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41078, 'BARAYA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41132, 'CAMPOALEGRE', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41206, 'COLOMBIA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41244, 'ELIAS', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41298, 'GARZON', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41306, 'GIGANTE', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41319, 'GUADALUPE', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41349, 'HOBO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41357, 'IQUIRA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41359, 'ISNOS', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41378, 'LA ARGENTINA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41396, 'LA PLATA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41483, 'NATAGA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41503, 'OPORAPA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41518, 'PAICOL', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41524, 'PALERMO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41530, 'PALESTINA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41548, 'PITAL', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41551, 'PITALITO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41615, 'RIVERA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41660, 'SALADOBLANCO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41668, 'SAN AGUSTIN', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41676, 'SANTA MARIA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41770, 'SUAZA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41791, 'TARQUI', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41797, 'TESALIA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41799, 'TELLO', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41801, 'TERUEL', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41807, 'TIMANA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41872, 'VILLAVIEJA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (41885, 'YAGUARA', '41', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44001, 'RIOHACHA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44035, 'ALBANIA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44078, 'BARRANCAS', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44090, 'DIBULLA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44098, 'DISTRACCION', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44110, 'EL MOLINO', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44279, 'FONSECA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44378, 'HATONUEVO', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44420, 'LA JAGUA DEL PILAR', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44430, 'MAICAO', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44560, 'MANAURE', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44650, 'SAN JUAN DEL CESAR', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44847, 'URIBIA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44855, 'URUMITA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (44874, 'VILLANUEVA', '44', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47001, 'SANTA MARTA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47030, 'ALGARROBO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47053, 'ARACATACA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47058, 'ARIGUANI', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47161, 'CERRO SAN ANTONIO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47170, 'CHIBOLO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47189, 'CIENAGA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47205, 'CONCORDIA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47245, 'EL BANCO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47258, 'EL PIÑON', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47268, 'EL RETEN', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47288, 'FUNDACION', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47318, 'GUAMAL', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47460, 'NUEVA GRANADA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47541, 'PEDRAZA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47545, 'PIJIÑO DEL CARMEN', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47551, 'PIVIJAY', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47555, 'PLATO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47570, 'PUEBLOVIEJO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47605, 'REMOLINO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47660, 'SABANAS DE SAN ANGEL', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47675, 'SALAMINA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47692, 'SAN SEBASTIAN DE BUENAVISTA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47703, 'SAN ZENON', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47707, 'SANTA ANA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47720, 'SANTA BARBARA DE PINTO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47745, 'SITIONUEVO', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47798, 'TENERIFE', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47960, 'ZAPAYAN', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (47980, 'ZONA BANANERA', '47', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50001, 'VILLAVICENCIO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50006, 'ACACIAS', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50110, 'BARRANCA DE UPIA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50124, 'CABUYARO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50150, 'CASTILLA LA NUEVA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50223, 'CUBARRAL', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50226, 'CUMARAL', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50245, 'EL CALVARIO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50251, 'EL CASTILLO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50270, 'EL DORADO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50287, 'FUENTE DE ORO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50313, 'GRANADA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50318, 'GUAMAL', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50325, 'MAPIRIPAN', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50330, 'MESETAS', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50350, 'LA MACARENA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50370, 'URIBE', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50400, 'LEJANIAS', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50450, 'PUERTO CONCORDIA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50568, 'PUERTO GAITAN', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50573, 'PUERTO LOPEZ', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50577, 'PUERTO LLERAS', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50590, 'PUERTO RICO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50606, 'RESTREPO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50680, 'SAN CARLOS DE GUAROA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50683, 'SAN JUAN DE ARAMA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50686, 'SAN JUANITO', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50689, 'SAN MARTIN', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (50711, 'VISTAHERMOSA', '50', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52001, 'PASTO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52019, 'ALBAN', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52022, 'ALDANA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52036, 'ANCUYA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52051, 'ARBOLEDA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52079, 'BARBACOAS', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52083, 'BELEN', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52110, 'BUESACO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52203, 'COLON', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52207, 'CONSACA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52210, 'CONTADERO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52215, 'CORDOBA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52224, 'CUASPUD', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52227, 'CUMBAL', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52233, 'CUMBITARA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52240, 'CHACHAGÜI', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52250, 'EL CHARCO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52254, 'EL PEÑOL', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52256, 'EL ROSARIO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52258, 'EL TABLON DE GOMEZ', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52260, 'EL TAMBO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52287, 'FUNES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52317, 'GUACHUCAL', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52320, 'GUAITARILLA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52323, 'GUALMATAN', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52352, 'ILES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52354, 'IMUES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52356, 'IPIALES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52378, 'LA CRUZ', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52381, 'LA FLORIDA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52385, 'LA LLANADA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52390, 'LA TOLA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52399, 'LA UNION', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52405, 'LEIVA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52411, 'LINARES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52418, 'LOS ANDES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52427, 'MAGÜI', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52435, 'MALLAMA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52473, 'MOSQUERA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52480, 'NARIÑO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52490, 'OLAYA HERRERA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52506, 'OSPINA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52520, 'FRANCISCO PIZARRO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52540, 'POLICARPA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52560, 'POTOSI', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52565, 'PROVIDENCIA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52573, 'PUERRES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52585, 'PUPIALES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52612, 'RICAURTE', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52621, 'ROBERTO PAYAN', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52678, 'SAMANIEGO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52683, 'SANDONA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52685, 'SAN BERNARDO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52687, 'SAN LORENZO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52693, 'SAN PABLO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52694, 'SAN PEDRO DE CARTAGO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52696, 'SANTA BARBARA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52699, 'SANTACRUZ', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52720, 'SAPUYES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52786, 'TAMINANGO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52788, 'TANGUA', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52835, 'TUMACO', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52838, 'TUQUERRES', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (52885, 'YACUANQUER', '52', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54001, 'CUCUTA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54003, 'ABREGO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54051, 'ARBOLEDAS', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54099, 'BOCHALEMA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54109, 'BUCARASICA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54125, 'CACOTA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54128, 'CACHIRA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54172, 'CHINACOTA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54174, 'CHITAGA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54206, 'CONVENCION', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54223, 'CUCUTILLA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54239, 'DURANIA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54245, 'EL CARMEN', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54250, 'EL TARRA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54261, 'EL ZULIA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54313, 'GRAMALOTE', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54344, 'HACARI', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54347, 'HERRAN', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54377, 'LABATECA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54385, 'LA ESPERANZA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54398, 'LA PLAYA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54405, 'LOS PATIOS', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54418, 'LOURDES', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54480, 'MUTISCUA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54498, 'OCAÑA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54518, 'PAMPLONA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54520, 'PAMPLONITA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54553, 'PUERTO SANTANDER', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54599, 'RAGONVALIA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54660, 'SALAZAR', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54670, 'SAN CALIXTO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54673, 'SAN CAYETANO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54680, 'SANTIAGO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54720, 'SARDINATA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54743, 'SILOS', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54800, 'TEORAMA', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54810, 'TIBU', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54820, 'TOLEDO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54871, 'VILLA CARO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (54874, 'VILLA DEL ROSARIO', '54', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63001, 'ARMENIA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63111, 'BUENAVISTA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63130, 'CALARCA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63190, 'CIRCASIA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63212, 'CORDOBA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63272, 'FILANDIA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63302, 'GENOVA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63401, 'LA TEBAIDA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63470, 'MONTENEGRO', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63548, 'PIJAO', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63594, 'QUIMBAYA', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (63690, 'SALENTO', '63', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66001, 'PEREIRA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66045, 'APIA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66075, 'BALBOA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66088, 'BELEN DE UMBRIA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66170, 'DOSQUEBRADAS', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66318, 'GUATICA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66383, 'LA CELIA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66400, 'LA VIRGINIA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66440, 'MARSELLA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66456, 'MISTRATO', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66572, 'PUEBLO RICO', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66594, 'QUINCHIA', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66682, 'SANTA ROSA DE CABAL', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (66687, 'SANTUARIO', '66', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68001, 'BUCARAMANGA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68013, 'AGUADA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68020, 'ALBANIA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68051, 'ARATOCA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68077, 'BARBOSA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68079, 'BARICHARA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68081, 'BARRANCABERMEJA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68092, 'BETULIA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68101, 'BOLIVAR', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68121, 'CABRERA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68132, 'CALIFORNIA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68147, 'CAPITANEJO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68152, 'CARCASI', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68160, 'CEPITA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68162, 'CERRITO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68167, 'CHARALA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68169, 'CHARTA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68176, 'CHIMA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68179, 'CHIPATA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68190, 'CIMITARRA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68207, 'CONCEPCION', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68209, 'CONFINES', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68211, 'CONTRATACION', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68217, 'COROMORO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68229, 'CURITI', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68235, 'EL CARMEN DE CHUCURI', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68245, 'EL GUACAMAYO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68250, 'EL PEÑON', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68255, 'EL PLAYON', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68264, 'ENCINO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68266, 'ENCISO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68271, 'FLORIAN', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68276, 'FLORIDABLANCA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68296, 'GALAN', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68298, 'GAMBITA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68307, 'GIRON', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68318, 'GUACA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68320, 'GUADALUPE', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68322, 'GUAPOTA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68324, 'GUAVATA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68327, 'GÜEPSA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68344, 'HATO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68368, 'JES/S MARIA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68370, 'JORDAN', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68377, 'LA BELLEZA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68385, 'LANDAZURI', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68397, 'LA PAZ', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68406, 'LEBRIJA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68418, 'LOS SANTOS', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68425, 'MACARAVITA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68432, 'MALAGA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68444, 'MATANZA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68464, 'MOGOTES', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68468, 'MOLAGAVITA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68498, 'OCAMONTE', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68500, 'OIBA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68502, 'ONZAGA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68522, 'PALMAR', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68524, 'PALMAS DEL SOCORRO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68533, 'PARAMO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68547, 'PIEDECUESTA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68549, 'PINCHOTE', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68572, 'PUENTE NACIONAL', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68573, 'PUERTO PARRA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68575, 'PUERTO WILCHES', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68615, 'RIONEGRO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68655, 'SABANA DE TORRES', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68669, 'SAN ANDRES', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68673, 'SAN BENITO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68679, 'SAN GIL', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68682, 'SAN JOAQUIN', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68684, 'SAN JOSE DE MIRANDA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68686, 'SAN MIGUEL', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68689, 'SAN VICENTE DE CHUCURI', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68705, 'SANTA BARBARA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68720, 'SANTA HELENA DEL OPON', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68745, 'SIMACOTA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68755, 'SOCORRO', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68770, 'SUAITA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68773, 'SUCRE', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68780, 'SURATA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68820, 'TONA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68855, 'VALLE DE SAN JOSE', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68861, 'VELEZ', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68867, 'VETAS', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68872, 'VILLANUEVA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (68895, 'ZAPATOCA', '68', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70001, 'SINCELEJO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70110, 'BUENAVISTA', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70124, 'CAIMITO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70204, 'COLOSO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70215, 'COROZAL', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70221, 'COVEÑAS', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70230, 'CHALAN', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70233, 'EL ROBLE', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70235, 'GALERAS', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70265, 'GUARANDA', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70400, 'LA UNION', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70418, 'LOS PALMITOS', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70429, 'MAJAGUAL', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70473, 'MORROA', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70508, 'OVEJAS', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70523, 'PALMITO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70670, 'SAMPUES', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70678, 'SAN BENITO ABAD', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70702, 'SAN JUAN DE BETULIA', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70708, 'SAN MARCOS', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70713, 'SAN ONOFRE', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70717, 'SAN PEDRO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70742, 'SINCE', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70771, 'SUCRE', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70820, 'SANTIAGO DE TOLU', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (70823, 'TOLUVIEJO', '70', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73001, 'IBAGUE', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73024, 'ALPUJARRA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73026, 'ALVARADO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73030, 'AMBALEMA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73043, 'ANZOATEGUI', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73055, 'ARMERO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73067, 'ATACO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73124, 'CAJAMARCA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73148, 'CARMEN DE APICALA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73152, 'CASABIANCA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73168, 'CHAPARRAL', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73200, 'COELLO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73217, 'COYAIMA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73226, 'CUNDAY', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73236, 'DOLORES', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73268, 'ESPINAL', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73270, 'FALAN', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73275, 'FLANDES', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73283, 'FRESNO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73319, 'GUAMO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73347, 'HERVEO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73349, 'HONDA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73352, 'ICONONZO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73408, 'LERIDA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73411, 'LIBANO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73443, 'MARIQUITA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73449, 'MELGAR', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73461, 'MURILLO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73483, 'NATAGAIMA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73504, 'ORTEGA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73520, 'PALOCABILDO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73547, 'PIEDRAS', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73555, 'PLANADAS', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73563, 'PRADO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73585, 'PURIFICACION', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73616, 'RIOBLANCO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73622, 'RONCESVALLES', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73624, 'ROVIRA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73671, 'SALDAÑA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73675, 'SAN ANTONIO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73678, 'SAN LUIS', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73686, 'SANTA ISABEL', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73770, 'SUAREZ', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73854, 'VALLE DE SAN JUAN', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73861, 'VENADILLO', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73870, 'VILLAHERMOSA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (73873, 'VILLARRICA', '73', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76001, 'CALI', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76020, 'ALCALA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76036, 'ANDALUCIA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76041, 'ANSERMANUEVO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76054, 'ARGELIA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76100, 'BOLIVAR', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76109, 'BUENAVENTURA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76111, 'GUADALAJARA DE BUGA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76113, 'BUGALAGRANDE', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76122, 'CAICEDONIA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76126, 'CALIMA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76130, 'CANDELARIA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76147, 'CARTAGO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76233, 'DAGUA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76243, 'EL AGUILA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76246, 'EL CAIRO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76248, 'EL CERRITO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76250, 'EL DOVIO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76275, 'FLORIDA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76306, 'GINEBRA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76318, 'GUACARI', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76364, 'JAMUNDI', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76377, 'LA CUMBRE', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76400, 'LA UNION', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76403, 'LA VICTORIA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76497, 'OBANDO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76520, 'PALMIRA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76563, 'PRADERA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76606, 'RESTREPO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76616, 'RIOFRIO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76622, 'ROLDANILLO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76670, 'SAN PEDRO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76736, 'SEVILLA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76823, 'TORO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76828, 'TRUJILLO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76834, 'TULUA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76845, 'ULLOA', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76863, 'VERSALLES', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76869, 'VIJES', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76890, 'YOTOCO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76892, 'YUMBO', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (76895, 'ZARZAL', '76', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81001, 'ARAUCA', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81065, 'ARAUQUITA', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81220, 'CRAVO NORTE', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81300, 'FORTUL', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81591, 'PUERTO RONDON', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81736, 'SARAVENA', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (81794, 'TAME', '81', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85001, 'YOPAL', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85010, 'AGUAZUL', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85015, 'CHAMEZA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85125, 'HATO COROZAL', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85136, 'LA SALINA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85139, 'MANI', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85162, 'MONTERREY', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85225, 'NUNCHIA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85230, 'OROCUE', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85250, 'PAZ DE ARIPORO', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85263, 'PORE', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85279, 'RECETOR', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85300, 'SABANALARGA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85315, 'SACAMA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85325, 'SAN LUIS DE PALENQUE', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85400, 'TAMARA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85410, 'TAURAMENA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85430, 'TRINIDAD', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (85440, 'VILLANUEVA', '85', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86001, 'MOCOA', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86219, 'COLON', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86320, 'ORITO', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86568, 'PUERTO ASIS', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86569, 'PUERTO CAICEDO', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86571, 'PUERTO GUZMAN', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86573, 'LEGUIZAMO', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86749, 'SIBUNDOY', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86755, 'SAN FRANCISCO', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86757, 'SAN MIGUEL', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86760, 'SANTIAGO', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86865, 'VALLE DEL GUAMUEZ', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (86885, 'VILLAGARZON', '86', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (88001, 'SAN ANDRES', '88', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (88564, 'PROVIDENCIA', '88', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91001, 'LETICIA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91263, 'EL ENCANTO', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91405, 'LA CHORRERA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91407, 'LA PEDRERA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91430, 'LA VICTORIA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91460, 'MIRITI - PARANA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91530, 'PUERTO ALEGRIA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91536, 'PUERTO ARICA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91540, 'PUERTO NARIÑO', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91669, 'PUERTO SANTANDER', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (91798, 'TARAPACA', '91', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94001, 'INIRIDA', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94343, 'BARRANCO MINAS', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94663, 'MAPIRIPANA', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94883, 'SAN FELIPE', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94884, 'PUERTO COLOMBIA', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94885, 'LA GUADALUPE', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94886, 'CACAHUAL', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94887, 'PANA PANA', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (94888, 'MORICHAL', '94', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (95001, 'SAN JOSE DEL GUAVIARE', '95', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (95015, 'CALAMAR', '95', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (95025, 'EL RETORNO', '95', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (95200, 'MIRAFLORES', '95', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97001, 'MITU', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97161, 'CARURU', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97511, 'PACOA', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97666, 'TARAIRA', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97777, 'PAPUNAUA', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (97889, 'YAVARATE', '97', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (99001, 'PUERTO CARREÑO', '99', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (99524, 'LA PRIMAVERA', '99', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (99624, 'SANTA ROSALIA', '99', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);
INSERT INTO `gen04ciudad` (`COD_CIUDAD`, `TEX_NOMCIU`, `COD_DEPTO`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (99773, 'CUMARIBO', '99', '1', '2014-05-27 00:00:00', '127,0,0,1', 1, 0);


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `migrations` (`version`) VALUES ('0');


#
# TABLE STRUCTURE FOR: par02empresa
#

DROP TABLE IF EXISTS `par02empresa`;

CREATE TABLE `par02empresa` (
  `ID_EMPRESA` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Consecutivo autoincremental',
  `COD_NIT` text NOT NULL COMMENT 'corresponde al NIT de la empresa usuaria se utilizará para la presentación de los procesos y sus reportes',
  `TEX_NOMEMP` text NOT NULL COMMENT 'corresponde al nombre de la empresa usuaria se utilizará para la presentación de los procesos y sus reportes',
  `TEX_LOGO` text COMMENT 'corresponde a la imagen logo de la empresa',
  `TEX_DIREMP` text NOT NULL COMMENT 'Direccion de la empresa se utilizará para contacto administrativo y comercial',
  `TEX_CELEMP` text COMMENT 'Telefono Movil de la empresa se utilizará para contacto administrativo y comercial',
  `TEX_TELEMP` text COMMENT 'Teléfono de la empresa se utilizará para contacto administrativo y comercial',
  `COD_CIUDAD` int(11) NOT NULL DEFAULT '999' COMMENT 'Codigo Ciudad de la empresa. Defecto 999.',
  `TEX_MAIEMP` text COMMENT 'Correo electónico de la empresa se utilizará para contacto administrativo y comercial',
  `TEX_OBSERVACION` longtext COMMENT 'Observaciones al registro',
  `COD_CREAUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `FEC_CREACION` datetime NOT NULL COMMENT 'Fecha de creación',
  `TEX_CREANOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  `BOL_ACTIVO` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Determina si el registro esta o no activo. Por defecto=1',
  `IS_DELETE` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Determina si se ha borrado el registro. Por defecto=0',
  PRIMARY KEY (`ID_EMPRESA`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='Información de la empresa usuaria de CVIR';

INSERT INTO `par02empresa` (`ID_EMPRESA`, `COD_NIT`, `TEX_NOMEMP`, `TEX_LOGO`, `TEX_DIREMP`, `TEX_CELEMP`, `TEX_TELEMP`, `COD_CIUDAD`, `TEX_MAIEMP`, `TEX_OBSERVACION`, `COD_CREAUSU`, `FEC_CREACION`, `TEX_CREANOTA`, `BOL_ACTIVO`, `IS_DELETE`) VALUES (13, '6eabaabaec32832584dc3fcf8d0567a1851474e0846c3cd0324b22829b949f27c5d74f7cca495bc1d3f6fbf7ff77d40729c98b1f3535cdf397a2a2cac411ba69tOdmZdg5QXrfAqS+/BoZPDB5I2RgcYEmqvzVbud0kLI=', '7a56478f7b1e48af40014805ff45340fc24687dfd49ca46250996b5b9fb35f93cd326c55a52506a431b5abd627ace2e37ef21430278cb69545591b9cd6501bb0e8w71KwvyrFiZ7jRZlxPDdCefaIvF6cvAPba1OWqe90=', 'c86d55f8b8971e207d735cb0c7cd19f4ab20bb6b8e156ecd20c62331ca361c724072f1f6ea362dc0f2e40669e81c33381a84b42179d3e51ec414cc2a0b798c990vAOnqr5EPDq8r6iz8cn8HJ1b6OAs+DlDnAkLHWOgMK/pjQwadtJVJdfilwu84bI', '83ef737bc46f8f0afe67442c464a4a0adc26017c81a0c091c0d5b1f946c7eb298b906d0a466dde8b70d4efcd2b74ccc68b46d2bc97832714d6c9d3ef99b538dc2ZHHlHF/ZTGvrIqn2Ul9GwguGWjMbBZoc+LdoMurOQ8=', '9ac6980dbda99340995dcccf59b44afa6311e607fc013650477806aa44bb84fae4469f80c42c255b0048613cee45cf993ca5c863281585a7dbc96b2d4c6d47f0QR6LU1lhkJPRoYur0UL4uOVWUHAI911+3MRVci4+3VY=', '94dcf16b8d3ee6a149b789c6922a1caa8a0af4bec4f107c99d44168c0ef39820c26e3440f9a0ce35fc1efdb1af30d42b4c7eda27c8766e1cc57da4a60d8cd989gEckTkrlZHTX+JKc7u1dskdizrJDNyzqjt5nFqIL3UM=', 11001, '62f18c4a418a26def5faa99010fd4edc97c3e55ed280d45d0033b9b6d02c6db395fa8dd4ebe73f50345af0ada6679adc82d3f57450d076b98a04249d13399eb2FakwH+cJVQuHrHEsz03eZiLyNQR+NR76DFv2mdqKOBzvU7+8HRSUF/gLpoWSxoEk', '6a9424472a9c77da525870cc6e42505cde55a5b4a4db672150569363e35f33954628a636e4fe238c1b0d498c47731558e0faf66dc6525e3226d79110737c8fa3iGc4RY11dBE23Fd9t8weJa9dsx5GhBkeC6FURgmS++s=', '1', '2021-02-19 17:43:26', '190.25.106.56', 1, 0);


#
# TABLE STRUCTURE FOR: sincro01proceso
#

DROP TABLE IF EXISTS `sincro01proceso`;

CREATE TABLE `sincro01proceso` (
  `COD_PROCESO` int(11) NOT NULL AUTO_INCREMENT,
  `STATUS` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=Exitoso 0=Fallido',
  `FEC_EJECUTA` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Fecha de creación',
  `COD_AGENCIA` int(3) NOT NULL,
  `COD_EJEUSU` varchar(9) NOT NULL COMMENT 'Codigo del usuario que lo crea',
  `TEX_EJENOTA` varchar(240) NOT NULL COMMENT 'Datos terminal de creación',
  PRIMARY KEY (`COD_PROCESO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: sincro02logproceso
#

DROP TABLE IF EXISTS `sincro02logproceso`;

CREATE TABLE `sincro02logproceso` (
  `COD_LOGPROCESO` int(11) NOT NULL AUTO_INCREMENT,
  `COD_PROCESO` int(11) NOT NULL,
  `ID_INSTAN` int(11) NOT NULL,
  `ID_CANDID` int(3) NOT NULL,
  `NUM_IDETER` varchar(12) NOT NULL,
  `COD_AGENCIA` int(3) NOT NULL,
  `FEC_PROVOT` datetime NOT NULL,
  `TEX_IPORIG` varchar(50) NOT NULL,
  `BOL_REGIS` tinyint(1) NOT NULL,
  `FEC_CREACION` datetime NOT NULL,
  PRIMARY KEY (`COD_LOGPROCESO`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Tabla que muestra el detalle de la sincronizacion de votaciones';

#
# TABLE STRUCTURE FOR: sincro03generacion
#

DROP TABLE IF EXISTS `sincro03generacion`;

CREATE TABLE `sincro03generacion` (
  `COD_GEN` int(11) NOT NULL AUTO_INCREMENT,
  `NUM_REGIST` int(10) NOT NULL,
  `FEC_GENARCHIV` datetime NOT NULL,
  `COD_SINUSU` varchar(9) NOT NULL,
  PRIMARY KEY (`COD_GEN`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (2, 3, '2018-12-19 14:54:45', '37');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (3, 5, '2018-12-19 15:07:05', '37');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (4, 5, '2018-12-19 15:07:10', '37');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (5, 3, '2018-12-20 09:02:01', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (6, 11, '2019-01-02 12:05:40', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (7, 11, '2019-01-02 12:05:41', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (8, 14, '2019-01-03 09:14:10', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (9, 12, '2019-01-09 17:40:46', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (10, 24, '2019-01-11 16:10:06', '1');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (11, 9, '2019-02-13 18:48:33', '50');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (12, 17, '2019-02-17 11:32:04', '50');
INSERT INTO `sincro03generacion` (`COD_GEN`, `NUM_REGIST`, `FEC_GENARCHIV`, `COD_SINUSU`) VALUES (13, 21, '2019-02-17 17:58:06', '50');


#
# TABLE STRUCTURE FOR: z_ingreso
#

DROP TABLE IF EXISTS `z_ingreso`;

CREATE TABLE `z_ingreso` (
  `z_nom` varchar(250) NOT NULL,
  `z_ape` varchar(250) NOT NULL,
  `z_email` varchar(250) NOT NULL,
  `z_codemp` varchar(50) NOT NULL,
  `z_fecini` varchar(20) NOT NULL,
  `z_obs` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `z_ingreso` (`z_nom`, `z_ape`, `z_email`, `z_codemp`, `z_fecini`, `z_obs`) VALUES ('John', 'xyz', 'jxyz@gmail.com', '1000-2000', '2020-05-16T14:00:00.', '+1.888.799.9666');
INSERT INTO `z_ingreso` (`z_nom`, `z_ape`, `z_email`, `z_codemp`, `z_fecini`, `z_obs`) VALUES ('John', 'xyz', 'jxyz@gmail.com', 'VACIO', '2020-05-18T16:00:00.', '+1.888.799.9666');
INSERT INTO `z_ingreso` (`z_nom`, `z_ape`, `z_email`, `z_codemp`, `z_fecini`, `z_obs`) VALUES ('MATEO', 'SUAREZ', 'alberto_suarezv@hotmail.com', 'VACIO', '2020-05-18T16:00:00Z', '3116922422');


SET foreign_key_checks = 1;
