<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Log_recordar_password extends MY_Model
{

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->_table               = 'evi11logrecon';
		$this->_table_parent        = 'evi05partic';
		$this->_table_parent_parent = 'gen01agencias';
		$this->primary_key          = 'ID_LOGRECON';
		$this->_column        = array('evi05partic.NUM_IDETER',
			'evi05partic.TEX_NOMPAR', 'evi11logrecon.TEX_TIPOENVIO', 'evi05partic.TEX_MAIL',
			'gen01agencias.TEX_NOMAGE', 'evi11logrecon.TEX_IPORIG', 'evi11logrecon.FEC_GENERACION');
		$this->_order         = array('evi11logrecon.FEC_GENERACION' => 'desc');
	}

	private function _get_datatables_query()
	{
		$this->db->select("$this->_table.*, $this->_table_parent.TEX_NOMPAR, $this->_table_parent.TEX_APEPAR, 
			$this->_table_parent.TEX_MAIL,$this->_table_parent.NUM_TELCEL, $this->_table_parent_parent.TEX_NOMAGE");
		$this->db->from($this->_table);
		$this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER");
		$this->db->join($this->_table_parent_parent, "$this->_table_parent.COD_AGENCIA=$this->_table_parent_parent.COD_AGENCIA");
		$this->db->where("$this->_table_parent.IS_DELETE", 0);
		$this->db->order_by("$this->_table.FEC_GENERACION", 'DESC');
		$i = 0;
		foreach ($this->_column as $item) {
			if ($_POST['search']['value']) {
				($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
			}

			$column[$i] = $item;
			$i++;
		}
		if (isset($_POST['order'])) {
			$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} else if (isset($this->_order)) {
			$order = $this->_order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	public function get_datatables()
	{
		$this->_get_datatables_query();
		if ($_POST['length'] != -1):
			$this->db->limit($_POST['length'], $_POST['start']);
		endif;
		$query = $this->db->get();
		return $query->result();
	}

	public function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->_table);
		return $this->db->count_all_results();
	}
}
