<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Administrador extends MX_Controller
{

	protected $path_js;

	public function __construct()
	{
		parent::__construct();
		$this->load->model(array('Admin', 'configuracion/Config', 'empresas/Empresa', 'participantes/Participante', 'candidatos/Candidato',
			'agencias/Agencia', 'instancias/Instancia'));
		$this->path_js = 'administrador/scripts_dev.js';
		if (!$this->session->userdata('COD_PERFIL')) {
			$this->redirect_no_login();
		}
	}

	public function index()
	{


		$data_view['titulo']        = 'Panel de Administración';
		$data_view['config']        = $this->Config->get_row();
		$data_view['empresa']       = $this->Empresa->get_row();
		$data_view['agencias']      = $this->Agencia->get_row();
		$data_view['instancias']    = $this->Instancia->get_row();
		$data_view['participantes'] = $this->Participante->get_row();
		$data_view['candidatos']    = $this->Candidato->get_row();



		$data_view['total_candidatos']    = $this->Candidato->count_all();
		$data_view['total_participantes'] = $this->Participante->count_all();

		$this->db->where('BOL_INISES', 1);
		$data_view['total_participantes_online'] = $this->Participante->count_all();

		$data_view['total_instancias'] = $this->Instancia->count_all();
		
		$data_view['load_js'] = $this->path_js;
		$this->load->view('home_admin', $data_view);
	}

}
