<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Agencias extends MX_Controller
{

	public $path_js;
	protected $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}

		$this->load->model('Agencia');
		$this->path_js = 'agencias/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos'); 
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado '.$this->session->userdata('NOMBRE_SEGMENTO');
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

     /**
      * Lista asociados desde Datatables.
      */
     public function get_all()
     {
     	$list = $this->Agencia->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	$this->ini_desencriptado();
     	foreach ($list as $agencia) {
     		$no++;
     		$row    = array();


     		$delete= '';
     		$editar = '';
     		$status = '';

     		if(isset($this->_permisos['agencias']['agencias_borrar'])) {
     			$delete = "<a href='agencias/delete/$agencia->COD_AGENCIA ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}

     		if(isset($this->_permisos['agencias']['agencias_editar'])) {
     			
     			$status = ($agencia->BOL_ACTIVO) ? "<a href='agencias/status/$agencia->COD_AGENCIA/$agencia->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='agencias/status/$agencia->COD_AGENCIA/$agencia->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}
     		if(isset($this->_permisos['agencias']['agencias_activar'])) {
     			$editar = "<a href='agencias/create/1/$agencia->COD_AGENCIA ' class='btn btn-success'>Editar</a>";
     		}


     		$row[]  = $agencia->COD_AGENCIA;
     		$row[]  = $agencia->TEX_NOMAGE;
     		$row[]  = $this->encryption->decrypt($agencia->TEX_NOMEMP);
     		$row[]  = $agencia->TEX_DIRAGE;
     		$row[]  = $agencia->TEX_NOMCIU;
     		$row[]  = ($agencia->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Agencia->count_all(),
     		"recordsFiltered" => $this->Agencia->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear agencia.
      */
     public function create($edit = null, $id = null)
     {
     if(isset($this->_permisos['agencias']['agencias_crear'])) {
     		if ($this->input->post()):
     			unset($_POST['TEX_CIUDAD']);
     			$edit = $this->input->post('edit');
     			$id   = $this->input->post('COD_AGENCIA');
     			if ($edit) {
     				$this->form_validation->set_rules('TEX_NOMAGE', 'Nombre del Agencia', 'required');
     			}
     			else {
     				$this->form_validation->set_rules('TEX_NOMAGE', 'Nombre del Agencia', 'required|is_unique[gen01agencias.TEX_NOMAGE]');
     			}
     			if (!$this->form_validation->run()):
     				$this->session->set_flashdata('error', validation_errors());
     				if ($edit) {
     					redirect("agencias/create/1/$id");
     				}
     				redirect("agencias/create");
     			else:
     				$_post              = $this->security->xss_clean($_POST);
     				$datos_tipo_agencia = array_merge($_post, $this->get_campos_control_DB());

     				if ($edit && $id) {
     					unset($datos_tipo_agencia['edit']);
     					if ($this->Agencia->edit($id, $datos_tipo_agencia)) {
     						$this->session->set_flashdata('success', 'Se ha editado el registro');
     						redirect('agencias');
     					}
     					else {
     						$this->session->set_flashdata('error', 'Error en la edición de los datos');
     						redirect("agencias/create/1/$id");
     					}
     				}
     				if (is_int($this->Agencia->insert($datos_tipo_agencia))) {
     					$this->session->set_flashdata('success', 'Se ha guardado el registro');
     					redirect('agencias');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     					redirect('agencias/create');
     				}
     			endif;
     		else:
     			if ($edit && $id) {
     				$data_view['titulo']  = 'Editar '.$this->session->userdata('NOMBRE_SEGMENTO');
     				$this->db->join('gen04ciudad', "gen04ciudad.COD_CIUDAD=gen01agencias.COD_CIUDAD");
     				$data_view['agencia'] = $this->Agencia->get($id);
     			}
     			$data_view['ciudades'] = $this->Agencia->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
     			$data_view['route']    = $this->get_module_name();
     			$data_view['empresas'] = $this->Agencia->get_html_select_empresas();
     			$data_view['titulo']   = 'Crear '.$this->session->userdata('NOMBRE_SEGMENTO');
     			$data_view['load_js']  = $this->path_js;
     			$this->load->view('create', $data_view);
     		endif;
     	}
     	else {
     		redirect('usuarios/login');
     	}
     }

     /**
      *
      * Cambiar status
      *
      * @param type $id
      * @param type $status
      *
      */
     public function status($id, $status)
     {
     	if(isset($this->_permisos['agencias']['agencias_activar'])) {
     		$data = ['BOL_ACTIVO' => 1];
     		if ($status) {
     			$data = ['BOL_ACTIVO' => 0];
     		}
     		if ($this->Agencia->edit($id, $data)):
     			$this->session->set_flashdata('success', 'Status cambiado');
     			redirect('agencias');
     		else:
     			$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     			redirect('agencias');
     		endif;
     	}
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Agencia->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('agencias');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('agencias');
     	endif;
     }

  }
