<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Clear_data extends MX_Controller
{

	public $path_js;
	protected $_permisos;

//---------------------------------------------------------------------------------------------------

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Clear', 'participantes/Participante']);
		$this->path_js = 'clear_data/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos');
	}

//------------------------------------------------------------------------------
     /**
      * Crear clear_data.
      */
     public function index()
     {
     	$data_view['titulo']  = 'Limpiar datos';
     	$data_view['load_js'] = $this->path_js;
     	$this->load->view('index', $data_view);
     }

//------------------------------------------------------------------------------
     /**
      *  Limpia registro de votación. 
      */
     public function clean_reg_votacion()
     {
     	if ($this->input->post('reg_vota')) {
     		if ($this->Clear->clean('evi07audpro')) {
     			$this->db->trans_start();
     			$this->Clear->limpiar_reg_participante();
     			$this->Clear->limpiar_reg_votos();
				 $this->Clear->limpiar_reg_login();
				 $this->_limpiar_sincronizacion();
				 $this->Clear->clean('evi11logrecon');
                 //Elimina candidatos tipo lista.
                 //$this->Clear->eliminar_candidato_lista();
     			$this->db->trans_complete();
     			if ($this->db->trans_status() === FALSE) {
     				$this->session->set_flashdata('error', 'Error en la transacción');
     				redirect('clear_data');
     			}
     			$this->session->set_flashdata('success', 'Se ha limpiado la tabla');
     			redirect('clear_data');
     		}
     		else {
     			$this->session->set_flashdata('error', 'No se pudo limpiar la tabla');
     			redirect('clear_data');
     		}
     	}
     }

//------------------------------------------------------------------------------
     /**
      *  Limpia registro de ingresos y salidas. 
      */
     public function clean_ingresos_salidas()
     {
     	if ($this->input->post('ingre_salida')) {
     		if ($this->Clear->clean('evi09ingre')) {
     			$this->Clear->clean('evi06loinpa');
     			$this->db->query("ALTER TABLE evi09ingre AUTO_INCREMENT =1");
     			$this->db->query("ALTER TABLE evi06loinpa AUTO_INCREMENT =1");
     			$this->Clear->limpiar_reg_ingresos_salidas();
     			$this->Clear->limpiar_reg_login();
     			$this->db->query("ALTER TABLE evi07audpro AUTO_INCREMENT =1");
     			$this->session->set_flashdata('success', 'Se ha limpiado la tabla');
     			redirect('clear_data');
     		}
     		else {
     			$this->session->set_flashdata('error', 'No se pudo limpiar la tabla');
     			redirect('clear_data');
     		}
     	}
     }

     /**
      * Limpia la tabla de participantes. 
      * 
      */
     public function clean_participantes()
     {
     	if ($this->input->post('participantes')) {
     		$this->Clear->clean('evi11logrecon');
     		$this->Clear->clean('evi05partic');
     		$this->db->query("ALTER TABLE evi05partic AUTO_INCREMENT =1");
     		$this->session->set_flashdata('success', 'Se ha limpiado la tabla de participantes');
     		redirect('clear_data');
     	}
     }

		/**
      * Limpia la tabla de participantes. 
      * 
      */
		public function clean_listas()
		{
			if ($this->input->post('listas')) {
				$this->Clear->clean('evi03listas');
				$this->db->query("ALTER TABLE evi03listas AUTO_INCREMENT =1");
				$this->session->set_flashdata('success', 'Se ha limpiado la tabla de listas');
				redirect('clear_data');
			}
		}

     /**
      * Limpia la tabla de candidatos. 
      * 
      */
     public function clean_candidatos()
     {
     	if ($this->input->post('candidatos')) {
     		$this->Clear->clean('evi04candidat_mr');
     		$this->db->query("ALTER TABLE evi04candidat_mr AUTO_INCREMENT =1");
     		$this->session->set_flashdata('success', 'Se ha limpiado la tabla de candidatos');
     		redirect('clear_data');
     	}
     }


     public function clean_votacion()
     {
     	if ($this->input->post('votacion')) {
     	//	if ($this->Clear->clean('evi07audpro')) {
				 $this->db->trans_start();
     		 	 $this->Clear->limpiar_reg_participante();
				 $this->Clear->limpiar_reg_login();
				 $this->_limpiar_sincronizacion();
                 //Elimina candidatos tipo lista.
                 //$this->Clear->eliminar_candidato_lista();
     			$this->db->trans_complete();
     			if ($this->db->trans_status() === FALSE) {
     				$this->session->set_flashdata('error', 'Error en la transacción');
     				redirect('clear_data');
     			}
     			$this->session->set_flashdata('success', 'Se ha limpiado el registro');
     			redirect('clear_data');
     	//	}
     		//else {
     		//	$this->session->set_flashdata('error', 'No se pudo limpiar la tabla');
     		//	redirect('clear_data');
     	//	}
     	}
	 }
	 
	 private function _limpiar_sincronizacion()
	 {
		$this->Clear->clean('sincro01proceso');
		$this->Clear->clean('sincro02logproceso');
		$this->db->query("ALTER TABLE sincro01proceso AUTO_INCREMENT =1");
		$this->db->query("ALTER TABLE sincro02logproceso AUTO_INCREMENT =1");
	 }


	 public function backup_db()
	 {

		if (!$this->_permisos['clear_data']['clear_data_backup']['MOSTRAR_FRONT']){
            $this->session->set_flashdata('error', "No tienes permisos para realizar esta operación.");
            redirect('clear_data');
            
        }
		$this->load->dbutil();

		$prefs = array(
			'format'        => 'zip',                       
			'filename'      => 'backup_basedatos_evir2_'.date('YmdHis').'sql',   
			'add_insert'    => TRUE,                        
			'foreign_key_checks' => false,
			'newline'       => "\n",
	);

		$backup = $this->dbutil->backup($prefs);

		$this->load->helper('file');
		write_file(FCPATH.'/backups/backup_basedatos_evir2'.date('YmdHis').'.zip', $backup);
		
		$this->load->helper('download');
		force_download('backup_basedatos_evir2_'.date('YmdHis').'.zip', $backup);
	 }

  }
