<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Departamentos extends MX_Controller
{

	public $path_js;
	protected $_permisos;

	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
			echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
			exit;
		}
		$this->load->model(['Departamento', 'paises/Pais']);
		$this->path_js = 'departamentos/scripts_dev.js';
		$this->_permisos = $this->session->userdata('permisos'); 
	}

	public function index()
	{
		$data_view['titulo']  = 'Listado de Departamentos';
		$data_view['permisos']  = $this->_permisos;
		$data_view['load_js'] = $this->path_js;
		$this->load->view('index', $data_view);
	}

	function change_status($primary_key, $row)
	{
		return site_url('departamentos/status') . '/' . $primary_key . '/' . $row->BOL_ACTIVO;
	}

	public function example_output($output = null, $titulo = null)
	{
		$this->load->view('render', $output);
	}

     /**
      * Lista asociados desde Datatables. 
      */
     public function get_all()
     {
     	$list = $this->Departamento->get_datatables();
     	$data = array();
     	$no   = $this->input->post('start');
     	foreach ($list as $departamento) {
     		$no++;
     		$row    = array();

     		$delete= '';
     		$editar = '';
     		$status = '';

     		if(isset($this->_permisos['departamentos']['departamentos_borrar'])) {
     			$delete = "<a href='departamentos/delete/$departamento->COD_DEPTO ' class='btn btn-danger' onclick='borrarRegistro(this.id)'>Eliminar</a>";
     		}

     		if(isset($this->_permisos['departamentos']['departamentos_editar'])) {
     			$editar = "<a href='departamentos/create/1/$departamento->COD_DEPTO ' class='btn btn-success'>Editar</a>";
     		}

     		if(isset($this->_permisos['departamentos']['departamentos_activar'])) {
     			$status = ($departamento->BOL_ACTIVO) ? "<a href='departamentos/status/$departamento->COD_DEPTO/$departamento->BOL_ACTIVO ' class='btn btn-danger' style='margin-left:3px;'>Desactivar</a>" : "<a href='departamentos/status/$departamento->COD_DEPTO/$departamento->BOL_ACTIVO ' class='btn btn-success' style='margin-left:3px;'>Activar</a>";
     		}

     		$row[]  = $departamento->COD_DEPTO;
     		$row[]  = $departamento->TEX_NOMDEPTO;
     		$row[]  = $departamento->TEX_NOMPAIS;
     		$row[]  = ($departamento->BOL_ACTIVO) ? '<p style="color:green">Activo</p>' : '<p style="color:red">Inactivo</p>';
     		$row[]  = "$editar $status $delete";
     		$data[] = $row;
     	}
     	$output = array(
     		"draw"            => $this->input->post('draw'),
     		"recordsTotal"    => $this->Departamento->count_all(),
     		"recordsFiltered" => $this->Departamento->count_filtered(),
     		"data"            => $data,
     	);
     	echo json_encode($output);
     }

     /**
      * Crear departamento.
      */
     public function create($edit = null, $id = null)
     {
         // if ($this->session->userdata('logged_in')):
     	if ($this->input->post()):
     		$edit = $this->input->post('edit');
     		$id   = $this->input->post('COD_DEPTO');
     		if ($edit) {
     			$this->form_validation->set_rules('COD_DEPTO', 'Código del Departamento', 'trim|required|integer');
     			$this->form_validation->set_rules('TEX_NOMDEPTO', 'Nombre del Departamento', 'required');
     		}
     		else {
     			$this->form_validation->set_rules('COD_DEPTO', 'Código del Departamento', 'trim|required|integer|is_unique[gen03depto.COD_DEPTO]');
     			$this->form_validation->set_rules('TEX_NOMDEPTO', 'Nombre del Departamento', 'required|is_unique[gen03depto.TEX_NOMDEPTO]');
     		}
     		if (!$this->form_validation->run()):
     			$this->session->set_flashdata('error', validation_errors());
     			if ($edit) {
     				redirect("departamentos/create/1/$id");
     			}
     			redirect("departamentos/create");
     		else:
     			$_post              = $this->security->xss_clean($_POST);
     			$datos_departamento = array_merge($_post, $this->get_campos_control_DB());
     			if ($edit && $id) {
     				unset($datos_departamento['edit']);
     				if ($this->Departamento->edit($id, $datos_departamento)) {
     					$this->session->set_flashdata('success', 'Se ha editado el registro');
     					redirect('departamentos');
     				}
     				else {
     					$this->session->set_flashdata('error', 'Error en la edición de los datos');
     					redirect("departamentos/create/1/$id");
     				}
     			}
     			if (is_int($this->Departamento->insert($datos_departamento))):
     				$this->session->set_flashdata('success', 'Se ha guardado el registro');
     				redirect('departamentos');
     			else:
     				$this->session->set_flashdata('error', 'Error en la inserción de los datos');
     				redirect('departamentos/create');
     			endif;
     		endif;
     	else:
     		$data_view['route'] = $this->get_module_name();
     		if ($edit && $id) {
     			$data_view['departamento'] = $this->Departamento->get($id);
     		}
     		$data_view['paises']  = $this->Pais->select_forms('gen02pais', 'COD_PAIS', 'TEX_NOMPAIS');
     		$data_view['titulo']  = 'Crear Departamento';
     		$data_view['load_js'] = $this->path_js;
     		$this->load->view('create', $data_view);
     	endif;
         // endif;
     }

     /**
      * 
      * Cambiar status
      * 
      * @param type $id
      * @param type $status
      * 
      */
     public function status($id, $status)
     {
     	if ($status === 'inactivo') {
     		$data = ['BOL_ACTIVO' => 1];
     	}
     	if ($status === 'activo') {
     		$data = ['BOL_ACTIVO' => 0];
     	}
     	if ($this->Departamento->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Status cambiado');
     		redirect('departamentos');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
     		redirect('departamentos');
     	endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
     	$data = ['IS_DELETE' => 1];
     	if ($this->Departamento->edit($id, $data)):
     		$this->session->set_flashdata('success', 'Registro Eliminado');
     		redirect('departamentos');
     	else:
     		$this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
     		redirect('departamentos');
     	endif;
     }

  }
