<?php

 defined('BASEPATH') OR exit('No direct script access allowed');

 class Empresas extends MX_Controller
 {

     public $path_js;

     public function __construct()
     {
         parent::__construct();
         $this->load->model('Empresa');
         $this->load->helper('html');
         $this->load->library('encryption');
         $this->path_js = 'empresas/scripts_dev.js';
       if ($this->session->userdata('COD_TIPOPERFIL') !== 1 && $this->session->userdata('COD_TIPOPERFIL') !== 2) {
             echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
             exit;
         }
     }

     public function index()
     {
             if ($this->input->post()):

                 $this->encryption->initialize(
                   array(
                     'cipher' => 'aes-256',
                     'mode'   => 'cbc',
                     'key'    => $this->config->item('encryption_key')
                   )
                 );

                 unset($_POST['TEX_CIUDAD']);
                 $edit = $this->input->post('edit');
                 $id   = $this->input->post('ID_EMPRESA');
                 if ($edit) {
                     $this->form_validation->set_rules('TEX_NOMEMP', 'Nombre del Empresa', 'required');
                 }
                 else {
                     $this->form_validation->set_rules('TEX_NOMEMP', 'Nombre del Empresa', 'required|is_unique[par02empresa.TEX_NOMEMP]');
                 }
                 if (!$this->form_validation->run()):
                     $this->session->set_flashdata('error', validation_errors());
                     if ($edit) {
                         redirect("empresas");
                     }
                     redirect("empresas");
                 else:
                     $datos_post = [
                       'COD_NIT'         => $this->encryption->encrypt($this->input->post('COD_NIT')),
                       'TEX_NOMEMP'      => $this->encryption->encrypt($this->input->post('TEX_NOMEMP')),
                       'TEX_DIREMP'      => $this->encryption->encrypt($this->input->post('TEX_DIREMP')),
                       'TEX_TELEMP'      => $this->encryption->encrypt($this->input->post('TEX_TELEMP')),
                       'TEX_CELEMP'      => $this->encryption->encrypt($this->input->post('TEX_CELEMP')),
                       'COD_CIUDAD'      => $this->input->post('COD_CIUDAD'),
                       'TEX_MAIEMP'      => $this->encryption->encrypt($this->input->post('TEX_MAIEMP')),
                       'TEX_OBSERVACION' => $this->encryption->encrypt($this->input->post('TEX_OBSERVACION'))
                     ];

                     if ($edit && $id) {
                         $datos_tipo_empresa = array_merge($datos_post, $this->get_campos_control_DB());
                         unset($datos_tipo_empresa['edit']);
                         if (file_exists($_FILES['upload_logo']['tmp_name'])) {
                             if ($this->do_upload()) {
                                 $datos_tipo_empresa['TEX_LOGO'] = $this->encryption->encrypt('uploads/' . $this->upload->data('file_name'));
                                 if ($this->Empresa->edit($id, $datos_tipo_empresa)) {
                                     $this->session->set_flashdata('success', 'Se ha editado el registro');
                                     redirect('empresas');
                                 }
                                 else {
                                     $this->session->set_flashdata('error', 'Error en la edición de los datos');
                                     redirect("empresas");
                                 }
                             }
                         }
                         else {
                             unset($datos_tipo_empresa['TEX_LOGO']);
                             if ($this->Empresa->edit($id, $datos_tipo_empresa)) {
                                 $this->session->set_flashdata('success', 'Se ha editado el registro');
                                 redirect('empresas');
                             }
                             else {
                                 $this->session->set_flashdata('error', 'Error en la edición de los datos');
                                 redirect("empresas");
                             }
                         }
                     }
                     if ($this->do_upload()) {
                         $path               = 'uploads/' . $this->upload->data('file_name');
                         $logo               = ['TEX_LOGO' => $this->encryption->encrypt($path)];
                         $datos_tipo_empresa = array_merge($datos_post, $this->get_campos_control_DB());
                         $datos_tipo_empresa = array_merge($datos_tipo_empresa, $logo);
                         if (is_int($this->Empresa->insert($datos_tipo_empresa))) {
                             $this->session->set_flashdata('success', 'Se ha guardado el registro');
                             redirect('empresas');
                         }
                         else {
                             $this->session->set_flashdata('error', 'Error en la inserción de los datos');
                             redirect('empresas');
                         }
                     }
                 endif;
             else:
                 $data_view['titulo']   = 'Definir Empresa';
                 $data_view['ciudades'] = $this->Empresa->select_forms('gen04ciudad', 'COD_CIUDAD', 'TEX_NOMCIU', null, null, null, 'TEX_NOMCIU');
                 $data_view['load_js']  = $this->path_js;
                 $data_view['empresa']  = $this->Empresa->get_empresa_info();
                 $this->load->view('index', $data_view);
             endif; 
     }

     /**
      * Subir logo 
      * 
      * @return boolean
      */
     public function do_upload()
     {
         $config['upload_path']   = './uploads/';
         $config['allowed_types'] = 'gif|jpg|png';
         $config['max_size']      = 5000;
         $config['max_width']     = 1920;
         $config['max_height']    = 1080;
         $config['file_name']     = 'logo';
         $config['overwrite']     = true;
         $this->load->library('upload', $config);
         if (!$this->upload->do_upload('upload_logo')) {
             $this->session->set_flashdata('error', $this->upload->display_errors());
             redirect('empresas');
         }
         else {
             return $config['file_name'];
         }
     }

     /**
      *
      * Cambiar status
      *
      * @param type $id
      * @param type $status
      *
      */
     public function status($id, $status)
     {
             $data = ['BOL_ACTIVO' => 1];
             if ($status) {
                 $data = ['BOL_ACTIVO' => 0];
             }
             if ($this->Empresa->edit($id, $data)):
                 $this->session->set_flashdata('success', 'Status cambiado');
                 redirect('empresas');
             else:
                 $this->session->set_flashdata('error', 'Ocurrió un error al cambiar el status');
                 redirect('empresas');
             endif;
     }

     /**
      * Borrar Registro
      * @param type $id
      */
     public function delete($id)
     {
         $data = ['IS_DELETE' => 1];
         if ($this->Empresa->edit($id, $data)):
             $this->session->set_flashdata('success', 'Registro Eliminado');
             redirect('empresas');
         else:
             $this->session->set_flashdata('error', 'Ocurrió un error al eliminar el registro');
             redirect('empresas');
         endif;
     }

 }
 