	<?php
    
    /*
    * To change this license header, choose License Headers in Project Properties.
    * To change this template file, choose Tools | Templates
    * and open the template in the editor.
    */
    
    /**
    * Description of Graficos
    *
    * @author Sammy Guergachi <sguergachi at gmail.com>
    */
    class Graficos extends MX_Controller
    {
        private $_permisos;
        
        /**
        * Constructor.
        */
        public function __construct()
        {
            
            parent::__construct();
            if ((int)$this->session->userdata('COD_TIPOPERFIL') != 1 && (int)$this->session->userdata('COD_TIPOPERFIL') != 2) {
                echo "<h3>No tiene permisos para acceder a esta sección.</h3>";
                exit;
            }
            $this->load->model(['Inf_personas_sin_registrarse', 'Inf_personas_registradas',
            'Inf_participantes', 'Inf_personas_en_auditorio', 'Inf_personas_fuera_auditorio',
            'Inf_registrados_sin_participar', 'Inf_asistentes_habiles', 'Inf_candidatos', 
            'Inf_por_instancias', 'Inf_por_instancias_participantes', 'Inf_resumen_por_agencia', 
            'Inf_por_agencia', 'configuracion/Config', 'agencias/Agencia']);
            
            $this->_permisos = $this->session->userdata('permisos');
            $this->ini_desencriptado();
            $this->path_js     = 'informes/scripts_dev.js';
            $this->graficos_js = 'informes/graficos.js';
            
            $this->_configuracion = $this->Config->get_row();
            if (!$this->_configuracion) {
                $data_view['message'] = 'No se ha definido la configuración de la aplicación. Contacte al administrador.';
                $this->load->view('errors/error_start_sistema', $data_view);
                return false;
            }
        }
        
        /**
        *  Genera los datos para alimentar los gráficos de el reporte general de
        *  candidatos.
        * 
        */
        public function get_graficos_general_candidatos()
        {
            $list = $this->Inf_candidatos->get_all_data();
            $arr = [];
            foreach ($list as $g_candidato) {
                if($g_candidato->votos) {
                    $arr[] = [
                        'y'     => $g_candidato->votos,
                        'label' => $g_candidato->TEX_NOMCAN . ' ' . $g_candidato->TEX_APECAN
                    ];
                }
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        /**
        *  Genera datos para graficos de reporte por instancia. 
        * 
        */
        public function get_graficos_por_instancia()
        {
            $instancia = $this->input->post('instancia_id');
            $list      = $this->Inf_por_instancias->get_all_data($instancia);
            $arr       = [];
            foreach ($list as $por_instancia) {
                $arr[] = [
                    'y'          => $por_instancia->NUM_TOVOCA,
                    'label'      => $por_instancia->TEX_NOMCAN . ' ' . $por_instancia->TEX_APECAN,
                    'indexLabel' => 'Votos:' . $por_instancia->NUM_TOVOCA,
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        
        /**
        *  Genera datos para graficos de reporte por instancia. 
        * 
        */
        public function get_graficos_por_instancia_participantes()
        {
            $instancia = $this->input->post('instancia_id');
            $list      = $this->Inf_por_instancias_participantes->get_all_data($instancia);
            $arr       = [];
            foreach ($list as $por_instancia) {
                $arr[] = [
                    'y'          => 1,
                    'label'      => $por_instancia->NUM_PESO,
                    'indexLabel' => $por_instancia->TEX_NOMPAR . ' ' . $por_instancia->TEX_APEPAR,
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        /**
        * Muestra la participacion en todas la instancias. 
        *
        * @return void
        */
        public function get_graficos_todas_instancias_participantes()
        {
            $list      = $this->Inf_por_instancias_participantes->get_all_data();
            $arr       = [];
            foreach ($list as $participantes_all_instancia) {
                $arr[] = [
                    'y'          => $participantes_all_instancia->participantes,
                    'label'      => $participantes_all_instancia->instancia,
                    'indexLabel' => 'Participantes:' . $participantes_all_instancia->participantes,
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        /**
        * Muestra la participacion en todas la instancias. 
        *
        * @return void
        */
        public function get_graficos_todas_instancias_candidatos()
        {
            $list      = $this->Inf_por_instancias->get_all_data_graficos_candidatos();
            $arr       = [];
            foreach ($list as $candidatos_all_instancia) {
                $arr[] = [
                    'y'          => $candidatos_all_instancia->candidatos,
                    'label'      => $candidatos_all_instancia->instancia,
                    'indexLabel' => 'candidatos:' . $candidatos_all_instancia->candidatos,
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        /**
        *  Genera datos para graficos de reporte resumen por agencia. 
        * 
        */
        public function get_graficos_resumen_por_agencia()
        {
            $list = $this->Inf_resumen_por_agencia->get_all_data($this->input->post('agencia_id'));
            $arr  = [];
            foreach ($list as $por_agencia) {
                $arr[] = [
                    'y'          => $por_agencia->votos,
                    'label'      => $por_agencia->TEX_NOMAGE,
                    'indexLabel' => "$por_agencia->votos votos",
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        /**
        *  Genera datos para gráficos reporte por agencia. 
        * 
        */
        public function get_graficos_por_agencia()
        {
            $agencia = $this->input->post('agencia_id');
            $list    = $this->Inf_por_agencia->get_all_data($agencia);
            $arr     = [];
            foreach ($list as $por_agencia) {
                $arr[] = [
                    'y'          => $por_agencia->NUM_TOVOCA,
                    'label'      => $por_agencia->TEX_NOMCAN . ' ' . $por_agencia->TEX_APECAN,
                    'indexLabel' => 'Votos:' . $por_agencia->NUM_TOVOCA
                ];
            }
            echo json_encode($arr, JSON_NUMERIC_CHECK);
        }
        
        
        public function contador_votos()
        {  	
            
            if (!$this->_permisos['registros']['registros_contador_votos']['MOSTRAR_FRONT']){
                $this->session->set_flashdata('error', "No tienes permisos para ver esta sección");
                redirect('administrador');
                
            }
            
            
            $bool_reloj_contador = (boolean)$this->_configuracion->BOL_RELOJ_CONTADOR;
            $bool_grafico_contador = (boolean)$this->_configuracion->BOL_GRAFICO_CONTADOR;
            $bool_tabla_reg_contador = (boolean)$this->_configuracion->BOL_TABLA_REG_CONTADOR;
            

            $registrados_sin_votar = $this->db->query("SELECT p.NUM_IDETER, 
            COUNT(i.NUM_IDETER) as ingresos,
            CONCAT(p.TEX_NOMPAR, ' ', p.TEX_APEPAR) as nombre_participante, a.TEX_NOMAGE
            FROM `evi09ingre` `i`
            JOIN `evi05partic` `p` ON p.NUM_IDETER=i.NUM_IDETER
            JOIN `gen01agencias` `a` ON a.COD_AGENCIA=p.COD_AGENCIA
            WHERE i.NUM_IDETER NOT IN (
                SELECT NUM_IDETER
                FROM evi07audpro)
                GROUP BY i.NUM_IDETER
                HAVING ingresos %2=1
                ORDER BY p.TEX_NOMPAR ASC
                ")
                ->result();
                
                
                $data_view['titulo']  = 'Contador de votos';
                $data_view['registrados_sin_votar']  = $registrados_sin_votar;
                
                $data_view['bool_reloj_contador']  = $bool_reloj_contador;
                $data_view['bool_grafico_contador']  = $bool_grafico_contador;
                $data_view['bool_tabla_reg_contador']  = $bool_tabla_reg_contador;
                
                $data_view['load_js'] = $this->path_js;
                $this->load->view('contador_votos', $data_view);
            }
            
            public function get_grafico_contador_votos()
            {
                
                $instancia_activa_row = $this->db->select('TEX_NOMINS')
                ->from('evi02instan')
                ->where('BOL_ACTIVO', 1)
                ->where('IS_DELETE', 0)->get()->row();

                $total_participantes = $this->db->query("SELECT NUM_IDETER  from evi05partic p WHERE p.FEC_REGIST IS NOT NULL")->result();
                $peso_participantes = $this->db->query("SELECT sum(NUM_PESO) as peso from evi05partic p WHERE p.FEC_REGIST IS NOT NULL")->row();
                
                $data_view['nombre_instancia_activa']  = ($instancia_activa_row->TEX_NOMINS)?$instancia_activa_row->TEX_NOMINS:'';
                $data_view['total_participantes']  = count($total_participantes);
                $data_view['total_peso']  = $peso_participantes->peso;

                $data_view['datos'] = $this->grafico_contador_votos();
                $this->load->view('grafico_contador_votos', $data_view);
            }
            
            public function cambiar_estado_contador()
            {
                $tipo = $this->input->post('tipo');
                $estado = $this->input->post('estado');
                
                if($tipo == 'reloj'){
                    $this->db->update('evi01general', ['BOL_RELOJ_CONTADOR' => $estado]);
                    echo json_encode(['type'=> 'success', 'message' => 'Se ha cambiado el estado del reloj']);
                    return false;
                }
                
                if($tipo == 'grafico'){
                    $this->db->update('evi01general', ['BOL_GRAFICO_CONTADOR' => $estado]);
                    echo json_encode(['type'=> 'success', 'message' => 'Se ha cambiado el estado del gráfico']);
                    return false;
                }
                
                if($tipo == 'tabla_registrados'){
                    $this->db->update('evi01general', ['BOL_TABLA_REG_CONTADOR' => $estado]);
                    echo json_encode(['type'=> 'success', 'message' => 'Se ha cambiado el estado de la tabla de registrados']);
                    return false;
                }
                
                
                
            }
            
            private function grafico_contador_votos()
            {
                //Se evalua la Instancia activa.
                $instancias_activas_result = $this->db->select('ID_INSTAN')
                ->from('evi02instan')
                ->where('BOL_ACTIVO', 1)
                ->where('IS_DELETE', 0)->get()->result();
                
                $instancias_activas = '';
                if($instancias_activas_result) {   
                    $arr_instancias = [];
                    foreach ($instancias_activas_result as $key => $instancia) {
                        $arr_instancias[] = $instancia->ID_INSTAN;
                    } 
                    $instancias_activas = implode(',',$arr_instancias);
                } 
                
                
                //Registrados que han votado
                $total_registrados_con_voto = $this->db->query("SELECT *    
                FROM `evi05partic` `p`
                WHERE NUM_IDETER IN (
                    SELECT NUM_IDETER
                    FROM evi09ingre) AND NUM_IDETER IN (
                        SELECT NUM_IDETER
                        FROM evi07audpro WHERE ID_INSTAN=$instancias_activas)")
                        ->result();


                   
                        $total_peso_registrados_con_voto = 0;
                        foreach ($total_registrados_con_voto as $key => $registrados_con_voto) {
                            $total_peso_registrados_con_voto += $registrados_con_voto->NUM_PESO;
                        }
                        
                        
                        
                        //Registrados sin votar
                        $total_registrados_sin_votar = $this->db->query("SELECT p.NUM_IDETER, 
                        COUNT(i.NUM_IDETER) as ingresos,
                        p.NUM_PESO as peso,
                        CONCAT(p.TEX_NOMPAR, ' ', p.TEX_APEPAR) as nombre_participante, a.TEX_NOMAGE
                        FROM `evi09ingre` `i`
                        JOIN `evi05partic` `p` ON p.NUM_IDETER=i.NUM_IDETER
                        JOIN `gen01agencias` `a` ON a.COD_AGENCIA=p.COD_AGENCIA
                        WHERE i.NUM_IDETER NOT IN (
                            SELECT NUM_IDETER
                            FROM evi07audpro)
                            GROUP BY i.NUM_IDETER
                            HAVING ingresos %2=1")
                            ->result();
                            
                            
                            $total_peso_registrados_sin_votar = 0;
                            foreach ($total_registrados_sin_votar as $key => $registrados_sin_votar) {
                                $total_peso_registrados_sin_votar += $registrados_sin_votar->peso;
                            }
                            
                            
                            
                            $arr = [];
                            //Registrados sin votar
                            $arr[0] = [
                                'y'     => ($total_registrados_con_voto)?count($total_registrados_con_voto):0,
                                'label' => ($total_registrados_con_voto)?count($total_registrados_con_voto) .' / '.$total_peso_registrados_con_voto:0,
                                'legendText' => 'REGISTRADOS QUE HAN VOTADO'
                            ];
                            
                            //Registrados que han votado
                            $arr[1] = [
                                'y'     => ($total_registrados_sin_votar)? count($total_registrados_sin_votar):0,
                                'label' => ($total_registrados_sin_votar)? count($total_registrados_sin_votar).' / '.$total_peso_registrados_sin_votar:0,
                                'legendText' => 'REGISTRADOS SIN VOTAR'
                            ];
                            
                            return json_encode($arr, JSON_NUMERIC_CHECK);
                        }
                        
                    }
                    