<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Inf_participantes_bloqueados extends MY_Model
 {

 	protected $_table;
 	protected $_table_parent;
 	protected $_table_parent2;
 	protected $_table_child;
 	private $_column;
 	private $_order;
 	private $_configuracion;

 	public function __construct()
 	{
 		parent::__construct();
 		$this->load->database();
 		$this->_table         = 'evi05partic';
 		$this->_table_parent  = 'gen04ciudad';
 		$this->_table_parent2 = 'gen01agencias';
 		$this->_table_child   = 'evi07audpro';
 		$this->primary_key    = 'NUM_IDETER';
 		$this->_column        = array("$this->_table.NUM_IDETER",
 			"$this->_table.TEX_NOMPAR",
 			"$this->_table.TEX_APEPAR",
 			"$this->_table_parent.COD_CIUDAD",
 			"$this->_table_parent.TEX_NOMCIU",
 			"$this->_table_parent2.TEX_NOMAGE",
 			"$this->_table_parent2.COD_AGENCIA");
 		$this->_order         = array("evi07audpro.NUM_IDETER" => 'desc');

 		$this->load->model('configuracion/Config');
         //Config del sistema
 		$this->_configuracion = $this->Config->get_row();

         //Si no esta definida la configuración.
 		if (!$this->_configuracion) {
 			$data_view['message'] = 'No se ha definido la configuración del sistema. Contacte al administrador.';
 			$this->load->view('errors/error_start_sistema', $data_view);
 			return false;
 		}
 	}

 	private function _get_datatables_query()
 	{
 		$this->db->distinct();
 		$this->db->select("$this->_table.NUM_IDETER,$this->_table.TEX_NOMPAR, $this->_table.NUM_INTENLOGIN as intentos_login, 
 			$this->_table.BOL_BLOQUEADO as bloqueado, $this->_table.BOL_INISES as inicio_sesion,"
 			. "$this->_table.TEX_APEPAR,"
 			. " $this->_table_parent.TEX_NOMCIU, $this->_table_parent2.TEX_NOMAGE");
 		$this->db->from($this->_table);
 		$this->db->join($this->_table_parent, "$this->_table_parent.COD_CIUDAD=$this->_table.COD_CIUDAD");
 		$this->db->join($this->_table_child, "$this->_table_child.NUM_IDETER=$this->_table.NUM_IDETER", 'LEFT');
 		$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table.COD_AGENCIA");
 		$this->db->where("$this->_table.IS_DELETE", 0);
 		$this->db->where("$this->_table.BOL_ACTIVO", 1);
 		$this->db->where("$this->_table_child.NUM_IDETER", null);
 		
 		if($_POST['search']['value'] == 'por_login') {
 			$this->db->where("$this->_table.NUM_INTENLOGIN >=", (int) $this->_configuracion->NUM_INLOGIN);
 			$this->db->where("$this->_table.BOL_BLOQUEADO", 1);
 		}
 		else if($_POST['search']['value'] == 'por_ingreso') {
 			$this->db->where("$this->_table.BOL_INISES ", 1);
 		} else {
 			$this->db->where("$this->_table.BOL_INISES", 1);
 			$this->db->or_where("$this->_table.NUM_INTENLOGIN >=", (int) $this->_configuracion->NUM_INLOGIN);
 			$this->db->or_where("$this->_table.BOL_BLOQUEADO", 1);
 		}

        // $this->db->where("$this->_table_parent2.COD_AGENCIA !=", 0);
        // if ($this->_agencia_usuario !== 0) {
        //      $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
        //  }

 		$this->db->group_by("$this->_table.NUM_IDETER");

 		$i = 0;
 		if ($_POST['search']['value'] !== 'por_ingreso' && $_POST['search']['value'] !== 'por_login') {

 			foreach ($this->_column as $item) {
 				if ($_POST['search']['value']) {
 					$search = $_POST['search']['value']; 
 					$paren = '';
 					if($i==6) {
 						$paren=')'; 				
 					}
 					($i === 0) ? 
 					$this->db->where("($item LIKE '%$search%'"): $this->db->or_where("$item LIKE '%$search%'$paren");
 				}

 				$column[$i] = $item;
 				$i++;
 			}

 		}
 		if (isset($_POST['order'])) {
 			if ($_POST['search']['value'] !== 'por_ingreso' && $_POST['search']['value'] !== 'por_login') {
 				$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
 			}
 		}
 		else if (isset($this->_order)) {
 			$order = $this->_order;
 			$this->db->order_by(key($order), $order[key($order)]);
 		}
 	}

 	public function get_datatables()
 	{
 		$this->_get_datatables_query();
 		if ($_POST['length'] != -1):
 			$this->db->limit($_POST['length'], $_POST['start']);
 		endif;
 		$query = $this->db->get();
 		return $query->result();
 	}

 	public function count_filtered()
 	{
 		$this->_get_datatables_query();
 		$query = $this->db->get();
 		return $query->num_rows();
 	}

 	public function count_all()
 	{
 		$this->db->from($this->_table);
 		$this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table.COD_AGENCIA");
 		if ($this->_agencia_usuario !== 0) {
 			$this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
 		}
 		if($_POST['search']['value'] == 'por_login') {
 			$this->db->where("$this->_table.NUM_INTENLOGIN >=", (int) $this->_configuracion->NUM_INLOGIN);
 			$this->db->where("$this->_table.BOL_BLOQUEADO", 1);
 		}
 		else if($_POST['search']['value'] == 'por_ingreso') {
 			$this->db->where("$this->_table.BOL_INISES ", 1);
 		} else {
 			$this->db->where("$this->_table.BOL_INISES", 1);
 		}
 		return $this->db->count_all_results();
 	}

 }
 