<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Inf_personas_fuera_auditorio extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     protected $_table_parent2;
     protected $_agencia_usuario;
     private $_column;
     private $_order;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();
         $this->_table        = 'evi09ingre';
         $this->_table_parent = 'evi05partic';
         $this->_table_parent2 = 'gen01agencias';
         $this->primary_key   = 'ID_INGRE';
         $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
         $this->_column       = array('ID_INGRE', "$this->_table.NUM_IDETER", 'FEC_INGSAL',
           "$this->_table_parent.TEX_NOMPAR", "$this->_table_parent.TEX_APEPAR");
         $this->_order        = array('NUM_IDETER' => 'desc');
     }

     private function _get_datatables_query()
     {
         $this->db->distinct();
         $this->db->select("COUNT($this->_table.NUM_IDETER) as ingresos,"
           . " MAX($this->_table.FEC_INGSAL) as FEC_INGSAL, $this->_table.NUM_IDETER, $this->_table_parent.TEX_NOMPAR,"
           . " $this->_table_parent.TEX_APEPAR");
         $this->db->from($this->_table);
         $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER", 'LEFT');
         $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table_parent.COD_AGENCIA", 'LEFT');
         $this->db->where("$this->_table.BOL_ACTIVO", 1);

        $this->db->where("$this->_table_parent2.COD_AGENCIA !=", 0);
         if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
         }


         $this->db->group_by("$this->_table.NUM_IDETER");
         $this->db->having('ingresos %2=', 0, false);
         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables()
     {
         $this->_get_datatables_query();
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query();
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->distinct();
         $this->db->select("COUNT($this->_table.NUM_IDETER) as ingresos,"
           . " $this->_table.FEC_INGSAL, $this->_table.NUM_IDETER, $this->_table_parent.TEX_NOMPAR,"
           . " $this->_table_parent.TEX_APEPAR");
         $this->db->from($this->_table);
         $this->db->join($this->_table_parent, "$this->_table_parent.NUM_IDETER=$this->_table.NUM_IDETER", 'LEFT');
         $this->db->join($this->_table_parent2, "$this->_table_parent2.COD_AGENCIA=$this->_table_parent.COD_AGENCIA", 'LEFT');
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
           
         if ($this->_agencia_usuario !== 0) {
             $this->db->where("$this->_table_parent2.COD_AGENCIA", $this->_agencia_usuario);
         }

         $this->db->group_by("$this->_table.NUM_IDETER");
         $this->db->having('ingresos %2=', 0, false);
         return $this->db->count_all_results();
     }

 }
 