<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of Inf_por_agencia
  *
  * @author Jaime Bravo.
  */
 class Inf_resumen_ip_por_agencia extends MY_Model
 {

     protected $_table;
     protected $_table_parent;
     private $_column;
     private $_order;
     private $_agencia;
     protected $_agencia_usuario;

     public function __construct()
     {
         parent::__construct();
         $this->load->database();
         $this->_table        = 'gen01agencias';
         $this->_table_candid = 'evi04candidat_mr';
         $this->_table_audit = 'evi07audpro';
         $this->_table_parti = 'evi05partic';
         $this->primary_key   = 'COD_AGENCIA';
         $this->_agencia_usuario    = $this->session->userdata('COD_AGENCIA');
         $this->_column       = array('gen01agencias.COD_AGENCIA', 'gen01agencias.TEX_NOMAGE', 'gen01agencias.TEX_NOMAGE', 'gen01agencias.TEX_NOMAGE');
         $this->_order        = array('gen01agencias.COD_AGENCIA' => 'ASC');
     }

     private function _get_datatables_query($agencia)
     {

         $this->_agencia = $agencia;
         $this->db->distinct();
         $this->db->select("$this->_table.TEX_IPORIG");
         $this->db->from($this->_table);
         $this->db->where("$this->_table.COD_AGENCIA", $this->_agencia);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $query = $this->db->get();
         $result = $query->first_row();
         $ip_agencia= $result->TEX_IPORIG;
        

        //Datos de votación.
        $this->db->select("$this->_table.COD_AGENCIA,
            $this->_table.TEX_NOMAGE, 
            $this->_table_parti.NUM_IDETER,
            SUM(NUM_TOVOCA) as votos_agencia");
        $this->db->from($this->_table_audit);
        $this->db->join($this->_table_parti, "$this->_table_parti.NUM_IDETER=$this->_table_audit.NUM_IDETER");
        $this->db->join($this->_table, "$this->_table.COD_AGENCIA=$this->_table_parti.COD_AGENCIA");
        $this->db->join($this->_table_candid, "$this->_table_candid.COD_AGENCIA=$this->_table.COD_AGENCIA");

if($ip_agencia !== '0'){
   $this->db->where("$this->_table_audit.TEX_IPORIG", $ip_agencia); 
}
         
        $this->db->group_by("$this->_table.COD_AGENCIA");

         $i = 0;
         foreach ($this->_column as $item) {
             if ($_POST['search']['value']) {
                 ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
             }

             $column[$i] = $item;
             $i++;
         }
         if (isset($_POST['order'])) {
             $this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
         }
         else if (isset($this->_order)) {
             $order = $this->_order;
             $this->db->order_by(key($order), $order[key($order)]);
         }
     }

     public function get_datatables($agencia)
     {
         $this->_get_datatables_query($agencia);
         if ($_POST['length'] != -1):
             $this->db->limit($_POST['length'], $_POST['start']);
         endif;
         $query = $this->db->get();
         return $query->result();
     }

     public function count_filtered()
     {
         $this->_get_datatables_query($this->_agencia);
         $query = $this->db->get();
         return $query->num_rows();
     }

     public function count_all()
     {
         $this->db->from($this->_table);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $this->db->where("$this->_table.COD_AGENCIA", $this->_agencia);
         return $this->db->count_all_results();
     }

     public function get_all_data($agencia_id)
     {
         $this->db->select("$this->_table.*");
         $this->db->from($this->_table);
         $this->db->where("$this->_table.COD_AGENCIA", $agencia_id);
         $this->db->where("$this->_table.BOL_ACTIVO", 1);
         $this->db->where("$this->_table.IS_DELETE", 0);
         $this->db->order_by("NUM_TOVOCA", 'DESC');
         return $this->db->get()->result();
     }

     public function get_candidatos_por_agencia($cod_agencia)
     {
         $this->db->select("$this->_table.TEX_IPORIG");
                 $this->db->from($this->_table);
                 $this->db->where("$this->_table.COD_AGENCIA", $this->_agencia);
                 $this->db->where("$this->_table.BOL_ACTIVO", 1);
                 $this->db->where("$this->_table.IS_DELETE", 0);
                 $query = $this->db->get();
                 $result = $query->first_row();
                  $ip_agencia = null;
                 if($ip_agencia){
                  $ip_agencia= $result->TEX_IPORIG;
                 }
               $where = 'WHERE';
               if($ip_agencia) {
                 $where = " WHERE aut.TEX_IPORIG= '$ip_agencia' AND";
               }
             

        $sql = "SELECT DISTINCT candid.TEX_APECAN as candidato,COUNT(aut.ID_CANDID) AS votos
                FROM evi07audpro aut
                JOIN evi05partic parti ON parti.NUM_IDETER = aut.NUM_IDETER
                JOIN evi04candidat_mr candid ON candid.ID_CANDID = aut.ID_CANDID
                $where parti.COD_AGENCIA=$cod_agencia";
                 $res = $this->db->query($sql);
                 return $res->result();
             }

 }
 