<?php

 /**
  * EVIR
  *
  * An application development for PHP
  *
  * This content is released under the End User License Agreement (EULA)
  *
  * Copyright (c) 2008 - 2016, Cyberia Tech SAS.
  *
  * THIS IS A LEGAL AGREEMENT BETWEEN YOU, THE END USER, 
  * AND EVIR .IF YOU DO NOT AGREE TO THE TERMS OF THIS AGREEMENT, 
  * DO NOT DOWNLOAD OR USE THIS SOFTWARE.
  *
  * The above copyright notice and this permission notice shall be included in
  * all copies or substantial portions of the Software.
  *
  * LICENSE
  * The software is licensed for exclusive and non-transferable use. 
  * A licensed copy of the software may be used for an unlimited amount 
  * of time without any monthly fees. For each installed instance of the software,
  * a separate license is required unless the multi-user licenses bundle
  * deal has been purchased, thus the a simple copy of the software can be
  * installed up to multiple different machines depending on the license type.
  *
  * @package	Evir 2.
  * @author Jaime P. Bravo 
  * @copyright	Copyright (c) 2008 - 2016, Cyberia Tech SAS.(http://cyberiatech.com.co/)
  * @license	http://opensource.org/licenses/MIT	EULA
  * @link	http://cyberiatech.com.co/evir
  * @since	Version 2.0.0
  * @filesource
  */
 defined('BASEPATH') OR exit('No direct script access allowed');

 class Ingresos_salidas extends MX_Controller
 {

     public $path_js;
     public $message;

     public function __construct()
     {

         parent::__construct();
         if (!$this->session->userdata('COD_PERFIL')) {
             $this->redirect_no_login();
         }

         $this->load->model(['Ingresos_salida', 'participantes/Participante']);
         $this->load->helper('security');
         $this->path_js        = 'ingresos_salidas/scripts_dev.js';
     }

//--------------------------------------------------------------------------------------------------------------------------------
     /**
      *  Carga de los datos de votación. 
      * 
      * @param type $instancia_numero
      * @return boolean
      */
     public function index()
     {
         if (!$this->input->post()) {
             $data_view['titulo']  = 'Ingreso - Salida de Participantes';
             $data_view['load_js'] = $this->path_js;
             $this->load->view('index', $data_view);
         }
         else {
             $this->form_validation->set_rules('NUM_IDETER', 'Identificación', 'required|integer');
             if ($this->form_validation->run() == FALSE) {
                 $this->message = ['type' => 'error', 'message' => validation_errors()];
             }
             else {
                 $participante = $this->Participante->get_participante(xss_clean($this->input->post('NUM_IDETER')));

                 if (!$participante) {
                     $this->message = ['type' => 'error', 'message' => 'El participante no esta registrado en la base de datos.'];
                 }
                 else {
                     $verifica_registro = $this->Participante->verifica_registro(xss_clean($this->input->post('NUM_IDETER')));

                     if (!$verifica_registro->FEC_REGIST) {
                         $this->message = ['type' => 'error', 'message' => 'El participante no se ha registrado aun'];
                     }
                     else {
                         $data_registro = ['NUM_IDETER'   => xss_clean($this->input->post('NUM_IDETER')),
                           'FEC_INGSAL'   => $this->get_fecha_hora_hoy(),
                           'COD_CREAUSU'  => $this->session->userdata('COD_USUARIO'),
                           'TEX_CREANOTA' => $this->input->ip_address()
                         ];
                         if ($this->Ingresos_salida->insert($data_registro)) {
                             $this->message = [
                               'type'               => 'success',
                               'message_ing_salida' => $participante->TEX_NOMPAR . ' ' . $participante->TEX_APEPAR . '. Cédula: ' . $this->input->post('NUM_IDETER')];
                         }
                     }
                 }
             }
             echo json_encode($this->message);
         }
     }

 }
 