<?php

 /*
  * To change this license header, choose License Headers in Project Properties.
  * To change this template file, choose Tools | Templates
  * and open the template in the editor.
  */

 /**
  * Description of User
  *
  * @author Developer
  */
 class Instancia extends MY_Model
 {

 	protected $_table;
 	private $_column = array('ID_INSTAN', 'TEX_NOMINS', 'BOL_ACTIVO');
 	private $_order  = array('ID_INSTAN' => 'desc');

 	public function __construct()
 	{
 		parent::__construct();
 		$this->load->database();
 		$this->_table      = 'evi02instan';
 		$this->primary_key = 'ID_INSTAN';
	 }
	 
	 public function all($estado=1, $is_delete=0)
     	{
     		$this->db->from($this->_table);
     		$this->db->where("$this->_table.BOL_ACTIVO", $estado);
     		$this->db->where("$this->_table.IS_DELETE", $is_delete);
     		return $this->db->get()->result();
     	}

     /**
      * Para editar el campo de una tabla. 
      * 
      * @param type @table Tabla
      * @param type @table_id Id a editar
      * @param type @id Id primaria
      * @param type $data datos
      * @return boolean
      */
     public function edit($id, $data)
     {
     	$this->db->where($this->primary_key, $id);
     	if ($this->db->update($this->_table, $data)):
     		return true;
     	else:
     		return false;
     	endif;
     }

     private function _get_datatables_query()
     {
     	$this->db->select("$this->_table.*");
     	$this->db->from($this->_table);
     	$this->db->where("$this->_table.IS_DELETE", 0);
     	$i = 0;
     	foreach ($this->_column as $item) {
     		if ($_POST['search']['value']) ($i === 0) ? $this->db->like($item, $_POST['search']['value']) : $this->db->or_like($item, $_POST['search']['value']);
     			$column[$i] = $item;
     			$i++;
     		}
     		if (isset($_POST['order'])) {
     			$this->db->order_by($column[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
     		}
     		else if (isset($this->_order)) {
     			$order = $this->_order;
     			$this->db->order_by(key($order), $order[key($order)]);
     		}
     	}

     	public function get_datatables()
     	{
     		$this->_get_datatables_query();
     		if ($_POST['length'] != -1):
     			$this->db->limit($_POST['length'], $_POST['start']);
     		endif;
     		$query = $this->db->get();
     		return $query->result();
     	}

     	public function count_filtered()
     	{
     		$this->_get_datatables_query();
     		$query = $this->db->get();
     		return $query->num_rows();
     	}

     	public function count_all()
     	{
     		$this->db->from($this->_table);
     		$this->db->where("$this->_table.BOL_ACTIVO", 1);
     		return $this->db->count_all_results();
     	}

     /**
      * 
      * @return type
      */
     public function get_instancia($orden = null)
     {
     	$this->db->select('MIN(NUM_ORDEN) as MIN_ORDEN')->where('BOL_ACTIVO', 1)->where('IS_DELETE', 0);
     	$min_orden = (int)$this->db->get($this->_table)->row()->MIN_ORDEN;

     	if ($orden) {
     		$this->db->where('NUM_ORDEN', $orden);
     	} else {
     		if($min_orden) {
     			$this->db->where('NUM_ORDEN', $min_orden);
     		} else{
     			$this->db->where('NUM_ORDEN', 1);
     		}
     	}
     	$this->db->select('NUM_ORDEN, ID_INSTAN, TEX_NOMINS,'
     		. ' NUM_MUSEIN, BOL_VOTBLA, BOL_OBLMUL, FEC_INIUSO, FEC_FINUSO ');
     	$this->db->where('BOL_ACTIVO', 1);
     	$this->db->where('IS_DELETE', 0);
     	return $this->db->get($this->_table)->row();
	 }
	 
	 public function get_max_num_order()
	 {
		
			$this->db->select('MAX(CAST(NUM_ORDEN AS unsigned)) as MAX_ORDEN');
			$max_num_order = (int)$this->db->get($this->_table)->row()->MAX_ORDEN;
   
			return $max_num_order;
		
	 }

/**
      * Min. field row from table - Jaime. 
      * 
      * @return type
      */
public function get_instancia_by_id($id = null)
{
	if ($id) {
		$this->db->where('ID_INSTAN', $id);
	} 
	$this->db->select('ID_INSTAN,NUM_ORDEN, TEX_NOMINS,'
		. ' NUM_MUSEIN, BOL_VOTBLA, BOL_OBLMUL, FEC_INIUSO, FEC_FINUSO ');
	$this->db->where('BOL_ACTIVO', 1);
	$this->db->where('IS_DELETE', 0);
	return $this->db->get($this->_table)->row();
}


}
